/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.CustomBar;
import com.android.layoutlib.bridge.bars.IconLoader;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.resources.Density;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParserException;

public class StatusBar
extends CustomBar {
    private final int mSimulatedPlatformVersion;
    private static final String ATTR_COLOR = "colorPrimaryDark";

    public StatusBar(BridgeContext context, Density density, int direction, boolean RtlEnabled, int simulatedPlatformVersion) throws XmlPullParserException {
        super(context, 0, "/bars/status_bar.xml", "status_bar.xml", simulatedPlatformVersion);
        this.mSimulatedPlatformVersion = simulatedPlatformVersion;
        this.setGravity(8388663);
        int color2 = this.getThemeAttrColor(ATTR_COLOR, true);
        this.setBackgroundColor(color2 == 0 ? Config.getStatusBarColor(simulatedPlatformVersion) : color2);
        this.loadIcon(1, "stat_sys_wifi_signal_4_fully." + Config.getWifiIconType(simulatedPlatformVersion), density);
        this.loadIcon(2, "stat_sys_battery_100.png", density);
        this.setText(3, Config.getTime(simulatedPlatformVersion), false).setTextColor(Config.getTimeColor(simulatedPlatformVersion));
    }

    @Override
    protected void loadIcon(int index, String iconName, Density density) {
        if (!iconName.endsWith(".xml")) {
            super.loadIcon(index, iconName, density);
            return;
        }
        View child = this.getChildAt(index);
        if (child instanceof ImageView) {
            ImageView imageView = (ImageView)child;
            IconLoader iconLoader = new IconLoader(iconName, Density.XHIGH, this.mSimulatedPlatformVersion, null);
            InputStream stream = iconLoader.getIcon();
            if (stream != null) {
                try {
                    BridgeXmlBlockParser parser = new BridgeXmlBlockParser(ParserFactory.create(stream, null), (BridgeContext)this.mContext, true);
                    imageView.setImageDrawable(Drawable.createFromXml(this.mContext.getResources(), parser));
                }
                catch (XmlPullParserException e) {
                    Bridge.getLog().error("broken", "Unable to draw wifi icon", (Throwable)e, null);
                }
                catch (IOException e) {
                    Bridge.getLog().error("broken", "Unable to draw wifi icon", (Throwable)e, null);
                }
            }
        }
    }

    @Override
    protected TextView getStyleableTextView() {
        return null;
    }
}

