/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.app.ActionBar;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowCallback;
import android.widget.ActionMenuPresenter;
import android.widget.Toolbar;
import android.widget.Toolbar_Accessor;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.internal.app.ToolbarActionBar;
import com.android.internal.app.WindowDecorActionBar;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.ActionBarAccessor;
import com.android.internal.widget.ActionBarView;
import com.android.internal.widget.DecorToolbar;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.FrameworkActionBar;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;

public abstract class FrameworkActionBarWrapper {
    @NonNull
    protected ActionBar mActionBar;
    @NonNull
    protected ActionBarCallback mCallback;
    @NonNull
    protected BridgeContext mContext;

    @NonNull
    public static FrameworkActionBarWrapper getActionBarWrapper(@NonNull BridgeContext context, @NonNull ActionBarCallback callback, @NonNull View decorContent) {
        View view = decorContent.findViewById(16909178);
        if (view instanceof Toolbar) {
            return new ToolbarWrapper(context, callback, (Toolbar)view);
        }
        if (view instanceof ActionBarView) {
            return new WindowActionBarWrapper(context, callback, decorContent, (ActionBarView)view);
        }
        throw new IllegalStateException("Can't make an action bar out of " + view.getClass().getSimpleName());
    }

    FrameworkActionBarWrapper(@NonNull BridgeContext context, ActionBarCallback callback, @NonNull ActionBar actionBar) {
        this.mActionBar = actionBar;
        this.mCallback = callback;
        this.mContext = context;
    }

    protected void setupActionBar() {
    }

    public void setTitle(CharSequence title) {
        this.mActionBar.setTitle(title);
    }

    public void setSubTitle(CharSequence subTitle) {
        if (subTitle != null) {
            this.mActionBar.setSubtitle(subTitle);
        }
    }

    public void setHomeAsUp(boolean homeAsUp) {
        this.mActionBar.setDisplayHomeAsUpEnabled(homeAsUp);
    }

    public void setIcon(String icon) {
    }

    protected boolean isSplit() {
        return this.getDecorToolbar().isSplit();
    }

    protected boolean isOverflowPopupNeeded() {
        return this.mCallback.isOverflowPopupNeeded();
    }

    protected void inflateMenus() {
        MenuInflater inflater = new MenuInflater(this.getActionMenuContext());
        MenuBuilder menuBuilder = this.getMenuBuilder();
        for (String name : this.mCallback.getMenuIdNames()) {
            int id2;
            if (name.startsWith("android:")) {
                name = name.substring("android:".length());
                id2 = this.mContext.getFrameworkResourceValue(ResourceType.MENU, name, -1);
            } else {
                id2 = this.mContext.getProjectResourceValue(ResourceType.MENU, name, -1);
            }
            if (id2 <= -1) continue;
            inflater.inflate(id2, menuBuilder);
        }
    }

    @NonNull
    protected Context getActionMenuContext() {
        return this.mActionBar.getThemedContext();
    }

    @NonNull
    abstract Context getPopupContext();

    @NonNull
    abstract MenuBuilder getMenuBuilder();

    @Nullable
    abstract ActionMenuPresenter getActionMenuPresenter();

    @NonNull
    abstract DecorToolbar getDecorToolbar();

    abstract int getMenuPopupElevation();

    abstract int getMenuPopupMargin();

    private static class WindowActionBarWrapper
    extends FrameworkActionBarWrapper {
        @NonNull
        private final WindowDecorActionBar mActionBar;
        @NonNull
        private final ActionBarView mActionBarView;
        @NonNull
        private final View mDecorContentRoot;
        private MenuBuilder mMenuBuilder;

        public WindowActionBarWrapper(@NonNull BridgeContext context, @NonNull ActionBarCallback callback, @NonNull View decorContentRoot, @NonNull ActionBarView actionBarView) {
            super(context, callback, new WindowDecorActionBar(decorContentRoot));
            this.mActionBarView = actionBarView;
            this.mActionBar = (WindowDecorActionBar)((FrameworkActionBarWrapper)this).mActionBar;
            this.mDecorContentRoot = decorContentRoot;
        }

        @Override
        protected void setupActionBar() {
            ViewGroup splitView;
            int navMode = this.mCallback.getNavigationMode();
            this.mActionBar.setNavigationMode(navMode);
            if (navMode == 2) {
                this.setupTabs(3);
            }
            if ((splitView = (ViewGroup)this.mDecorContentRoot.findViewById(16909180)) != null) {
                this.mActionBarView.setSplitView(splitView);
                Resources res = this.mContext.getResources();
                boolean split = res.getBoolean(17956869) && this.mCallback.getSplitActionBarWhenNarrow();
                this.mActionBarView.setSplitToolbar(split);
            }
        }

        @Override
        public void setIcon(String icon) {
            Drawable iconDrawable;
            if (!this.mActionBar.hasIcon() && icon != null && (iconDrawable = this.getDrawable(icon, false)) != null) {
                this.mActionBar.setIcon(iconDrawable);
            }
        }

        @Override
        protected void inflateMenus() {
            super.inflateMenus();
            this.mActionBarView.setMenu(this.getMenuBuilder(), null);
        }

        @Override
        @NonNull
        Context getPopupContext() {
            return this.getActionMenuContext();
        }

        @Override
        @NonNull
        MenuBuilder getMenuBuilder() {
            if (this.mMenuBuilder == null) {
                this.mMenuBuilder = new MenuBuilder(this.getActionMenuContext());
            }
            return this.mMenuBuilder;
        }

        @Override
        @Nullable
        ActionMenuPresenter getActionMenuPresenter() {
            return ActionBarAccessor.getActionMenuPresenter(this.mActionBarView);
        }

        @Override
        @NonNull
        ActionBarView getDecorToolbar() {
            return this.mActionBarView;
        }

        @Override
        int getMenuPopupElevation() {
            return 0;
        }

        @Override
        int getMenuPopupMargin() {
            return -FrameworkActionBar.getPixelValue("10dp", this.mContext.getMetrics());
        }

        private void setupTabs(int num) {
            for (int i = 1; i <= num; ++i) {
                ActionBar.Tab tab = this.mActionBar.newTab().setText("Tab" + i).setTabListener(new ActionBar.TabListener(){

                    @Override
                    public void onTabUnselected(ActionBar.Tab t, FragmentTransaction ft) {
                    }

                    @Override
                    public void onTabSelected(ActionBar.Tab t, FragmentTransaction ft) {
                    }

                    @Override
                    public void onTabReselected(ActionBar.Tab t, FragmentTransaction ft) {
                    }
                });
                this.mActionBar.addTab(tab);
            }
        }

        @Nullable
        private Drawable getDrawable(@NonNull String name, boolean isFramework) {
            RenderResources res = this.mContext.getRenderResources();
            ResourceValue value = res.findResValue(name, isFramework);
            if ((value = res.resolveResValue(value)) != null) {
                return ResourceHelper.getDrawable(value, this.mContext);
            }
            return null;
        }
    }

    private static class ToolbarWrapper
    extends FrameworkActionBarWrapper {
        @NonNull
        private final Toolbar mToolbar;

        ToolbarWrapper(@NonNull BridgeContext context, @NonNull ActionBarCallback callback, @NonNull Toolbar toolbar) {
            super(context, callback, new ToolbarActionBar(toolbar, "", new WindowCallback()));
            this.mToolbar = toolbar;
        }

        @Override
        protected void inflateMenus() {
            super.inflateMenus();
            MenuBuilder menu2 = this.getMenuBuilder();
            DecorToolbar decorToolbar = this.getDecorToolbar();
            decorToolbar.setMenu(new MenuBuilder(this.getActionMenuContext()), null);
            decorToolbar.setMenu(menu2, null);
        }

        @Override
        @NonNull
        Context getPopupContext() {
            return Toolbar_Accessor.getPopupContext(this.mToolbar);
        }

        @Override
        @NonNull
        MenuBuilder getMenuBuilder() {
            return (MenuBuilder)this.mToolbar.getMenu();
        }

        @Override
        @Nullable
        ActionMenuPresenter getActionMenuPresenter() {
            return Toolbar_Accessor.getActionMenuPresenter(this.mToolbar);
        }

        @Override
        @NonNull
        DecorToolbar getDecorToolbar() {
            return this.mToolbar.getWrapper();
        }

        @Override
        int getMenuPopupElevation() {
            return 10;
        }

        @Override
        int getMenuPopupMargin() {
            return 0;
        }
    }
}

