/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android.support;

import android.content.Context;
import android.view.View;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.SessionParamsFlags;
import com.android.layoutlib.bridge.util.ReflectionUtils;
import java.lang.reflect.Method;

public class RecyclerViewUtil {
    private static final Object CONTEXT = new Object();
    public static final String CN_RECYCLER_VIEW = "android.support.v7.widget.RecyclerView";
    private static final String CN_LAYOUT_MANAGER = "android.support.v7.widget.RecyclerView$LayoutManager";
    private static final String CN_ADAPTER = "android.support.v7.widget.RecyclerView$Adapter";

    public static void setAdapter(@NonNull View recyclerView, @NonNull BridgeContext context, @NonNull SessionParams params) {
        try {
            RecyclerViewUtil.setLayoutManager(recyclerView, context, params.getProjectCallback());
            Object adapter = RecyclerViewUtil.createAdapter(params);
            RecyclerViewUtil.setProperty(recyclerView, CN_ADAPTER, adapter, "setAdapter");
        }
        catch (ReflectionUtils.ReflectionException e) {
            Bridge.getLog().error("broken", "Error occured while trying to setup RecyclerView.", (Throwable)e, null);
        }
    }

    private static void setLayoutManager(@NonNull View recyclerView, @NonNull BridgeContext context, @NonNull IProjectCallback callback) throws ReflectionUtils.ReflectionException {
        Object cookie = context.getCookie(recyclerView);
        assert (cookie == null || cookie instanceof LayoutManagerType || cookie instanceof String);
        if (!(cookie instanceof LayoutManagerType)) {
            if (cookie != null) {
                Bridge.getLog().warning("unsupported", "LayoutManager (" + cookie + ") not found, falling back to " + "LinearLayoutManager", null);
            }
            cookie = LayoutManagerType.getDefault();
        }
        Object layoutManager = RecyclerViewUtil.createLayoutManager((LayoutManagerType)((Object)cookie), context, callback);
        RecyclerViewUtil.setProperty(recyclerView, CN_LAYOUT_MANAGER, layoutManager, "setLayoutManager");
    }

    @Nullable
    private static Object createLayoutManager(@Nullable LayoutManagerType type, @NonNull Context context, @NonNull IProjectCallback callback) throws ReflectionUtils.ReflectionException {
        if (type == null) {
            type = LayoutManagerType.getDefault();
        }
        try {
            return callback.loadView(type.getClassName(), type.getSignature(), type.getArgs(context));
        }
        catch (Exception e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    @Nullable
    private static Object createAdapter(@NonNull SessionParams params) throws ReflectionUtils.ReflectionException {
        Boolean ideSupport = (Boolean)params.getFlag(SessionParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT);
        if (ideSupport != Boolean.TRUE) {
            return null;
        }
        try {
            return params.getProjectCallback().loadView(CN_ADAPTER, new Class[0], new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    private static void setProperty(@NonNull View recyclerView, @NonNull String propertyClassName, @Nullable Object propertyValue, @NonNull String propertySetter) throws ReflectionUtils.ReflectionException {
        if (propertyValue != null) {
            Class<?> layoutManagerClass = RecyclerViewUtil.getClassInstance(propertyValue, propertyClassName);
            Method setLayoutManager = ReflectionUtils.getMethod(recyclerView.getClass(), propertySetter, layoutManagerClass);
            if (setLayoutManager != null) {
                ReflectionUtils.invoke(setLayoutManager, recyclerView, propertyValue);
            }
        }
    }

    @NonNull
    private static Class<?> getClassInstance(@NonNull Object object, @NonNull String className) {
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!className.equals(superClass.getName())) continue;
            return superClass;
        }
        throw new RuntimeException("invalid object/classname combination.");
    }

    public static enum LayoutManagerType {
        LINEAR_LAYOUT_MANGER("Linear", "android.support.v7.widget.LinearLayoutManager", new Class[]{Context.class}, new Object[]{RecyclerViewUtil.access$000()}),
        GRID_LAYOUT_MANAGER("Grid", "android.support.v7.widget.GridLayoutManager", new Class[]{Context.class, Integer.TYPE}, new Object[]{RecyclerViewUtil.access$000(), 2}),
        STAGGERED_GRID_LAYOUT_MANAGER("StaggeredGrid", "android.support.v7.widget.StaggeredGridLayoutManager", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{2, 1});

        private String mLogicalName;
        private String mClassName;
        private Class[] mSignature;
        private Object[] mArgs;

        private LayoutManagerType(String logicalName, String className, Class[] signature, Object[] args) {
            this.mLogicalName = logicalName;
            this.mClassName = className;
            this.mSignature = signature;
            this.mArgs = args;
        }

        String getClassName() {
            return this.mClassName;
        }

        Class[] getSignature() {
            return this.mSignature;
        }

        @NonNull
        Object[] getArgs(Context context) {
            Object[] args = new Object[this.mArgs.length];
            System.arraycopy(this.mArgs, 0, args, 0, this.mArgs.length);
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != CONTEXT) continue;
                args[i] = context;
            }
            return args;
        }

        @NonNull
        public static LayoutManagerType getDefault() {
            return LINEAR_LAYOUT_MANGER;
        }

        @Nullable
        public static LayoutManagerType getByLogicalName(@NonNull String logicalName) {
            for (LayoutManagerType type : LayoutManagerType.values()) {
                if (!logicalName.equals(type.mLogicalName)) continue;
                return type;
            }
            return null;
        }

        @Nullable
        public static LayoutManagerType getByClassName(@NonNull String className) {
            for (LayoutManagerType type : LayoutManagerType.values()) {
                if (!className.equals(type.mClassName)) continue;
                return type;
            }
            return null;
        }
    }
}

