/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.R;
import com.android.internal.widget.LockPatternUtils;
import java.util.ArrayList;
import java.util.List;

public class LockPatternView
extends View {
    private static final int ASPECT_SQUARE = 0;
    private static final int ASPECT_LOCK_WIDTH = 1;
    private static final int ASPECT_LOCK_HEIGHT = 2;
    private static final boolean PROFILE_DRAWING = false;
    private final CellState[][] mCellStates;
    private final int mDotSize;
    private final int mDotSizeActivated;
    private final int mPathWidth;
    private boolean mDrawingProfilingStarted = false;
    private Paint mPaint = new Paint();
    private Paint mPathPaint = new Paint();
    private static final int MILLIS_PER_CIRCLE_ANIMATING = 700;
    private static final float DRAG_THRESHHOLD = 0.0f;
    private OnPatternListener mOnPatternListener;
    private ArrayList<Cell> mPattern = new ArrayList(9);
    private boolean[][] mPatternDrawLookup = new boolean[3][3];
    private float mInProgressX = -1.0f;
    private float mInProgressY = -1.0f;
    private long mAnimatingPeriodStart;
    private DisplayMode mPatternDisplayMode = DisplayMode.Correct;
    private boolean mInputEnabled = true;
    private boolean mInStealthMode = false;
    private boolean mEnableHapticFeedback = true;
    private boolean mPatternInProgress = false;
    private float mHitFactor = 0.6f;
    private float mSquareWidth;
    private float mSquareHeight;
    private final Path mCurrentPath = new Path();
    private final Rect mInvalidate = new Rect();
    private final Rect mTmpInvalidateRect = new Rect();
    private int mAspect;
    private int mRegularColor;
    private int mErrorColor;
    private int mSuccessColor;
    private Interpolator mFastOutSlowInInterpolator;
    private Interpolator mLinearOutSlowInInterpolator;

    public LockPatternView(Context context) {
        this(context, null);
    }

    public LockPatternView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LockPatternView);
        String aspect = a.getString(0);
        this.mAspect = "square".equals(aspect) ? 0 : ("lock_width".equals(aspect) ? 1 : ("lock_height".equals(aspect) ? 2 : 0));
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mRegularColor = this.getResources().getColor(17170506);
        this.mErrorColor = this.getResources().getColor(17170508);
        this.mSuccessColor = this.getResources().getColor(17170507);
        this.mRegularColor = a.getColor(2, this.mRegularColor);
        this.mErrorColor = a.getColor(3, this.mErrorColor);
        this.mSuccessColor = a.getColor(4, this.mSuccessColor);
        int pathColor = a.getColor(1, this.mRegularColor);
        this.mPathPaint.setColor(pathColor);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPathWidth = this.getResources().getDimensionPixelSize(17105055);
        this.mPathPaint.setStrokeWidth(this.mPathWidth);
        this.mDotSize = this.getResources().getDimensionPixelSize(17105056);
        this.mDotSizeActivated = this.getResources().getDimensionPixelSize(17105057);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mCellStates = new CellState[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mCellStates[i][j] = new CellState();
                this.mCellStates[i][j].size = this.mDotSize;
            }
        }
        this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
    }

    public CellState[][] getCellStates() {
        return this.mCellStates;
    }

    public boolean isInStealthMode() {
        return this.mInStealthMode;
    }

    public boolean isTactileFeedbackEnabled() {
        return this.mEnableHapticFeedback;
    }

    public void setInStealthMode(boolean inStealthMode) {
        this.mInStealthMode = inStealthMode;
    }

    public void setTactileFeedbackEnabled(boolean tactileFeedbackEnabled) {
        this.mEnableHapticFeedback = tactileFeedbackEnabled;
    }

    public void setOnPatternListener(OnPatternListener onPatternListener) {
        this.mOnPatternListener = onPatternListener;
    }

    public void setPattern(DisplayMode displayMode, List<Cell> pattern) {
        this.mPattern.clear();
        this.mPattern.addAll(pattern);
        this.clearPatternDrawLookup();
        for (Cell cell : pattern) {
            this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        }
        this.setDisplayMode(displayMode);
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.mPatternDisplayMode = displayMode;
        if (displayMode == DisplayMode.Animate) {
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = SystemClock.elapsedRealtime();
            Cell first = this.mPattern.get(0);
            this.mInProgressX = this.getCenterXForColumn(first.getColumn());
            this.mInProgressY = this.getCenterYForRow(first.getRow());
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    private void notifyCellAdded() {
        this.sendAccessEvent(17040312);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCellAdded(this.mPattern);
        }
    }

    private void notifyPatternStarted() {
        this.sendAccessEvent(17040310);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternStart();
        }
    }

    private void notifyPatternDetected() {
        this.sendAccessEvent(17040313);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternDetected(this.mPattern);
        }
    }

    private void notifyPatternCleared() {
        this.sendAccessEvent(17040311);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCleared();
        }
    }

    public void clearPattern() {
        this.resetPattern();
    }

    private void resetPattern() {
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.invalidate();
    }

    private void clearPatternDrawLookup() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mPatternDrawLookup[i][j] = false;
            }
        }
    }

    public void disableInput() {
        this.mInputEnabled = false;
    }

    public void enableInput() {
        this.mInputEnabled = true;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int width = w - this.mPaddingLeft - this.mPaddingRight;
        this.mSquareWidth = (float)width / 3.0f;
        int height = h - this.mPaddingTop - this.mPaddingBottom;
        this.mSquareHeight = (float)height / 3.0f;
    }

    private int resolveMeasured(int measureSpec, int desired) {
        int result = 0;
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (View.MeasureSpec.getMode(measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.max(specSize, desired);
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumWidth = this.getSuggestedMinimumWidth();
        int minimumHeight = this.getSuggestedMinimumHeight();
        int viewWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
        int viewHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
        switch (this.mAspect) {
            case 0: {
                viewWidth = viewHeight = Math.min(viewWidth, viewHeight);
                break;
            }
            case 1: {
                viewHeight = Math.min(viewWidth, viewHeight);
                break;
            }
            case 2: {
                viewWidth = Math.min(viewWidth, viewHeight);
            }
        }
        this.setMeasuredDimension(viewWidth, viewHeight);
    }

    private Cell detectAndAddHit(float x, float y) {
        Cell cell = this.checkForNewHit(x, y);
        if (cell != null) {
            Cell fillInGapCell = null;
            ArrayList<Cell> pattern = this.mPattern;
            if (!pattern.isEmpty()) {
                Cell lastCell = pattern.get(pattern.size() - 1);
                int dRow = cell.row - lastCell.row;
                int dColumn = cell.column - lastCell.column;
                int fillInRow = lastCell.row;
                int fillInColumn = lastCell.column;
                if (Math.abs(dRow) == 2 && Math.abs(dColumn) != 1) {
                    fillInRow = lastCell.row + (dRow > 0 ? 1 : -1);
                }
                if (Math.abs(dColumn) == 2 && Math.abs(dRow) != 1) {
                    fillInColumn = lastCell.column + (dColumn > 0 ? 1 : -1);
                }
                fillInGapCell = Cell.of(fillInRow, fillInColumn);
            }
            if (fillInGapCell != null && !this.mPatternDrawLookup[fillInGapCell.row][fillInGapCell.column]) {
                this.addCellToPattern(fillInGapCell);
            }
            this.addCellToPattern(cell);
            if (this.mEnableHapticFeedback) {
                this.performHapticFeedback(1, 3);
            }
            return cell;
        }
        return null;
    }

    private void addCellToPattern(Cell newCell) {
        this.mPatternDrawLookup[newCell.getRow()][newCell.getColumn()] = true;
        this.mPattern.add(newCell);
        if (!this.mInStealthMode) {
            this.startCellActivatedAnimation(newCell);
        }
        this.notifyCellAdded();
    }

    private void startCellActivatedAnimation(Cell cell) {
        final CellState cellState = this.mCellStates[cell.row][cell.column];
        this.startSizeAnimation(this.mDotSize, this.mDotSizeActivated, 96L, this.mLinearOutSlowInInterpolator, cellState, new Runnable(){

            @Override
            public void run() {
                LockPatternView.this.startSizeAnimation(LockPatternView.this.mDotSizeActivated, LockPatternView.this.mDotSize, 192L, LockPatternView.this.mFastOutSlowInInterpolator, cellState, null);
            }
        });
        this.startLineEndAnimation(cellState, this.mInProgressX, this.mInProgressY, this.getCenterXForColumn(cell.column), this.getCenterYForRow(cell.row));
    }

    private void startLineEndAnimation(final CellState state, final float startX, final float startY, final float targetX, final float targetY) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                float t = ((Float)animation.getAnimatedValue()).floatValue();
                state.lineEndX = (1.0f - t) * startX + t * targetX;
                state.lineEndY = (1.0f - t) * startY + t * targetY;
                LockPatternView.this.invalidate();
            }
        });
        valueAnimator.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                state.lineAnimator = null;
            }
        });
        valueAnimator.setInterpolator(this.mFastOutSlowInInterpolator);
        valueAnimator.setDuration(100L);
        valueAnimator.start();
        state.lineAnimator = valueAnimator;
    }

    private void startSizeAnimation(float start, float end, long duration, Interpolator interpolator2, final CellState state, final Runnable endRunnable) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(start, end);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                state.size = ((Float)animation.getAnimatedValue()).floatValue();
                LockPatternView.this.invalidate();
            }
        });
        if (endRunnable != null) {
            valueAnimator.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    endRunnable.run();
                }
            });
        }
        valueAnimator.setInterpolator(interpolator2);
        valueAnimator.setDuration(duration);
        valueAnimator.start();
    }

    private Cell checkForNewHit(float x, float y) {
        int rowHit = this.getRowHit(y);
        if (rowHit < 0) {
            return null;
        }
        int columnHit = this.getColumnHit(x);
        if (columnHit < 0) {
            return null;
        }
        if (this.mPatternDrawLookup[rowHit][columnHit]) {
            return null;
        }
        return Cell.of(rowHit, columnHit);
    }

    private int getRowHit(float y) {
        float squareHeight = this.mSquareHeight;
        float hitSize = squareHeight * this.mHitFactor;
        float offset = (float)this.mPaddingTop + (squareHeight - hitSize) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float hitTop = offset + squareHeight * (float)i;
            if (!(y >= hitTop) || !(y <= hitTop + hitSize)) continue;
            return i;
        }
        return -1;
    }

    private int getColumnHit(float x) {
        float squareWidth = this.mSquareWidth;
        float hitSize = squareWidth * this.mHitFactor;
        float offset = (float)this.mPaddingLeft + (squareWidth - hitSize) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float hitLeft = offset + squareWidth * (float)i;
            if (!(x >= hitLeft) || !(x <= hitLeft + hitSize)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean onHoverEvent(MotionEvent event) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            this.onTouchEvent(event);
            event.setAction(action);
        }
        return super.onHoverEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mInputEnabled || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.handleActionDown(event);
                return true;
            }
            case 1: {
                this.handleActionUp(event);
                return true;
            }
            case 2: {
                this.handleActionMove(event);
                return true;
            }
            case 3: {
                if (this.mPatternInProgress) {
                    this.mPatternInProgress = false;
                    this.resetPattern();
                    this.notifyPatternCleared();
                }
                return true;
            }
        }
        return false;
    }

    private void handleActionMove(MotionEvent event) {
        float radius = this.mPathWidth;
        int historySize = event.getHistorySize();
        this.mTmpInvalidateRect.setEmpty();
        boolean invalidateNow = false;
        for (int i = 0; i < historySize + 1; ++i) {
            float x = i < historySize ? event.getHistoricalX(i) : event.getX();
            float y = i < historySize ? event.getHistoricalY(i) : event.getY();
            Cell hitCell = this.detectAndAddHit(x, y);
            int patternSize = this.mPattern.size();
            if (hitCell != null && patternSize == 1) {
                this.mPatternInProgress = true;
                this.notifyPatternStarted();
            }
            float dx = Math.abs(x - this.mInProgressX);
            float dy = Math.abs(y - this.mInProgressY);
            if (dx > 0.0f || dy > 0.0f) {
                invalidateNow = true;
            }
            if (!this.mPatternInProgress || patternSize <= 0) continue;
            ArrayList<Cell> pattern = this.mPattern;
            Cell lastCell = pattern.get(patternSize - 1);
            float lastCellCenterX = this.getCenterXForColumn(lastCell.column);
            float lastCellCenterY = this.getCenterYForRow(lastCell.row);
            float left = Math.min(lastCellCenterX, x) - radius;
            float right = Math.max(lastCellCenterX, x) + radius;
            float top = Math.min(lastCellCenterY, y) - radius;
            float bottom = Math.max(lastCellCenterY, y) + radius;
            if (hitCell != null) {
                float width = this.mSquareWidth * 0.5f;
                float height = this.mSquareHeight * 0.5f;
                float hitCellCenterX = this.getCenterXForColumn(hitCell.column);
                float hitCellCenterY = this.getCenterYForRow(hitCell.row);
                left = Math.min(hitCellCenterX - width, left);
                right = Math.max(hitCellCenterX + width, right);
                top = Math.min(hitCellCenterY - height, top);
                bottom = Math.max(hitCellCenterY + height, bottom);
            }
            this.mTmpInvalidateRect.union(Math.round(left), Math.round(top), Math.round(right), Math.round(bottom));
        }
        this.mInProgressX = event.getX();
        this.mInProgressY = event.getY();
        if (invalidateNow) {
            this.mInvalidate.union(this.mTmpInvalidateRect);
            this.invalidate(this.mInvalidate);
            this.mInvalidate.set(this.mTmpInvalidateRect);
        }
    }

    private void sendAccessEvent(int resId) {
        this.announceForAccessibility(this.mContext.getString(resId));
    }

    private void handleActionUp(MotionEvent event) {
        if (!this.mPattern.isEmpty()) {
            this.mPatternInProgress = false;
            this.cancelLineAnimations();
            this.notifyPatternDetected();
            this.invalidate();
        }
    }

    private void cancelLineAnimations() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                CellState state = this.mCellStates[i][j];
                if (state.lineAnimator == null) continue;
                state.lineAnimator.cancel();
                state.lineEndX = Float.MIN_VALUE;
                state.lineEndY = Float.MIN_VALUE;
            }
        }
    }

    private void handleActionDown(MotionEvent event) {
        this.resetPattern();
        float x = event.getX();
        float y = event.getY();
        Cell hitCell = this.detectAndAddHit(x, y);
        if (hitCell != null) {
            this.mPatternInProgress = true;
            this.mPatternDisplayMode = DisplayMode.Correct;
            this.notifyPatternStarted();
        } else if (this.mPatternInProgress) {
            this.mPatternInProgress = false;
            this.notifyPatternCleared();
        }
        if (hitCell != null) {
            float startX = this.getCenterXForColumn(hitCell.column);
            float startY = this.getCenterYForRow(hitCell.row);
            float widthOffset = this.mSquareWidth / 2.0f;
            float heightOffset = this.mSquareHeight / 2.0f;
            this.invalidate((int)(startX - widthOffset), (int)(startY - heightOffset), (int)(startX + widthOffset), (int)(startY + heightOffset));
        }
        this.mInProgressX = x;
        this.mInProgressY = y;
    }

    private float getCenterXForColumn(int column) {
        return (float)this.mPaddingLeft + (float)column * this.mSquareWidth + this.mSquareWidth / 2.0f;
    }

    private float getCenterYForRow(int row) {
        return (float)this.mPaddingTop + (float)row * this.mSquareHeight + this.mSquareHeight / 2.0f;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        boolean drawPath;
        ArrayList<Cell> pattern = this.mPattern;
        int count = pattern.size();
        boolean[][] drawLookup = this.mPatternDrawLookup;
        if (this.mPatternDisplayMode == DisplayMode.Animate) {
            boolean needToUpdateInProgressPoint;
            int oneCycle = (count + 1) * 700;
            int spotInCycle = (int)(SystemClock.elapsedRealtime() - this.mAnimatingPeriodStart) % oneCycle;
            int numCircles = spotInCycle / 700;
            this.clearPatternDrawLookup();
            for (int i = 0; i < numCircles; ++i) {
                Cell cell = pattern.get(i);
                drawLookup[cell.getRow()][cell.getColumn()] = true;
            }
            boolean bl = needToUpdateInProgressPoint = numCircles > 0 && numCircles < count;
            if (needToUpdateInProgressPoint) {
                float percentageOfNextCircle = (float)(spotInCycle % 700) / 700.0f;
                Cell currentCell = pattern.get(numCircles - 1);
                float centerX = this.getCenterXForColumn(currentCell.column);
                float centerY = this.getCenterYForRow(currentCell.row);
                Cell nextCell = pattern.get(numCircles);
                float dx = percentageOfNextCircle * (this.getCenterXForColumn(nextCell.column) - centerX);
                float dy = percentageOfNextCircle * (this.getCenterYForRow(nextCell.row) - centerY);
                this.mInProgressX = centerX + dx;
                this.mInProgressY = centerY + dy;
            }
            this.invalidate();
        }
        Path currentPath = this.mCurrentPath;
        currentPath.rewind();
        for (int i = 0; i < 3; ++i) {
            float centerY = this.getCenterYForRow(i);
            for (int j = 0; j < 3; ++j) {
                CellState cellState = this.mCellStates[i][j];
                float centerX = this.getCenterXForColumn(j);
                float size = cellState.size * cellState.scale;
                float translationY = cellState.translateY;
                this.drawCircle(canvas, (int)centerX, (float)((int)centerY) + translationY, size, drawLookup[i][j], cellState.alpha);
            }
        }
        boolean bl = drawPath = !this.mInStealthMode;
        if (drawPath) {
            this.mPathPaint.setColor(this.getCurrentColor(true));
            boolean anyCircles = false;
            float lastX = 0.0f;
            float lastY = 0.0f;
            for (int i = 0; i < count; ++i) {
                Cell cell = pattern.get(i);
                if (!drawLookup[cell.row][cell.column]) break;
                anyCircles = true;
                float centerX = this.getCenterXForColumn(cell.column);
                float centerY = this.getCenterYForRow(cell.row);
                if (i != 0) {
                    CellState state = this.mCellStates[cell.row][cell.column];
                    currentPath.rewind();
                    currentPath.moveTo(lastX, lastY);
                    if (state.lineEndX != Float.MIN_VALUE && state.lineEndY != Float.MIN_VALUE) {
                        currentPath.lineTo(state.lineEndX, state.lineEndY);
                    } else {
                        currentPath.lineTo(centerX, centerY);
                    }
                    canvas.drawPath(currentPath, this.mPathPaint);
                }
                lastX = centerX;
                lastY = centerY;
            }
            if ((this.mPatternInProgress || this.mPatternDisplayMode == DisplayMode.Animate) && anyCircles) {
                currentPath.rewind();
                currentPath.moveTo(lastX, lastY);
                currentPath.lineTo(this.mInProgressX, this.mInProgressY);
                this.mPathPaint.setAlpha((int)(this.calculateLastSegmentAlpha(this.mInProgressX, this.mInProgressY, lastX, lastY) * 255.0f));
                canvas.drawPath(currentPath, this.mPathPaint);
            }
        }
    }

    private float calculateLastSegmentAlpha(float x, float y, float lastX, float lastY) {
        float diffX = x - lastX;
        float diffY = y - lastY;
        float dist = (float)Math.sqrt(diffX * diffX + diffY * diffY);
        float frac = dist / this.mSquareWidth;
        return Math.min(1.0f, Math.max(0.0f, (frac - 0.3f) * 4.0f));
    }

    private int getCurrentColor(boolean partOfPattern) {
        if (!partOfPattern || this.mInStealthMode || this.mPatternInProgress) {
            return this.mRegularColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Wrong) {
            return this.mErrorColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Correct || this.mPatternDisplayMode == DisplayMode.Animate) {
            return this.mSuccessColor;
        }
        throw new IllegalStateException("unknown display mode " + (Object)((Object)this.mPatternDisplayMode));
    }

    private void drawCircle(Canvas canvas, float centerX, float centerY, float size, boolean partOfPattern, float alpha) {
        this.mPaint.setColor(this.getCurrentColor(partOfPattern));
        this.mPaint.setAlpha((int)(alpha * 255.0f));
        canvas.drawCircle(centerX, centerY, size / 2.0f, this.mPaint);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, LockPatternUtils.patternToString(this.mPattern), this.mPatternDisplayMode.ordinal(), this.mInputEnabled, this.mInStealthMode, this.mEnableHapticFeedback);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setPattern(DisplayMode.Correct, LockPatternUtils.stringToPattern(ss.getSerializedPattern()));
        this.mPatternDisplayMode = DisplayMode.values()[ss.getDisplayMode()];
        this.mInputEnabled = ss.isInputEnabled();
        this.mInStealthMode = ss.isInStealthMode();
        this.mEnableHapticFeedback = ss.isTactileFeedbackEnabled();
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final String mSerializedPattern;
        private final int mDisplayMode;
        private final boolean mInputEnabled;
        private final boolean mInStealthMode;
        private final boolean mTactileFeedbackEnabled;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, String serializedPattern, int displayMode, boolean inputEnabled, boolean inStealthMode, boolean tactileFeedbackEnabled) {
            super(superState);
            this.mSerializedPattern = serializedPattern;
            this.mDisplayMode = displayMode;
            this.mInputEnabled = inputEnabled;
            this.mInStealthMode = inStealthMode;
            this.mTactileFeedbackEnabled = tactileFeedbackEnabled;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mSerializedPattern = in.readString();
            this.mDisplayMode = in.readInt();
            this.mInputEnabled = (Boolean)in.readValue(null);
            this.mInStealthMode = (Boolean)in.readValue(null);
            this.mTactileFeedbackEnabled = (Boolean)in.readValue(null);
        }

        public String getSerializedPattern() {
            return this.mSerializedPattern;
        }

        public int getDisplayMode() {
            return this.mDisplayMode;
        }

        public boolean isInputEnabled() {
            return this.mInputEnabled;
        }

        public boolean isInStealthMode() {
            return this.mInStealthMode;
        }

        public boolean isTactileFeedbackEnabled() {
            return this.mTactileFeedbackEnabled;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.mSerializedPattern);
            dest.writeInt(this.mDisplayMode);
            dest.writeValue(this.mInputEnabled);
            dest.writeValue(this.mInStealthMode);
            dest.writeValue(this.mTactileFeedbackEnabled);
        }
    }

    public static interface OnPatternListener {
        public void onPatternStart();

        public void onPatternCleared();

        public void onPatternCellAdded(List<Cell> var1);

        public void onPatternDetected(List<Cell> var1);
    }

    public static enum DisplayMode {
        Correct,
        Animate,
        Wrong;

    }

    public static class CellState {
        public float scale = 1.0f;
        public float translateY = 0.0f;
        public float alpha = 1.0f;
        public float size;
        public float lineEndX = Float.MIN_VALUE;
        public float lineEndY = Float.MIN_VALUE;
        public ValueAnimator lineAnimator;
    }

    public static class Cell {
        int row;
        int column;
        static Cell[][] sCells = new Cell[3][3];

        private Cell(int row, int column) {
            Cell.checkRange(row, column);
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public static synchronized Cell of(int row, int column) {
            Cell.checkRange(row, column);
            return sCells[row][column];
        }

        private static void checkRange(int row, int column) {
            if (row < 0 || row > 2) {
                throw new IllegalArgumentException("row must be in range 0-2");
            }
            if (column < 0 || column > 2) {
                throw new IllegalArgumentException("column must be in range 0-2");
            }
        }

        public String toString() {
            return "(row=" + this.row + ",clmn=" + this.column + ")";
        }

        static {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Cell.sCells[i][j] = new Cell(i, j);
                }
            }
        }
    }
}

