/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.admin.DevicePolicyManager;
import android.app.trust.TrustManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.IWindowManager;
import android.widget.Button;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternView;
import com.google.android.collect.Lists;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LockPatternUtils {
    private static final String TAG = "LockPatternUtils";
    private static final boolean DEBUG = false;
    public static final int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final int FAILED_ATTEMPTS_BEFORE_WIPE_GRACE = 5;
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 4;
    public static final String KEYGUARD_SHOW_USER_SWITCHER = "showuserswitcher";
    public static final String KEYGUARD_SHOW_SECURITY_CHALLENGE = "showsecuritychallenge";
    public static final String KEYGUARD_SHOW_APPWIDGET = "showappwidget";
    public static final int FLAG_BIOMETRIC_WEAK_LIVELINESS = 1;
    public static final int ID_DEFAULT_STATUS_WIDGET = -2;
    public static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    public static final String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    public static final String PASSWORD_TYPE_ALTERNATE_KEY = "lockscreen.password_type_alternate";
    public static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    public static final String DISABLE_LOCKSCREEN_KEY = "lockscreen.disabled";
    public static final String LOCKSCREEN_OPTIONS = "lockscreen.options";
    public static final String LOCKSCREEN_BIOMETRIC_WEAK_FALLBACK = "lockscreen.biometric_weak_fallback";
    public static final String BIOMETRIC_WEAK_EVER_CHOSEN_KEY = "lockscreen.biometricweakeverchosen";
    public static final String LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS = "lockscreen.power_button_instantly_locks";
    public static final String LOCKSCREEN_WIDGETS_ENABLED = "lockscreen.widgets_enabled";
    public static final String PASSWORD_HISTORY_KEY = "lockscreen.passwordhistory";
    private static final String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
    private static final String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
    private static final String ENABLED_TRUST_AGENTS = "lockscreen.enabledtrustagents";
    public static final int MAX_ALLOWED_SEQUENCE = 3;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private DevicePolicyManager mDevicePolicyManager;
    private ILockSettings mLockSettingsService;
    private final boolean mMultiUserMode;
    private static volatile int sCurrentUserId = -10000;

    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    private TrustManager getTrustManager() {
        TrustManager trust = (TrustManager)this.mContext.getSystemService("trust");
        if (trust == null) {
            Log.e(TAG, "Can't get TrustManagerService: is it running?", new IllegalStateException("Stack trace:"));
        }
        return trust;
    }

    public LockPatternUtils(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mMultiUserMode = context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0;
    }

    private ILockSettings getLockSettings() {
        if (this.mLockSettingsService == null) {
            ILockSettings service;
            this.mLockSettingsService = service = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        }
        return this.mLockSettingsService;
    }

    public int getRequestedMinimumPasswordLength() {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordQuality() {
        return this.getDevicePolicyManager().getPasswordQuality(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordHistoryLength() {
        return this.getDevicePolicyManager().getPasswordHistoryLength(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumLetters() {
        return this.getDevicePolicyManager().getPasswordMinimumLetters(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumUpperCase() {
        return this.getDevicePolicyManager().getPasswordMinimumUpperCase(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumLowerCase() {
        return this.getDevicePolicyManager().getPasswordMinimumLowerCase(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumNumeric() {
        return this.getDevicePolicyManager().getPasswordMinimumNumeric(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumSymbols() {
        return this.getDevicePolicyManager().getPasswordMinimumSymbols(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumNonLetter() {
        return this.getDevicePolicyManager().getPasswordMinimumNonLetter(null, this.getCurrentOrCallingUserId());
    }

    public void reportFailedPasswordAttempt() {
        int userId = this.getCurrentOrCallingUserId();
        this.getDevicePolicyManager().reportFailedPasswordAttempt(userId);
        this.getTrustManager().reportUnlockAttempt(false, userId);
        this.getTrustManager().reportRequireCredentialEntry(userId);
    }

    public void reportSuccessfulPasswordAttempt() {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt(this.getCurrentOrCallingUserId());
        this.getTrustManager().reportUnlockAttempt(true, this.getCurrentOrCallingUserId());
    }

    public void setCurrentUser(int userId) {
        sCurrentUserId = userId;
    }

    public int getCurrentUser() {
        if (sCurrentUserId != -10000) {
            return sCurrentUserId;
        }
        try {
            return ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException re) {
            return 0;
        }
    }

    public void removeUser(int userId) {
        try {
            this.getLockSettings().removeUser(userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't remove lock settings for user " + userId);
        }
    }

    private int getCurrentOrCallingUserId() {
        if (this.mMultiUserMode) {
            return this.getCurrentUser();
        }
        return UserHandle.getCallingUserId();
    }

    public boolean checkPattern(List<LockPatternView.Cell> pattern) {
        int userId = this.getCurrentOrCallingUserId();
        try {
            return this.getLockSettings().checkPattern(LockPatternUtils.patternToString(pattern), userId);
        }
        catch (RemoteException re) {
            return true;
        }
    }

    public boolean checkPassword(String password) {
        int userId = this.getCurrentOrCallingUserId();
        try {
            return this.getLockSettings().checkPassword(password, userId);
        }
        catch (RemoteException re) {
            return true;
        }
    }

    public boolean checkVoldPassword() {
        int userId = this.getCurrentOrCallingUserId();
        try {
            return this.getLockSettings().checkVoldPassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public boolean checkPasswordHistory(String password) {
        String passwordHashString = new String(this.passwordToHash(password, this.getCurrentOrCallingUserId()));
        String passwordHistory = this.getString(PASSWORD_HISTORY_KEY);
        if (passwordHistory == null) {
            return false;
        }
        int passwordHashLength = passwordHashString.length();
        int passwordHistoryLength = this.getRequestedPasswordHistoryLength();
        if (passwordHistoryLength == 0) {
            return false;
        }
        int neededPasswordHistoryLength = passwordHashLength * passwordHistoryLength + passwordHistoryLength - 1;
        if (passwordHistory.length() > neededPasswordHistoryLength) {
            passwordHistory = passwordHistory.substring(0, neededPasswordHistoryLength);
        }
        return passwordHistory.contains(passwordHashString);
    }

    public boolean savedPatternExists() {
        return this.savedPatternExists(this.getCurrentOrCallingUserId());
    }

    public boolean savedPatternExists(int userId) {
        try {
            return this.getLockSettings().havePattern(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public boolean savedPasswordExists() {
        return this.savedPasswordExists(this.getCurrentOrCallingUserId());
    }

    public boolean savedPasswordExists(int userId) {
        try {
            return this.getLockSettings().havePassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public boolean isPatternEverChosen() {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY, false);
    }

    public boolean isBiometricWeakEverChosen() {
        return this.getBoolean(BIOMETRIC_WEAK_EVER_CHOSEN_KEY, false);
    }

    public int getActivePasswordQuality() {
        int activePasswordQuality = 0;
        int quality = (int)this.getLong(PASSWORD_TYPE_KEY, 65536L);
        switch (quality) {
            case 65536: {
                if (!this.isLockPatternEnabled()) break;
                activePasswordQuality = 65536;
                break;
            }
            case 32768: {
                if (!this.isBiometricWeakInstalled()) break;
                activePasswordQuality = 32768;
                break;
            }
            case 131072: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 131072;
                break;
            }
            case 196608: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 196608;
                break;
            }
            case 262144: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 262144;
                break;
            }
            case 327680: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 327680;
                break;
            }
            case 393216: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 393216;
            }
        }
        return activePasswordQuality;
    }

    public void clearLock(boolean isFallback) {
        this.clearLock(isFallback, this.getCurrentOrCallingUserId());
    }

    public void clearLock(boolean isFallback, int userHandle) {
        if (!isFallback) {
            this.deleteGallery(userHandle);
        }
        this.saveLockPassword(null, 65536, isFallback, userHandle);
        this.setLockPatternEnabled(false, userHandle);
        this.saveLockPattern(null, isFallback, userHandle);
        this.setLong(PASSWORD_TYPE_KEY, 0L, userHandle);
        this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L, userHandle);
        this.onAfterChangingPassword(userHandle);
    }

    public void setLockScreenDisabled(boolean disable) {
        this.setLong(DISABLE_LOCKSCREEN_KEY, disable ? 1L : 0L);
    }

    public boolean isLockScreenDisabled() {
        if (!this.isSecure() && this.getLong(DISABLE_LOCKSCREEN_KEY, 0L) != 0L) {
            List<UserInfo> users = UserManager.get(this.mContext).getUsers(true);
            int userCount = users.size();
            int switchableUsers = 0;
            for (int i = 0; i < userCount; ++i) {
                if (!users.get(i).supportsSwitchTo()) continue;
                ++switchableUsers;
            }
            return switchableUsers < 2;
        }
        return false;
    }

    public void deleteTempGallery() {
        Intent intent = new Intent().setAction("com.android.facelock.DELETE_GALLERY");
        intent.putExtra("deleteTempGallery", true);
        this.mContext.sendBroadcast(intent);
    }

    void deleteGallery(int userId) {
        if (this.usingBiometricWeak(userId)) {
            Intent intent = new Intent().setAction("com.android.facelock.DELETE_GALLERY");
            intent.putExtra("deleteGallery", true);
            this.mContext.sendBroadcastAsUser(intent, new UserHandle(userId));
        }
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern) {
        this.saveLockPattern(pattern, false);
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern, boolean isFallback) {
        this.saveLockPattern(pattern, isFallback, this.getCurrentOrCallingUserId());
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern, boolean isFallback, int userId) {
        try {
            this.getLockSettings().setLockPattern(LockPatternUtils.patternToString(pattern), userId);
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (pattern != null) {
                if (userId == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                    boolean required = this.isCredentialRequiredToDecrypt(true);
                    if (!required) {
                        this.clearEncryptionPassword();
                    } else {
                        String stringPattern = LockPatternUtils.patternToString(pattern);
                        this.updateEncryptionPassword(2, stringPattern);
                    }
                }
                this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true, userId);
                if (!isFallback) {
                    this.deleteGallery(userId);
                    this.setLong(PASSWORD_TYPE_KEY, 65536L, userId);
                    dpm.setActivePasswordState(65536, pattern.size(), 0, 0, 0, 0, 0, 0, userId);
                } else {
                    this.setLong(PASSWORD_TYPE_KEY, 32768L, userId);
                    this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, 65536L, userId);
                    this.finishBiometricWeak(userId);
                    dpm.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, userId);
                }
            } else {
                dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userId);
            }
            this.onAfterChangingPassword(userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't save lock pattern " + re);
        }
    }

    private void updateCryptoUserInfo() {
        int userId = this.getCurrentOrCallingUserId();
        if (userId != 0) {
            return;
        }
        String ownerInfo = this.isOwnerInfoEnabled() ? this.getOwnerInfo(userId) : "";
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            Log.d(TAG, "Setting owner info");
            mountService.setField("OwnerInfo", ownerInfo);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing user info", e);
        }
    }

    public void setOwnerInfo(String info, int userId) {
        this.setString(LOCK_SCREEN_OWNER_INFO, info, userId);
        this.updateCryptoUserInfo();
    }

    public void setOwnerInfoEnabled(boolean enabled) {
        this.setBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, enabled);
        this.updateCryptoUserInfo();
    }

    public String getOwnerInfo(int userId) {
        return this.getString(LOCK_SCREEN_OWNER_INFO);
    }

    public boolean isOwnerInfoEnabled() {
        return this.getBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, false);
    }

    public static int computePasswordQuality(String password) {
        boolean hasDigit = false;
        boolean hasNonDigit = false;
        int len = password.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(password.charAt(i))) {
                hasDigit = true;
                continue;
            }
            hasNonDigit = true;
        }
        if (hasNonDigit && hasDigit) {
            return 327680;
        }
        if (hasNonDigit) {
            return 262144;
        }
        if (hasDigit) {
            return LockPatternUtils.maxLengthSequence(password) > 3 ? 131072 : 196608;
        }
        return 0;
    }

    private static int categoryChar(char c) {
        if ('a' <= c && c <= 'z') {
            return 0;
        }
        if ('A' <= c && c <= 'Z') {
            return 1;
        }
        if ('0' <= c && c <= '9') {
            return 2;
        }
        return 3;
    }

    private static int maxDiffCategory(int category) {
        if (category == 0 || category == 1) {
            return 1;
        }
        if (category == 2) {
            return 10;
        }
        return 0;
    }

    public static int maxLengthSequence(String string2) {
        if (string2.length() == 0) {
            return 0;
        }
        char previousChar = string2.charAt(0);
        int category = LockPatternUtils.categoryChar(previousChar);
        int diff = 0;
        boolean hasDiff = false;
        int maxLength = 0;
        int startSequence = 0;
        for (int current = 1; current < string2.length(); ++current) {
            char currentChar = string2.charAt(current);
            int categoryCurrent = LockPatternUtils.categoryChar(currentChar);
            int currentDiff = currentChar - previousChar;
            if (categoryCurrent != category || Math.abs(currentDiff) > LockPatternUtils.maxDiffCategory(category)) {
                maxLength = Math.max(maxLength, current - startSequence);
                startSequence = current;
                hasDiff = false;
                category = categoryCurrent;
            } else {
                if (hasDiff && currentDiff != diff) {
                    maxLength = Math.max(maxLength, current - startSequence);
                    startSequence = current - 1;
                }
                diff = currentDiff;
                hasDiff = true;
            }
            previousChar = currentChar;
        }
        maxLength = Math.max(maxLength, string2.length() - startSequence);
        return maxLength;
    }

    private void updateEncryptionPassword(final int type, final String password) {
        if (!LockPatternUtils.isDeviceEncryptionEnabled()) {
            return;
        }
        final IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the encryption password");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... dummy) {
                IMountService mountService = IMountService.Stub.asInterface(service);
                try {
                    mountService.changeEncryptionPassword(type, password);
                }
                catch (RemoteException e) {
                    Log.e(LockPatternUtils.TAG, "Error changing encryption password", e);
                }
                return null;
            }
        }.execute(new Void[0]);
    }

    public void saveLockPassword(String password, int quality) {
        this.saveLockPassword(password, quality, false, this.getCurrentOrCallingUserId());
    }

    public void saveLockPassword(String password, int quality, boolean isFallback) {
        this.saveLockPassword(password, quality, isFallback, this.getCurrentOrCallingUserId());
    }

    public void saveLockPassword(String password, int quality, boolean isFallback, int userHandle) {
        try {
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (!TextUtils.isEmpty(password)) {
                int passwordHistoryLength;
                this.getLockSettings().setLockPassword(password, userHandle);
                int computedQuality = LockPatternUtils.computePasswordQuality(password);
                if (userHandle == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                    if (!this.isCredentialRequiredToDecrypt(true)) {
                        this.clearEncryptionPassword();
                    } else {
                        boolean numeric = computedQuality == 131072;
                        boolean numericComplex = computedQuality == 196608;
                        int type = numeric || numericComplex ? 3 : 0;
                        this.updateEncryptionPassword(type, password);
                    }
                }
                if (!isFallback) {
                    this.deleteGallery(userHandle);
                    this.setLong(PASSWORD_TYPE_KEY, Math.max(quality, computedQuality), userHandle);
                    if (computedQuality != 0) {
                        int letters = 0;
                        int uppercase = 0;
                        int lowercase = 0;
                        int numbers = 0;
                        int symbols = 0;
                        int nonletter = 0;
                        for (int i = 0; i < password.length(); ++i) {
                            char c = password.charAt(i);
                            if (c >= 'A' && c <= 'Z') {
                                ++letters;
                                ++uppercase;
                                continue;
                            }
                            if (c >= 'a' && c <= 'z') {
                                ++letters;
                                ++lowercase;
                                continue;
                            }
                            if (c >= '0' && c <= '9') {
                                ++numbers;
                                ++nonletter;
                                continue;
                            }
                            ++symbols;
                            ++nonletter;
                        }
                        dpm.setActivePasswordState(Math.max(quality, computedQuality), password.length(), letters, uppercase, lowercase, numbers, symbols, nonletter, userHandle);
                    } else {
                        dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
                    }
                } else {
                    this.setLong(PASSWORD_TYPE_KEY, 32768L, userHandle);
                    this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, Math.max(quality, computedQuality), userHandle);
                    this.finishBiometricWeak(userHandle);
                    dpm.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, userHandle);
                }
                String passwordHistory = this.getString(PASSWORD_HISTORY_KEY, userHandle);
                if (passwordHistory == null) {
                    passwordHistory = "";
                }
                if ((passwordHistoryLength = this.getRequestedPasswordHistoryLength()) == 0) {
                    passwordHistory = "";
                } else {
                    byte[] hash = this.passwordToHash(password, userHandle);
                    passwordHistory = new String(hash) + "," + passwordHistory;
                    passwordHistory = passwordHistory.substring(0, Math.min(hash.length * passwordHistoryLength + passwordHistoryLength - 1, passwordHistory.length()));
                }
                this.setString(PASSWORD_HISTORY_KEY, passwordHistory, userHandle);
            } else {
                this.getLockSettings().setLockPassword(null, userHandle);
                if (userHandle == 0) {
                    this.updateEncryptionPassword(1, null);
                }
                dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
            }
            this.onAfterChangingPassword(userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Unable to save lock password " + re);
        }
    }

    public static boolean isDeviceEncrypted() {
        IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        try {
            return mountService.getEncryptionState() != 1 && mountService.getPasswordType() != 1;
        }
        catch (RemoteException re) {
            Log.e(TAG, "Error getting encryption state", re);
            return true;
        }
    }

    public static boolean isDeviceEncryptionEnabled() {
        String status = SystemProperties.get("ro.crypto.state", "unsupported");
        return "encrypted".equalsIgnoreCase(status);
    }

    public void clearEncryptionPassword() {
        this.updateEncryptionPassword(1, null);
    }

    public int getKeyguardStoredPasswordQuality() {
        return this.getKeyguardStoredPasswordQuality(this.getCurrentOrCallingUserId());
    }

    public int getKeyguardStoredPasswordQuality(int userHandle) {
        int quality = (int)this.getLong(PASSWORD_TYPE_KEY, 0L, userHandle);
        if (quality == 32768) {
            quality = (int)this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L, userHandle);
        }
        return quality;
    }

    public boolean usingBiometricWeak() {
        return this.usingBiometricWeak(this.getCurrentOrCallingUserId());
    }

    public boolean usingBiometricWeak(int userId) {
        int quality = (int)this.getLong(PASSWORD_TYPE_KEY, 0L, userId);
        return quality == 32768;
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        byte[] bytes = string2.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    public static String patternToString(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        return new String(res);
    }

    public static byte[] patternToHash(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return null;
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(res);
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            return res;
        }
    }

    private String getSalt(int userId) {
        long salt = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L, userId);
        if (salt == 0L) {
            try {
                salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                this.setLong(LOCK_PASSWORD_SALT_KEY, salt, userId);
                Log.v(TAG, "Initialized lock password salt for user: " + userId);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Couldn't get SecureRandom number", e);
            }
        }
        return Long.toHexString(salt);
    }

    public byte[] passwordToHash(String password, int userId) {
        if (password == null) {
            return null;
        }
        String algo = null;
        byte[] hashed = null;
        try {
            byte[] saltedPassword = (password + this.getSalt(userId)).getBytes();
            algo = "SHA-1";
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            algo = "MD5";
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            hashed = (LockPatternUtils.toHex(sha1) + LockPatternUtils.toHex(md5)).getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            Log.w(TAG, "Failed to encode string because of missing algorithm: " + algo);
        }
        return hashed;
    }

    private static String toHex(byte[] ary) {
        String hex = "0123456789ABCDEF";
        String ret = "";
        for (int i = 0; i < ary.length; ++i) {
            ret = ret + "0123456789ABCDEF".charAt(ary[i] >> 4 & 0xF);
            ret = ret + "0123456789ABCDEF".charAt(ary[i] & 0xF);
        }
        return ret;
    }

    public boolean isLockPasswordEnabled() {
        long mode = this.getLong(PASSWORD_TYPE_KEY, 0L);
        long backupMode = this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L);
        boolean passwordEnabled = mode == 262144L || mode == 131072L || mode == 196608L || mode == 327680L || mode == 393216L;
        boolean backupEnabled = backupMode == 262144L || backupMode == 131072L || backupMode == 196608L || backupMode == 327680L || backupMode == 393216L;
        return this.savedPasswordExists() && (passwordEnabled || this.usingBiometricWeak() && backupEnabled);
    }

    public boolean isLockPatternEnabled() {
        return this.isLockPatternEnabled(this.getCurrentOrCallingUserId());
    }

    public boolean isLockPatternEnabled(int userId) {
        boolean backupEnabled = this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L, userId) == 65536L;
        return this.getBoolean("lock_pattern_autolock", false, userId) && (this.getLong(PASSWORD_TYPE_KEY, 0L, userId) == 65536L || this.usingBiometricWeak(userId) && backupEnabled);
    }

    public boolean isBiometricWeakInstalled() {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pm.getPackageInfo("com.android.facelock", 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        if (!pm.hasSystemFeature("android.hardware.camera.front")) {
            return false;
        }
        if (this.getDevicePolicyManager().getCameraDisabled(null, this.getCurrentOrCallingUserId())) {
            return false;
        }
        return false;
    }

    public void setBiometricWeakLivelinessEnabled(boolean enabled) {
        long currentFlag = this.getLong("lock_biometric_weak_flags", 0L);
        long newFlag = enabled ? currentFlag | 1L : currentFlag & 0xFFFFFFFFFFFFFFFEL;
        this.setLong("lock_biometric_weak_flags", newFlag);
    }

    public boolean isBiometricWeakLivelinessEnabled() {
        long currentFlag = this.getLong("lock_biometric_weak_flags", 0L);
        return (currentFlag & 1L) != 0L;
    }

    public void setLockPatternEnabled(boolean enabled) {
        this.setLockPatternEnabled(enabled, this.getCurrentOrCallingUserId());
    }

    public void setLockPatternEnabled(boolean enabled, int userHandle) {
        this.setBoolean("lock_pattern_autolock", enabled, userHandle);
    }

    public boolean isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern", false);
    }

    public void setVisiblePatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_visible_pattern", enabled);
        int userId = this.getCurrentOrCallingUserId();
        if (userId != 0) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            mountService.setField("PatternVisible", enabled ? "1" : "0");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing pattern visible state", e);
        }
    }

    public boolean isTactileFeedbackEnabled() {
        return Settings.System.getIntForUser(this.mContentResolver, "haptic_feedback_enabled", 1, -2) != 0;
    }

    public long setLockoutAttemptDeadline() {
        long deadline = SystemClock.elapsedRealtime() + 30000L;
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, deadline);
        return deadline;
    }

    public long getLockoutAttemptDeadline() {
        long now;
        long deadline = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L);
        if (deadline < (now = SystemClock.elapsedRealtime()) || deadline > now + 30000L) {
            return 0L;
        }
        return deadline;
    }

    public boolean isPermanentlyLocked() {
        return this.getBoolean(LOCKOUT_PERMANENT_KEY, false);
    }

    public void setPermanentlyLocked(boolean locked) {
        this.setBoolean(LOCKOUT_PERMANENT_KEY, locked);
    }

    public boolean isEmergencyCallCapable() {
        return this.mContext.getResources().getBoolean(17956942);
    }

    public boolean isPukUnlockScreenEnable() {
        return this.mContext.getResources().getBoolean(17956927);
    }

    public boolean isEmergencyCallEnabledWhileSimLocked() {
        return this.mContext.getResources().getBoolean(17956928);
    }

    public AlarmManager.AlarmClockInfo getNextAlarm() {
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        return alarmManager.getNextAlarmClock(-2);
    }

    private boolean getBoolean(String secureSettingKey, boolean defaultValue, int userId) {
        try {
            return this.getLockSettings().getBoolean(secureSettingKey, defaultValue, userId);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private boolean getBoolean(String secureSettingKey, boolean defaultValue) {
        return this.getBoolean(secureSettingKey, defaultValue, this.getCurrentOrCallingUserId());
    }

    private void setBoolean(String secureSettingKey, boolean enabled, int userId) {
        try {
            this.getLockSettings().setBoolean(secureSettingKey, enabled, userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write boolean " + secureSettingKey + re);
        }
    }

    private void setBoolean(String secureSettingKey, boolean enabled) {
        this.setBoolean(secureSettingKey, enabled, this.getCurrentOrCallingUserId());
    }

    public int[] getAppWidgets() {
        return this.getAppWidgets(-2);
    }

    private int[] getAppWidgets(int userId) {
        String appWidgetIdString = Settings.Secure.getStringForUser(this.mContentResolver, "lock_screen_appwidget_ids", userId);
        String delims = ",";
        if (appWidgetIdString != null && appWidgetIdString.length() > 0) {
            String[] appWidgetStringIds = appWidgetIdString.split(delims);
            int[] appWidgetIds = new int[appWidgetStringIds.length];
            for (int i = 0; i < appWidgetStringIds.length; ++i) {
                String appWidget = appWidgetStringIds[i];
                try {
                    appWidgetIds[i] = Integer.decode(appWidget);
                    continue;
                }
                catch (NumberFormatException e) {
                    Log.d(TAG, "Error when parsing widget id " + appWidget);
                    return null;
                }
            }
            return appWidgetIds;
        }
        return new int[0];
    }

    private static String combineStrings(int[] list, String separator) {
        int listLength = list.length;
        switch (listLength) {
            case 0: {
                return "";
            }
            case 1: {
                return Integer.toString(list[0]);
            }
        }
        int strLength = 0;
        int separatorLength = separator.length();
        String[] stringList = new String[list.length];
        for (int i = 0; i < listLength; ++i) {
            stringList[i] = Integer.toString(list[i]);
            strLength += stringList[i].length();
            if (i >= listLength - 1) continue;
            strLength += separatorLength;
        }
        StringBuilder sb = new StringBuilder(strLength);
        for (int i = 0; i < listLength; ++i) {
            sb.append(list[i]);
            if (i >= listLength - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public void writeFallbackAppWidgetId(int appWidgetId) {
        Settings.Secure.putIntForUser(this.mContentResolver, "lock_screen_fallback_appwidget_id", appWidgetId, -2);
    }

    public int getFallbackAppWidgetId() {
        return Settings.Secure.getIntForUser(this.mContentResolver, "lock_screen_fallback_appwidget_id", 0, -2);
    }

    private void writeAppWidgets(int[] appWidgetIds) {
        Settings.Secure.putStringForUser(this.mContentResolver, "lock_screen_appwidget_ids", LockPatternUtils.combineStrings(appWidgetIds, ","), -2);
    }

    public boolean addAppWidget(int widgetId, int index) {
        int[] widgets = this.getAppWidgets();
        if (widgets == null) {
            return false;
        }
        if (index < 0 || index > widgets.length) {
            return false;
        }
        int[] newWidgets = new int[widgets.length + 1];
        int j = 0;
        for (int i = 0; i < newWidgets.length; ++i) {
            if (index == i) {
                newWidgets[i] = widgetId;
                ++i;
            }
            if (i >= newWidgets.length) continue;
            newWidgets[i] = widgets[j];
            ++j;
        }
        this.writeAppWidgets(newWidgets);
        return true;
    }

    public boolean removeAppWidget(int widgetId) {
        int[] widgets = this.getAppWidgets();
        if (widgets.length == 0) {
            return false;
        }
        int[] newWidgets = new int[widgets.length - 1];
        int j = 0;
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i] == widgetId) continue;
            if (j >= newWidgets.length) {
                return false;
            }
            newWidgets[j] = widgets[i];
            ++j;
        }
        this.writeAppWidgets(newWidgets);
        return true;
    }

    private long getLong(String secureSettingKey, long defaultValue, int userHandle) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, userHandle);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private long getLong(String secureSettingKey, long defaultValue) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, this.getCurrentOrCallingUserId());
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private void setLong(String secureSettingKey, long value) {
        this.setLong(secureSettingKey, value, this.getCurrentOrCallingUserId());
    }

    private void setLong(String secureSettingKey, long value, int userHandle) {
        try {
            this.getLockSettings().setLong(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write long " + secureSettingKey + re);
        }
    }

    private String getString(String secureSettingKey) {
        return this.getString(secureSettingKey, this.getCurrentOrCallingUserId());
    }

    private String getString(String secureSettingKey, int userHandle) {
        try {
            return this.getLockSettings().getString(secureSettingKey, null, userHandle);
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private void setString(String secureSettingKey, String value, int userHandle) {
        try {
            this.getLockSettings().setString(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write string " + secureSettingKey + re);
        }
    }

    public boolean isSecure() {
        return this.isSecure(this.getCurrentOrCallingUserId());
    }

    public boolean isSecure(int userId) {
        long mode = this.getKeyguardStoredPasswordQuality(userId);
        boolean isPattern = mode == 65536L;
        boolean isPassword = mode == 131072L || mode == 196608L || mode == 262144L || mode == 327680L || mode == 393216L;
        boolean secure = isPattern && this.isLockPatternEnabled(userId) && this.savedPatternExists(userId) || isPassword && this.savedPasswordExists(userId);
        return secure;
    }

    public void updateEmergencyCallButtonState(Button button, boolean shown, boolean showIcon) {
        int textId;
        if (!this.isEmergencyCallCapable() || !shown) {
            button.setVisibility(8);
            return;
        }
        button.setVisibility(0);
        if (this.isInCall()) {
            textId = 17040266;
            int phoneCallIcon = showIcon ? 17301636 : 0;
            button.setCompoundDrawablesWithIntrinsicBounds(phoneCallIcon, 0, 0, 0);
        } else {
            textId = 17040265;
            int emergencyIcon = showIcon ? 17302360 : 0;
            button.setCompoundDrawablesWithIntrinsicBounds(emergencyIcon, 0, 0, 0);
        }
        button.setText(textId);
    }

    public void resumeCall() {
        this.getTelecommManager().showInCallScreen(false);
    }

    public boolean isInCall() {
        return this.getTelecommManager().isInCall();
    }

    private TelecomManager getTelecommManager() {
        return (TelecomManager)this.mContext.getSystemService("telecom");
    }

    private void finishBiometricWeak(int userId) {
        this.setBoolean(BIOMETRIC_WEAK_EVER_CHOSEN_KEY, true, userId);
        Intent intent = new Intent();
        intent.setClassName("com.android.facelock", "com.android.facelock.SetupEndScreen");
        this.mContext.startActivityAsUser(intent, new UserHandle(userId));
    }

    public void setPowerButtonInstantlyLocks(boolean enabled) {
        this.setBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, enabled);
    }

    public boolean getPowerButtonInstantlyLocks() {
        return this.getBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, true);
    }

    public static boolean isSafeModeEnabled() {
        try {
            return IWindowManager.Stub.asInterface(ServiceManager.getService("window")).isSafeModeEnabled();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean hasWidgetsEnabledInKeyguard(int userid) {
        int[] widgets = this.getAppWidgets(userid);
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i] <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean getWidgetsEnabled() {
        return this.getWidgetsEnabled(this.getCurrentOrCallingUserId());
    }

    public boolean getWidgetsEnabled(int userId) {
        return this.getBoolean(LOCKSCREEN_WIDGETS_ENABLED, false, userId);
    }

    public void setWidgetsEnabled(boolean enabled) {
        this.setWidgetsEnabled(enabled, this.getCurrentOrCallingUserId());
    }

    public void setWidgetsEnabled(boolean enabled, int userId) {
        this.setBoolean(LOCKSCREEN_WIDGETS_ENABLED, enabled, userId);
    }

    public void setEnabledTrustAgents(Collection<ComponentName> activeTrustAgents) {
        this.setEnabledTrustAgents(activeTrustAgents, this.getCurrentOrCallingUserId());
    }

    public List<ComponentName> getEnabledTrustAgents() {
        return this.getEnabledTrustAgents(this.getCurrentOrCallingUserId());
    }

    public void setEnabledTrustAgents(Collection<ComponentName> activeTrustAgents, int userId) {
        StringBuilder sb = new StringBuilder();
        for (ComponentName cn : activeTrustAgents) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(cn.flattenToShortString());
        }
        this.setString(ENABLED_TRUST_AGENTS, sb.toString(), userId);
        this.getTrustManager().reportEnabledTrustAgentsChanged(this.getCurrentOrCallingUserId());
    }

    public List<ComponentName> getEnabledTrustAgents(int userId) {
        String serialized = this.getString(ENABLED_TRUST_AGENTS, userId);
        if (TextUtils.isEmpty(serialized)) {
            return null;
        }
        String[] split = serialized.split(",");
        ArrayList<ComponentName> activeTrustAgents = new ArrayList<ComponentName>(split.length);
        for (String s : split) {
            if (TextUtils.isEmpty(s)) continue;
            activeTrustAgents.add(ComponentName.unflattenFromString(s));
        }
        return activeTrustAgents;
    }

    public void requireCredentialEntry(int userId) {
        this.getTrustManager().reportRequireCredentialEntry(userId);
    }

    private void onAfterChangingPassword(int userHandle) {
        this.getTrustManager().reportEnabledTrustAgentsChanged(userHandle);
    }

    public boolean isCredentialRequiredToDecrypt(boolean defaultValue) {
        int value = Settings.Global.getInt(this.mContentResolver, "require_password_to_decrypt", -1);
        return value == -1 ? defaultValue : value != 0;
    }

    public void setCredentialRequiredToDecrypt(boolean required) {
        if (this.getCurrentUser() != 0) {
            Log.w(TAG, "Only device owner may call setCredentialRequiredForDecrypt()");
            return;
        }
        Settings.Global.putInt(this.mContext.getContentResolver(), "require_password_to_decrypt", required ? 1 : 0);
    }
}

