/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.ViewDebug;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Calendar;
import java.util.TimeZone;
import libcore.icu.LocaleData;

@RemoteViews.RemoteView
public class TextClock
extends TextView {
    public static final CharSequence DEFAULT_FORMAT_12_HOUR = "h:mm a";
    public static final CharSequence DEFAULT_FORMAT_24_HOUR = "H:mm";
    private CharSequence mFormat12;
    private CharSequence mFormat24;
    @ViewDebug.ExportedProperty
    private CharSequence mFormat;
    @ViewDebug.ExportedProperty
    private boolean mHasSeconds;
    private boolean mAttached;
    private Calendar mTime;
    private String mTimeZone;
    private boolean mShowCurrentUserTime;
    private final ContentObserver mFormatChangeObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            TextClock.this.chooseFormat();
            TextClock.this.onTimeChanged();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            TextClock.this.chooseFormat();
            TextClock.this.onTimeChanged();
        }
    };
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (TextClock.this.mTimeZone == null && "android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                String timeZone = intent.getStringExtra("time-zone");
                TextClock.this.createTime(timeZone);
            }
            TextClock.this.onTimeChanged();
        }
    };
    private final Runnable mTicker = new Runnable(){

        @Override
        public void run() {
            TextClock.this.onTimeChanged();
            long now = SystemClock.uptimeMillis();
            long next = now + (1000L - now % 1000L);
            TextClock.this.getHandler().postAtTime(TextClock.this.mTicker, next);
        }
    };

    public TextClock(Context context) {
        super(context);
        this.init();
    }

    public TextClock(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextClock(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextClock(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextClock, defStyleAttr, defStyleRes);
        try {
            this.mFormat12 = a.getText(0);
            this.mFormat24 = a.getText(1);
            this.mTimeZone = a.getString(2);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        if (this.mFormat12 == null || this.mFormat24 == null) {
            LocaleData ld = LocaleData.get(this.getContext().getResources().getConfiguration().locale);
            if (this.mFormat12 == null) {
                this.mFormat12 = ld.timeFormat12;
            }
            if (this.mFormat24 == null) {
                this.mFormat24 = ld.timeFormat24;
            }
        }
        this.createTime(this.mTimeZone);
        this.chooseFormat(false);
    }

    private void createTime(String timeZone) {
        this.mTime = timeZone != null ? Calendar.getInstance(TimeZone.getTimeZone(timeZone)) : Calendar.getInstance();
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat12Hour() {
        return this.mFormat12;
    }

    @RemotableViewMethod
    public void setFormat12Hour(CharSequence format) {
        this.mFormat12 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat24Hour() {
        return this.mFormat24;
    }

    @RemotableViewMethod
    public void setFormat24Hour(CharSequence format) {
        this.mFormat24 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    public void setShowCurrentUserTime(boolean showCurrentUserTime) {
        this.mShowCurrentUserTime = showCurrentUserTime;
        this.chooseFormat();
        this.onTimeChanged();
        this.unregisterObserver();
        this.registerObserver();
    }

    public boolean is24HourModeEnabled() {
        if (this.mShowCurrentUserTime) {
            return DateFormat.is24HourFormat(this.getContext(), ActivityManager.getCurrentUser());
        }
        return DateFormat.is24HourFormat(this.getContext());
    }

    public String getTimeZone() {
        return this.mTimeZone;
    }

    @RemotableViewMethod
    public void setTimeZone(String timeZone) {
        this.mTimeZone = timeZone;
        this.createTime(timeZone);
        this.onTimeChanged();
    }

    private void chooseFormat() {
        this.chooseFormat(true);
    }

    public CharSequence getFormat() {
        return this.mFormat;
    }

    private void chooseFormat(boolean handleTicker) {
        boolean format24Requested = this.is24HourModeEnabled();
        LocaleData ld = LocaleData.get(this.getContext().getResources().getConfiguration().locale);
        this.mFormat = format24Requested ? TextClock.abc(this.mFormat24, this.mFormat12, ld.timeFormat24) : TextClock.abc(this.mFormat12, this.mFormat24, ld.timeFormat12);
        boolean hadSeconds = this.mHasSeconds;
        this.mHasSeconds = DateFormat.hasSeconds(this.mFormat);
        if (handleTicker && this.mAttached && hadSeconds != this.mHasSeconds) {
            if (hadSeconds) {
                this.getHandler().removeCallbacks(this.mTicker);
            } else {
                this.mTicker.run();
            }
        }
    }

    private static CharSequence abc(CharSequence a, CharSequence b, CharSequence c) {
        return a == null ? (b == null ? c : b) : a;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            this.registerReceiver();
            this.registerObserver();
            this.createTime(this.mTimeZone);
            if (this.mHasSeconds) {
                this.mTicker.run();
            } else {
                this.onTimeChanged();
            }
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.unregisterReceiver();
            this.unregisterObserver();
            this.getHandler().removeCallbacks(this.mTicker);
            this.mAttached = false;
        }
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.TIME_TICK");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        this.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.getHandler());
    }

    private void registerObserver() {
        ContentResolver resolver = this.getContext().getContentResolver();
        if (this.mShowCurrentUserTime) {
            resolver.registerContentObserver(Settings.System.CONTENT_URI, true, this.mFormatChangeObserver, -1);
        } else {
            resolver.registerContentObserver(Settings.System.CONTENT_URI, true, this.mFormatChangeObserver);
        }
    }

    private void unregisterReceiver() {
        this.getContext().unregisterReceiver(this.mIntentReceiver);
    }

    private void unregisterObserver() {
        ContentResolver resolver = this.getContext().getContentResolver();
        resolver.unregisterContentObserver(this.mFormatChangeObserver);
    }

    private void onTimeChanged() {
        this.mTime.setTimeInMillis(System.currentTimeMillis());
        this.setText(DateFormat.format(this.mFormat, this.mTime));
    }
}

