/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.SimpleMonthView;
import com.android.internal.R;
import java.util.Calendar;

class SimpleMonthAdapter
extends BaseAdapter {
    private final Calendar mMinDate = Calendar.getInstance();
    private final Calendar mMaxDate = Calendar.getInstance();
    private final Context mContext;
    private Calendar mSelectedDay = Calendar.getInstance();
    private ColorStateList mCalendarTextColors = ColorStateList.valueOf(-16777216);
    private OnDaySelectedListener mOnDaySelectedListener;
    private int mFirstDayOfWeek;
    private final SimpleMonthView.OnDayClickListener mOnDayClickListener = new SimpleMonthView.OnDayClickListener(){

        @Override
        public void onDayClick(SimpleMonthView view, Calendar day) {
            if (day != null && SimpleMonthAdapter.this.isCalendarInRange(day)) {
                SimpleMonthAdapter.this.setSelectedDay(day);
                if (SimpleMonthAdapter.this.mOnDaySelectedListener != null) {
                    SimpleMonthAdapter.this.mOnDaySelectedListener.onDaySelected(SimpleMonthAdapter.this, day);
                }
            }
        }
    };

    public SimpleMonthAdapter(Context context) {
        this.mContext = context;
    }

    public void setRange(Calendar min, Calendar max) {
        this.mMinDate.setTimeInMillis(min.getTimeInMillis());
        this.mMaxDate.setTimeInMillis(max.getTimeInMillis());
        this.notifyDataSetInvalidated();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.notifyDataSetInvalidated();
    }

    public int getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    public void setSelectedDay(Calendar day) {
        this.mSelectedDay = day;
        this.notifyDataSetChanged();
    }

    public void setOnDaySelectedListener(OnDaySelectedListener listener) {
        this.mOnDaySelectedListener = listener;
    }

    void setCalendarTextColor(ColorStateList colors) {
        this.mCalendarTextColors = colors;
    }

    void setCalendarTextAppearance(int resId) {
        TypedArray a = this.mContext.obtainStyledAttributes(resId, R.styleable.TextAppearance);
        ColorStateList textColor = a.getColorStateList(3);
        if (textColor != null) {
            this.mCalendarTextColors = textColor;
        }
        a.recycle();
    }

    @Override
    public int getCount() {
        int diffYear = this.mMaxDate.get(1) - this.mMinDate.get(1);
        int diffMonth = this.mMaxDate.get(2) - this.mMinDate.get(2);
        return diffMonth + 12 * diffYear + 1;
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        SimpleMonthView v;
        if (convertView != null) {
            v = (SimpleMonthView)convertView;
        } else {
            v = new SimpleMonthView(this.mContext);
            AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
            v.setLayoutParams(params);
            v.setClickable(true);
            v.setOnDayClickListener(this.mOnDayClickListener);
            if (this.mCalendarTextColors != null) {
                v.setTextColor(this.mCalendarTextColors);
            }
        }
        int minMonth = this.mMinDate.get(2);
        int minYear = this.mMinDate.get(1);
        int currentMonth = position + minMonth;
        int month = currentMonth % 12;
        int year = currentMonth / 12 + minYear;
        int selectedDay = this.isSelectedDayInMonth(year, month) ? this.mSelectedDay.get(5) : -1;
        v.reuse();
        int enabledDayRangeStart = minMonth == month && minYear == year ? this.mMinDate.get(5) : 1;
        int enabledDayRangeEnd = this.mMaxDate.get(2) == month && this.mMaxDate.get(1) == year ? this.mMaxDate.get(5) : 31;
        v.setMonthParams(selectedDay, month, year, this.mFirstDayOfWeek, enabledDayRangeStart, enabledDayRangeEnd);
        v.invalidate();
        return v;
    }

    private boolean isSelectedDayInMonth(int year, int month) {
        return this.mSelectedDay.get(1) == year && this.mSelectedDay.get(2) == month;
    }

    private boolean isCalendarInRange(Calendar value) {
        return value.compareTo(this.mMinDate) >= 0 && value.compareTo(this.mMaxDate) <= 0;
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(SimpleMonthAdapter var1, Calendar var2);
    }
}

