/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.Log;
import android.util.MathUtils;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.widget.ExploreByTouchHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class RadialTimePickerView
extends View
implements View.OnTouchListener {
    private static final String TAG = "ClockView";
    private static final boolean DEBUG = false;
    private static final int DEBUG_COLOR = 0x20FF0000;
    private static final int DEBUG_TEXT_COLOR = 0x60FF0000;
    private static final int DEBUG_STROKE_WIDTH = 2;
    private static final int HOURS = 0;
    private static final int MINUTES = 1;
    private static final int HOURS_INNER = 2;
    private static final int SELECTOR_CIRCLE = 0;
    private static final int SELECTOR_DOT = 1;
    private static final int SELECTOR_LINE = 2;
    private static final int AM = 0;
    private static final int PM = 1;
    private static final int ALPHA_OPAQUE = 255;
    private static final int ALPHA_TRANSPARENT = 0;
    private static final int ALPHA_SELECTOR = 60;
    private static final float COSINE_30_DEGREES = (float)Math.sqrt(3.0) * 0.5f;
    private static final float SINE_30_DEGREES = 0.5f;
    private static final int DEGREES_FOR_ONE_HOUR = 30;
    private static final int DEGREES_FOR_ONE_MINUTE = 6;
    private static final int[] HOURS_NUMBERS = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] HOURS_NUMBERS_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] MINUTES_NUMBERS = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
    private static final int CENTER_RADIUS = 2;
    private static int[] sSnapPrefer30sMap = new int[361];
    private final InvalidateUpdateListener mInvalidateUpdateListener = new InvalidateUpdateListener();
    private final String[] mHours12Texts = new String[12];
    private final String[] mOuterHours24Texts = new String[12];
    private final String[] mInnerHours24Texts = new String[12];
    private final String[] mMinutesTexts = new String[12];
    private final Paint[] mPaint = new Paint[2];
    private final int[] mColor = new int[2];
    private final IntHolder[] mAlpha = new IntHolder[2];
    private final Paint mPaintCenter = new Paint();
    private final Paint[][] mPaintSelector = new Paint[2][3];
    private final int[][] mColorSelector = new int[2][3];
    private final IntHolder[][] mAlphaSelector = new IntHolder[2][3];
    private final Paint mPaintBackground = new Paint();
    private final Paint mPaintDebug = new Paint();
    private final Typeface mTypeface;
    private final float[] mCircleRadius = new float[3];
    private final float[] mTextSize = new float[2];
    private final float[][] mTextGridHeights = new float[2][7];
    private final float[][] mTextGridWidths = new float[2][7];
    private final float[] mInnerTextGridHeights = new float[7];
    private final float[] mInnerTextGridWidths = new float[7];
    private final float[] mCircleRadiusMultiplier = new float[2];
    private final float[] mNumbersRadiusMultiplier = new float[3];
    private final float[] mTextSizeMultiplier = new float[3];
    private final float[] mAnimationRadiusMultiplier = new float[3];
    private final float mTransitionMidRadiusMultiplier;
    private final float mTransitionEndRadiusMultiplier;
    private final int[] mLineLength = new int[3];
    private final int[] mSelectionRadius = new int[3];
    private final float mSelectionRadiusMultiplier;
    private final int[] mSelectionDegrees = new int[3];
    private final ArrayList<Animator> mHoursToMinutesAnims = new ArrayList();
    private final ArrayList<Animator> mMinuteToHoursAnims = new ArrayList();
    private final RadialPickerTouchHelper mTouchHelper;
    private float mInnerTextSize;
    private boolean mIs24HourMode;
    private boolean mShowHours;
    private boolean mIsOnInnerCircle;
    private int mXCenter;
    private int mYCenter;
    private int mMinHypotenuseForInnerNumber;
    private int mMaxHypotenuseForOuterNumber;
    private int mHalfwayHypotenusePoint;
    private String[] mOuterTextHours;
    private String[] mInnerTextHours;
    private String[] mOuterTextMinutes;
    private AnimatorSet mTransition;
    private int mAmOrPm;
    private int mDisabledAlpha;
    private OnValueSelectedListener mListener;
    private boolean mInputEnabled = true;
    boolean mChangedDuringTouch = false;

    private static void preparePrefer30sMap() {
        int snappedOutputDegrees = 0;
        int count = 1;
        int expectedCount = 8;
        for (int degrees = 0; degrees < 361; ++degrees) {
            RadialTimePickerView.sSnapPrefer30sMap[degrees] = snappedOutputDegrees;
            if (count == expectedCount) {
                expectedCount = (snappedOutputDegrees += 6) == 360 ? 7 : (snappedOutputDegrees % 30 == 0 ? 14 : 4);
                count = 1;
                continue;
            }
            ++count;
        }
    }

    private static int snapPrefer30s(int degrees) {
        if (sSnapPrefer30sMap == null) {
            return -1;
        }
        return sSnapPrefer30sMap[degrees];
    }

    private static int snapOnly30s(int degrees, int forceHigherOrLower) {
        int stepSize = 30;
        int floor = degrees / 30 * 30;
        int ceiling = floor + 30;
        if (forceHigherOrLower == 1) {
            degrees = ceiling;
        } else if (forceHigherOrLower == -1) {
            if (degrees == floor) {
                floor -= 30;
            }
            degrees = floor;
        } else {
            degrees = degrees - floor < ceiling - degrees ? floor : ceiling;
        }
        return degrees;
    }

    public RadialTimePickerView(Context context) {
        this(context, null);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843933);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        int i;
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010033, outValue, true);
        this.mDisabledAlpha = (int)(outValue.getFloat() * 255.0f + 0.5f);
        Resources res = this.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        this.mTypeface = Typeface.create("sans-serif", 0);
        for (i = 0; i < this.mAlpha.length; ++i) {
            this.mAlpha[i] = new IntHolder(255);
        }
        for (i = 0; i < this.mAlphaSelector.length; ++i) {
            for (int j = 0; j < this.mAlphaSelector[i].length; ++j) {
                this.mAlphaSelector[i][j] = new IntHolder(255);
            }
        }
        int numbersTextColor = a.getColor(3, res.getColor(17170679));
        this.mPaint[0] = new Paint();
        this.mPaint[0].setAntiAlias(true);
        this.mPaint[0].setTextAlign(Paint.Align.CENTER);
        this.mColor[0] = numbersTextColor;
        this.mPaint[1] = new Paint();
        this.mPaint[1].setAntiAlias(true);
        this.mPaint[1].setTextAlign(Paint.Align.CENTER);
        this.mColor[1] = numbersTextColor;
        this.mPaintCenter.setColor(numbersTextColor);
        this.mPaintCenter.setAntiAlias(true);
        this.mPaintCenter.setTextAlign(Paint.Align.CENTER);
        this.mPaintSelector[0][0] = new Paint();
        this.mPaintSelector[0][0].setAntiAlias(true);
        this.mColorSelector[0][0] = a.getColor(5, 17170682);
        this.mPaintSelector[0][1] = new Paint();
        this.mPaintSelector[0][1].setAntiAlias(true);
        this.mColorSelector[0][1] = a.getColor(5, 17170682);
        this.mPaintSelector[0][2] = new Paint();
        this.mPaintSelector[0][2].setAntiAlias(true);
        this.mPaintSelector[0][2].setStrokeWidth(2.0f);
        this.mColorSelector[0][2] = a.getColor(5, 17170682);
        this.mPaintSelector[1][0] = new Paint();
        this.mPaintSelector[1][0].setAntiAlias(true);
        this.mColorSelector[1][0] = a.getColor(5, 17170682);
        this.mPaintSelector[1][1] = new Paint();
        this.mPaintSelector[1][1].setAntiAlias(true);
        this.mColorSelector[1][1] = a.getColor(5, 17170682);
        this.mPaintSelector[1][2] = new Paint();
        this.mPaintSelector[1][2].setAntiAlias(true);
        this.mPaintSelector[1][2].setStrokeWidth(2.0f);
        this.mColorSelector[1][2] = a.getColor(5, 17170682);
        this.mPaintBackground.setColor(a.getColor(4, res.getColor(17170683)));
        this.mPaintBackground.setAntiAlias(true);
        this.mShowHours = true;
        this.mIs24HourMode = false;
        this.mAmOrPm = 0;
        this.mTouchHelper = new RadialPickerTouchHelper();
        this.setAccessibilityDelegate(this.mTouchHelper);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.initHoursAndMinutesText();
        this.initData();
        this.mTransitionMidRadiusMultiplier = Float.parseFloat(res.getString(17039444));
        this.mTransitionEndRadiusMultiplier = Float.parseFloat(res.getString(17039445));
        this.mTextGridHeights[0] = new float[7];
        this.mTextGridHeights[1] = new float[7];
        this.mSelectionRadiusMultiplier = Float.parseFloat(res.getString(17039436));
        a.recycle();
        this.setOnTouchListener(this);
        this.setClickable(true);
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.setCurrentHourInternal(currentHour, false, false);
        this.setCurrentMinuteInternal(currentMinute, false);
        this.setHapticFeedbackEnabled(true);
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int minDimension = Math.min(measuredWidth, measuredHeight);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec(minDimension, widthMode), View.MeasureSpec.makeMeasureSpec(minDimension, heightMode));
    }

    public void initialize(int hour, int minute, boolean is24HourMode) {
        if (this.mIs24HourMode != is24HourMode) {
            this.mIs24HourMode = is24HourMode;
            this.initData();
        }
        this.setCurrentHourInternal(hour, false, false);
        this.setCurrentMinuteInternal(minute, false);
    }

    public void setCurrentItemShowing(int item, boolean animate) {
        switch (item) {
            case 0: {
                this.showHours(animate);
                break;
            }
            case 1: {
                this.showMinutes(animate);
                break;
            }
            default: {
                Log.e(TAG, "ClockView does not support showing item " + item);
            }
        }
    }

    public int getCurrentItemShowing() {
        return this.mShowHours ? 0 : 1;
    }

    public void setOnValueSelectedListener(OnValueSelectedListener listener) {
        this.mListener = listener;
    }

    public void setCurrentHour(int hour) {
        this.setCurrentHourInternal(hour, true, false);
    }

    private void setCurrentHourInternal(int hour, boolean callback, boolean autoAdvance) {
        boolean isOnInnerCircle;
        int degrees;
        this.mSelectionDegrees[0] = degrees = hour % 12 * 30;
        this.mSelectionDegrees[2] = degrees;
        int amOrPm = hour == 0 || hour % 24 < 12 ? 0 : 1;
        boolean bl = isOnInnerCircle = this.mIs24HourMode && hour >= 1 && hour <= 12;
        if (this.mAmOrPm != amOrPm || this.mIsOnInnerCircle != isOnInnerCircle) {
            this.mAmOrPm = amOrPm;
            this.mIsOnInnerCircle = isOnInnerCircle;
            this.initData();
            this.updateLayoutData();
            this.mTouchHelper.invalidateRoot();
        }
        this.invalidate();
        if (callback && this.mListener != null) {
            this.mListener.onValueSelected(0, hour, autoAdvance);
        }
    }

    public int getCurrentHour() {
        return this.getHourForDegrees(this.mSelectionDegrees[this.mIsOnInnerCircle ? 2 : 0], this.mIsOnInnerCircle);
    }

    private int getHourForDegrees(int degrees, boolean innerCircle) {
        int hour = degrees / 30 % 12;
        if (this.mIs24HourMode) {
            if (innerCircle && hour == 0) {
                hour = 12;
            } else if (!innerCircle && hour != 0) {
                hour += 12;
            }
        } else if (this.mAmOrPm == 1) {
            hour += 12;
        }
        return hour;
    }

    private int getDegreesForHour(int hour) {
        if (this.mIs24HourMode) {
            if (hour >= 12) {
                hour -= 12;
            }
        } else if (hour == 12) {
            hour = 0;
        }
        return hour * 30;
    }

    public void setCurrentMinute(int minute) {
        this.setCurrentMinuteInternal(minute, true);
    }

    private void setCurrentMinuteInternal(int minute, boolean callback) {
        this.mSelectionDegrees[1] = minute % 60 * 6;
        this.invalidate();
        if (callback && this.mListener != null) {
            this.mListener.onValueSelected(1, minute, false);
        }
    }

    public int getCurrentMinute() {
        return this.getMinuteForDegrees(this.mSelectionDegrees[1]);
    }

    private int getMinuteForDegrees(int degrees) {
        return degrees / 6;
    }

    private int getDegreesForMinute(int minute) {
        return minute * 6;
    }

    public void setAmOrPm(int val) {
        this.mAmOrPm = val % 2;
        this.invalidate();
        this.mTouchHelper.invalidateRoot();
    }

    public int getAmOrPm() {
        return this.mAmOrPm;
    }

    public void showHours(boolean animate) {
        if (this.mShowHours) {
            return;
        }
        this.mShowHours = true;
        if (animate) {
            this.startMinutesToHoursAnimation();
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    public void showMinutes(boolean animate) {
        if (!this.mShowHours) {
            return;
        }
        this.mShowHours = false;
        if (animate) {
            this.startHoursToMinutesAnimation();
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    private void initHoursAndMinutesText() {
        for (int i = 0; i < 12; ++i) {
            this.mHours12Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mOuterHours24Texts[i] = String.format("%02d", HOURS_NUMBERS_24[i]);
            this.mInnerHours24Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mMinutesTexts[i] = String.format("%02d", MINUTES_NUMBERS[i]);
        }
    }

    private void initData() {
        if (this.mIs24HourMode) {
            this.mOuterTextHours = this.mOuterHours24Texts;
            this.mInnerTextHours = this.mInnerHours24Texts;
        } else {
            this.mOuterTextHours = this.mHours12Texts;
            this.mInnerTextHours = null;
        }
        this.mOuterTextMinutes = this.mMinutesTexts;
        Resources res = this.getResources();
        if (this.mShowHours) {
            if (this.mIs24HourMode) {
                this.mCircleRadiusMultiplier[0] = Float.parseFloat(res.getString(17039435));
                this.mNumbersRadiusMultiplier[0] = Float.parseFloat(res.getString(17039440));
                this.mTextSizeMultiplier[0] = Float.parseFloat(res.getString(17039443));
                this.mNumbersRadiusMultiplier[2] = Float.parseFloat(res.getString(17039439));
                this.mTextSizeMultiplier[2] = Float.parseFloat(res.getString(17039442));
            } else {
                this.mCircleRadiusMultiplier[0] = Float.parseFloat(res.getString(17039434));
                this.mNumbersRadiusMultiplier[0] = Float.parseFloat(res.getString(17039438));
                this.mTextSizeMultiplier[0] = Float.parseFloat(res.getString(17039441));
            }
        } else {
            this.mCircleRadiusMultiplier[1] = Float.parseFloat(res.getString(17039434));
            this.mNumbersRadiusMultiplier[1] = Float.parseFloat(res.getString(17039438));
            this.mTextSizeMultiplier[1] = Float.parseFloat(res.getString(17039441));
        }
        this.mAnimationRadiusMultiplier[0] = 1.0f;
        this.mAnimationRadiusMultiplier[2] = 1.0f;
        this.mAnimationRadiusMultiplier[1] = 1.0f;
        this.mAlpha[0].setValue(this.mShowHours ? 255 : 0);
        this.mAlpha[1].setValue(this.mShowHours ? 0 : 255);
        this.mAlphaSelector[0][0].setValue(this.mShowHours ? 60 : 0);
        this.mAlphaSelector[0][1].setValue(this.mShowHours ? 255 : 0);
        this.mAlphaSelector[0][2].setValue(this.mShowHours ? 60 : 0);
        this.mAlphaSelector[1][0].setValue(this.mShowHours ? 0 : 60);
        this.mAlphaSelector[1][1].setValue(this.mShowHours ? 0 : 255);
        this.mAlphaSelector[1][2].setValue(this.mShowHours ? 0 : 60);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.updateLayoutData();
    }

    private void updateLayoutData() {
        this.mXCenter = this.getWidth() / 2;
        this.mYCenter = this.getHeight() / 2;
        int min = Math.min(this.mXCenter, this.mYCenter);
        this.mCircleRadius[0] = (float)min * this.mCircleRadiusMultiplier[0];
        this.mCircleRadius[2] = (float)min * this.mCircleRadiusMultiplier[0];
        this.mCircleRadius[1] = (float)min * this.mCircleRadiusMultiplier[1];
        this.mMinHypotenuseForInnerNumber = (int)(this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[2]) - this.mSelectionRadius[0];
        this.mMaxHypotenuseForOuterNumber = (int)(this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0]) + this.mSelectionRadius[0];
        this.mHalfwayHypotenusePoint = (int)(this.mCircleRadius[0] * ((this.mNumbersRadiusMultiplier[0] + this.mNumbersRadiusMultiplier[2]) / 2.0f));
        this.mTextSize[0] = this.mCircleRadius[0] * this.mTextSizeMultiplier[0];
        this.mTextSize[1] = this.mCircleRadius[1] * this.mTextSizeMultiplier[1];
        if (this.mIs24HourMode) {
            this.mInnerTextSize = this.mCircleRadius[0] * this.mTextSizeMultiplier[2];
        }
        this.calculateGridSizesHours();
        this.calculateGridSizesMinutes();
        this.mSelectionRadius[0] = (int)(this.mCircleRadius[0] * this.mSelectionRadiusMultiplier);
        this.mSelectionRadius[2] = this.mSelectionRadius[0];
        this.mSelectionRadius[1] = (int)(this.mCircleRadius[1] * this.mSelectionRadiusMultiplier);
        this.mTouchHelper.invalidateRoot();
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (!this.mInputEnabled) {
            canvas.saveLayerAlpha(0.0f, 0.0f, this.getWidth(), this.getHeight(), this.mDisabledAlpha);
        } else {
            canvas.save();
        }
        this.calculateGridSizesHours();
        this.calculateGridSizesMinutes();
        this.drawCircleBackground(canvas);
        this.drawSelector(canvas);
        this.drawTextElements(canvas, this.mTextSize[0], this.mTypeface, this.mOuterTextHours, this.mTextGridWidths[0], this.mTextGridHeights[0], this.mPaint[0], this.mColor[0], this.mAlpha[0].getValue());
        if (this.mIs24HourMode && this.mInnerTextHours != null) {
            this.drawTextElements(canvas, this.mInnerTextSize, this.mTypeface, this.mInnerTextHours, this.mInnerTextGridWidths, this.mInnerTextGridHeights, this.mPaint[0], this.mColor[0], this.mAlpha[0].getValue());
        }
        this.drawTextElements(canvas, this.mTextSize[1], this.mTypeface, this.mOuterTextMinutes, this.mTextGridWidths[1], this.mTextGridHeights[1], this.mPaint[1], this.mColor[1], this.mAlpha[1].getValue());
        this.drawCenter(canvas);
        canvas.restore();
    }

    private void drawCircleBackground(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius[0], this.mPaintBackground);
    }

    private void drawCenter(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, 2.0f, this.mPaintCenter);
    }

    private void drawSelector(Canvas canvas) {
        this.drawSelector(canvas, this.mIsOnInnerCircle ? 2 : 0);
        this.drawSelector(canvas, 1);
    }

    private int getMultipliedAlpha(int argb, int alpha) {
        return (int)((double)Color.alpha(argb) * ((double)alpha / 255.0) + 0.5);
    }

    private void drawSelector(Canvas canvas, int index) {
        this.mLineLength[index] = (int)(this.mCircleRadius[index] * this.mNumbersRadiusMultiplier[index] * this.mAnimationRadiusMultiplier[index]);
        double selectionRadians = Math.toRadians(this.mSelectionDegrees[index]);
        int pointX = this.mXCenter + (int)((double)this.mLineLength[index] * Math.sin(selectionRadians));
        int pointY = this.mYCenter - (int)((double)this.mLineLength[index] * Math.cos(selectionRadians));
        int color2 = this.mColorSelector[index % 2][0];
        int alpha = this.mAlphaSelector[index % 2][0].getValue();
        Paint paint = this.mPaintSelector[index % 2][0];
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawCircle(pointX, pointY, this.mSelectionRadius[index], paint);
        if (this.mSelectionDegrees[index] % 30 != 0) {
            color2 = this.mColorSelector[index % 2][1];
            alpha = this.mAlphaSelector[index % 2][1].getValue();
            paint = this.mPaintSelector[index % 2][1];
            paint.setColor(color2);
            paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
            canvas.drawCircle(pointX, pointY, this.mSelectionRadius[index] * 2 / 7, paint);
        } else {
            int lineLength = this.mLineLength[index] - this.mSelectionRadius[index];
            pointX = this.mXCenter + (int)((double)lineLength * Math.sin(selectionRadians));
            pointY = this.mYCenter - (int)((double)lineLength * Math.cos(selectionRadians));
        }
        color2 = this.mColorSelector[index % 2][2];
        alpha = this.mAlphaSelector[index % 2][2].getValue();
        paint = this.mPaintSelector[index % 2][2];
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawLine(this.mXCenter, this.mYCenter, pointX, pointY, paint);
    }

    private void drawDebug(Canvas canvas) {
        float outerRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0];
        canvas.drawCircle(this.mXCenter, this.mYCenter, outerRadius, this.mPaintDebug);
        float innerRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[2];
        canvas.drawCircle(this.mXCenter, this.mYCenter, innerRadius, this.mPaintDebug);
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius[0], this.mPaintDebug);
        float left = (float)this.mXCenter - outerRadius;
        float top = (float)this.mYCenter - outerRadius;
        float right = (float)this.mXCenter + outerRadius;
        float bottom = (float)this.mYCenter + outerRadius;
        canvas.drawRect(left, top, right, bottom, this.mPaintDebug);
        left = (float)this.mXCenter - this.mCircleRadius[0];
        top = (float)this.mYCenter - this.mCircleRadius[0];
        right = (float)this.mXCenter + this.mCircleRadius[0];
        bottom = (float)this.mYCenter + this.mCircleRadius[0];
        canvas.drawRect(left, top, right, bottom, this.mPaintDebug);
        canvas.drawRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), this.mPaintDebug);
        String selected = String.format("%02d:%02d", this.getCurrentHour(), this.getCurrentMinute());
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-2, -2);
        TextView tv = new TextView(this.getContext());
        tv.setLayoutParams(lp);
        tv.setText(selected);
        tv.measure(0, 0);
        TextPaint paint = tv.getPaint();
        paint.setColor(0x60FF0000);
        int width = tv.getMeasuredWidth();
        float height = paint.descent() - paint.ascent();
        float x = this.mXCenter - width / 2;
        float y = (float)this.mYCenter + 1.5f * height;
        canvas.drawText(selected, x, y, paint);
    }

    private void calculateGridSizesHours() {
        float numbersRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0] * this.mAnimationRadiusMultiplier[0];
        RadialTimePickerView.calculateGridSizes(this.mPaint[0], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[0], this.mTextGridHeights[0], this.mTextGridWidths[0]);
        if (this.mIs24HourMode) {
            float innerNumbersRadius = this.mCircleRadius[2] * this.mNumbersRadiusMultiplier[2] * this.mAnimationRadiusMultiplier[2];
            RadialTimePickerView.calculateGridSizes(this.mPaint[0], innerNumbersRadius, this.mXCenter, this.mYCenter, this.mInnerTextSize, this.mInnerTextGridHeights, this.mInnerTextGridWidths);
        }
    }

    private void calculateGridSizesMinutes() {
        float numbersRadius = this.mCircleRadius[1] * this.mNumbersRadiusMultiplier[1] * this.mAnimationRadiusMultiplier[1];
        RadialTimePickerView.calculateGridSizes(this.mPaint[1], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[1], this.mTextGridHeights[1], this.mTextGridWidths[1]);
    }

    private static void calculateGridSizes(Paint paint, float numbersRadius, float xCenter, float yCenter, float textSize, float[] textGridHeights, float[] textGridWidths) {
        float offset1 = numbersRadius;
        float offset2 = numbersRadius * COSINE_30_DEGREES;
        float offset3 = numbersRadius * 0.5f;
        paint.setTextSize(textSize);
        textGridHeights[0] = (yCenter -= (paint.descent() + paint.ascent()) / 2.0f) - offset1;
        textGridWidths[0] = xCenter - offset1;
        textGridHeights[1] = yCenter - offset2;
        textGridWidths[1] = xCenter - offset2;
        textGridHeights[2] = yCenter - offset3;
        textGridWidths[2] = xCenter - offset3;
        textGridHeights[3] = yCenter;
        textGridWidths[3] = xCenter;
        textGridHeights[4] = yCenter + offset3;
        textGridWidths[4] = xCenter + offset3;
        textGridHeights[5] = yCenter + offset2;
        textGridWidths[5] = xCenter + offset2;
        textGridHeights[6] = yCenter + offset1;
        textGridWidths[6] = xCenter + offset1;
    }

    private void drawTextElements(Canvas canvas, float textSize, Typeface typeface, String[] texts, float[] textGridWidths, float[] textGridHeights, Paint paint, int color2, int alpha) {
        paint.setTextSize(textSize);
        paint.setTypeface(typeface);
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawText(texts[0], textGridWidths[3], textGridHeights[0], paint);
        canvas.drawText(texts[1], textGridWidths[4], textGridHeights[1], paint);
        canvas.drawText(texts[2], textGridWidths[5], textGridHeights[2], paint);
        canvas.drawText(texts[3], textGridWidths[6], textGridHeights[3], paint);
        canvas.drawText(texts[4], textGridWidths[5], textGridHeights[4], paint);
        canvas.drawText(texts[5], textGridWidths[4], textGridHeights[5], paint);
        canvas.drawText(texts[6], textGridWidths[3], textGridHeights[6], paint);
        canvas.drawText(texts[7], textGridWidths[2], textGridHeights[5], paint);
        canvas.drawText(texts[8], textGridWidths[1], textGridHeights[4], paint);
        canvas.drawText(texts[9], textGridWidths[0], textGridHeights[3], paint);
        canvas.drawText(texts[10], textGridWidths[1], textGridHeights[2], paint);
        canvas.drawText(texts[11], textGridWidths[2], textGridHeights[1], paint);
    }

    private void setAnimationRadiusMultiplierHours(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier[0] = animationRadiusMultiplier;
        this.mAnimationRadiusMultiplier[2] = animationRadiusMultiplier;
    }

    private void setAnimationRadiusMultiplierMinutes(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier[1] = animationRadiusMultiplier;
    }

    private static ObjectAnimator getRadiusDisappearAnimator(Object target, String radiusPropertyName, InvalidateUpdateListener updateListener, float midRadiusMultiplier, float endRadiusMultiplier) {
        float midwayPoint = 0.2f;
        int duration = 500;
        Keyframe kf0 = Keyframe.ofFloat(0.0f, 1.0f);
        Keyframe kf1 = Keyframe.ofFloat(midwayPoint, midRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat(1.0f, endRadiusMultiplier);
        PropertyValuesHolder radiusDisappear = PropertyValuesHolder.ofKeyframe(radiusPropertyName, kf0, kf1, kf2);
        ObjectAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, radiusDisappear).setDuration(duration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static ObjectAnimator getRadiusReappearAnimator(Object target, String radiusPropertyName, InvalidateUpdateListener updateListener, float midRadiusMultiplier, float endRadiusMultiplier) {
        float midwayPoint = 0.2f;
        int duration = 500;
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        midwayPoint = 1.0f - midwayPoint * (1.0f - delayPoint);
        Keyframe kf0 = Keyframe.ofFloat(0.0f, endRadiusMultiplier);
        Keyframe kf1 = Keyframe.ofFloat(delayPoint, endRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat(midwayPoint, midRadiusMultiplier);
        Keyframe kf3 = Keyframe.ofFloat(1.0f, 1.0f);
        PropertyValuesHolder radiusReappear = PropertyValuesHolder.ofKeyframe(radiusPropertyName, kf0, kf1, kf2, kf3);
        ObjectAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, radiusReappear).setDuration(totalDuration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static ObjectAnimator getFadeOutAnimator(IntHolder target, int startAlpha, int endAlpha, InvalidateUpdateListener updateListener) {
        int duration = 500;
        ObjectAnimator animator2 = ObjectAnimator.ofInt((Object)target, "value", startAlpha, endAlpha);
        animator2.setDuration(duration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static ObjectAnimator getFadeInAnimator(IntHolder target, int startAlpha, int endAlpha, InvalidateUpdateListener updateListener) {
        int duration = 500;
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        Keyframe kf0 = Keyframe.ofInt(0.0f, startAlpha);
        Keyframe kf1 = Keyframe.ofInt(delayPoint, startAlpha);
        Keyframe kf2 = Keyframe.ofInt(1.0f, endAlpha);
        PropertyValuesHolder fadeIn = PropertyValuesHolder.ofKeyframe("value", kf0, kf1, kf2);
        ObjectAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, fadeIn).setDuration(totalDuration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private void startHoursToMinutesAnimation() {
        if (this.mHoursToMinutesAnims.size() == 0) {
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getRadiusDisappearAnimator(this, "animationRadiusMultiplierHours", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[0], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][0], 60, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][1], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][2], 60, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getRadiusReappearAnimator(this, "animationRadiusMultiplierMinutes", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[1], 0, 255, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][0], 0, 60, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][1], 0, 255, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][2], 0, 60, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mHoursToMinutesAnims);
        this.mTransition.start();
    }

    private void startMinutesToHoursAnimation() {
        if (this.mMinuteToHoursAnims.size() == 0) {
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getRadiusDisappearAnimator(this, "animationRadiusMultiplierMinutes", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][0], 60, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][2], 60, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getRadiusReappearAnimator(this, "animationRadiusMultiplierHours", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[0], 0, 255, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][0], 0, 60, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][1], 0, 255, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][2], 0, 60, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mMinuteToHoursAnims);
        this.mTransition.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getDegreesFromXY(float x, float y) {
        boolean topSide;
        double hypotenuse = Math.sqrt((y - (float)this.mYCenter) * (y - (float)this.mYCenter) + (x - (float)this.mXCenter) * (x - (float)this.mXCenter));
        if (hypotenuse > (double)this.mCircleRadius[0]) {
            return -1;
        }
        if (this.mIs24HourMode && this.mShowHours) {
            if (hypotenuse >= (double)this.mMinHypotenuseForInnerNumber && hypotenuse <= (double)this.mHalfwayHypotenusePoint) {
                this.mIsOnInnerCircle = true;
            } else {
                if (!(hypotenuse <= (double)this.mMaxHypotenuseForOuterNumber)) return -1;
                if (!(hypotenuse >= (double)this.mHalfwayHypotenusePoint)) return -1;
                this.mIsOnInnerCircle = false;
            }
        } else {
            int maxAllowedDistance;
            int index = this.mShowHours ? 0 : 1;
            float length = this.mCircleRadius[index] * this.mNumbersRadiusMultiplier[index];
            int distanceToNumber = (int)Math.abs(hypotenuse - (double)length);
            if (distanceToNumber > (maxAllowedDistance = (int)(this.mCircleRadius[index] * (1.0f - this.mNumbersRadiusMultiplier[index])))) {
                return -1;
            }
        }
        float opposite = Math.abs(y - (float)this.mYCenter);
        int degrees = (int)(Math.toDegrees(Math.asin((double)opposite / hypotenuse)) + 0.5);
        boolean rightSide = x > (float)this.mXCenter;
        boolean bl = topSide = y < (float)this.mYCenter;
        if (rightSide) {
            if (!topSide) return 90 + degrees;
            return 90 - degrees;
        }
        if (!topSide) return 270 - degrees;
        return 270 + degrees;
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        if (!this.mInputEnabled) {
            return true;
        }
        int action = event.getActionMasked();
        if (action == 2 || action == 1 || action == 0) {
            boolean forceSelection = false;
            boolean autoAdvance = false;
            if (action == 0) {
                this.mChangedDuringTouch = false;
            } else if (action == 1) {
                autoAdvance = true;
                if (!this.mChangedDuringTouch) {
                    forceSelection = true;
                }
            }
            this.mChangedDuringTouch |= this.handleTouchInput(event.getX(), event.getY(), forceSelection, autoAdvance);
        }
        return true;
    }

    private boolean handleTouchInput(float x, float y, boolean forceSelection, boolean autoAdvance) {
        int newValue;
        int type;
        boolean valueChanged;
        boolean wasOnInnerCircle = this.mIsOnInnerCircle;
        int degrees = this.getDegreesFromXY(x, y);
        if (degrees == -1) {
            return false;
        }
        int[] selectionDegrees = this.mSelectionDegrees;
        if (this.mShowHours) {
            int snapDegrees = RadialTimePickerView.snapOnly30s(degrees, 0) % 360;
            valueChanged = selectionDegrees[0] != snapDegrees || selectionDegrees[2] != snapDegrees || wasOnInnerCircle != this.mIsOnInnerCircle;
            selectionDegrees[0] = snapDegrees;
            selectionDegrees[2] = snapDegrees;
            type = 0;
            newValue = this.getCurrentHour();
        } else {
            int snapDegrees = RadialTimePickerView.snapPrefer30s(degrees) % 360;
            valueChanged = selectionDegrees[1] != snapDegrees;
            selectionDegrees[1] = snapDegrees;
            type = 1;
            newValue = this.getCurrentMinute();
        }
        if (valueChanged || forceSelection || autoAdvance) {
            if (this.mListener != null) {
                this.mListener.onValueSelected(type, newValue, autoAdvance);
            }
            if (valueChanged || forceSelection) {
                this.performHapticFeedback(4);
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent event) {
        if (this.mTouchHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    public void setInputEnabled(boolean inputEnabled) {
        this.mInputEnabled = inputEnabled;
        this.invalidate();
    }

    static {
        RadialTimePickerView.preparePrefer30sMap();
    }

    private static class IntHolder {
        private int mValue;

        public IntHolder(int value) {
            this.mValue = value;
        }

        public void setValue(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    private class RadialPickerTouchHelper
    extends ExploreByTouchHelper {
        private final Rect mTempRect;
        private final int TYPE_HOUR = 1;
        private final int TYPE_MINUTE = 2;
        private final int SHIFT_TYPE = 0;
        private final int MASK_TYPE = 15;
        private final int SHIFT_VALUE = 8;
        private final int MASK_VALUE = 255;
        private final int MINUTE_INCREMENT = 5;

        public RadialPickerTouchHelper() {
            super(RadialTimePickerView.this);
            this.mTempRect = new Rect();
            this.TYPE_HOUR = 1;
            this.TYPE_MINUTE = 2;
            this.SHIFT_TYPE = 0;
            this.MASK_TYPE = 15;
            this.SHIFT_VALUE = 8;
            this.MASK_VALUE = 255;
            this.MINUTE_INCREMENT = 5;
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
        }

        @Override
        public boolean performAccessibilityAction(View host, int action, Bundle arguments) {
            if (super.performAccessibilityAction(host, action, arguments)) {
                return true;
            }
            switch (action) {
                case 4096: {
                    this.adjustPicker(1);
                    return true;
                }
                case 8192: {
                    this.adjustPicker(-1);
                    return true;
                }
            }
            return false;
        }

        private void adjustPicker(int step) {
            int minValue;
            int maxValue;
            int initialValue;
            int stepSize;
            if (RadialTimePickerView.this.mShowHours) {
                stepSize = 30;
                initialValue = RadialTimePickerView.this.getCurrentHour() % 12;
                if (RadialTimePickerView.this.mIs24HourMode) {
                    maxValue = 23;
                    minValue = 0;
                } else {
                    maxValue = 12;
                    minValue = 1;
                }
            } else {
                stepSize = 6;
                initialValue = RadialTimePickerView.this.getCurrentMinute();
                maxValue = 55;
                minValue = 0;
            }
            int steppedValue = RadialTimePickerView.snapOnly30s(initialValue * stepSize, step) / stepSize;
            int clampedValue = MathUtils.constrain(steppedValue, minValue, maxValue);
            if (RadialTimePickerView.this.mShowHours) {
                RadialTimePickerView.this.setCurrentHour(clampedValue);
            } else {
                RadialTimePickerView.this.setCurrentMinute(clampedValue);
            }
        }

        @Override
        protected int getVirtualViewAt(float x, float y) {
            int id2;
            boolean wasOnInnerCircle = RadialTimePickerView.this.mIsOnInnerCircle;
            int degrees = RadialTimePickerView.this.getDegreesFromXY(x, y);
            boolean isOnInnerCircle = RadialTimePickerView.this.mIsOnInnerCircle;
            RadialTimePickerView.this.mIsOnInnerCircle = wasOnInnerCircle;
            if (degrees != -1) {
                int snapDegrees = RadialTimePickerView.snapOnly30s(degrees, 0) % 360;
                if (RadialTimePickerView.this.mShowHours) {
                    int hour24 = RadialTimePickerView.this.getHourForDegrees(snapDegrees, isOnInnerCircle);
                    int hour = RadialTimePickerView.this.mIs24HourMode ? hour24 : this.hour24To12(hour24);
                    id2 = this.makeId(1, hour);
                } else {
                    int current = RadialTimePickerView.this.getCurrentMinute();
                    int touched = RadialTimePickerView.this.getMinuteForDegrees(degrees);
                    int snapped = RadialTimePickerView.this.getMinuteForDegrees(snapDegrees);
                    int minute = Math.abs(current - touched) < Math.abs(snapped - touched) ? current : snapped;
                    id2 = this.makeId(2, minute);
                }
            } else {
                id2 = Integer.MIN_VALUE;
            }
            return id2;
        }

        @Override
        protected void getVisibleVirtualViews(IntArray virtualViewIds) {
            if (RadialTimePickerView.this.mShowHours) {
                int min = RadialTimePickerView.this.mIs24HourMode ? 0 : 1;
                int max = RadialTimePickerView.this.mIs24HourMode ? 23 : 12;
                for (int i = min; i <= max; ++i) {
                    virtualViewIds.add(this.makeId(1, i));
                }
            } else {
                int current = RadialTimePickerView.this.getCurrentMinute();
                for (int i = 0; i < 60; i += 5) {
                    virtualViewIds.add(this.makeId(2, i));
                    if (current <= i || current >= i + 5) continue;
                    virtualViewIds.add(this.makeId(2, current));
                }
            }
        }

        @Override
        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setClassName(this.getClass().getName());
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            CharSequence description = this.getVirtualViewDescription(type, value);
            event.setContentDescription(description);
        }

        @Override
        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            node.setClassName(this.getClass().getName());
            node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            CharSequence description = this.getVirtualViewDescription(type, value);
            node.setContentDescription(description);
            this.getBoundsForVirtualView(virtualViewId, this.mTempRect);
            node.setBoundsInParent(this.mTempRect);
            boolean selected = this.isVirtualViewSelected(type, value);
            node.setSelected(selected);
            int nextId = this.getVirtualViewIdAfter(type, value);
            if (nextId != Integer.MIN_VALUE) {
                node.setTraversalBefore(RadialTimePickerView.this, nextId);
            }
        }

        private int getVirtualViewIdAfter(int type, int value) {
            if (type == 1) {
                int max;
                int nextValue = value + 1;
                int n = max = RadialTimePickerView.this.mIs24HourMode ? 23 : 12;
                if (nextValue <= max) {
                    return this.makeId(type, nextValue);
                }
            } else if (type == 2) {
                int current = RadialTimePickerView.this.getCurrentMinute();
                int snapValue = value - value % 5;
                int nextValue = snapValue + 5;
                if (value < current && nextValue > current) {
                    return this.makeId(type, current);
                }
                if (nextValue < 60) {
                    return this.makeId(type, nextValue);
                }
            }
            return Integer.MIN_VALUE;
        }

        @Override
        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            if (action == 16) {
                int type = this.getTypeFromId(virtualViewId);
                int value = this.getValueFromId(virtualViewId);
                if (type == 1) {
                    int hour = RadialTimePickerView.this.mIs24HourMode ? value : this.hour12To24(value, RadialTimePickerView.this.mAmOrPm);
                    RadialTimePickerView.this.setCurrentHour(hour);
                    return true;
                }
                if (type == 2) {
                    RadialTimePickerView.this.setCurrentMinute(value);
                    return true;
                }
            }
            return false;
        }

        private int hour12To24(int hour12, int amOrPm) {
            int hour24 = hour12;
            if (hour12 == 12) {
                if (amOrPm == 0) {
                    hour24 = 0;
                }
            } else if (amOrPm == 1) {
                hour24 += 12;
            }
            return hour24;
        }

        private int hour24To12(int hour24) {
            if (hour24 == 0) {
                return 12;
            }
            if (hour24 > 12) {
                return hour24 - 12;
            }
            return hour24;
        }

        private void getBoundsForVirtualView(int virtualViewId, Rect bounds) {
            float degrees;
            float radius;
            float centerRadius;
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            if (type == 1) {
                boolean innerCircle;
                boolean bl = innerCircle = RadialTimePickerView.this.mIs24HourMode && value > 0 && value <= 12;
                if (innerCircle) {
                    centerRadius = RadialTimePickerView.this.mCircleRadius[2] * RadialTimePickerView.this.mNumbersRadiusMultiplier[2];
                    radius = RadialTimePickerView.this.mSelectionRadius[2];
                } else {
                    centerRadius = RadialTimePickerView.this.mCircleRadius[0] * RadialTimePickerView.this.mNumbersRadiusMultiplier[0];
                    radius = RadialTimePickerView.this.mSelectionRadius[0];
                }
                degrees = RadialTimePickerView.this.getDegreesForHour(value);
            } else if (type == 2) {
                centerRadius = RadialTimePickerView.this.mCircleRadius[1] * RadialTimePickerView.this.mNumbersRadiusMultiplier[1];
                degrees = RadialTimePickerView.this.getDegreesForMinute(value);
                radius = RadialTimePickerView.this.mSelectionRadius[1];
            } else {
                centerRadius = 0.0f;
                degrees = 0.0f;
                radius = 0.0f;
            }
            double radians = Math.toRadians(degrees);
            float xCenter = (float)RadialTimePickerView.this.mXCenter + centerRadius * (float)Math.sin(radians);
            float yCenter = (float)RadialTimePickerView.this.mYCenter - centerRadius * (float)Math.cos(radians);
            bounds.set((int)(xCenter - radius), (int)(yCenter - radius), (int)(xCenter + radius), (int)(yCenter + radius));
        }

        private CharSequence getVirtualViewDescription(int type, int value) {
            String description = type == 1 || type == 2 ? Integer.toString(value) : null;
            return description;
        }

        private boolean isVirtualViewSelected(int type, int value) {
            boolean selected = type == 1 ? RadialTimePickerView.this.getCurrentHour() == value : (type == 2 ? RadialTimePickerView.this.getCurrentMinute() == value : false);
            return selected;
        }

        private int makeId(int type, int value) {
            return type << 0 | value << 8;
        }

        private int getTypeFromId(int id2) {
            return id2 >>> 0 & 0xF;
        }

        private int getValueFromId(int id2) {
            return id2 >>> 8 & 0xFF;
        }
    }

    private class InvalidateUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private InvalidateUpdateListener() {
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            RadialTimePickerView.this.invalidate();
        }
    }

    public static interface OnValueSelectedListener {
        public void onValueSelected(int var1, int var2, boolean var3);
    }
}

