/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import android.util.MathUtils;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsListView;
import android.widget.ListView;
import android.widget.SimpleMonthAdapter;
import android.widget.SimpleMonthView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

class DayPickerView
extends ListView
implements AbsListView.OnScrollListener {
    private static final String TAG = "DayPickerView";
    private static final int GOTO_SCROLL_DURATION = 250;
    private static final int SCROLL_CHANGE_DELAY = 40;
    private static final int LIST_TOP_OFFSET = -1;
    private final SimpleMonthAdapter mAdapter = new SimpleMonthAdapter(this.getContext());
    private final ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable(this);
    private SimpleDateFormat mYearFormat = new SimpleDateFormat("yyyy", Locale.getDefault());
    private Calendar mSelectedDay = Calendar.getInstance();
    private Calendar mTempDay = Calendar.getInstance();
    private Calendar mMinDate = Calendar.getInstance();
    private Calendar mMaxDate = Calendar.getInstance();
    private Calendar mTempCalendar;
    private OnDaySelectedListener mOnDaySelectedListener;
    private int mCurrentMonthDisplayed;
    private int mPreviousScrollState = 0;
    private int mCurrentScrollState = 0;
    private boolean mPerformingScroll;
    private final SimpleMonthAdapter.OnDaySelectedListener mProxyOnDaySelectedListener = new SimpleMonthAdapter.OnDaySelectedListener(){

        @Override
        public void onDaySelected(SimpleMonthAdapter adapter, Calendar day) {
            if (DayPickerView.this.mOnDaySelectedListener != null) {
                DayPickerView.this.mOnDaySelectedListener.onDaySelected(DayPickerView.this, day);
            }
        }
    };

    public DayPickerView(Context context) {
        super(context);
        this.setAdapter(this.mAdapter);
        this.setLayoutParams(new AbsListView.LayoutParams(-1, -1));
        this.setDrawSelectorOnTop(false);
        this.setUpListView();
        this.goTo(this.mSelectedDay.getTimeInMillis(), false, false, true);
        this.mAdapter.setOnDaySelectedListener(this.mProxyOnDaySelectedListener);
    }

    public void setDate(long timeInMillis) {
        this.setDate(timeInMillis, false, true);
    }

    public void setDate(long timeInMillis, boolean animate, boolean forceScroll) {
        this.goTo(timeInMillis, animate, true, forceScroll);
    }

    public long getDate() {
        return this.mSelectedDay.getTimeInMillis();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mAdapter.setFirstDayOfWeek(firstDayOfWeek);
    }

    public int getFirstDayOfWeek() {
        return this.mAdapter.getFirstDayOfWeek();
    }

    public void setMinDate(long timeInMillis) {
        this.mMinDate.setTimeInMillis(timeInMillis);
        this.onRangeChanged();
    }

    public long getMinDate() {
        return this.mMinDate.getTimeInMillis();
    }

    public void setMaxDate(long timeInMillis) {
        this.mMaxDate.setTimeInMillis(timeInMillis);
        this.onRangeChanged();
    }

    public long getMaxDate() {
        return this.mMaxDate.getTimeInMillis();
    }

    public void onRangeChanged() {
        this.mAdapter.setRange(this.mMinDate, this.mMaxDate);
        this.goTo(this.mSelectedDay.getTimeInMillis(), false, false, true);
    }

    public void setOnDaySelectedListener(OnDaySelectedListener listener) {
        this.mOnDaySelectedListener = listener;
    }

    private void setUpListView() {
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFriction(ViewConfiguration.getScrollFriction());
    }

    private int getDiffMonths(Calendar start, Calendar end) {
        int diffYears = end.get(1) - start.get(1);
        int diffMonths = end.get(2) - start.get(2) + 12 * diffYears;
        return diffMonths;
    }

    private int getPositionFromDay(long timeInMillis) {
        int diffMonthMax = this.getDiffMonths(this.mMinDate, this.mMaxDate);
        int diffMonth = this.getDiffMonths(this.mMinDate, this.getTempCalendarForTime(timeInMillis));
        return MathUtils.constrain(diffMonth, 0, diffMonthMax);
    }

    private Calendar getTempCalendarForTime(long timeInMillis) {
        if (this.mTempCalendar == null) {
            this.mTempCalendar = Calendar.getInstance();
        }
        this.mTempCalendar.setTimeInMillis(timeInMillis);
        return this.mTempCalendar;
    }

    private boolean goTo(long day, boolean animate, boolean setSelected, boolean forceScroll) {
        View child;
        if (setSelected) {
            this.mSelectedDay.setTimeInMillis(day);
        }
        this.mTempDay.setTimeInMillis(day);
        int position = this.getPositionFromDay(day);
        int i = 0;
        int top = 0;
        while ((child = this.getChildAt(i++)) != null && (top = child.getTop()) < 0) {
        }
        int selectedPosition = child != null ? this.getPositionForView(child) : 0;
        if (setSelected) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthDisplayed(this.mTempDay);
            this.mPreviousScrollState = 2;
            if (animate) {
                this.smoothScrollToPositionFromTop(position, -1, 250);
                return true;
            }
            this.postSetSelection(position);
        } else if (setSelected) {
            this.setMonthDisplayed(this.mSelectedDay);
        }
        return false;
    }

    public void postSetSelection(final int position) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                DayPickerView.this.setSelection(position);
            }
        });
        this.onScrollStateChanged(this, 0);
    }

    @Override
    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        SimpleMonthView child = (SimpleMonthView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    protected void setMonthDisplayed(Calendar date) {
        if (this.mCurrentMonthDisplayed != date.get(2)) {
            this.mCurrentMonthDisplayed = date.get(2);
            this.invalidateViews();
        }
    }

    @Override
    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    void setCalendarTextColor(ColorStateList colors) {
        this.mAdapter.setCalendarTextColor(colors);
    }

    void setCalendarTextAppearance(int resId) {
        this.mAdapter.setCalendarTextAppearance(resId);
    }

    public int getMostVisiblePosition() {
        View child;
        int firstPosition = this.getFirstVisiblePosition();
        int height = this.getHeight();
        int maxDisplayedHeight = 0;
        int mostVisibleIndex = 0;
        int i = 0;
        int bottom = 0;
        while (bottom < height && (child = this.getChildAt(i)) != null) {
            bottom = child.getBottom();
            int displayedHeight = Math.min(bottom, height) - Math.max(0, child.getTop());
            if (displayedHeight > maxDisplayedHeight) {
                mostVisibleIndex = i;
                maxDisplayedHeight = displayedHeight;
            }
            ++i;
        }
        return firstPosition + mostVisibleIndex;
    }

    private Calendar findAccessibilityFocus() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Calendar focus;
            View child = this.getChildAt(i);
            if (!(child instanceof SimpleMonthView) || (focus = ((SimpleMonthView)child).getAccessibilityFocus()) == null) continue;
            return focus;
        }
        return null;
    }

    private boolean restoreAccessibilityFocus(Calendar day) {
        if (day == null) {
            return false;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof SimpleMonthView) || !((SimpleMonthView)child).restoreAccessibilityFocus(day)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void layoutChildren() {
        Calendar focusedDay = this.findAccessibilityFocus();
        super.layoutChildren();
        if (this.mPerformingScroll) {
            this.mPerformingScroll = false;
        } else {
            this.restoreAccessibilityFocus(focusedDay);
        }
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        this.mYearFormat = new SimpleDateFormat("yyyy", Locale.getDefault());
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setItemCount(-1);
    }

    private String getMonthAndYearString(Calendar day) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(day.getDisplayName(2, 2, Locale.getDefault()));
        sbuf.append(" ");
        sbuf.append(this.mYearFormat.format(day.getTime()));
        return sbuf.toString();
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
    }

    @Override
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        View firstVisibleView;
        if (action != 4096 && action != 8192) {
            return super.performAccessibilityAction(action, arguments);
        }
        int firstVisiblePosition = this.getFirstVisiblePosition();
        int month = firstVisiblePosition % 12;
        int year = firstVisiblePosition / 12 + this.mMinDate.get(1);
        Calendar day = Calendar.getInstance();
        day.set(year, month, 1);
        if (action == 4096) {
            day.add(2, 1);
            if (day.get(2) == 12) {
                day.set(2, 0);
                day.add(1, 1);
            }
        } else if (action == 8192 && (firstVisibleView = this.getChildAt(0)) != null && firstVisibleView.getTop() >= -1) {
            day.add(2, -1);
            if (day.get(2) == -1) {
                day.set(2, 11);
                day.add(1, -1);
            }
        }
        this.announceForAccessibility(this.getMonthAndYearString(day));
        this.goTo(day.getTimeInMillis(), true, false, true);
        this.mPerformingScroll = true;
        return true;
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(DayPickerView var1, Calendar var2);
    }

    protected class ScrollStateRunnable
    implements Runnable {
        private int mNewState;
        private View mParent;

        ScrollStateRunnable(View view) {
            this.mParent = view;
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            this.mParent.removeCallbacks(this);
            this.mNewState = scrollState;
            this.mParent.postDelayed(this, 40L);
        }

        @Override
        public void run() {
            DayPickerView.this.mCurrentScrollState = this.mNewState;
            if (Log.isLoggable(DayPickerView.TAG, 3)) {
                Log.d(DayPickerView.TAG, "new scroll state: " + this.mNewState + " old state: " + DayPickerView.this.mPreviousScrollState);
            }
            if (this.mNewState == 0 && DayPickerView.this.mPreviousScrollState != 0 && DayPickerView.this.mPreviousScrollState != 1) {
                DayPickerView.this.mPreviousScrollState = this.mNewState;
                int i = 0;
                View child = DayPickerView.this.getChildAt(i);
                while (child != null && child.getBottom() <= 0) {
                    child = DayPickerView.this.getChildAt(++i);
                }
                if (child == null) {
                    return;
                }
                int firstPosition = DayPickerView.this.getFirstVisiblePosition();
                int lastPosition = DayPickerView.this.getLastVisiblePosition();
                boolean scroll = firstPosition != 0 && lastPosition != DayPickerView.this.getCount() - 1;
                int top = child.getTop();
                int bottom = child.getBottom();
                int midpoint = DayPickerView.this.getHeight() / 2;
                if (scroll && top < -1) {
                    if (bottom > midpoint) {
                        DayPickerView.this.smoothScrollBy(top, 250);
                    } else {
                        DayPickerView.this.smoothScrollBy(bottom, 250);
                    }
                }
            } else {
                DayPickerView.this.mPreviousScrollState = this.mNewState;
            }
        }
    }
}

