/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ProgressBar;
import com.android.internal.R;

public abstract class AbsSeekBar
extends ProgressBar {
    private final Rect mTempRect = new Rect();
    private Drawable mThumb;
    private ColorStateList mThumbTintList = null;
    private PorterDuff.Mode mThumbTintMode = null;
    private boolean mHasThumbTint = false;
    private boolean mHasThumbTintMode = false;
    private int mThumbOffset;
    private boolean mSplitTrack;
    float mTouchProgressOffset;
    boolean mIsUserSeekable = true;
    private int mKeyProgressIncrement = 1;
    private static final int NO_ALPHA = 255;
    private float mDisabledAlpha;
    private int mScaledTouchSlop;
    private float mTouchDownX;
    private boolean mIsDragging;

    public AbsSeekBar(Context context) {
        super(context);
    }

    public AbsSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AbsSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public AbsSeekBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SeekBar, defStyleAttr, defStyleRes);
        Drawable thumb = a.getDrawable(0);
        this.setThumb(thumb);
        if (a.hasValue(4)) {
            this.mThumbTintMode = Drawable.parseTintMode(a.getInt(4, -1), this.mThumbTintMode);
            this.mHasThumbTintMode = true;
        }
        if (a.hasValue(3)) {
            this.mThumbTintList = a.getColorStateList(3);
            this.mHasThumbTint = true;
        }
        int thumbOffset = a.getDimensionPixelOffset(1, this.getThumbOffset());
        this.setThumbOffset(thumbOffset);
        this.mSplitTrack = a.getBoolean(2, false);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.Theme, 0, 0);
        this.mDisabledAlpha = a.getFloat(3, 0.5f);
        a.recycle();
        this.applyThumbTint();
        this.mScaledTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
    }

    public void setThumb(Drawable thumb) {
        boolean needUpdate;
        if (this.mThumb != null && thumb != this.mThumb) {
            this.mThumb.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (thumb != null) {
            thumb.setCallback(this);
            if (this.canResolveLayoutDirection()) {
                thumb.setLayoutDirection(this.getLayoutDirection());
            }
            this.mThumbOffset = thumb.getIntrinsicWidth() / 2;
            if (needUpdate && (thumb.getIntrinsicWidth() != this.mThumb.getIntrinsicWidth() || thumb.getIntrinsicHeight() != this.mThumb.getIntrinsicHeight())) {
                this.requestLayout();
            }
        }
        this.mThumb = thumb;
        this.applyThumbTint();
        this.invalidate();
        if (needUpdate) {
            this.updateThumbAndTrackPos(this.getWidth(), this.getHeight());
            if (thumb != null && thumb.isStateful()) {
                int[] state = this.getDrawableState();
                thumb.setState(state);
            }
        }
    }

    public Drawable getThumb() {
        return this.mThumb;
    }

    public void setThumbTintList(ColorStateList tint) {
        this.mThumbTintList = tint;
        this.mHasThumbTint = true;
        this.applyThumbTint();
    }

    public ColorStateList getThumbTintList() {
        return this.mThumbTintList;
    }

    public void setThumbTintMode(PorterDuff.Mode tintMode) {
        this.mThumbTintMode = tintMode;
        this.mHasThumbTintMode = true;
        this.applyThumbTint();
    }

    public PorterDuff.Mode getThumbTintMode() {
        return this.mThumbTintMode;
    }

    private void applyThumbTint() {
        if (this.mThumb != null && (this.mHasThumbTint || this.mHasThumbTintMode)) {
            this.mThumb = this.mThumb.mutate();
            if (this.mHasThumbTint) {
                this.mThumb.setTintList(this.mThumbTintList);
            }
            if (this.mHasThumbTintMode) {
                this.mThumb.setTintMode(this.mThumbTintMode);
            }
            if (this.mThumb.isStateful()) {
                this.mThumb.setState(this.getDrawableState());
            }
        }
    }

    public int getThumbOffset() {
        return this.mThumbOffset;
    }

    public void setThumbOffset(int thumbOffset) {
        this.mThumbOffset = thumbOffset;
        this.invalidate();
    }

    public void setSplitTrack(boolean splitTrack) {
        this.mSplitTrack = splitTrack;
        this.invalidate();
    }

    public boolean getSplitTrack() {
        return this.mSplitTrack;
    }

    public void setKeyProgressIncrement(int increment) {
        this.mKeyProgressIncrement = increment < 0 ? -increment : increment;
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    @Override
    public synchronized void setMax(int max) {
        super.setMax(max);
        if (this.mKeyProgressIncrement == 0 || this.getMax() / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(Math.max(1, Math.round((float)this.getMax() / 20.0f)));
        }
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        return who == this.mThumb || super.verifyDrawable(who);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mThumb != null) {
            this.mThumb.jumpToCurrentState();
        }
    }

    @Override
    protected void drawableStateChanged() {
        Drawable thumb;
        super.drawableStateChanged();
        Drawable progressDrawable = this.getProgressDrawable();
        if (progressDrawable != null) {
            progressDrawable.setAlpha(this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha));
        }
        if ((thumb = this.mThumb) != null && thumb.isStateful()) {
            thumb.setState(this.getDrawableState());
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mThumb != null) {
            this.mThumb.setHotspot(x, y);
        }
    }

    @Override
    void onProgressRefresh(float scale, boolean fromUser) {
        super.onProgressRefresh(scale, fromUser);
        Drawable thumb = this.mThumb;
        if (thumb != null) {
            this.setThumbPos(this.getWidth(), thumb, scale, Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateThumbAndTrackPos(w, h);
    }

    private void updateThumbAndTrackPos(int w, int h) {
        int thumbOffset;
        int trackOffset;
        int thumbHeight;
        Drawable track = this.getCurrentDrawable();
        Drawable thumb = this.mThumb;
        int trackHeight = Math.min(this.mMaxHeight, h - this.mPaddingTop - this.mPaddingBottom);
        int n = thumbHeight = thumb == null ? 0 : thumb.getIntrinsicHeight();
        if (thumbHeight > trackHeight) {
            trackOffset = (thumbHeight - trackHeight) / 2;
            thumbOffset = 0;
        } else {
            trackOffset = 0;
            thumbOffset = (trackHeight - thumbHeight) / 2;
        }
        if (track != null) {
            track.setBounds(0, trackOffset, w - this.mPaddingRight - this.mPaddingLeft, h - this.mPaddingBottom - trackOffset - this.mPaddingTop);
        }
        if (thumb != null) {
            this.setThumbPos(w, thumb, this.getScale(), thumbOffset);
        }
    }

    private float getScale() {
        int max = this.getMax();
        return max > 0 ? (float)this.getProgress() / (float)max : 0.0f;
    }

    private void setThumbPos(int w, Drawable thumb, float scale, int offset) {
        int bottom;
        int top;
        int available = w - this.mPaddingLeft - this.mPaddingRight;
        int thumbWidth = thumb.getIntrinsicWidth();
        int thumbHeight = thumb.getIntrinsicHeight();
        available -= thumbWidth;
        int thumbPos = (int)(scale * (float)(available += this.mThumbOffset * 2) + 0.5f);
        if (offset == Integer.MIN_VALUE) {
            Rect oldBounds = thumb.getBounds();
            top = oldBounds.top;
            bottom = oldBounds.bottom;
        } else {
            top = offset;
            bottom = offset + thumbHeight;
        }
        int left = this.isLayoutRtl() && this.mMirrorForRtl ? available - thumbPos : thumbPos;
        int right = left + thumbWidth;
        Drawable background = this.getBackground();
        if (background != null) {
            Rect bounds = thumb.getBounds();
            int offsetX = this.mPaddingLeft - this.mThumbOffset;
            int offsetY = this.mPaddingTop;
            background.setHotspotBounds(left + offsetX, top + offsetY, right + offsetX, bottom + offsetY);
        }
        thumb.setBounds(left, top, right, bottom);
    }

    @Override
    public void onResolveDrawables(int layoutDirection) {
        super.onResolveDrawables(layoutDirection);
        if (this.mThumb != null) {
            this.mThumb.setLayoutDirection(layoutDirection);
        }
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawThumb(canvas);
    }

    @Override
    void drawTrack(Canvas canvas) {
        Drawable thumbDrawable = this.mThumb;
        if (thumbDrawable != null && this.mSplitTrack) {
            Insets insets = thumbDrawable.getOpticalInsets();
            Rect tempRect = this.mTempRect;
            thumbDrawable.copyBounds(tempRect);
            tempRect.offset(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            tempRect.left += insets.left;
            tempRect.right -= insets.right;
            int saveCount = canvas.save();
            canvas.clipRect(tempRect, Region.Op.DIFFERENCE);
            super.drawTrack(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.drawTrack(canvas);
        }
    }

    void drawThumb(Canvas canvas) {
        if (this.mThumb != null) {
            canvas.save();
            canvas.translate(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            this.mThumb.draw(canvas);
            canvas.restore();
        }
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.getCurrentDrawable();
        int thumbHeight = this.mThumb == null ? 0 : this.mThumb.getIntrinsicHeight();
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
            dh = Math.max(thumbHeight, dh);
        }
        this.setMeasuredDimension(AbsSeekBar.resolveSizeAndState(dw += this.mPaddingLeft + this.mPaddingRight, widthMeasureSpec, 0), AbsSeekBar.resolveSizeAndState(dh += this.mPaddingTop + this.mPaddingBottom, heightMeasureSpec, 0));
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsUserSeekable || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.isInScrollingContainer()) {
                    this.mTouchDownX = event.getX();
                    break;
                }
                this.setPressed(true);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 2: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    break;
                }
                float x = event.getX();
                if (!(Math.abs(x - this.mTouchDownX) > (float)this.mScaledTouchSlop)) break;
                this.setPressed(true);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                }
                this.invalidate();
            }
        }
        return true;
    }

    private void setHotspot(float x, float y) {
        Drawable bg = this.getBackground();
        if (bg != null) {
            bg.setHotspot(x, y);
        }
    }

    private void trackTouchEvent(MotionEvent event) {
        float scale;
        int width = this.getWidth();
        int available = width - this.mPaddingLeft - this.mPaddingRight;
        int x = (int)event.getX();
        float progress = 0.0f;
        if (this.isLayoutRtl() && this.mMirrorForRtl) {
            if (x > width - this.mPaddingRight) {
                scale = 0.0f;
            } else if (x < this.mPaddingLeft) {
                scale = 1.0f;
            } else {
                scale = (float)(available - x + this.mPaddingLeft) / (float)available;
                progress = this.mTouchProgressOffset;
            }
        } else if (x < this.mPaddingLeft) {
            scale = 0.0f;
        } else if (x > width - this.mPaddingRight) {
            scale = 1.0f;
        } else {
            scale = (float)(x - this.mPaddingLeft) / (float)available;
            progress = this.mTouchProgressOffset;
        }
        int max = this.getMax();
        this.setHotspot(x, (int)event.getY());
        this.setProgress((int)(progress += scale * (float)max), true);
    }

    private void attemptClaimDrag() {
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    void onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    void onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    void onKeyChange() {
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isEnabled()) {
            int progress = this.getProgress();
            switch (keyCode) {
                case 21: {
                    if (progress <= 0) break;
                    this.setProgress(progress - this.mKeyProgressIncrement, true);
                    this.onKeyChange();
                    return true;
                }
                case 22: {
                    if (progress >= this.getMax()) break;
                    this.setProgress(progress + this.mKeyProgressIncrement, true);
                    this.onKeyChange();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(AbsSeekBar.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(AbsSeekBar.class.getName());
        if (this.isEnabled()) {
            int progress = this.getProgress();
            if (progress > 0) {
                info.addAction(8192);
            }
            if (progress < this.getMax()) {
                info.addAction(4096);
            }
        }
    }

    @Override
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        int progress = this.getProgress();
        int increment = Math.max(1, Math.round((float)this.getMax() / 5.0f));
        switch (action) {
            case 8192: {
                if (progress <= 0) {
                    return false;
                }
                this.setProgress(progress - increment, true);
                this.onKeyChange();
                return true;
            }
            case 4096: {
                if (progress >= this.getMax()) {
                    return false;
                }
                this.setProgress(progress + increment, true);
                this.onKeyChange();
                return true;
            }
        }
        return false;
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        Drawable thumb = this.mThumb;
        if (thumb != null) {
            this.setThumbPos(this.getWidth(), thumb, this.getScale(), Integer.MIN_VALUE);
            this.invalidate();
        }
    }
}

