/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityCache;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class AccessibilityInteractionClient
extends IAccessibilityInteractionConnectionCallback.Stub {
    public static final int NO_ID = -1;
    private static final String LOG_TAG = "AccessibilityInteractionClient";
    private static final boolean DEBUG = false;
    private static final boolean CHECK_INTEGRITY = true;
    private static final long TIMEOUT_INTERACTION_MILLIS = 5000L;
    private static final Object sStaticLock = new Object();
    private static final LongSparseArray<AccessibilityInteractionClient> sClients = new LongSparseArray();
    private final AtomicInteger mInteractionIdCounter = new AtomicInteger();
    private final Object mInstanceLock = new Object();
    private volatile int mInteractionId = -1;
    private AccessibilityNodeInfo mFindAccessibilityNodeInfoResult;
    private List<AccessibilityNodeInfo> mFindAccessibilityNodeInfosResult;
    private boolean mPerformAccessibilityActionResult;
    private Message mSameThreadMessage;
    private static final SparseArray<IAccessibilityServiceConnection> sConnectionCache = new SparseArray();
    private static final AccessibilityCache sAccessibilityCache = new AccessibilityCache();

    public static AccessibilityInteractionClient getInstance() {
        long threadId = Thread.currentThread().getId();
        return AccessibilityInteractionClient.getInstanceForThread(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityInteractionClient getInstanceForThread(long threadId) {
        Object object = sStaticLock;
        synchronized (object) {
            AccessibilityInteractionClient client = sClients.get(threadId);
            if (client == null) {
                client = new AccessibilityInteractionClient();
                sClients.put(threadId, client);
            }
            return client;
        }
    }

    private AccessibilityInteractionClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSameThreadMessage(Message message) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mSameThreadMessage = message;
            this.mInstanceLock.notifyAll();
        }
    }

    public AccessibilityNodeInfo getRootInActiveWindow(int connectionId) {
        return this.findAccessibilityNodeInfoByAccessibilityId(connectionId, Integer.MAX_VALUE, AccessibilityNodeInfo.ROOT_NODE_ID, false, 4);
    }

    public AccessibilityWindowInfo getWindow(int connectionId, int accessibilityWindowId) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                AccessibilityWindowInfo window = sAccessibilityCache.getWindow(accessibilityWindowId);
                if (window != null) {
                    return window;
                }
                window = connection.getWindow(accessibilityWindowId);
                if (window != null) {
                    sAccessibilityCache.addWindow(window);
                    return window;
                }
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while calling remote getWindow", re);
        }
        return null;
    }

    public List<AccessibilityWindowInfo> getWindows(int connectionId) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                List<AccessibilityWindowInfo> windows = sAccessibilityCache.getWindows();
                if (windows != null) {
                    return windows;
                }
                windows = connection.getWindows();
                if (windows != null) {
                    int windowCount = windows.size();
                    for (int i = 0; i < windowCount; ++i) {
                        AccessibilityWindowInfo window = windows.get(i);
                        sAccessibilityCache.addWindow(window);
                    }
                    return windows;
                }
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while calling remote getWindows", re);
        }
        return Collections.emptyList();
    }

    public AccessibilityNodeInfo findAccessibilityNodeInfoByAccessibilityId(int connectionId, int accessibilityWindowId, long accessibilityNodeId, boolean bypassCache, int prefetchFlags) {
        if ((prefetchFlags & 2) != 0 && (prefetchFlags & 1) == 0) {
            throw new IllegalArgumentException("FLAG_PREFETCH_SIBLINGS requires FLAG_PREFETCH_PREDECESSORS");
        }
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                AccessibilityNodeInfo cachedInfo;
                if (!bypassCache && (cachedInfo = sAccessibilityCache.getNode(accessibilityWindowId, accessibilityNodeId)) != null) {
                    return cachedInfo;
                }
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                boolean success = connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityWindowId, accessibilityNodeId, interactionId, this, prefetchFlags, Thread.currentThread().getId());
                if (success) {
                    List<AccessibilityNodeInfo> infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId);
                    this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId);
                    if (infos != null && !infos.isEmpty()) {
                        return infos.get(0);
                    }
                }
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while calling remote findAccessibilityNodeInfoByAccessibilityId", re);
        }
        return null;
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(int connectionId, int accessibilityWindowId, long accessibilityNodeId, String viewId) {
        try {
            List<AccessibilityNodeInfo> infos;
            int interactionId;
            boolean success;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (success = connection.findAccessibilityNodeInfosByViewId(accessibilityWindowId, accessibilityNodeId, viewId, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId())) && (infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId)) != null) {
                this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId);
                return infos;
            }
        }
        catch (RemoteException re) {
            Log.w(LOG_TAG, "Error while calling remote findAccessibilityNodeInfoByViewIdInActiveWindow", re);
        }
        return Collections.emptyList();
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(int connectionId, int accessibilityWindowId, long accessibilityNodeId, String text) {
        try {
            List<AccessibilityNodeInfo> infos;
            int interactionId;
            boolean success;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (success = connection.findAccessibilityNodeInfosByText(accessibilityWindowId, accessibilityNodeId, text, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId())) && (infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId)) != null) {
                this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId);
                return infos;
            }
        }
        catch (RemoteException re) {
            Log.w(LOG_TAG, "Error while calling remote findAccessibilityNodeInfosByViewText", re);
        }
        return Collections.emptyList();
    }

    public AccessibilityNodeInfo findFocus(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int focusType) {
        try {
            int interactionId;
            boolean success;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (success = connection.findFocus(accessibilityWindowId, accessibilityNodeId, focusType, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId()))) {
                AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId);
                return info;
            }
        }
        catch (RemoteException re) {
            Log.w(LOG_TAG, "Error while calling remote findFocus", re);
        }
        return null;
    }

    public AccessibilityNodeInfo focusSearch(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int direction) {
        try {
            int interactionId;
            boolean success;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (success = connection.focusSearch(accessibilityWindowId, accessibilityNodeId, direction, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId()))) {
                AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId);
                return info;
            }
        }
        catch (RemoteException re) {
            Log.w(LOG_TAG, "Error while calling remote accessibilityFocusSearch", re);
        }
        return null;
    }

    public boolean performAccessibilityAction(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments) {
        try {
            int interactionId;
            boolean success;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (success = connection.performAccessibilityAction(accessibilityWindowId, accessibilityNodeId, action, arguments, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId()))) {
                return this.getPerformAccessibilityActionResultAndClear(interactionId);
            }
        }
        catch (RemoteException re) {
            Log.w(LOG_TAG, "Error while calling remote performAccessibilityAction", re);
        }
        return false;
    }

    public void clearCache() {
        sAccessibilityCache.clear();
    }

    public void onAccessibilityEvent(AccessibilityEvent event) {
        sAccessibilityCache.onAccessibilityEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessibilityNodeInfo getFindAccessibilityNodeInfoResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            AccessibilityNodeInfo result = success ? this.mFindAccessibilityNodeInfoResult : null;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFindAccessibilityNodeInfoResult(AccessibilityNodeInfo info, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mFindAccessibilityNodeInfoResult = info;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AccessibilityNodeInfo> getFindAccessibilityNodeInfosResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            List<AccessibilityNodeInfo> result = null;
            result = success ? this.mFindAccessibilityNodeInfosResult : Collections.emptyList();
            this.clearResultLocked();
            if (Build.IS_DEBUGGABLE) {
                this.checkFindAccessibilityNodeInfoResultIntegrity(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFindAccessibilityNodeInfosResult(List<AccessibilityNodeInfo> infos, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                if (infos != null) {
                    boolean isIpcCall;
                    boolean bl = isIpcCall = Binder.getCallingPid() != Process.myPid();
                    this.mFindAccessibilityNodeInfosResult = !isIpcCall ? new ArrayList<AccessibilityNodeInfo>(infos) : infos;
                } else {
                    this.mFindAccessibilityNodeInfosResult = Collections.emptyList();
                }
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPerformAccessibilityActionResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            boolean result = success ? this.mPerformAccessibilityActionResult : false;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPerformAccessibilityActionResult(boolean succeeded, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mPerformAccessibilityActionResult = succeeded;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    private void clearResultLocked() {
        this.mInteractionId = -1;
        this.mFindAccessibilityNodeInfoResult = null;
        this.mFindAccessibilityNodeInfosResult = null;
        this.mPerformAccessibilityActionResult = false;
    }

    private boolean waitForResultTimedLocked(int interactionId) {
        long waitTimeMillis = 5000L;
        long startTimeMillis = SystemClock.uptimeMillis();
        while (true) {
            try {
                while (true) {
                    Message sameProcessMessage;
                    if ((sameProcessMessage = this.getSameProcessMessageAndClear()) != null) {
                        sameProcessMessage.getTarget().handleMessage(sameProcessMessage);
                    }
                    if (this.mInteractionId == interactionId) {
                        return true;
                    }
                    if (this.mInteractionId > interactionId) {
                        return false;
                    }
                    long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                    waitTimeMillis = 5000L - elapsedTimeMillis;
                    if (waitTimeMillis <= 0L) {
                        return false;
                    }
                    this.mInstanceLock.wait(waitTimeMillis);
                }
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
    }

    private void finalizeAndCacheAccessibilityNodeInfo(AccessibilityNodeInfo info, int connectionId) {
        if (info != null) {
            info.setConnectionId(connectionId);
            info.setSealed(true);
            sAccessibilityCache.add(info);
        }
    }

    private void finalizeAndCacheAccessibilityNodeInfos(List<AccessibilityNodeInfo> infos, int connectionId) {
        if (infos != null) {
            int infosCount = infos.size();
            for (int i = 0; i < infosCount; ++i) {
                AccessibilityNodeInfo info = infos.get(i);
                this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getSameProcessMessageAndClear() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Message result = this.mSameThreadMessage;
            this.mSameThreadMessage = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAccessibilityServiceConnection getConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            return sConnectionCache.get(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(int connectionId, IAccessibilityServiceConnection connection) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.put(connectionId, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.remove(connectionId);
        }
    }

    private void checkFindAccessibilityNodeInfoResultIntegrity(List<AccessibilityNodeInfo> infos) {
        if (infos.size() == 0) {
            return;
        }
        AccessibilityNodeInfo root = infos.get(0);
        int infoCount = infos.size();
        block0: for (int i = 1; i < infoCount; ++i) {
            for (int j = i; j < infoCount; ++j) {
                AccessibilityNodeInfo candidate = infos.get(j);
                if (root.getParentNodeId() != candidate.getSourceNodeId()) continue;
                root = candidate;
                continue block0;
            }
        }
        if (root == null) {
            Log.e(LOG_TAG, "No root.");
        }
        HashSet<AccessibilityNodeInfo> seen = new HashSet<AccessibilityNodeInfo>();
        LinkedList<AccessibilityNodeInfo> fringe = new LinkedList<AccessibilityNodeInfo>();
        fringe.add(root);
        while (!fringe.isEmpty()) {
            AccessibilityNodeInfo current = (AccessibilityNodeInfo)fringe.poll();
            if (!seen.add(current)) {
                Log.e(LOG_TAG, "Duplicate node.");
                return;
            }
            int childCount = current.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                long childId = current.getChildId(i);
                for (int j = 0; j < infoCount; ++j) {
                    AccessibilityNodeInfo child = infos.get(j);
                    if (child.getSourceNodeId() != childId) continue;
                    fringe.add(child);
                }
            }
        }
        int disconnectedCount = infos.size() - seen.size();
        if (disconnectedCount > 0) {
            Log.e(LOG_TAG, disconnectedCount + " Disconnected nodes.");
        }
    }
}

