/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.GLES20Canvas;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.RenderNode;
import android.view.Surface;
import android.view.ThreadedRenderer;
import android.view.View;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class HardwareRenderer {
    static final String LOG_TAG = "HardwareRenderer";
    private static final String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    static final String RENDER_DIRTY_REGIONS_PROPERTY = "debug.hwui.render_dirty_regions";
    public static final String PROFILE_PROPERTY = "debug.hwui.profile";
    public static final String PROFILE_PROPERTY_VISUALIZE_BARS = "visual_bars";
    static final String PROFILE_MAXFRAMES_PROPERTY = "debug.hwui.profile.maxframes";
    static final String PRINT_CONFIG_PROPERTY = "debug.hwui.print_config";
    public static final String DEBUG_DIRTY_REGIONS_PROPERTY = "debug.hwui.show_dirty_regions";
    public static final String DEBUG_SHOW_LAYERS_UPDATES_PROPERTY = "debug.hwui.show_layers_updates";
    public static final String DEBUG_OVERDRAW_PROPERTY = "debug.hwui.overdraw";
    public static final String OVERDRAW_PROPERTY_SHOW = "show";
    public static final String DEBUG_SHOW_NON_RECTANGULAR_CLIP_PROPERTY = "debug.hwui.show_non_rect_clip";
    public static boolean sRendererDisabled = false;
    public static boolean sSystemRendererDisabled = false;
    private boolean mEnabled;
    private boolean mRequested = true;
    public static boolean sTrimForeground = false;

    public static void disable(boolean system) {
        sRendererDisabled = true;
        if (system) {
            sSystemRendererDisabled = true;
        }
    }

    public static void enableForegroundTrimming() {
        sTrimForeground = true;
    }

    public static boolean isAvailable() {
        return GLES20Canvas.isAvailable();
    }

    abstract void destroy();

    abstract boolean initialize(Surface var1) throws Surface.OutOfResourcesException;

    abstract void updateSurface(Surface var1) throws Surface.OutOfResourcesException;

    abstract boolean pauseSurface(Surface var1);

    abstract void destroyHardwareResources(View var1);

    abstract void invalidate(Surface var1);

    abstract void detachSurfaceTexture(long var1);

    abstract int getWidth();

    abstract int getHeight();

    abstract void dumpGfxInfo(PrintWriter var1, FileDescriptor var2);

    abstract boolean loadSystemProperties();

    public static void setupDiskCache(File cacheDir) {
        ThreadedRenderer.setupShadersDiskCache(new File(cacheDir, CACHE_PATH_SHADERS).getAbsolutePath());
    }

    abstract void pushLayerUpdate(HardwareLayer var1);

    abstract void onLayerDestroyed(HardwareLayer var1);

    abstract void invalidateRoot();

    abstract void draw(View var1, View.AttachInfo var2, HardwareDrawCallbacks var3);

    abstract HardwareLayer createTextureLayer();

    abstract void buildLayer(RenderNode var1);

    abstract boolean copyLayerInto(HardwareLayer var1, Bitmap var2);

    boolean initializeIfNeeded(int width, int height, Surface surface, Rect surfaceInsets) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(surface)) {
            this.setup(width, height, surfaceInsets);
            return true;
        }
        return false;
    }

    abstract void setup(int var1, int var2, Rect var3);

    abstract void setName(String var1);

    abstract void setOpaque(boolean var1);

    static HardwareRenderer create(Context context, boolean translucent) {
        ThreadedRenderer renderer = null;
        if (GLES20Canvas.isAvailable()) {
            renderer = new ThreadedRenderer(context, translucent);
        }
        return renderer;
    }

    static void trimMemory(int level) {
        ThreadedRenderer.trimMemory(level);
    }

    boolean isEnabled() {
        return this.mEnabled;
    }

    void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    boolean isRequested() {
        return this.mRequested;
    }

    void setRequested(boolean requested) {
        this.mRequested = requested;
    }

    abstract void fence();

    abstract void stopDrawing();

    abstract void notifyFramePending();

    abstract void registerAnimatingRenderNode(RenderNode var1);

    static interface HardwareDrawCallbacks {
        public void onHardwarePreDraw(HardwareCanvas var1);

        public void onHardwarePostDraw(HardwareCanvas var1);
    }
}

