/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.RenderNode;
import com.android.tools.layoutlib.create.OverrideMethod;

class GLES20Canvas
extends HardwareCanvas {
    private final boolean mOpaque;
    protected long mRenderer = GLES20Canvas.nCreateDisplayListRenderer();
    private CanvasFinalizer mFinalizer;
    private int mWidth;
    private int mHeight;
    private float[] mPoint;
    private float[] mLine;
    private Rect mClipBounds;
    private RectF mPathBounds;
    private DrawFilter mFilter;
    private static boolean sIsAvailable = GLES20Canvas.nIsAvailable();

    private static boolean nIsAvailable() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nIsAvailable()Z", true, null) != 0;
    }

    static boolean isAvailable() {
        return sIsAvailable;
    }

    protected GLES20Canvas() {
        this.mOpaque = false;
        this.setupFinalizer();
    }

    private void setupFinalizer() {
        if (this.mRenderer == 0L) {
            throw new IllegalStateException("Could not create GLES20Canvas renderer");
        }
        this.mFinalizer = new CanvasFinalizer(this.mRenderer);
    }

    private static long nCreateDisplayListRenderer() {
        return OverrideMethod.invokeL("android.view.GLES20Canvas#nCreateDisplayListRenderer()J", true, null);
    }

    private static void nResetDisplayListRenderer(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetDisplayListRenderer(J)V", true, null);
    }

    private static void nDestroyRenderer(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyRenderer(J)V", true, null);
    }

    public static void setProperty(String name, String value) {
        GLES20Canvas.nSetProperty(name, value);
    }

    private static void nSetProperty(String string2, String string3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetProperty(Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    @Override
    public boolean isOpaque() {
        return this.mOpaque;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return GLES20Canvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return GLES20Canvas.nGetMaximumTextureHeight();
    }

    private static int nGetMaximumTextureWidth() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetMaximumTextureWidth()I", true, null);
    }

    private static int nGetMaximumTextureHeight() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetMaximumTextureHeight()I", true, null);
    }

    long getRenderer() {
        return this.mRenderer;
    }

    @Override
    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20Canvas.nSetViewport(this.mRenderer, width, height);
    }

    private static void nSetViewport(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetViewport(JII)V", true, null);
    }

    @Override
    public void setHighContrastText(boolean highContrastText) {
        GLES20Canvas.nSetHighContrastText(this.mRenderer, highContrastText);
    }

    private static void nSetHighContrastText(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetHighContrastText(JZ)V", true, null);
    }

    @Override
    public void insertReorderBarrier() {
        GLES20Canvas.nInsertReorderBarrier(this.mRenderer, true);
    }

    @Override
    public void insertInorderBarrier() {
        GLES20Canvas.nInsertReorderBarrier(this.mRenderer, false);
    }

    private static void nInsertReorderBarrier(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nInsertReorderBarrier(JZ)V", true, null);
    }

    @Override
    public int onPreDraw(Rect dirty) {
        if (dirty != null) {
            return GLES20Canvas.nPrepareDirty(this.mRenderer, dirty.left, dirty.top, dirty.right, dirty.bottom, this.mOpaque);
        }
        return GLES20Canvas.nPrepare(this.mRenderer, this.mOpaque);
    }

    private static int nPrepare(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nPrepare(JZ)I", true, null);
    }

    private static int nPrepareDirty(long l, int n, int n2, int n3, int n4, boolean bl) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nPrepareDirty(JIIIIZ)I", true, null);
    }

    @Override
    public void onPostDraw() {
        GLES20Canvas.nFinish(this.mRenderer);
    }

    private static void nFinish(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nFinish(J)V", true, null);
    }

    @Override
    public int callDrawGLFunction2(long drawGLFunction) {
        return GLES20Canvas.nCallDrawGLFunction(this.mRenderer, drawGLFunction);
    }

    private static int nCallDrawGLFunction(long l, long l2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCallDrawGLFunction(JJ)I", true, null);
    }

    protected static long nFinishRecording(long l) {
        return OverrideMethod.invokeL("android.view.GLES20Canvas#nFinishRecording(J)J", true, null);
    }

    @Override
    public int drawRenderNode(RenderNode renderNode, Rect dirty, int flags) {
        return GLES20Canvas.nDrawRenderNode(this.mRenderer, renderNode.getNativeDisplayList(), dirty, flags);
    }

    private static int nDrawRenderNode(long l, long l2, Rect rect, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nDrawRenderNode(JJLandroid/graphics/Rect;I)I", true, null);
    }

    @Override
    void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        layer.setLayerPaint(paint);
        GLES20Canvas.nDrawLayer(this.mRenderer, layer.getLayerHandle(), x, y);
    }

    private static void nDrawLayer(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawLayer(JJFF)V", true, null);
    }

    private Rect getInternalClipBounds() {
        if (this.mClipBounds == null) {
            this.mClipBounds = new Rect();
        }
        return this.mClipBounds;
    }

    private RectF getPathBounds() {
        if (this.mPathBounds == null) {
            this.mPathBounds = new RectF();
        }
        return this.mPathBounds;
    }

    private float[] getPointStorage() {
        if (this.mPoint == null) {
            this.mPoint = new float[2];
        }
        return this.mPoint;
    }

    private float[] getLineStorage() {
        if (this.mLine == null) {
            this.mLine = new float[4];
        }
        return this.mLine;
    }

    @Override
    public boolean clipPath(Path path) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipPath(Path path, Region.Op op) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, op.nativeInt);
    }

    private static boolean nClipPath(long l, long l2, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipPath(JJI)Z", true, null) != 0;
    }

    @Override
    public boolean clipRect(float left, float top, float right, float bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static boolean nClipRect(long l, float f, float f2, float f3, float f4, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRect(JFFFFI)Z", true, null) != 0;
    }

    @Override
    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, op.nativeInt);
    }

    @Override
    public boolean clipRect(int left, int top, int right, int bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static boolean nClipRect(long l, int n, int n2, int n3, int n4, int n5) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRect(JIIIII)Z", true, null) != 0;
    }

    @Override
    public boolean clipRect(Rect rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRect(Rect rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Override
    public boolean clipRect(RectF rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRect(RectF rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Override
    public boolean clipRegion(Region region) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRegion(Region region, Region.Op op) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, op.nativeInt);
    }

    private static boolean nClipRegion(long l, long l2, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRegion(JJI)Z", true, null) != 0;
    }

    @Override
    public boolean getClipBounds(Rect bounds) {
        return GLES20Canvas.nGetClipBounds(this.mRenderer, bounds);
    }

    private static boolean nGetClipBounds(long l, Rect rect) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetClipBounds(JLandroid/graphics/Rect;)Z", true, null) != 0;
    }

    @Override
    public boolean quickReject(float left, float top, float right, float bottom, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, left, top, right, bottom);
    }

    private static boolean nQuickReject(long l, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nQuickReject(JFFFF)Z", true, null) != 0;
    }

    @Override
    public boolean quickReject(Path path, Canvas.EdgeType type) {
        RectF pathBounds = this.getPathBounds();
        path.computeBounds(pathBounds, true);
        return GLES20Canvas.nQuickReject(this.mRenderer, pathBounds.left, pathBounds.top, pathBounds.right, pathBounds.bottom);
    }

    @Override
    public boolean quickReject(RectF rect, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom);
    }

    @Override
    public void translate(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            GLES20Canvas.nTranslate(this.mRenderer, dx, dy);
        }
    }

    private static void nTranslate(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nTranslate(JFF)V", true, null);
    }

    @Override
    public void skew(float sx, float sy) {
        GLES20Canvas.nSkew(this.mRenderer, sx, sy);
    }

    private static void nSkew(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSkew(JFF)V", true, null);
    }

    @Override
    public void rotate(float degrees) {
        GLES20Canvas.nRotate(this.mRenderer, degrees);
    }

    private static void nRotate(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRotate(JF)V", true, null);
    }

    @Override
    public void scale(float sx, float sy) {
        GLES20Canvas.nScale(this.mRenderer, sx, sy);
    }

    private static void nScale(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nScale(JFF)V", true, null);
    }

    @Override
    public void setMatrix(Matrix matrix) {
        GLES20Canvas.nSetMatrix(this.mRenderer, matrix == null ? 0L : matrix.native_instance);
    }

    private static void nSetMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetMatrix(JJ)V", true, null);
    }

    @Override
    public void getMatrix(Matrix matrix) {
        GLES20Canvas.nGetMatrix(this.mRenderer, matrix.native_instance);
    }

    private static void nGetMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nGetMatrix(JJ)V", true, null);
    }

    @Override
    public void concat(Matrix matrix) {
        if (matrix != null) {
            GLES20Canvas.nConcatMatrix(this.mRenderer, matrix.native_instance);
        }
    }

    private static void nConcatMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nConcatMatrix(JJ)V", true, null);
    }

    @Override
    public int save() {
        return GLES20Canvas.nSave(this.mRenderer, 3);
    }

    @Override
    public int save(int saveFlags) {
        return GLES20Canvas.nSave(this.mRenderer, saveFlags);
    }

    private static int nSave(long l, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSave(JI)I", true, null);
    }

    @Override
    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        if (bounds != null) {
            return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
        }
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        return GLES20Canvas.nSaveLayer(this.mRenderer, nativePaint, saveFlags);
    }

    private static int nSaveLayer(long l, long l2, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayer(JJI)I", true, null);
    }

    @Override
    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        if (left < right && top < bottom) {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            return GLES20Canvas.nSaveLayer(this.mRenderer, left, top, right, bottom, nativePaint, saveFlags);
        }
        return this.save(saveFlags);
    }

    private static int nSaveLayer(long l, float f, float f2, float f3, float f4, long l2, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayer(JFFFFJI)I", true, null);
    }

    @Override
    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds != null) {
            return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
        }
        return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, alpha, saveFlags);
    }

    private static int nSaveLayerAlpha(long l, int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayerAlpha(JII)I", true, null);
    }

    @Override
    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        if (left < right && top < bottom) {
            return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, left, top, right, bottom, alpha, saveFlags);
        }
        return this.save(saveFlags);
    }

    private static int nSaveLayerAlpha(long l, float f, float f2, float f3, float f4, int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayerAlpha(JFFFFII)I", true, null);
    }

    @Override
    public void restore() {
        GLES20Canvas.nRestore(this.mRenderer);
    }

    private static void nRestore(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRestore(J)V", true, null);
    }

    @Override
    public void restoreToCount(int saveCount) {
        GLES20Canvas.nRestoreToCount(this.mRenderer, saveCount);
    }

    private static void nRestoreToCount(long l, int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRestoreToCount(JI)V", true, null);
    }

    @Override
    public int getSaveCount() {
        return GLES20Canvas.nGetSaveCount(this.mRenderer);
    }

    private static int nGetSaveCount(long l) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetSaveCount(J)I", true, null);
    }

    @Override
    public void setDrawFilter(DrawFilter filter) {
        this.mFilter = filter;
        if (filter == null) {
            GLES20Canvas.nResetPaintFilter(this.mRenderer);
        } else if (filter instanceof PaintFlagsDrawFilter) {
            PaintFlagsDrawFilter flagsFilter = (PaintFlagsDrawFilter)filter;
            GLES20Canvas.nSetupPaintFilter(this.mRenderer, flagsFilter.clearBits, flagsFilter.setBits);
        }
    }

    private static void nResetPaintFilter(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetPaintFilter(J)V", true, null);
    }

    private static void nSetupPaintFilter(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupPaintFilter(JII)V", true, null);
    }

    @Override
    public DrawFilter getDrawFilter() {
        return this.mFilter;
    }

    @Override
    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        GLES20Canvas.nDrawArc(this.mRenderer, left, top, right, bottom, startAngle, sweepAngle, useCenter, paint.mNativePaint);
    }

    private static void nDrawArc(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawArc(JFFFFFFZJ)V", true, null);
    }

    @Override
    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    @Override
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    @Override
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    private static void nDrawPatch(long l, long l2, long l3, float f, float f2, float f3, float f4, long l4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPatch(JJJFFFFJ)V", true, null);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, left, top, nativePaint);
    }

    private static void nDrawBitmap(long l, long l2, float f, float f2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(JJFFJ)V", true, null);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, matrix.native_instance, nativePaint);
    }

    private static void nDrawBitmap(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(JJJJ)V", true, null);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        long nativePaint;
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.mNativePaint;
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        long nativePaint;
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.mNativePaint;
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    private static void nDrawBitmap(long l, long l2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(JJFFFFFFFFJ)V", true, null);
    }

    @Override
    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, colors, offset, stride, x, y, width, height, hasAlpha, nativePaint);
    }

    private static void nDrawBitmap(long l, int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(J[IIIFFIIZJ)V", true, null);
    }

    @Override
    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    @Override
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        if (meshWidth < 0 || meshHeight < 0 || vertOffset < 0 || colorOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        GLES20Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            GLES20Canvas.checkRange(colors.length, colorOffset, count);
        }
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmapMesh(this.mRenderer, bitmap.mNativeBitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, nativePaint);
    }

    private static void nDrawBitmapMesh(long l, long l2, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmapMesh(JJII[FI[IIJ)V", true, null);
    }

    @Override
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        GLES20Canvas.nDrawCircle(this.mRenderer, cx, cy, radius, paint.mNativePaint);
    }

    private static void nDrawCircle(long l, float f, float f2, float f3, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawCircle(JFFFJ)V", true, null);
    }

    @Override
    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        GLES20Canvas.nDrawCircle(this.mRenderer, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    private static void nDrawCircle(long l, long l2, long l3, long l4, long l5) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawCircle(JJJJJ)V", true, null);
    }

    @Override
    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right, CanvasProperty<Float> bottom, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        GLES20Canvas.nDrawRoundRect(this.mRenderer, left.getNativeContainer(), top.getNativeContainer(), right.getNativeContainer(), bottom.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    private static void nDrawRoundRect(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRoundRect(JJJJJJJJ)V", true, null);
    }

    @Override
    public void drawColor(int color2) {
        this.drawColor(color2, PorterDuff.Mode.SRC_OVER);
    }

    @Override
    public void drawColor(int color2, PorterDuff.Mode mode) {
        GLES20Canvas.nDrawColor(this.mRenderer, color2, mode.nativeInt);
    }

    private static void nDrawColor(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawColor(JII)V", true, null);
    }

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        float[] line = this.getLineStorage();
        line[0] = startX;
        line[1] = startY;
        line[2] = stopX;
        line[3] = stopY;
        this.drawLines(line, 0, 4, paint);
    }

    @Override
    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        if (count < 4) {
            return;
        }
        if ((offset | count) < 0 || offset + count > pts.length) {
            throw new IllegalArgumentException("The lines array must contain 4 elements per line.");
        }
        GLES20Canvas.nDrawLines(this.mRenderer, pts, offset, count, paint.mNativePaint);
    }

    private static void nDrawLines(long l, float[] fArray, int n, int n2, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawLines(J[FIIJ)V", true, null);
    }

    @Override
    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    @Override
    public void drawOval(float left, float top, float right, float bottom, Paint paint) {
        GLES20Canvas.nDrawOval(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
    }

    private static void nDrawOval(long l, float f, float f2, float f3, float f4, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawOval(JFFFFJ)V", true, null);
    }

    @Override
    public void drawPaint(Paint paint) {
        Rect r = this.getInternalClipBounds();
        GLES20Canvas.nGetClipBounds(this.mRenderer, r);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        if (path.isSimplePath) {
            if (path.rects != null) {
                GLES20Canvas.nDrawRects(this.mRenderer, path.rects.mNativeRegion, paint.mNativePaint);
            }
        } else {
            GLES20Canvas.nDrawPath(this.mRenderer, path.mNativePath, paint.mNativePaint);
        }
    }

    private static void nDrawPath(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPath(JJJ)V", true, null);
    }

    private static void nDrawRects(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRects(JJJ)V", true, null);
    }

    @Override
    public void drawPicture(Picture picture) {
        picture.endRecording();
    }

    @Override
    public void drawPoint(float x, float y, Paint paint) {
        float[] point = this.getPointStorage();
        point[0] = x;
        point[1] = y;
        this.drawPoints(point, 0, 2, paint);
    }

    @Override
    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    @Override
    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        if (count < 2) {
            return;
        }
        GLES20Canvas.nDrawPoints(this.mRenderer, pts, offset, count, paint.mNativePaint);
    }

    private static void nDrawPoints(long l, float[] fArray, int n, int n2, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPoints(J[FIIJ)V", true, null);
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        if (left == right || top == bottom) {
            return;
        }
        GLES20Canvas.nDrawRect(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
    }

    private static void nDrawRect(long l, float f, float f2, float f3, float f4, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRect(JFFFFJ)V", true, null);
    }

    @Override
    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawRect(RectF r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawRGB(int r, int g, int b) {
        this.drawColor(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        GLES20Canvas.nDrawRoundRect(this.mRenderer, left, top, right, bottom, rx, ry, paint.mNativePaint);
    }

    private static void nDrawRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRoundRect(JFFFFFFJ)V", true, null);
    }

    @Override
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        GLES20Canvas.nDrawText(this.mRenderer, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static void nDrawText(long l, char[] cArray, int n, int n2, float f, float f2, int n3, long l2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawText(J[CIIFFIJJ)V", true, null);
    }

    @Override
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            GLES20Canvas.nDrawText(this.mRenderer, text.toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            GLES20Canvas.nDrawText(this.mRenderer, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
            TemporaryBuffer.recycle(buf);
        }
    }

    @Override
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        GLES20Canvas.nDrawText(this.mRenderer, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static void nDrawText(long l, String string2, int n, int n2, float f, float f2, int n3, long l2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawText(JLjava/lang/String;IIFFIJJ)V", true, null);
    }

    @Override
    public void drawText(String text, float x, float y, Paint paint) {
        GLES20Canvas.nDrawText(this.mRenderer, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    @Override
    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, index, count, path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static void nDrawTextOnPath(long l, char[] cArray, int n, int n2, long l2, float f, float f2, int n3, long l3, long l4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextOnPath(J[CIIJFFIJJ)V", true, null);
    }

    @Override
    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() == 0) {
            return;
        }
        GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, 0, text.length(), path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static void nDrawTextOnPath(long l, String string2, int n, int n2, long l2, float f, float f2, int n3, long l3, long l4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextOnPath(JLjava/lang/String;IIJFFIJJ)V", true, null);
    }

    @Override
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        GLES20Canvas.nDrawTextRun(this.mRenderer, text, index, count, contextIndex, contextCount, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static void nDrawTextRun(long l, char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextRun(J[CIIIIFFZJJ)V", true, null);
    }

    @Override
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            GLES20Canvas.nDrawTextRun(this.mRenderer, text.toString(), start, end, contextStart, contextEnd, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, isRtl, paint);
        } else {
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            GLES20Canvas.nDrawTextRun(this.mRenderer, buf, start - contextStart, len, 0, contextLen, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
            TemporaryBuffer.recycle(buf);
        }
    }

    private static void nDrawTextRun(long l, String string2, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextRun(JLjava/lang/String;IIIIFFZJJ)V", true, null);
    }

    @Override
    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
    }

    private static class CanvasFinalizer {
        private final long mRenderer;

        public CanvasFinalizer(long renderer) {
            this.mRenderer = renderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                GLES20Canvas.nDestroyRenderer(this.mRenderer);
            }
            finally {
                super.finalize();
            }
        }
    }
}

