/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.SntpClient;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.TrustedTime;

public class NtpTrustedTime
implements TrustedTime {
    private static final String TAG = "NtpTrustedTime";
    private static final boolean LOGD = false;
    private static NtpTrustedTime sSingleton;
    private static Context sContext;
    private final String mServer;
    private final long mTimeout;
    private ConnectivityManager mCM;
    private boolean mHasCache;
    private long mCachedNtpTime;
    private long mCachedNtpElapsedRealtime;
    private long mCachedNtpCertainty;

    private NtpTrustedTime(String server, long timeout) {
        this.mServer = server;
        this.mTimeout = timeout;
    }

    public static synchronized NtpTrustedTime getInstance(Context context) {
        if (sSingleton == null) {
            Resources res = context.getResources();
            ContentResolver resolver = context.getContentResolver();
            String defaultServer = res.getString(17039414);
            long defaultTimeout = res.getInteger(17694827);
            String secureServer = Settings.Global.getString(resolver, "ntp_server");
            long timeout = Settings.Global.getLong(resolver, "ntp_timeout", defaultTimeout);
            String server = secureServer != null ? secureServer : defaultServer;
            sSingleton = new NtpTrustedTime(server, timeout);
            sContext = context;
        }
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forceRefresh() {
        NetworkInfo ni;
        if (this.mServer == null) {
            return false;
        }
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            if (this.mCM == null) {
                this.mCM = (ConnectivityManager)sContext.getSystemService("connectivity");
            }
        }
        NetworkInfo networkInfo = ni = this.mCM == null ? null : this.mCM.getActiveNetworkInfo();
        if (ni == null || !ni.isConnected()) {
            return false;
        }
        SntpClient client = new SntpClient();
        if (client.requestTime(this.mServer, (int)this.mTimeout)) {
            this.mHasCache = true;
            this.mCachedNtpTime = client.getNtpTime();
            this.mCachedNtpElapsedRealtime = client.getNtpTimeReference();
            this.mCachedNtpCertainty = client.getRoundTripTime() / 2L;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCache() {
        return this.mHasCache;
    }

    @Override
    public long getCacheAge() {
        if (this.mHasCache) {
            return SystemClock.elapsedRealtime() - this.mCachedNtpElapsedRealtime;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long getCacheCertainty() {
        if (this.mHasCache) {
            return this.mCachedNtpCertainty;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long currentTimeMillis() {
        if (!this.mHasCache) {
            throw new IllegalStateException("Missing authoritative time source");
        }
        return this.mCachedNtpTime + this.getCacheAge();
    }

    public long getCachedNtpTime() {
        return this.mCachedNtpTime;
    }

    public long getCachedNtpTimeReference() {
        return this.mCachedNtpElapsedRealtime;
    }
}

