/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.format.DateFormat;
import android.text.format.Time;
import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import libcore.icu.DateIntervalFormat;
import libcore.icu.LocaleData;

public class DateUtils {
    private static final Object sLock = new Object();
    private static Configuration sLastConfig;
    private static String sElapsedFormatMMSS;
    private static String sElapsedFormatHMMSS;
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final long YEAR_IN_MILLIS = 31449600000L;
    public static final int FORMAT_SHOW_TIME = 1;
    public static final int FORMAT_SHOW_WEEKDAY = 2;
    public static final int FORMAT_SHOW_YEAR = 4;
    public static final int FORMAT_NO_YEAR = 8;
    public static final int FORMAT_SHOW_DATE = 16;
    public static final int FORMAT_NO_MONTH_DAY = 32;
    @Deprecated
    public static final int FORMAT_12HOUR = 64;
    @Deprecated
    public static final int FORMAT_24HOUR = 128;
    @Deprecated
    public static final int FORMAT_CAP_AMPM = 256;
    public static final int FORMAT_NO_NOON = 512;
    @Deprecated
    public static final int FORMAT_CAP_NOON = 1024;
    public static final int FORMAT_NO_MIDNIGHT = 2048;
    @Deprecated
    public static final int FORMAT_CAP_MIDNIGHT = 4096;
    @Deprecated
    public static final int FORMAT_UTC = 8192;
    public static final int FORMAT_ABBREV_TIME = 16384;
    public static final int FORMAT_ABBREV_WEEKDAY = 32768;
    public static final int FORMAT_ABBREV_MONTH = 65536;
    public static final int FORMAT_NUMERIC_DATE = 131072;
    public static final int FORMAT_ABBREV_RELATIVE = 262144;
    public static final int FORMAT_ABBREV_ALL = 524288;
    @Deprecated
    public static final int FORMAT_CAP_NOON_MIDNIGHT = 5120;
    @Deprecated
    public static final int FORMAT_NO_NOON_MIDNIGHT = 2560;
    @Deprecated
    public static final String HOUR_MINUTE_24 = "%H:%M";
    public static final String MONTH_FORMAT = "%B";
    @Deprecated
    public static final String ABBREV_MONTH_FORMAT = "%b";
    public static final String NUMERIC_MONTH_FORMAT = "%m";
    public static final String MONTH_DAY_FORMAT = "%-d";
    public static final String YEAR_FORMAT = "%Y";
    public static final String YEAR_FORMAT_TWO_DIGITS = "%g";
    public static final String WEEKDAY_FORMAT = "%A";
    public static final String ABBREV_WEEKDAY_FORMAT = "%a";
    public static final int[] sameYearTable;
    public static final int[] sameMonthTable;
    @Deprecated
    public static final int LENGTH_LONG = 10;
    @Deprecated
    public static final int LENGTH_MEDIUM = 20;
    @Deprecated
    public static final int LENGTH_SHORT = 30;
    @Deprecated
    public static final int LENGTH_SHORTER = 40;
    @Deprecated
    public static final int LENGTH_SHORTEST = 50;
    private static Time sNowTime;
    private static Time sThenTime;

    @Deprecated
    public static String getDayOfWeekString(int dayOfWeek, int abbrev) {
        String[] names;
        LocaleData d = LocaleData.get(Locale.getDefault());
        switch (abbrev) {
            case 10: {
                names = d.longWeekdayNames;
                break;
            }
            case 20: {
                names = d.shortWeekdayNames;
                break;
            }
            case 30: {
                names = d.shortWeekdayNames;
                break;
            }
            case 40: {
                names = d.shortWeekdayNames;
                break;
            }
            case 50: {
                names = d.tinyWeekdayNames;
                break;
            }
            default: {
                names = d.shortWeekdayNames;
            }
        }
        return names[dayOfWeek];
    }

    @Deprecated
    public static String getAMPMString(int ampm) {
        return LocaleData.get((Locale)Locale.getDefault()).amPm[ampm - 0];
    }

    @Deprecated
    public static String getMonthString(int month, int abbrev) {
        String[] names;
        LocaleData d = LocaleData.get(Locale.getDefault());
        switch (abbrev) {
            case 10: {
                names = d.longMonthNames;
                break;
            }
            case 20: {
                names = d.shortMonthNames;
                break;
            }
            case 30: {
                names = d.shortMonthNames;
                break;
            }
            case 40: {
                names = d.shortMonthNames;
                break;
            }
            case 50: {
                names = d.tinyMonthNames;
                break;
            }
            default: {
                names = d.shortMonthNames;
            }
        }
        return names[month];
    }

    public static CharSequence getRelativeTimeSpanString(long startTime) {
        return DateUtils.getRelativeTimeSpanString(startTime, System.currentTimeMillis(), 60000L);
    }

    public static CharSequence getRelativeTimeSpanString(long time, long now, long minResolution) {
        int flags = 65556;
        return DateUtils.getRelativeTimeSpanString(time, now, minResolution, flags);
    }

    public static CharSequence getRelativeTimeSpanString(long time, long now, long minResolution, int flags) {
        int resId;
        long count;
        Resources r = Resources.getSystem();
        boolean abbrevRelative = (flags & 0xC0000) != 0;
        boolean past = now >= time;
        long duration = Math.abs(now - time);
        if (duration < 60000L && minResolution < 60000L) {
            count = duration / 1000L;
            resId = past ? (abbrevRelative ? 18087946 : 0x1140001) : (abbrevRelative ? 18087950 : 18087942);
        } else if (duration < 3600000L && minResolution < 3600000L) {
            count = duration / 60000L;
            resId = past ? (abbrevRelative ? 18087947 : 18087938) : (abbrevRelative ? 18087951 : 18087943);
        } else if (duration < 86400000L && minResolution < 86400000L) {
            count = duration / 3600000L;
            resId = past ? (abbrevRelative ? 18087948 : 18087939) : (abbrevRelative ? 0x1140010 : 18087944);
        } else {
            if (duration < 604800000L && minResolution < 604800000L) {
                return DateUtils.getRelativeDayString(r, time, now);
            }
            return DateUtils.formatDateRange(null, time, time, flags);
        }
        String format = r.getQuantityString(resId, (int)count);
        return String.format(format, count);
    }

    public static CharSequence getRelativeDateTimeString(Context c, long time, long minResolution, long transitionResolution, int flags) {
        String result;
        Resources r = Resources.getSystem();
        long now = System.currentTimeMillis();
        long duration = Math.abs(now - time);
        if (transitionResolution > 604800000L) {
            transitionResolution = 604800000L;
        } else if (transitionResolution < 86400000L) {
            transitionResolution = 86400000L;
        }
        String timeClause = DateUtils.formatDateRange(c, time, time, 1);
        if (duration < transitionResolution) {
            CharSequence relativeClause = DateUtils.getRelativeTimeSpanString(time, now, minResolution, flags);
            result = r.getString(17040479, relativeClause, timeClause);
        } else {
            CharSequence dateClause = DateUtils.getRelativeTimeSpanString(c, time, false);
            result = r.getString(17039450, dateClause, timeClause);
        }
        return result;
    }

    private static String getRelativeDayString(Resources r, long day, long today) {
        boolean past;
        Locale locale = r.getConfiguration().locale;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Time startTime = new Time();
        startTime.set(day);
        int startDay = Time.getJulianDay(day, startTime.gmtoff);
        Time currentTime = new Time();
        currentTime.set(today);
        int currentDay = Time.getJulianDay(today, currentTime.gmtoff);
        int days = Math.abs(currentDay - startDay);
        boolean bl = past = today > day;
        if (days == 1) {
            if (past) {
                return LocaleData.get((Locale)locale).yesterday;
            }
            return LocaleData.get((Locale)locale).tomorrow;
        }
        if (days == 0) {
            return LocaleData.get((Locale)locale).today;
        }
        int resId = past ? 18087941 : 18087945;
        String format = r.getQuantityString(resId, days);
        return String.format(format, days);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFormatStrings() {
        Object object = sLock;
        synchronized (object) {
            DateUtils.initFormatStringsLocked();
        }
    }

    private static void initFormatStringsLocked() {
        Resources r = Resources.getSystem();
        Configuration cfg = r.getConfiguration();
        if (sLastConfig == null || !sLastConfig.equals(cfg)) {
            sLastConfig = cfg;
            sElapsedFormatMMSS = r.getString(17040484);
            sElapsedFormatHMMSS = r.getString(17040485);
        }
    }

    public static CharSequence formatDuration(long millis) {
        Resources res = Resources.getSystem();
        if (millis >= 3600000L) {
            int hours = (int)((millis + 1800000L) / 3600000L);
            return res.getQuantityString(0x1140014, hours, hours);
        }
        if (millis >= 60000L) {
            int minutes = (int)((millis + 30000L) / 60000L);
            return res.getQuantityString(18087955, minutes, minutes);
        }
        int seconds = (int)((millis + 500L) / 1000L);
        return res.getQuantityString(18087954, seconds, seconds);
    }

    public static String formatElapsedTime(long elapsedSeconds) {
        return DateUtils.formatElapsedTime(null, elapsedSeconds);
    }

    public static String formatElapsedTime(StringBuilder recycle, long elapsedSeconds) {
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        if (elapsedSeconds >= 3600L) {
            hours = elapsedSeconds / 3600L;
            elapsedSeconds -= hours * 3600L;
        }
        if (elapsedSeconds >= 60L) {
            minutes = elapsedSeconds / 60L;
            elapsedSeconds -= minutes * 60L;
        }
        seconds = elapsedSeconds;
        StringBuilder sb = recycle;
        if (sb == null) {
            sb = new StringBuilder(8);
        } else {
            sb.setLength(0);
        }
        Formatter f = new Formatter(sb, Locale.getDefault());
        DateUtils.initFormatStrings();
        if (hours > 0L) {
            return f.format(sElapsedFormatHMMSS, hours, minutes, seconds).toString();
        }
        return f.format(sElapsedFormatMMSS, minutes, seconds).toString();
    }

    public static CharSequence formatSameDayTime(long then, long now, int dateStyle, int timeStyle) {
        GregorianCalendar thenCal = new GregorianCalendar();
        thenCal.setTimeInMillis(then);
        Date thenDate = thenCal.getTime();
        GregorianCalendar nowCal = new GregorianCalendar();
        nowCal.setTimeInMillis(now);
        java.text.DateFormat f = thenCal.get(1) == nowCal.get(1) && thenCal.get(2) == nowCal.get(2) && thenCal.get(5) == nowCal.get(5) ? java.text.DateFormat.getTimeInstance(timeStyle) : java.text.DateFormat.getDateInstance(dateStyle);
        return f.format(thenDate);
    }

    public static boolean isToday(long when) {
        Time time = new Time();
        time.set(when);
        int thenYear = time.year;
        int thenMonth = time.month;
        int thenMonthDay = time.monthDay;
        time.set(System.currentTimeMillis());
        return thenYear == time.year && thenMonth == time.month && thenMonthDay == time.monthDay;
    }

    public static String formatDateRange(Context context, long startMillis, long endMillis, int flags) {
        Formatter f = new Formatter(new StringBuilder(50), Locale.getDefault());
        return DateUtils.formatDateRange(context, f, startMillis, endMillis, flags).toString();
    }

    public static Formatter formatDateRange(Context context, Formatter formatter, long startMillis, long endMillis, int flags) {
        return DateUtils.formatDateRange(context, formatter, startMillis, endMillis, flags, null);
    }

    public static Formatter formatDateRange(Context context, Formatter formatter, long startMillis, long endMillis, int flags, String timeZone) {
        if ((flags & 0xC1) == 1) {
            flags |= DateFormat.is24HourFormat(context) ? 128 : 64;
        }
        String range = DateIntervalFormat.formatDateRange(startMillis, endMillis, flags, timeZone);
        try {
            formatter.out().append(range);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return formatter;
    }

    public static String formatDateTime(Context context, long millis, int flags) {
        return DateUtils.formatDateRange(context, millis, millis, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence getRelativeTimeSpanString(Context c, long millis, boolean withPreposition) {
        long now = System.currentTimeMillis();
        long span = Math.abs(now - millis);
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            int prepositionId;
            String result;
            int flags;
            if (sNowTime == null) {
                sNowTime = new Time();
            }
            if (sThenTime == null) {
                sThenTime = new Time();
            }
            sNowTime.set(now);
            sThenTime.set(millis);
            if (span < 86400000L && DateUtils.sNowTime.weekDay == DateUtils.sThenTime.weekDay) {
                flags = 1;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17040465;
            } else if (DateUtils.sNowTime.year != DateUtils.sThenTime.year) {
                flags = 131092;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17040464;
            } else {
                flags = 65552;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17040464;
            }
            if (withPreposition) {
                Resources res = c.getResources();
                result = res.getString(prepositionId, result);
            }
            // ** MonitorExit[var9_5] (shouldn't be in output)
            return result;
        }
    }

    public static CharSequence getRelativeTimeSpanString(Context c, long millis) {
        return DateUtils.getRelativeTimeSpanString(c, millis, false);
    }

    static {
        sameYearTable = null;
        sameMonthTable = null;
    }
}

