/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.format.DateFormat_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import libcore.icu.ICU;
import libcore.icu.LocaleData;

public class DateFormat {
    @Deprecated
    public static final char QUOTE = '\'';
    @Deprecated
    public static final char AM_PM = 'a';
    @Deprecated
    public static final char CAPITAL_AM_PM = 'A';
    @Deprecated
    public static final char DATE = 'd';
    @Deprecated
    public static final char DAY = 'E';
    @Deprecated
    public static final char HOUR = 'h';
    @Deprecated
    public static final char HOUR_OF_DAY = 'k';
    @Deprecated
    public static final char MINUTE = 'm';
    @Deprecated
    public static final char MONTH = 'M';
    @Deprecated
    public static final char STANDALONE_MONTH = 'L';
    @Deprecated
    public static final char SECONDS = 's';
    @Deprecated
    public static final char TIME_ZONE = 'z';
    @Deprecated
    public static final char YEAR = 'y';
    private static final Object sLocaleLock = new Object();
    private static Locale sIs24HourLocale;
    private static boolean sIs24Hour;

    public static boolean is24HourFormat_Original(Context context) {
        return DateFormat.is24HourFormat(context, UserHandle.myUserId());
    }

    @LayoutlibDelegate
    public static boolean is24HourFormat(Context context) {
        return DateFormat_Delegate.is24HourFormat(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean is24HourFormat_Original(Context context, int userHandle) {
        String value = Settings.System.getStringForUser(context.getContentResolver(), "time_12_24", userHandle);
        if (value == null) {
            SimpleDateFormat sdf;
            String pattern;
            Locale locale = context.getResources().getConfiguration().locale;
            Object object = sLocaleLock;
            synchronized (object) {
                if (sIs24HourLocale != null && sIs24HourLocale.equals(locale)) {
                    return sIs24Hour;
                }
            }
            java.text.DateFormat natural = java.text.DateFormat.getTimeInstance(1, locale);
            value = natural instanceof SimpleDateFormat ? ((pattern = (sdf = (SimpleDateFormat)natural).toPattern()).indexOf(72) >= 0 ? "24" : "12") : "12";
            Object object2 = sLocaleLock;
            synchronized (object2) {
                sIs24HourLocale = locale;
                sIs24Hour = value.equals("24");
            }
            return sIs24Hour;
        }
        return value.equals("24");
    }

    @LayoutlibDelegate
    public static boolean is24HourFormat(Context context, int n) {
        return DateFormat_Delegate.is24HourFormat(context, n);
    }

    public static String getBestDateTimePattern(Locale locale, String skeleton) {
        return ICU.getBestDateTimePattern(skeleton, locale);
    }

    public static java.text.DateFormat getTimeFormat(Context context) {
        return new SimpleDateFormat(DateFormat.getTimeFormatString(context));
    }

    public static String getTimeFormatString(Context context) {
        return DateFormat.getTimeFormatString(context, UserHandle.myUserId());
    }

    public static String getTimeFormatString(Context context, int userHandle) {
        LocaleData d = LocaleData.get(context.getResources().getConfiguration().locale);
        return DateFormat.is24HourFormat(context, userHandle) ? d.timeFormat24 : d.timeFormat12;
    }

    public static java.text.DateFormat getDateFormat(Context context) {
        String value = Settings.System.getString(context.getContentResolver(), "date_format");
        return DateFormat.getDateFormatForSetting(context, value);
    }

    public static java.text.DateFormat getDateFormatForSetting(Context context, String value) {
        String format = DateFormat.getDateFormatStringForSetting(context, value);
        return new SimpleDateFormat(format);
    }

    private static String getDateFormatStringForSetting(Context context, String value) {
        if (value != null) {
            int month = value.indexOf(77);
            int day = value.indexOf(100);
            int year = value.indexOf(121);
            if (month >= 0 && day >= 0 && year >= 0) {
                String template = context.getString(17039446);
                value = year < month && year < day ? (month < day ? String.format(template, "yyyy", "MM", "dd") : String.format(template, "yyyy", "dd", "MM")) : (month < day ? (day < year ? String.format(template, "MM", "dd", "yyyy") : String.format(template, "MM", "yyyy", "dd")) : (month < year ? String.format(template, "dd", "MM", "yyyy") : String.format(template, "dd", "yyyy", "MM")));
                return value;
            }
        }
        LocaleData d = LocaleData.get(context.getResources().getConfiguration().locale);
        return d.shortDateFormat4;
    }

    public static java.text.DateFormat getLongDateFormat(Context context) {
        return java.text.DateFormat.getDateInstance(1);
    }

    public static java.text.DateFormat getMediumDateFormat(Context context) {
        return java.text.DateFormat.getDateInstance(2);
    }

    public static char[] getDateFormatOrder(Context context) {
        return ICU.getDateFormatOrder(DateFormat.getDateFormatString(context));
    }

    private static String getDateFormatString(Context context) {
        String value = Settings.System.getString(context.getContentResolver(), "date_format");
        return DateFormat.getDateFormatStringForSetting(context, value);
    }

    public static CharSequence format(CharSequence inFormat, long inTimeInMillis) {
        return DateFormat.format(inFormat, new Date(inTimeInMillis));
    }

    public static CharSequence format(CharSequence inFormat, Date inDate) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(inDate);
        return DateFormat.format(inFormat, c);
    }

    public static boolean hasSeconds(CharSequence inFormat) {
        return DateFormat.hasDesignator(inFormat, 's');
    }

    public static boolean hasDesignator(CharSequence inFormat, char designator) {
        int count;
        if (inFormat == null) {
            return false;
        }
        int length = inFormat.length();
        for (int i = 0; i < length; i += count) {
            count = 1;
            char c = inFormat.charAt(i);
            if (c == '\'') {
                count = DateFormat.skipQuotedText(inFormat, i, length);
                continue;
            }
            if (c != designator) continue;
            return true;
        }
        return false;
    }

    private static int skipQuotedText(CharSequence s, int i, int len) {
        if (i + 1 < len && s.charAt(i + 1) == '\'') {
            return 2;
        }
        int count = 1;
        ++i;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\'') {
                ++count;
                if (i + 1 >= len || s.charAt(i + 1) != '\'') break;
                ++i;
                continue;
            }
            ++i;
            ++count;
        }
        return count;
    }

    public static CharSequence format(CharSequence inFormat, Calendar inDate) {
        int count;
        SpannableStringBuilder s = new SpannableStringBuilder(inFormat);
        LocaleData localeData = LocaleData.get(Locale.getDefault());
        int len = inFormat.length();
        for (int i = 0; i < len; i += count) {
            String replacement;
            count = 1;
            char c = s.charAt(i);
            if (c == '\'') {
                count = DateFormat.appendQuotedText(s, i, len);
                len = s.length();
                continue;
            }
            while (i + count < len && s.charAt(i + count) == c) {
                ++count;
            }
            switch (c) {
                case 'A': 
                case 'a': {
                    replacement = localeData.amPm[inDate.get(9) - 0];
                    break;
                }
                case 'd': {
                    replacement = DateFormat.zeroPad(inDate.get(5), count);
                    break;
                }
                case 'E': 
                case 'c': {
                    replacement = DateFormat.getDayOfWeekString(localeData, inDate.get(7), count, c);
                    break;
                }
                case 'K': 
                case 'h': {
                    int hour = inDate.get(10);
                    if (c == 'h' && hour == 0) {
                        hour = 12;
                    }
                    replacement = DateFormat.zeroPad(hour, count);
                    break;
                }
                case 'H': 
                case 'k': {
                    int hour = inDate.get(11);
                    replacement = DateFormat.zeroPad(hour, count);
                    break;
                }
                case 'L': 
                case 'M': {
                    replacement = DateFormat.getMonthString(localeData, inDate.get(2), count, c);
                    break;
                }
                case 'm': {
                    replacement = DateFormat.zeroPad(inDate.get(12), count);
                    break;
                }
                case 's': {
                    replacement = DateFormat.zeroPad(inDate.get(13), count);
                    break;
                }
                case 'y': {
                    replacement = DateFormat.getYearString(inDate.get(1), count);
                    break;
                }
                case 'z': {
                    replacement = DateFormat.getTimeZoneString(inDate, count);
                    break;
                }
                default: {
                    replacement = null;
                }
            }
            if (replacement == null) continue;
            s.replace(i, i + count, replacement);
            count = replacement.length();
            len = s.length();
        }
        if (inFormat instanceof Spanned) {
            return new SpannedString(s);
        }
        return s.toString();
    }

    private static String getDayOfWeekString(LocaleData ld, int day, int count, int kind) {
        boolean standalone;
        boolean bl = standalone = kind == 99;
        if (count == 5) {
            return standalone ? ld.tinyStandAloneWeekdayNames[day] : ld.tinyWeekdayNames[day];
        }
        if (count == 4) {
            return standalone ? ld.longStandAloneWeekdayNames[day] : ld.longWeekdayNames[day];
        }
        return standalone ? ld.shortStandAloneWeekdayNames[day] : ld.shortWeekdayNames[day];
    }

    private static String getMonthString(LocaleData ld, int month, int count, int kind) {
        boolean standalone;
        boolean bl = standalone = kind == 76;
        if (count == 5) {
            return standalone ? ld.tinyStandAloneMonthNames[month] : ld.tinyMonthNames[month];
        }
        if (count == 4) {
            return standalone ? ld.longStandAloneMonthNames[month] : ld.longMonthNames[month];
        }
        if (count == 3) {
            return standalone ? ld.shortStandAloneMonthNames[month] : ld.shortMonthNames[month];
        }
        return DateFormat.zeroPad(month + 1, count);
    }

    private static String getTimeZoneString(Calendar inDate, int count) {
        TimeZone tz = inDate.getTimeZone();
        if (count < 2) {
            return DateFormat.formatZoneOffset(inDate.get(16) + inDate.get(15), count);
        }
        boolean dst = inDate.get(16) != 0;
        return tz.getDisplayName(dst, 0);
    }

    private static String formatZoneOffset(int offset, int count) {
        StringBuilder tb = new StringBuilder();
        if ((offset /= 1000) < 0) {
            tb.insert(0, "-");
            offset = -offset;
        } else {
            tb.insert(0, "+");
        }
        int hours = offset / 3600;
        int minutes = offset % 3600 / 60;
        tb.append(DateFormat.zeroPad(hours, 2));
        tb.append(DateFormat.zeroPad(minutes, 2));
        return tb.toString();
    }

    private static String getYearString(int year, int count) {
        return count <= 2 ? DateFormat.zeroPad(year % 100, 2) : String.format(Locale.getDefault(), "%d", year);
    }

    private static int appendQuotedText(SpannableStringBuilder s, int i, int len) {
        if (i + 1 < len && s.charAt(i + 1) == '\'') {
            s.delete(i, i + 1);
            return 1;
        }
        int count = 0;
        s.delete(i, i + 1);
        --len;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\'') {
                if (i + 1 < len && s.charAt(i + 1) == '\'') {
                    s.delete(i, i + 1);
                    --len;
                    ++count;
                    ++i;
                    continue;
                }
                s.delete(i, i + 1);
                break;
            }
            ++i;
            ++count;
        }
        return count;
    }

    private static String zeroPad(int inValue, int inMinDigits) {
        return String.format(Locale.getDefault(), "%0" + inMinDigits + "d", inValue);
    }
}

