/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephonyRegistry;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionManager {
    private static final String LOG_TAG = "SubscriptionManager";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final int INVALID_SUBSCRIPTION_ID = -1;
    public static final int DUMMY_SUBSCRIPTION_ID_BASE = -2;
    public static final int INVALID_PHONE_INDEX = -1;
    public static final int INVALID_SIM_SLOT_INDEX = -1;
    public static final int DEFAULT_SUBSCRIPTION_ID = Integer.MAX_VALUE;
    public static final int DEFAULT_PHONE_INDEX = Integer.MAX_VALUE;
    public static final int DEFAULT_SIM_SLOT_INDEX = Integer.MAX_VALUE;
    public static final int MIN_SUBSCRIPTION_ID_VALUE = 0;
    public static final int MAX_SUBSCRIPTION_ID_VALUE = 0x7FFFFFFE;
    public static final Uri CONTENT_URI = Uri.parse("content://telephony/siminfo");
    public static final String UNIQUE_KEY_SUBSCRIPTION_ID = "_id";
    public static final String ICC_ID = "icc_id";
    public static final String SIM_SLOT_INDEX = "sim_id";
    public static final int SIM_NOT_INSERTED = -1;
    public static final String DISPLAY_NAME = "display_name";
    public static final String CARRIER_NAME = "carrier_name";
    public static final int DEFAULT_NAME_RES = 17039374;
    public static final String NAME_SOURCE = "name_source";
    public static final int NAME_SOURCE_UNDEFINDED = -1;
    public static final int NAME_SOURCE_DEFAULT_SOURCE = 0;
    public static final int NAME_SOURCE_SIM_SOURCE = 1;
    public static final int NAME_SOURCE_USER_INPUT = 2;
    public static final String COLOR = "color";
    public static final int COLOR_1 = 0;
    public static final int COLOR_2 = 1;
    public static final int COLOR_3 = 2;
    public static final int COLOR_4 = 3;
    public static final int COLOR_DEFAULT = 0;
    public static final String NUMBER = "number";
    public static final String DISPLAY_NUMBER_FORMAT = "display_number_format";
    public static final int DISPLAY_NUMBER_NONE = 0;
    public static final int DISPLAY_NUMBER_FIRST = 1;
    public static final int DISPLAY_NUMBER_LAST = 2;
    public static final int DISPLAY_NUMBER_DEFAULT = 1;
    public static final String DATA_ROAMING = "data_roaming";
    public static final int DATA_ROAMING_ENABLE = 1;
    public static final int DATA_ROAMING_DISABLE = 0;
    public static final int DATA_ROAMING_DEFAULT = 0;
    public static final String MCC = "mcc";
    public static final String MNC = "mnc";
    public static final String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";
    private final Context mContext;

    public SubscriptionManager(Context context) {
        this.mContext = context;
    }

    public static SubscriptionManager from(Context context) {
        return (SubscriptionManager)context.getSystemService("telephony_subscription_service");
    }

    public void addOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgForDebug = this.mContext != null ? this.mContext.getPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.addOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void removeOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgForDebug = this.mContext != null ? this.mContext.getPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.removeOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubscriptionInfo getActiveSubscriptionInfo(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[getActiveSubscriptionInfo]- invalid subId");
            return null;
        }
        SubscriptionInfo subInfo = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subInfo = iSub.getActiveSubscriptionInfo(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subInfo;
    }

    public SubscriptionInfo getActiveSubscriptionInfoForIccIndex(String iccId) {
        if (iccId == null) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForIccIndex]- null iccid");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForIccId(iccId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIdx) {
        if (!SubscriptionManager.isValidSlotId(slotIdx)) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForSimSlotIndex]- invalid slotIdx");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForSimSlotIndex(slotIdx);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public List<SubscriptionInfo> getAllSubscriptionInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public List<SubscriptionInfo> getActiveSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getAllSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoCount();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getActiveSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCount();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getActiveSubscriptionInfoCountMax() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCountMax();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public Uri addSubscriptionInfoRecord(String iccId, int slotId) {
        if (iccId == null) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- null iccId");
        }
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- invalid slotId");
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.addSubInfoRecord(iccId, slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public int setIconTint(int tint, int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setIconTint]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setIconTint(tint, subId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public int setDisplayName(String displayName, int subId) {
        return this.setDisplayName(displayName, subId, -1L);
    }

    public int setDisplayName(String displayName, int subId, long nameSource) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDisplayName]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNameUsingSrc(displayName, subId, nameSource);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public int setDisplayNumber(String number, int subId) {
        if (number == null || !SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNumber(number, subId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public int setDataRoaming(int roaming, int subId) {
        if (roaming < 0 || !SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDataRoaming]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDataRoaming(roaming, subId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public static int getSlotId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[getSlotId]- fail");
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSlotId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public static int[] getSubId(int slotId) {
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getSubId(slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static int getPhoneId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[getPhoneId]- fail");
            return -1;
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getPhoneId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static void logd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    public static int getDefaultSubId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static int getDefaultVoiceSubId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultVoiceSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public void setDefaultVoiceSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultVoiceSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubscriptionInfo getDefaultVoiceSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultVoiceSubId());
    }

    public static int getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubId());
    }

    public static int getDefaultSmsSubId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSmsSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public void setDefaultSmsSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultSmsSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubscriptionInfo getDefaultSmsSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultSmsSubId());
    }

    public int getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubId());
    }

    public static int getDefaultDataSubId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultDataSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public void setDefaultDataSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultDataSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubscriptionInfo getDefaultDataSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultDataSubId());
    }

    public int getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubId());
    }

    public void clearSubscriptionInfo() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearSubInfo();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean allDefaultsSelected() {
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultDataSubId())) {
            return false;
        }
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultSmsSubId())) {
            return false;
        }
        return SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultVoiceSubId());
    }

    public void clearDefaultsForInactiveSubIds() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearDefaultsForInactiveSubIds();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static boolean isValidSubscriptionId(int subId) {
        return subId > -1;
    }

    public static boolean isUsableSubIdValue(int subId) {
        return subId >= 0 && subId <= 0x7FFFFFFE;
    }

    public static boolean isValidSlotId(int slotId) {
        return slotId >= 0 && slotId < TelephonyManager.getDefault().getSimCount();
    }

    public static boolean isValidPhoneId(int phoneId) {
        return phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount();
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId) {
        int[] subIds = SubscriptionManager.getSubId(phoneId);
        if (subIds != null && subIds.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subIds[0]);
        } else {
            SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
        }
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId, int subId) {
        intent.putExtra("subscription", subId);
        intent.putExtra("phone", phoneId);
        intent.putExtra("slot", phoneId);
    }

    public int[] getActiveSubscriptionIdList() {
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getActiveSubIdList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subId == null) {
            subId = new int[]{};
        }
        return subId;
    }

    public boolean isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId < 0) {
            return false;
        }
        return TelephonyManager.getDefault().isNetworkRoaming(subId);
    }

    public static int getSimStateForSubscriber(int subId) {
        int simState;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            simState = iSub.getSimStateForSubscriber(subId);
        }
        catch (RemoteException ex) {
            simState = 0;
        }
        SubscriptionManager.logd("getSimStateForSubscriber: simState=" + simState + " subId=" + subId);
        return simState;
    }

    public static class OnSubscriptionsChangedListener {
        public static final String PERMISSION_ON_SUBSCRIPTIONS_CHANGED = "android.permission.READ_PHONE_STATE";
        private final Handler mHandler = new Handler(){

            @Override
            public void handleMessage(Message msg) {
                OnSubscriptionsChangedListener.this.onSubscriptionsChanged();
            }
        };
        IOnSubscriptionsChangedListener callback = new IOnSubscriptionsChangedListener.Stub(){

            @Override
            public void onSubscriptionsChanged() {
                OnSubscriptionsChangedListener.this.mHandler.sendEmptyMessage(0);
            }
        };

        public void onSubscriptionsChanged() {
        }

        private void log(String s) {
            Rlog.d(SubscriptionManager.LOG_TAG, s);
        }
    }
}

