/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;

public class RadioAccessFamily
implements Parcelable {
    public static final int RAF_UNKNOWN = 1;
    public static final int RAF_GPRS = 2;
    public static final int RAF_EDGE = 4;
    public static final int RAF_UMTS = 8;
    public static final int RAF_IS95A = 16;
    public static final int RAF_IS95B = 32;
    public static final int RAF_1xRTT = 64;
    public static final int RAF_EVDO_0 = 128;
    public static final int RAF_EVDO_A = 256;
    public static final int RAF_HSDPA = 512;
    public static final int RAF_HSUPA = 1024;
    public static final int RAF_HSPA = 2048;
    public static final int RAF_EVDO_B = 4096;
    public static final int RAF_EHRPD = 8192;
    public static final int RAF_LTE = 16384;
    public static final int RAF_HSPAP = 32768;
    public static final int RAF_GSM = 65536;
    public static final int RAF_TD_SCDMA = 131072;
    private int mPhoneId;
    private int mRadioAccessFamily;
    public static final Parcelable.Creator<RadioAccessFamily> CREATOR = new Parcelable.Creator<RadioAccessFamily>(){

        @Override
        public RadioAccessFamily createFromParcel(Parcel in) {
            int phoneId = in.readInt();
            int radioAccessFamily = in.readInt();
            return new RadioAccessFamily(phoneId, radioAccessFamily);
        }

        public RadioAccessFamily[] newArray(int size) {
            return new RadioAccessFamily[size];
        }
    };

    public RadioAccessFamily(int phoneId, int radioAccessFamily) {
        this.mPhoneId = phoneId;
        this.mRadioAccessFamily = radioAccessFamily;
    }

    public int getPhoneId() {
        return this.mPhoneId;
    }

    public int getRadioAccessFamily() {
        return this.mRadioAccessFamily;
    }

    public String toString() {
        String ret = "{ mPhoneId = " + this.mPhoneId + ", mRadioAccessFamily = " + this.mRadioAccessFamily + "}";
        return ret;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel outParcel, int flags) {
        outParcel.writeInt(this.mPhoneId);
        outParcel.writeInt(this.mRadioAccessFamily);
    }

    public static int getRafFromNetworkType(int type) {
        int raf;
        int GSM = 65542;
        int HS = 36352;
        int CDMA = 112;
        int EVDO = 4480;
        int WCDMA = 36360;
        switch (type) {
            case 0: {
                raf = 101902;
                break;
            }
            case 1: {
                raf = 65542;
                break;
            }
            case 2: {
                raf = 36360;
                break;
            }
            case 3: {
                raf = 101902;
                break;
            }
            case 4: {
                raf = 112;
                break;
            }
            case 8: {
                raf = 20976;
                break;
            }
            case 9: {
                raf = 118286;
                break;
            }
            case 10: {
                raf = 122878;
                break;
            }
            case 11: {
                raf = 16384;
                break;
            }
            case 12: {
                raf = 52744;
                break;
            }
            case 5: {
                raf = 112;
                break;
            }
            case 6: {
                raf = 4480;
                break;
            }
            case 7: {
                raf = 106494;
                break;
            }
            default: {
                raf = 1;
            }
        }
        return raf;
    }
}

