/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.SystemProperties;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.RSDriverException;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.Sampler;
import android.util.Log;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RenderScript {
    static final long TRACE_TAG = 32768L;
    static final String LOG_TAG = "RenderScript_jni";
    static final boolean DEBUG = false;
    static final boolean LOG_ENABLED = false;
    private Context mApplicationContext;
    static boolean sInitialized = false;
    static Object sRuntime;
    static Method registerNativeAllocation;
    static Method registerNativeFree;
    public static final int CREATE_FLAG_NONE = 0;
    public static final int CREATE_FLAG_LOW_LATENCY = 2;
    public static final int CREATE_FLAG_LOW_POWER = 4;
    static int sPointerSize;
    static File mCacheDir;
    static final long sMinorID = 1L;
    ContextType mContextType = ContextType.NORMAL;
    ReentrantReadWriteLock mRWLock;
    long mDev;
    long mContext;
    MessageThread mMessageThread;
    Element mElement_U8;
    Element mElement_I8;
    Element mElement_U16;
    Element mElement_I16;
    Element mElement_U32;
    Element mElement_I32;
    Element mElement_U64;
    Element mElement_I64;
    Element mElement_F32;
    Element mElement_F64;
    Element mElement_BOOLEAN;
    Element mElement_ELEMENT;
    Element mElement_TYPE;
    Element mElement_ALLOCATION;
    Element mElement_SAMPLER;
    Element mElement_SCRIPT;
    Element mElement_MESH;
    Element mElement_PROGRAM_FRAGMENT;
    Element mElement_PROGRAM_VERTEX;
    Element mElement_PROGRAM_RASTER;
    Element mElement_PROGRAM_STORE;
    Element mElement_FONT;
    Element mElement_A_8;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_8888;
    Element mElement_FLOAT_2;
    Element mElement_FLOAT_3;
    Element mElement_FLOAT_4;
    Element mElement_DOUBLE_2;
    Element mElement_DOUBLE_3;
    Element mElement_DOUBLE_4;
    Element mElement_UCHAR_2;
    Element mElement_UCHAR_3;
    Element mElement_UCHAR_4;
    Element mElement_CHAR_2;
    Element mElement_CHAR_3;
    Element mElement_CHAR_4;
    Element mElement_USHORT_2;
    Element mElement_USHORT_3;
    Element mElement_USHORT_4;
    Element mElement_SHORT_2;
    Element mElement_SHORT_3;
    Element mElement_SHORT_4;
    Element mElement_UINT_2;
    Element mElement_UINT_3;
    Element mElement_UINT_4;
    Element mElement_INT_2;
    Element mElement_INT_3;
    Element mElement_INT_4;
    Element mElement_ULONG_2;
    Element mElement_ULONG_3;
    Element mElement_ULONG_4;
    Element mElement_LONG_2;
    Element mElement_LONG_3;
    Element mElement_LONG_4;
    Element mElement_YUV;
    Element mElement_MATRIX_4X4;
    Element mElement_MATRIX_3X3;
    Element mElement_MATRIX_2X2;
    Sampler mSampler_CLAMP_NEAREST;
    Sampler mSampler_CLAMP_LINEAR;
    Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    Sampler mSampler_WRAP_NEAREST;
    Sampler mSampler_WRAP_LINEAR;
    Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_NEAREST;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR_MIP_LINEAR;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    ProgramRaster mProgramRaster_CULL_BACK;
    ProgramRaster mProgramRaster_CULL_FRONT;
    ProgramRaster mProgramRaster_CULL_NONE;
    RSMessageHandler mMessageCallback = null;
    RSErrorHandler mErrorCallback = null;

    static void _nInit() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#_nInit()V", true, null);
    }

    static int rsnSystemGetPointerSize() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnSystemGetPointerSize()I", true, null);
    }

    long nDeviceCreate() {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#nDeviceCreate()J", true, this);
    }

    void nDeviceDestroy(long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceDestroy(J)V", true, this);
    }

    void nDeviceSetConfig(long l, int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceSetConfig(JII)V", true, this);
    }

    int nContextGetUserMessage(long l, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextGetUserMessage(J[I)I", true, this);
    }

    String nContextGetErrorMessage(long l) {
        return (String)OverrideMethod.invokeA("android.renderscript.RenderScript#nContextGetErrorMessage(J)Ljava/lang/String;", true, this);
    }

    int nContextPeekMessage(long l, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextPeekMessage(J[I)I", true, this);
    }

    void nContextInitToClient(long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextInitToClient(J)V", true, this);
    }

    void nContextDeinitToClient(long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextDeinitToClient(J)V", true, this);
    }

    public static long getMinorID() {
        return 1L;
    }

    public static void setupDiskCache(File cacheDir) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.setupDiskCache() called when disabled");
            return;
        }
        mCacheDir = cacheDir;
    }

    long rsnContextCreateGL(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, float f, int n13) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnContextCreateGL(JIIIIIIIIIIIIFI)J", true, this);
    }

    synchronized long nContextCreateGL(long dev, int ver, int sdkVer, int colorMin, int colorPref, int alphaMin, int alphaPref, int depthMin, int depthPref, int stencilMin, int stencilPref, int samplesMin, int samplesPref, float samplesQ, int dpi) {
        return this.rsnContextCreateGL(dev, ver, sdkVer, colorMin, colorPref, alphaMin, alphaPref, depthMin, depthPref, stencilMin, stencilPref, samplesMin, samplesPref, samplesQ, dpi);
    }

    long rsnContextCreate(long l, int n, int n2, int n3) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnContextCreate(JIII)J", true, this);
    }

    synchronized long nContextCreate(long dev, int ver, int sdkVer, int contextType) {
        return this.rsnContextCreate(dev, ver, sdkVer, contextType);
    }

    void rsnContextDestroy(long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextDestroy(J)V", true, this);
    }

    synchronized void nContextDestroy() {
        this.validate();
        ReentrantReadWriteLock.WriteLock wlock = this.mRWLock.writeLock();
        wlock.lock();
        long curCon = this.mContext;
        this.mContext = 0L;
        wlock.unlock();
        this.rsnContextDestroy(curCon);
    }

    void rsnContextSetSurface(long l, int n, int n2, Surface surface) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetSurface(JIILandroid/view/Surface;)V", true, this);
    }

    synchronized void nContextSetSurface(int w, int h, Surface sur) {
        this.validate();
        this.rsnContextSetSurface(this.mContext, w, h, sur);
    }

    void rsnContextSetSurfaceTexture(long l, int n, int n2, SurfaceTexture surfaceTexture) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetSurfaceTexture(JIILandroid/graphics/SurfaceTexture;)V", true, this);
    }

    synchronized void nContextSetSurfaceTexture(int w, int h, SurfaceTexture sur) {
        this.validate();
        this.rsnContextSetSurfaceTexture(this.mContext, w, h, sur);
    }

    void rsnContextSetPriority(long l, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetPriority(JI)V", true, this);
    }

    synchronized void nContextSetPriority(int p) {
        this.validate();
        this.rsnContextSetPriority(this.mContext, p);
    }

    void rsnContextDump(long l, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextDump(JI)V", true, this);
    }

    synchronized void nContextDump(int bits) {
        this.validate();
        this.rsnContextDump(this.mContext, bits);
    }

    void rsnContextFinish(long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextFinish(J)V", true, this);
    }

    synchronized void nContextFinish() {
        this.validate();
        this.rsnContextFinish(this.mContext);
    }

    void rsnContextSendMessage(long l, int n, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSendMessage(JI[I)V", true, this);
    }

    synchronized void nContextSendMessage(int id2, int[] data) {
        this.validate();
        this.rsnContextSendMessage(this.mContext, id2, data);
    }

    void rsnContextBindRootScript(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindRootScript(JJ)V", true, this);
    }

    synchronized void nContextBindRootScript(long script) {
        this.validate();
        this.rsnContextBindRootScript(this.mContext, script);
    }

    void rsnContextBindSampler(long l, int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindSampler(JII)V", true, this);
    }

    synchronized void nContextBindSampler(int sampler, int slot) {
        this.validate();
        this.rsnContextBindSampler(this.mContext, sampler, slot);
    }

    void rsnContextBindProgramStore(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramStore(JJ)V", true, this);
    }

    synchronized void nContextBindProgramStore(long pfs) {
        this.validate();
        this.rsnContextBindProgramStore(this.mContext, pfs);
    }

    void rsnContextBindProgramFragment(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramFragment(JJ)V", true, this);
    }

    synchronized void nContextBindProgramFragment(long pf) {
        this.validate();
        this.rsnContextBindProgramFragment(this.mContext, pf);
    }

    void rsnContextBindProgramVertex(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramVertex(JJ)V", true, this);
    }

    synchronized void nContextBindProgramVertex(long pv) {
        this.validate();
        this.rsnContextBindProgramVertex(this.mContext, pv);
    }

    void rsnContextBindProgramRaster(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramRaster(JJ)V", true, this);
    }

    synchronized void nContextBindProgramRaster(long pr) {
        this.validate();
        this.rsnContextBindProgramRaster(this.mContext, pr);
    }

    void rsnContextPause(long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextPause(J)V", true, this);
    }

    synchronized void nContextPause() {
        this.validate();
        this.rsnContextPause(this.mContext);
    }

    void rsnContextResume(long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextResume(J)V", true, this);
    }

    synchronized void nContextResume() {
        this.validate();
        this.rsnContextResume(this.mContext);
    }

    void rsnAssignName(long l, long l2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAssignName(JJ[B)V", true, this);
    }

    synchronized void nAssignName(long obj, byte[] name) {
        this.validate();
        this.rsnAssignName(this.mContext, obj, name);
    }

    String rsnGetName(long l, long l2) {
        return (String)OverrideMethod.invokeA("android.renderscript.RenderScript#rsnGetName(JJ)Ljava/lang/String;", true, this);
    }

    synchronized String nGetName(long obj) {
        this.validate();
        return this.rsnGetName(this.mContext, obj);
    }

    void rsnObjDestroy(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnObjDestroy(JJ)V", true, this);
    }

    void nObjDestroy(long id2) {
        if (this.mContext != 0L) {
            this.rsnObjDestroy(this.mContext, id2);
        }
    }

    long rsnElementCreate(long l, long l2, int n, boolean bl, int n2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnElementCreate(JJIZI)J", true, this);
    }

    synchronized long nElementCreate(long type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnElementCreate(this.mContext, type, kind, norm, vecSize);
    }

    long rsnElementCreate2(long l, long[] lArray, String[] stringArray, int[] nArray) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnElementCreate2(J[J[Ljava/lang/String;[I)J", true, this);
    }

    synchronized long nElementCreate2(long[] elements, String[] names, int[] arraySizes) {
        this.validate();
        return this.rsnElementCreate2(this.mContext, elements, names, arraySizes);
    }

    void rsnElementGetNativeData(long l, long l2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnElementGetNativeData(JJ[I)V", true, this);
    }

    synchronized void nElementGetNativeData(long id2, int[] elementData) {
        this.validate();
        this.rsnElementGetNativeData(this.mContext, id2, elementData);
    }

    void rsnElementGetSubElements(long l, long l2, long[] lArray, String[] stringArray, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnElementGetSubElements(JJ[J[Ljava/lang/String;[I)V", true, this);
    }

    synchronized void nElementGetSubElements(long id2, long[] IDs, String[] names, int[] arraySizes) {
        this.validate();
        this.rsnElementGetSubElements(this.mContext, id2, IDs, names, arraySizes);
    }

    long rsnTypeCreate(long l, long l2, int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnTypeCreate(JJIIIZZI)J", true, this);
    }

    synchronized long nTypeCreate(long eid, int x, int y, int z, boolean mips, boolean faces, int yuv) {
        this.validate();
        return this.rsnTypeCreate(this.mContext, eid, x, y, z, mips, faces, yuv);
    }

    void rsnTypeGetNativeData(long l, long l2, long[] lArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnTypeGetNativeData(JJ[J)V", true, this);
    }

    synchronized void nTypeGetNativeData(long id2, long[] typeData) {
        this.validate();
        this.rsnTypeGetNativeData(this.mContext, id2, typeData);
    }

    long rsnAllocationCreateTyped(long l, long l2, int n, int n2, long l3) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnAllocationCreateTyped(JJIIJ)J", true, this);
    }

    synchronized long nAllocationCreateTyped(long type, int mip, int usage, long pointer) {
        this.validate();
        return this.rsnAllocationCreateTyped(this.mContext, type, mip, usage, pointer);
    }

    long rsnAllocationCreateFromBitmap(long l, long l2, int n, Bitmap bitmap, int n2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnAllocationCreateFromBitmap(JJILandroid/graphics/Bitmap;I)J", true, this);
    }

    synchronized long nAllocationCreateFromBitmap(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    long rsnAllocationCreateBitmapBackedAllocation(long l, long l2, int n, Bitmap bitmap, int n2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnAllocationCreateBitmapBackedAllocation(JJILandroid/graphics/Bitmap;I)J", true, this);
    }

    synchronized long nAllocationCreateBitmapBackedAllocation(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateBitmapBackedAllocation(this.mContext, type, mip, bmp, usage);
    }

    long rsnAllocationCubeCreateFromBitmap(long l, long l2, int n, Bitmap bitmap, int n2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnAllocationCubeCreateFromBitmap(JJILandroid/graphics/Bitmap;I)J", true, this);
    }

    synchronized long nAllocationCubeCreateFromBitmap(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCubeCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    long rsnAllocationCreateBitmapRef(long l, long l2, Bitmap bitmap) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnAllocationCreateBitmapRef(JJLandroid/graphics/Bitmap;)J", true, this);
    }

    synchronized long nAllocationCreateBitmapRef(long type, Bitmap bmp) {
        this.validate();
        return this.rsnAllocationCreateBitmapRef(this.mContext, type, bmp);
    }

    long rsnAllocationCreateFromAssetStream(long l, int n, int n2, int n3) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnAllocationCreateFromAssetStream(JIII)J", true, this);
    }

    synchronized long nAllocationCreateFromAssetStream(int mips, int assetStream, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromAssetStream(this.mContext, mips, assetStream, usage);
    }

    void rsnAllocationCopyToBitmap(long l, long l2, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationCopyToBitmap(JJLandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationCopyToBitmap(long alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyToBitmap(this.mContext, alloc, bmp);
    }

    void rsnAllocationSyncAll(long l, long l2, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationSyncAll(JJI)V", true, this);
    }

    synchronized void nAllocationSyncAll(long alloc, int src) {
        this.validate();
        this.rsnAllocationSyncAll(this.mContext, alloc, src);
    }

    Surface rsnAllocationGetSurface(long l, long l2) {
        return (Surface)OverrideMethod.invokeA("android.renderscript.RenderScript#rsnAllocationGetSurface(JJ)Landroid/view/Surface;", true, this);
    }

    synchronized Surface nAllocationGetSurface(long alloc) {
        this.validate();
        return this.rsnAllocationGetSurface(this.mContext, alloc);
    }

    void rsnAllocationSetSurface(long l, long l2, Surface surface) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationSetSurface(JJLandroid/view/Surface;)V", true, this);
    }

    synchronized void nAllocationSetSurface(long alloc, Surface sur) {
        this.validate();
        this.rsnAllocationSetSurface(this.mContext, alloc, sur);
    }

    void rsnAllocationIoSend(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationIoSend(JJ)V", true, this);
    }

    synchronized void nAllocationIoSend(long alloc) {
        this.validate();
        this.rsnAllocationIoSend(this.mContext, alloc);
    }

    void rsnAllocationIoReceive(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationIoReceive(JJ)V", true, this);
    }

    synchronized void nAllocationIoReceive(long alloc) {
        this.validate();
        this.rsnAllocationIoReceive(this.mContext, alloc);
    }

    void rsnAllocationGenerateMipmaps(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationGenerateMipmaps(JJ)V", true, this);
    }

    synchronized void nAllocationGenerateMipmaps(long alloc) {
        this.validate();
        this.rsnAllocationGenerateMipmaps(this.mContext, alloc);
    }

    void rsnAllocationCopyFromBitmap(long l, long l2, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationCopyFromBitmap(JJLandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationCopyFromBitmap(long alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyFromBitmap(this.mContext, alloc, bmp);
    }

    void rsnAllocationData1D(long l, long l2, int n, int n2, int n3, Object object, int n4, int n5) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(JJIIILjava/lang/Object;II)V", true, this);
    }

    synchronized void nAllocationData1D(long id2, int off, int mip, int count, Object d, int sizeBytes, Element.DataType dt) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes, dt.mID);
    }

    void rsnAllocationElementData1D(long l, long l2, int n, int n2, int n3, byte[] byArray, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationElementData1D(JJIII[BI)V", true, this);
    }

    synchronized void nAllocationElementData1D(long id2, int xoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementData1D(this.mContext, id2, xoff, mip, compIdx, d, sizeBytes);
    }

    void rsnAllocationData2D(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6, long l3, int n7, int n8, int n9, int n10) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(JJIIIIIIJIIII)V", true, this);
    }

    synchronized void nAllocationData2D(long dstAlloc, int dstXoff, int dstYoff, int dstMip, int dstFace, int width, int height, long srcAlloc, int srcXoff, int srcYoff, int srcMip, int srcFace) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, dstAlloc, dstXoff, dstYoff, dstMip, dstFace, width, height, srcAlloc, srcXoff, srcYoff, srcMip, srcFace);
    }

    void rsnAllocationData2D(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6, Object object, int n7, int n8) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(JJIIIIIILjava/lang/Object;II)V", true, this);
    }

    synchronized void nAllocationData2D(long id2, int xoff, int yoff, int mip, int face, int w, int h, Object d, int sizeBytes, Element.DataType dt) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes, dt.mID);
    }

    void rsnAllocationData2D(long l, long l2, int n, int n2, int n3, int n4, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(JJIIIILandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationData2D(long id2, int xoff, int yoff, int mip, int face, Bitmap b) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, b);
    }

    void rsnAllocationData3D(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6, int n7, long l3, int n8, int n9, int n10, int n11) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData3D(JJIIIIIIIJIIII)V", true, this);
    }

    synchronized void nAllocationData3D(long dstAlloc, int dstXoff, int dstYoff, int dstZoff, int dstMip, int width, int height, int depth, long srcAlloc, int srcXoff, int srcYoff, int srcZoff, int srcMip) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, dstAlloc, dstXoff, dstYoff, dstZoff, dstMip, width, height, depth, srcAlloc, srcXoff, srcYoff, srcZoff, srcMip);
    }

    void rsnAllocationData3D(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object, int n8, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData3D(JJIIIIIIILjava/lang/Object;II)V", true, this);
    }

    synchronized void nAllocationData3D(long id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, Object d, int sizeBytes, Element.DataType dt) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes, dt.mID);
    }

    void rsnAllocationRead(long l, long l2, Object object, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(JJLjava/lang/Object;I)V", true, this);
    }

    synchronized void nAllocationRead(long id2, Object d, Element.DataType dt) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d, dt.mID);
    }

    void rsnAllocationRead1D(long l, long l2, int n, int n2, int n3, Object object, int n4, int n5) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead1D(JJIIILjava/lang/Object;II)V", true, this);
    }

    synchronized void nAllocationRead1D(long id2, int off, int mip, int count, Object d, int sizeBytes, Element.DataType dt) {
        this.validate();
        this.rsnAllocationRead1D(this.mContext, id2, off, mip, count, d, sizeBytes, dt.mID);
    }

    void rsnAllocationRead2D(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6, Object object, int n7, int n8) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead2D(JJIIIIIILjava/lang/Object;II)V", true, this);
    }

    synchronized void nAllocationRead2D(long id2, int xoff, int yoff, int mip, int face, int w, int h, Object d, int sizeBytes, Element.DataType dt) {
        this.validate();
        this.rsnAllocationRead2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes, dt.mID);
    }

    long rsnAllocationGetType(long l, long l2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnAllocationGetType(JJ)J", true, this);
    }

    synchronized long nAllocationGetType(long id2) {
        this.validate();
        return this.rsnAllocationGetType(this.mContext, id2);
    }

    void rsnAllocationResize1D(long l, long l2, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationResize1D(JJI)V", true, this);
    }

    synchronized void nAllocationResize1D(long id2, int dimX) {
        this.validate();
        this.rsnAllocationResize1D(this.mContext, id2, dimX);
    }

    long rsnFileA3DCreateFromAssetStream(long l, long l2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnFileA3DCreateFromAssetStream(JJ)J", true, this);
    }

    synchronized long nFileA3DCreateFromAssetStream(long assetStream) {
        this.validate();
        return this.rsnFileA3DCreateFromAssetStream(this.mContext, assetStream);
    }

    long rsnFileA3DCreateFromFile(long l, String string2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnFileA3DCreateFromFile(JLjava/lang/String;)J", true, this);
    }

    synchronized long nFileA3DCreateFromFile(String path) {
        this.validate();
        return this.rsnFileA3DCreateFromFile(this.mContext, path);
    }

    long rsnFileA3DCreateFromAsset(long l, AssetManager assetManager, String string2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnFileA3DCreateFromAsset(JLandroid/content/res/AssetManager;Ljava/lang/String;)J", true, this);
    }

    synchronized long nFileA3DCreateFromAsset(AssetManager mgr, String path) {
        this.validate();
        return this.rsnFileA3DCreateFromAsset(this.mContext, mgr, path);
    }

    int rsnFileA3DGetNumIndexEntries(long l, long l2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DGetNumIndexEntries(JJ)I", true, this);
    }

    synchronized int nFileA3DGetNumIndexEntries(long fileA3D) {
        this.validate();
        return this.rsnFileA3DGetNumIndexEntries(this.mContext, fileA3D);
    }

    void rsnFileA3DGetIndexEntries(long l, long l2, int n, int[] nArray, String[] stringArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnFileA3DGetIndexEntries(JJI[I[Ljava/lang/String;)V", true, this);
    }

    synchronized void nFileA3DGetIndexEntries(long fileA3D, int numEntries, int[] IDs, String[] names) {
        this.validate();
        this.rsnFileA3DGetIndexEntries(this.mContext, fileA3D, numEntries, IDs, names);
    }

    long rsnFileA3DGetEntryByIndex(long l, long l2, int n) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnFileA3DGetEntryByIndex(JJI)J", true, this);
    }

    synchronized long nFileA3DGetEntryByIndex(long fileA3D, int index) {
        this.validate();
        return this.rsnFileA3DGetEntryByIndex(this.mContext, fileA3D, index);
    }

    long rsnFontCreateFromFile(long l, String string2, float f, int n) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnFontCreateFromFile(JLjava/lang/String;FI)J", true, this);
    }

    synchronized long nFontCreateFromFile(String fileName, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromFile(this.mContext, fileName, size, dpi);
    }

    long rsnFontCreateFromAssetStream(long l, String string2, float f, int n, long l2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnFontCreateFromAssetStream(JLjava/lang/String;FIJ)J", true, this);
    }

    synchronized long nFontCreateFromAssetStream(String name, float size, int dpi, long assetStream) {
        this.validate();
        return this.rsnFontCreateFromAssetStream(this.mContext, name, size, dpi, assetStream);
    }

    long rsnFontCreateFromAsset(long l, AssetManager assetManager, String string2, float f, int n) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnFontCreateFromAsset(JLandroid/content/res/AssetManager;Ljava/lang/String;FI)J", true, this);
    }

    synchronized long nFontCreateFromAsset(AssetManager mgr, String path, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromAsset(this.mContext, mgr, path, size, dpi);
    }

    void rsnScriptBindAllocation(long l, long l2, long l3, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptBindAllocation(JJJI)V", true, this);
    }

    synchronized void nScriptBindAllocation(long script, long alloc, int slot) {
        this.validate();
        this.rsnScriptBindAllocation(this.mContext, script, alloc, slot);
    }

    void rsnScriptSetTimeZone(long l, long l2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetTimeZone(JJ[B)V", true, this);
    }

    synchronized void nScriptSetTimeZone(long script, byte[] timeZone) {
        this.validate();
        this.rsnScriptSetTimeZone(this.mContext, script, timeZone);
    }

    void rsnScriptInvoke(long l, long l2, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptInvoke(JJI)V", true, this);
    }

    synchronized void nScriptInvoke(long id2, int slot) {
        this.validate();
        this.rsnScriptInvoke(this.mContext, id2, slot);
    }

    void rsnScriptForEach(long l, long l2, int n, long l3, long l4, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEach(JJIJJ[B)V", true, this);
    }

    void rsnScriptForEach(long l, long l2, int n, long l3, long l4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEach(JJIJJ)V", true, this);
    }

    void rsnScriptForEachClipped(long l, long l2, int n, long l3, long l4, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEachClipped(JJIJJ[BIIIIII)V", true, this);
    }

    void rsnScriptForEachClipped(long l, long l2, int n, long l3, long l4, int n2, int n3, int n4, int n5, int n6, int n7) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEachClipped(JJIJJIIIIII)V", true, this);
    }

    synchronized void nScriptForEach(long id2, int slot, long ain, long aout, byte[] params) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEach(this.mContext, id2, slot, ain, aout);
        } else {
            this.rsnScriptForEach(this.mContext, id2, slot, ain, aout, params);
        }
    }

    synchronized void nScriptForEachClipped(long id2, int slot, long ain, long aout, byte[] params, int xstart, int xend, int ystart, int yend, int zstart, int zend) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEachClipped(this.mContext, id2, slot, ain, aout, xstart, xend, ystart, yend, zstart, zend);
        } else {
            this.rsnScriptForEachClipped(this.mContext, id2, slot, ain, aout, params, xstart, xend, ystart, yend, zstart, zend);
        }
    }

    void rsnScriptForEachMultiClipped(long l, long l2, int n, long[] lArray, long l3, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEachMultiClipped(JJI[JJ[BIIIIII)V", true, this);
    }

    void rsnScriptForEachMultiClipped(long l, long l2, int n, long[] lArray, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEachMultiClipped(JJI[JJIIIIII)V", true, this);
    }

    synchronized void nScriptForEachMultiClipped(long id2, int slot, long[] ains, long aout, byte[] params, int xstart, int xend, int ystart, int yend, int zstart, int zend) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEachMultiClipped(this.mContext, id2, slot, ains, aout, xstart, xend, ystart, yend, zstart, zend);
        } else {
            this.rsnScriptForEachMultiClipped(this.mContext, id2, slot, ains, aout, params, xstart, xend, ystart, yend, zstart, zend);
        }
    }

    void rsnScriptInvokeV(long l, long l2, int n, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptInvokeV(JJI[B)V", true, this);
    }

    synchronized void nScriptInvokeV(long id2, int slot, byte[] params) {
        this.validate();
        this.rsnScriptInvokeV(this.mContext, id2, slot, params);
    }

    void rsnScriptSetVarI(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarI(JJII)V", true, this);
    }

    synchronized void nScriptSetVarI(long id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarI(this.mContext, id2, slot, val);
    }

    int rsnScriptGetVarI(long l, long l2, int n) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptGetVarI(JJI)I", true, this);
    }

    synchronized int nScriptGetVarI(long id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarI(this.mContext, id2, slot);
    }

    void rsnScriptSetVarJ(long l, long l2, int n, long l3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarJ(JJIJ)V", true, this);
    }

    synchronized void nScriptSetVarJ(long id2, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarJ(this.mContext, id2, slot, val);
    }

    long rsnScriptGetVarJ(long l, long l2, int n) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnScriptGetVarJ(JJI)J", true, this);
    }

    synchronized long nScriptGetVarJ(long id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarJ(this.mContext, id2, slot);
    }

    void rsnScriptSetVarF(long l, long l2, int n, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarF(JJIF)V", true, this);
    }

    synchronized void nScriptSetVarF(long id2, int slot, float val) {
        this.validate();
        this.rsnScriptSetVarF(this.mContext, id2, slot, val);
    }

    float rsnScriptGetVarF(long l, long l2, int n) {
        return OverrideMethod.invokeF("android.renderscript.RenderScript#rsnScriptGetVarF(JJI)F", true, this);
    }

    synchronized float nScriptGetVarF(long id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarF(this.mContext, id2, slot);
    }

    void rsnScriptSetVarD(long l, long l2, int n, double d) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarD(JJID)V", true, this);
    }

    synchronized void nScriptSetVarD(long id2, int slot, double val) {
        this.validate();
        this.rsnScriptSetVarD(this.mContext, id2, slot, val);
    }

    double rsnScriptGetVarD(long l, long l2, int n) {
        return OverrideMethod.invokeD("android.renderscript.RenderScript#rsnScriptGetVarD(JJI)D", true, this);
    }

    synchronized double nScriptGetVarD(long id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarD(this.mContext, id2, slot);
    }

    void rsnScriptSetVarV(long l, long l2, int n, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarV(JJI[B)V", true, this);
    }

    synchronized void nScriptSetVarV(long id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptSetVarV(this.mContext, id2, slot, val);
    }

    void rsnScriptGetVarV(long l, long l2, int n, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptGetVarV(JJI[B)V", true, this);
    }

    synchronized void nScriptGetVarV(long id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptGetVarV(this.mContext, id2, slot, val);
    }

    void rsnScriptSetVarVE(long l, long l2, int n, byte[] byArray, long l3, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarVE(JJI[BJ[I)V", true, this);
    }

    synchronized void nScriptSetVarVE(long id2, int slot, byte[] val, long e, int[] dims) {
        this.validate();
        this.rsnScriptSetVarVE(this.mContext, id2, slot, val, e, dims);
    }

    void rsnScriptSetVarObj(long l, long l2, int n, long l3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarObj(JJIJ)V", true, this);
    }

    synchronized void nScriptSetVarObj(long id2, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarObj(this.mContext, id2, slot, val);
    }

    long rsnScriptCCreate(long l, String string2, String string3, byte[] byArray, int n) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnScriptCCreate(JLjava/lang/String;Ljava/lang/String;[BI)J", true, this);
    }

    synchronized long nScriptCCreate(String resName, String cacheDir, byte[] script, int length) {
        this.validate();
        return this.rsnScriptCCreate(this.mContext, resName, cacheDir, script, length);
    }

    long rsnScriptIntrinsicCreate(long l, int n, long l2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnScriptIntrinsicCreate(JIJ)J", true, this);
    }

    synchronized long nScriptIntrinsicCreate(int id2, long eid) {
        this.validate();
        return this.rsnScriptIntrinsicCreate(this.mContext, id2, eid);
    }

    long rsnScriptKernelIDCreate(long l, long l2, int n, int n2) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnScriptKernelIDCreate(JJII)J", true, this);
    }

    synchronized long nScriptKernelIDCreate(long sid, int slot, int sig) {
        this.validate();
        return this.rsnScriptKernelIDCreate(this.mContext, sid, slot, sig);
    }

    long rsnScriptFieldIDCreate(long l, long l2, int n) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnScriptFieldIDCreate(JJI)J", true, this);
    }

    synchronized long nScriptFieldIDCreate(long sid, int slot) {
        this.validate();
        return this.rsnScriptFieldIDCreate(this.mContext, sid, slot);
    }

    long rsnScriptGroupCreate(long l, long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnScriptGroupCreate(J[J[J[J[J[J)J", true, this);
    }

    synchronized long nScriptGroupCreate(long[] kernels, long[] src, long[] dstk, long[] dstf, long[] types) {
        this.validate();
        return this.rsnScriptGroupCreate(this.mContext, kernels, src, dstk, dstf, types);
    }

    void rsnScriptGroupSetInput(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptGroupSetInput(JJJJ)V", true, this);
    }

    synchronized void nScriptGroupSetInput(long group, long kernel, long alloc) {
        this.validate();
        this.rsnScriptGroupSetInput(this.mContext, group, kernel, alloc);
    }

    void rsnScriptGroupSetOutput(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptGroupSetOutput(JJJJ)V", true, this);
    }

    synchronized void nScriptGroupSetOutput(long group, long kernel, long alloc) {
        this.validate();
        this.rsnScriptGroupSetOutput(this.mContext, group, kernel, alloc);
    }

    void rsnScriptGroupExecute(long l, long l2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptGroupExecute(JJ)V", true, this);
    }

    synchronized void nScriptGroupExecute(long group) {
        this.validate();
        this.rsnScriptGroupExecute(this.mContext, group);
    }

    long rsnSamplerCreate(long l, int n, int n2, int n3, int n4, int n5, float f) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnSamplerCreate(JIIIIIF)J", true, this);
    }

    synchronized long nSamplerCreate(int magFilter, int minFilter, int wrapS, int wrapT, int wrapR, float aniso) {
        this.validate();
        return this.rsnSamplerCreate(this.mContext, magFilter, minFilter, wrapS, wrapT, wrapR, aniso);
    }

    long rsnProgramStoreCreate(long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2, int n3) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnProgramStoreCreate(JZZZZZZIII)J", true, this);
    }

    synchronized long nProgramStoreCreate(boolean r, boolean g, boolean b, boolean a, boolean depthMask, boolean dither, int srcMode, int dstMode, int depthFunc) {
        this.validate();
        return this.rsnProgramStoreCreate(this.mContext, r, g, b, a, depthMask, dither, srcMode, dstMode, depthFunc);
    }

    long rsnProgramRasterCreate(long l, boolean bl, int n) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnProgramRasterCreate(JZI)J", true, this);
    }

    synchronized long nProgramRasterCreate(boolean pointSprite, int cullMode) {
        this.validate();
        return this.rsnProgramRasterCreate(this.mContext, pointSprite, cullMode);
    }

    void rsnProgramBindConstants(long l, long l2, int n, long l3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindConstants(JJIJ)V", true, this);
    }

    synchronized void nProgramBindConstants(long pv, int slot, long mID) {
        this.validate();
        this.rsnProgramBindConstants(this.mContext, pv, slot, mID);
    }

    void rsnProgramBindTexture(long l, long l2, int n, long l3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindTexture(JJIJ)V", true, this);
    }

    synchronized void nProgramBindTexture(long vpf, int slot, long a) {
        this.validate();
        this.rsnProgramBindTexture(this.mContext, vpf, slot, a);
    }

    void rsnProgramBindSampler(long l, long l2, int n, long l3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindSampler(JJIJ)V", true, this);
    }

    synchronized void nProgramBindSampler(long vpf, int slot, long s) {
        this.validate();
        this.rsnProgramBindSampler(this.mContext, vpf, slot, s);
    }

    long rsnProgramFragmentCreate(long l, String string2, String[] stringArray, long[] lArray) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnProgramFragmentCreate(JLjava/lang/String;[Ljava/lang/String;[J)J", true, this);
    }

    synchronized long nProgramFragmentCreate(String shader, String[] texNames, long[] params) {
        this.validate();
        return this.rsnProgramFragmentCreate(this.mContext, shader, texNames, params);
    }

    long rsnProgramVertexCreate(long l, String string2, String[] stringArray, long[] lArray) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnProgramVertexCreate(JLjava/lang/String;[Ljava/lang/String;[J)J", true, this);
    }

    synchronized long nProgramVertexCreate(String shader, String[] texNames, long[] params) {
        this.validate();
        return this.rsnProgramVertexCreate(this.mContext, shader, texNames, params);
    }

    long rsnMeshCreate(long l, long[] lArray, long[] lArray2, int[] nArray) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnMeshCreate(J[J[J[I)J", true, this);
    }

    synchronized long nMeshCreate(long[] vtx, long[] idx, int[] prim) {
        this.validate();
        return this.rsnMeshCreate(this.mContext, vtx, idx, prim);
    }

    int rsnMeshGetVertexBufferCount(long l, long l2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshGetVertexBufferCount(JJ)I", true, this);
    }

    synchronized int nMeshGetVertexBufferCount(long id2) {
        this.validate();
        return this.rsnMeshGetVertexBufferCount(this.mContext, id2);
    }

    int rsnMeshGetIndexCount(long l, long l2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshGetIndexCount(JJ)I", true, this);
    }

    synchronized int nMeshGetIndexCount(long id2) {
        this.validate();
        return this.rsnMeshGetIndexCount(this.mContext, id2);
    }

    void rsnMeshGetVertices(long l, long l2, long[] lArray, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshGetVertices(JJ[JI)V", true, this);
    }

    synchronized void nMeshGetVertices(long id2, long[] vtxIds, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetVertices(this.mContext, id2, vtxIds, vtxIdCount);
    }

    void rsnMeshGetIndices(long l, long l2, long[] lArray, int[] nArray, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshGetIndices(JJ[J[II)V", true, this);
    }

    synchronized void nMeshGetIndices(long id2, long[] idxIds, int[] primitives, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetIndices(this.mContext, id2, idxIds, primitives, vtxIdCount);
    }

    long rsnPathCreate(long l, int n, boolean bl, long l2, long l3, float f) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnPathCreate(JIZJJF)J", true, this);
    }

    synchronized long nPathCreate(int prim, boolean isStatic, long vtx, long loop, float q) {
        this.validate();
        return this.rsnPathCreate(this.mContext, prim, isStatic, vtx, loop, q);
    }

    public void setMessageHandler(RSMessageHandler msg) {
        this.mMessageCallback = msg;
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    public void sendMessage(int id2, int[] data) {
        this.nContextSendMessage(id2, data);
    }

    public void setErrorHandler(RSErrorHandler msg) {
        this.mErrorCallback = msg;
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    void validateObject(BaseObj o) {
        if (o != null && o.mRS != this) {
            throw new RSIllegalArgumentException("Attempting to use an object across contexts.");
        }
    }

    void validate() {
        if (this.mContext == 0L) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    public void setPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    RenderScript(Context ctx) {
        if (ctx != null) {
            this.mApplicationContext = ctx.getApplicationContext();
        }
        this.mRWLock = new ReentrantReadWriteLock();
        try {
            registerNativeAllocation.invoke(sRuntime, 0x400000);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Couldn't invoke registerNativeAllocation:" + e);
            throw new RSRuntimeException("Couldn't invoke registerNativeAllocation:" + e);
        }
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public static RenderScript create(Context ctx, int sdkVersion) {
        return RenderScript.create(ctx, sdkVersion, ContextType.NORMAL, 0);
    }

    public static RenderScript create(Context ctx, int sdkVersion, ContextType ct, int flags) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.create() called when disabled; someone is likely to crash");
            return null;
        }
        if ((flags & 0xFFFFFFF9) != 0) {
            throw new RSIllegalArgumentException("Invalid flags passed.");
        }
        RenderScript rs = new RenderScript(ctx);
        rs.mDev = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(rs.mDev, flags, sdkVersion, ct.mID);
        rs.mContextType = ct;
        if (rs.mContext == 0L) {
            throw new RSDriverException("Failed to create RS context.");
        }
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        return rs;
    }

    public static RenderScript create(Context ctx) {
        return RenderScript.create(ctx, ContextType.NORMAL);
    }

    public static RenderScript create(Context ctx, ContextType ct) {
        int v = ctx.getApplicationInfo().targetSdkVersion;
        return RenderScript.create(ctx, v, ct, 0);
    }

    public static RenderScript create(Context ctx, ContextType ct, int flags) {
        int v = ctx.getApplicationInfo().targetSdkVersion;
        return RenderScript.create(ctx, v, ct, flags);
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    public void finish() {
        this.nContextFinish();
    }

    public void destroy() {
        this.validate();
        this.nContextFinish();
        this.nContextDeinitToClient(this.mContext);
        this.mMessageThread.mRun = false;
        try {
            this.mMessageThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nContextDestroy();
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0L;
    }

    boolean isAlive() {
        return this.mContext != 0L;
    }

    long safeID(BaseObj o) {
        if (o != null) {
            return o.getID(this);
        }
        return 0L;
    }

    static {
        if (!SystemProperties.getBoolean("config.disable_renderscript", false)) {
            try {
                Class<?> vm_runtime = Class.forName("dalvik.system.VMRuntime");
                Method get_runtime = vm_runtime.getDeclaredMethod("getRuntime", new Class[0]);
                sRuntime = get_runtime.invoke(null, new Object[0]);
                registerNativeAllocation = vm_runtime.getDeclaredMethod("registerNativeAllocation", Integer.TYPE);
                registerNativeFree = vm_runtime.getDeclaredMethod("registerNativeFree", Integer.TYPE);
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Error loading GC methods: " + e);
                throw new RSRuntimeException("Error loading GC methods: " + e);
            }
            try {
                System.loadLibrary("rs_jni");
                RenderScript._nInit();
                sInitialized = true;
                sPointerSize = RenderScript.rsnSystemGetPointerSize();
            }
            catch (UnsatisfiedLinkError e) {
                Log.e(LOG_TAG, "Error loading RS jni library: " + e);
                throw new RSRuntimeException("Error loading RS jni library: " + e);
            }
        }
    }

    static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;
        int[] mAuxData = new int[2];
        static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        static final int RS_MESSAGE_TO_CLIENT_NEW_BUFFER = 5;
        static final int RS_ERROR_FATAL_DEBUG = 2048;
        static final int RS_ERROR_FATAL_UNKNOWN = 4096;

        MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        @Override
        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                rbuf[0] = 0;
                int msg = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData);
                int size = this.mAuxData[1];
                int subID = this.mAuxData[0];
                if (msg == 4) {
                    if (size >> 2 >= rbuf.length) {
                        rbuf = new int[size + 3 >> 2];
                    }
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 4) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = rbuf;
                        this.mRS.mMessageCallback.mID = subID;
                        this.mRS.mMessageCallback.mLength = size;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (msg == 3) {
                    String e = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (subID >= 4096 || subID >= 2048 && (this.mRS.mContextType != ContextType.DEBUG || this.mRS.mErrorCallback == null)) {
                        throw new RSRuntimeException("Fatal error " + subID + ", details: " + e);
                    }
                    if (this.mRS.mErrorCallback != null) {
                        this.mRS.mErrorCallback.mErrorMessage = e;
                        this.mRS.mErrorCallback.mErrorNum = subID;
                        this.mRS.mErrorCallback.run();
                        continue;
                    }
                    Log.e(RenderScript.LOG_TAG, "non fatal RS error, " + e);
                    continue;
                }
                if (msg == 5) {
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 5) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    long bufferID = ((long)rbuf[1] << 32) + ((long)rbuf[0] & 0xFFFFFFFFL);
                    Allocation.sendBufferNotification(bufferID);
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    public static enum Priority {
        LOW(15),
        NORMAL(-4);

        int mID;

        private Priority(int id2) {
            this.mID = id2;
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        protected String mErrorMessage;
        protected int mErrorNum;

        @Override
        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        protected int[] mData;
        protected int mID;
        protected int mLength;

        @Override
        public void run() {
        }
    }

    public static enum ContextType {
        NORMAL(0),
        DEBUG(1),
        PROFILE(2);

        int mID;

        private ContextType(int id2) {
            this.mID = id2;
        }
    }
}

