/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.telephony.SignalStrength;
import android.text.format.DateFormat;
import android.util.Printer;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BatteryStats
implements Parcelable {
    private static final boolean LOCAL_LOGV = false;
    public static final String SERVICE_NAME = "batterystats";
    public static final int WAKE_TYPE_PARTIAL = 0;
    public static final int WAKE_TYPE_FULL = 1;
    public static final int WAKE_TYPE_WINDOW = 2;
    public static final int SENSOR = 3;
    public static final int WIFI_RUNNING = 4;
    public static final int FULL_WIFI_LOCK = 5;
    public static final int WIFI_SCAN = 6;
    public static final int WIFI_MULTICAST_ENABLED = 7;
    public static final int VIDEO_TURNED_ON = 8;
    public static final int VIBRATOR_ON = 9;
    public static final int FOREGROUND_ACTIVITY = 10;
    public static final int WIFI_BATCHED_SCAN = 11;
    public static final int PROCESS_STATE = 12;
    public static final int SYNC = 13;
    public static final int JOB = 14;
    public static final int AUDIO_TURNED_ON = 15;
    public static final int STATS_SINCE_CHARGED = 0;
    public static final int STATS_CURRENT = 1;
    public static final int STATS_SINCE_UNPLUGGED = 2;
    private static final String[] STAT_NAMES = new String[]{"l", "c", "u"};
    private static final int BATTERY_STATS_CHECKIN_VERSION = 9;
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final String VERSION_DATA = "vers";
    private static final String UID_DATA = "uid";
    private static final String APK_DATA = "apk";
    private static final String PROCESS_DATA = "pr";
    private static final String SENSOR_DATA = "sr";
    private static final String VIBRATOR_DATA = "vib";
    private static final String FOREGROUND_DATA = "fg";
    private static final String STATE_TIME_DATA = "st";
    private static final String WAKELOCK_DATA = "wl";
    private static final String SYNC_DATA = "sy";
    private static final String JOB_DATA = "jb";
    private static final String KERNEL_WAKELOCK_DATA = "kwl";
    private static final String WAKEUP_REASON_DATA = "wr";
    private static final String NETWORK_DATA = "nt";
    private static final String USER_ACTIVITY_DATA = "ua";
    private static final String BATTERY_DATA = "bt";
    private static final String BATTERY_DISCHARGE_DATA = "dc";
    private static final String BATTERY_LEVEL_DATA = "lv";
    private static final String WIFI_DATA = "wfl";
    private static final String MISC_DATA = "m";
    private static final String GLOBAL_NETWORK_DATA = "gn";
    private static final String HISTORY_STRING_POOL = "hsp";
    private static final String HISTORY_DATA = "h";
    private static final String SCREEN_BRIGHTNESS_DATA = "br";
    private static final String SIGNAL_STRENGTH_TIME_DATA = "sgt";
    private static final String SIGNAL_SCANNING_TIME_DATA = "sst";
    private static final String SIGNAL_STRENGTH_COUNT_DATA = "sgc";
    private static final String DATA_CONNECTION_TIME_DATA = "dct";
    private static final String DATA_CONNECTION_COUNT_DATA = "dcc";
    private static final String WIFI_STATE_TIME_DATA = "wst";
    private static final String WIFI_STATE_COUNT_DATA = "wsc";
    private static final String WIFI_SUPPL_STATE_TIME_DATA = "wsst";
    private static final String WIFI_SUPPL_STATE_COUNT_DATA = "wssc";
    private static final String WIFI_SIGNAL_STRENGTH_TIME_DATA = "wsgt";
    private static final String WIFI_SIGNAL_STRENGTH_COUNT_DATA = "wsgc";
    private static final String BLUETOOTH_STATE_TIME_DATA = "bst";
    private static final String BLUETOOTH_STATE_COUNT_DATA = "bsc";
    private static final String POWER_USE_SUMMARY_DATA = "pws";
    private static final String POWER_USE_ITEM_DATA = "pwi";
    private static final String DISCHARGE_STEP_DATA = "dsd";
    private static final String CHARGE_STEP_DATA = "csd";
    private static final String DISCHARGE_TIME_REMAIN_DATA = "dtr";
    private static final String CHARGE_TIME_REMAIN_DATA = "ctr";
    private final StringBuilder mFormatBuilder = new StringBuilder(32);
    private final Formatter mFormatter = new Formatter(this.mFormatBuilder);
    public static final int SCREEN_BRIGHTNESS_DARK = 0;
    public static final int SCREEN_BRIGHTNESS_DIM = 1;
    public static final int SCREEN_BRIGHTNESS_MEDIUM = 2;
    public static final int SCREEN_BRIGHTNESS_LIGHT = 3;
    public static final int SCREEN_BRIGHTNESS_BRIGHT = 4;
    static final String[] SCREEN_BRIGHTNESS_NAMES = new String[]{"dark", "dim", "medium", "light", "bright"};
    static final String[] SCREEN_BRIGHTNESS_SHORT_NAMES = new String[]{"0", "1", "2", "3", "4"};
    public static final int NUM_SCREEN_BRIGHTNESS_BINS = 5;
    public static final int DATA_CONNECTION_NONE = 0;
    public static final int DATA_CONNECTION_GPRS = 1;
    public static final int DATA_CONNECTION_EDGE = 2;
    public static final int DATA_CONNECTION_UMTS = 3;
    public static final int DATA_CONNECTION_CDMA = 4;
    public static final int DATA_CONNECTION_EVDO_0 = 5;
    public static final int DATA_CONNECTION_EVDO_A = 6;
    public static final int DATA_CONNECTION_1xRTT = 7;
    public static final int DATA_CONNECTION_HSDPA = 8;
    public static final int DATA_CONNECTION_HSUPA = 9;
    public static final int DATA_CONNECTION_HSPA = 10;
    public static final int DATA_CONNECTION_IDEN = 11;
    public static final int DATA_CONNECTION_EVDO_B = 12;
    public static final int DATA_CONNECTION_LTE = 13;
    public static final int DATA_CONNECTION_EHRPD = 14;
    public static final int DATA_CONNECTION_HSPAP = 15;
    public static final int DATA_CONNECTION_OTHER = 16;
    static final String[] DATA_CONNECTION_NAMES = new String[]{"none", "gprs", "edge", "umts", "cdma", "evdo_0", "evdo_A", "1xrtt", "hsdpa", "hsupa", "hspa", "iden", "evdo_b", "lte", "ehrpd", "hspap", "other"};
    public static final int NUM_DATA_CONNECTION_TYPES = 17;
    public static final int WIFI_SUPPL_STATE_INVALID = 0;
    public static final int WIFI_SUPPL_STATE_DISCONNECTED = 1;
    public static final int WIFI_SUPPL_STATE_INTERFACE_DISABLED = 2;
    public static final int WIFI_SUPPL_STATE_INACTIVE = 3;
    public static final int WIFI_SUPPL_STATE_SCANNING = 4;
    public static final int WIFI_SUPPL_STATE_AUTHENTICATING = 5;
    public static final int WIFI_SUPPL_STATE_ASSOCIATING = 6;
    public static final int WIFI_SUPPL_STATE_ASSOCIATED = 7;
    public static final int WIFI_SUPPL_STATE_FOUR_WAY_HANDSHAKE = 8;
    public static final int WIFI_SUPPL_STATE_GROUP_HANDSHAKE = 9;
    public static final int WIFI_SUPPL_STATE_COMPLETED = 10;
    public static final int WIFI_SUPPL_STATE_DORMANT = 11;
    public static final int WIFI_SUPPL_STATE_UNINITIALIZED = 12;
    public static final int NUM_WIFI_SUPPL_STATES = 13;
    static final String[] WIFI_SUPPL_STATE_NAMES = new String[]{"invalid", "disconn", "disabled", "inactive", "scanning", "authenticating", "associating", "associated", "4-way-handshake", "group-handshake", "completed", "dormant", "uninit"};
    static final String[] WIFI_SUPPL_STATE_SHORT_NAMES = new String[]{"inv", "dsc", "dis", "inact", "scan", "auth", "ascing", "asced", "4-way", "group", "compl", "dorm", "uninit"};
    public static final BitDescription[] HISTORY_STATE_DESCRIPTIONS = new BitDescription[]{new BitDescription(Integer.MIN_VALUE, "running", "r"), new BitDescription(0x40000000, "wake_lock", "w"), new BitDescription(0x800000, "sensor", "s"), new BitDescription(0x20000000, "gps", "g"), new BitDescription(0x10000000, "wifi_full_lock", "Wl"), new BitDescription(0x8000000, "wifi_scan", "Ws"), new BitDescription(0x4000000, "wifi_multicast", "Wm"), new BitDescription(0x2000000, "mobile_radio", "Pr"), new BitDescription(0x200000, "phone_scanning", "Psc"), new BitDescription(0x400000, "audio", "a"), new BitDescription(0x100000, "screen", "S"), new BitDescription(524288, "plugged", "BP"), new BitDescription(262144, "phone_in_call", "Pcl"), new BitDescription(65536, "bluetooth", "b"), new BitDescription(15872, 9, "data_conn", "Pcn", DATA_CONNECTION_NAMES, DATA_CONNECTION_NAMES), new BitDescription(448, 6, "phone_state", "Pst", new String[]{"in", "out", "emergency", "off"}, new String[]{"in", "out", "em", "off"}), new BitDescription(56, 3, "phone_signal_strength", "Pss", SignalStrength.SIGNAL_STRENGTH_NAMES, new String[]{"0", "1", "2", "3", "4"}), new BitDescription(7, 0, "brightness", "Sb", SCREEN_BRIGHTNESS_NAMES, SCREEN_BRIGHTNESS_SHORT_NAMES)};
    public static final BitDescription[] HISTORY_STATE2_DESCRIPTIONS = new BitDescription[]{new BitDescription(Integer.MIN_VALUE, "low_power", "lp"), new BitDescription(0x40000000, "video", "v"), new BitDescription(0x20000000, "wifi_running", "Wr"), new BitDescription(0x10000000, "wifi", "W"), new BitDescription(0x8000000, "flashlight", "fl"), new BitDescription(112, 4, "wifi_signal_strength", "Wss", new String[]{"0", "1", "2", "3", "4"}, new String[]{"0", "1", "2", "3", "4"}), new BitDescription(15, 0, "wifi_suppl", "Wsp", WIFI_SUPPL_STATE_NAMES, WIFI_SUPPL_STATE_SHORT_NAMES)};
    public static final String[] HISTORY_EVENT_NAMES = new String[]{"null", "proc", "fg", "top", "sync", "wake_lock_in", "job", "user", "userfg", "conn"};
    public static final String[] HISTORY_EVENT_CHECKIN_NAMES = new String[]{"Enl", "Epr", "Efg", "Etp", "Esy", "Ewl", "Ejb", "Eur", "Euf", "Ecn"};
    public static final int WIFI_STATE_OFF = 0;
    public static final int WIFI_STATE_OFF_SCANNING = 1;
    public static final int WIFI_STATE_ON_NO_NETWORKS = 2;
    public static final int WIFI_STATE_ON_DISCONNECTED = 3;
    public static final int WIFI_STATE_ON_CONNECTED_STA = 4;
    public static final int WIFI_STATE_ON_CONNECTED_P2P = 5;
    public static final int WIFI_STATE_ON_CONNECTED_STA_P2P = 6;
    public static final int WIFI_STATE_SOFT_AP = 7;
    static final String[] WIFI_STATE_NAMES = new String[]{"off", "scanning", "no_net", "disconn", "sta", "p2p", "sta_p2p", "soft_ap"};
    public static final int NUM_WIFI_STATES = 8;
    public static final int NUM_WIFI_SIGNAL_STRENGTH_BINS = 5;
    public static final int BLUETOOTH_STATE_INACTIVE = 0;
    public static final int BLUETOOTH_STATE_LOW = 1;
    public static final int BLUETOOTH_STATE_MEDIUM = 2;
    public static final int BLUETOOTH_STATE_HIGH = 3;
    static final String[] BLUETOOTH_STATE_NAMES = new String[]{"inactive", "low", "med", "high"};
    public static final int NUM_BLUETOOTH_STATES = 4;
    public static final int NETWORK_MOBILE_RX_DATA = 0;
    public static final int NETWORK_MOBILE_TX_DATA = 1;
    public static final int NETWORK_WIFI_RX_DATA = 2;
    public static final int NETWORK_WIFI_TX_DATA = 3;
    public static final int NUM_NETWORK_ACTIVITY_TYPES = 4;
    public static final long STEP_LEVEL_TIME_MASK = 0xFFFFFFFFFFL;
    public static final long STEP_LEVEL_LEVEL_MASK = 0xFF0000000000L;
    public static final long STEP_LEVEL_LEVEL_SHIFT = 40L;
    public static final long STEP_LEVEL_INITIAL_MODE_MASK = 0xFF000000000000L;
    public static final long STEP_LEVEL_INITIAL_MODE_SHIFT = 48L;
    public static final long STEP_LEVEL_MODIFIED_MODE_MASK = -72057594037927936L;
    public static final long STEP_LEVEL_MODIFIED_MODE_SHIFT = 56L;
    public static final int STEP_LEVEL_MODE_SCREEN_STATE = 3;
    public static final int STEP_LEVEL_MODE_POWER_SAVE = 4;
    public static final int DUMP_UNPLUGGED_ONLY = 1;
    public static final int DUMP_CHARGED_ONLY = 2;
    public static final int DUMP_HISTORY_ONLY = 4;
    public static final int DUMP_INCLUDE_HISTORY = 8;
    public static final int DUMP_VERBOSE = 16;
    public static final int DUMP_DEVICE_WIFI_ONLY = 32;

    public abstract void commitCurrentHistoryBatchLocked();

    public abstract int getHistoryTotalSize();

    public abstract int getHistoryUsedSize();

    public abstract boolean startIteratingHistoryLocked();

    public abstract int getHistoryStringPoolSize();

    public abstract int getHistoryStringPoolBytes();

    public abstract String getHistoryTagPoolString(int var1);

    public abstract int getHistoryTagPoolUid(int var1);

    public abstract boolean getNextHistoryLocked(HistoryItem var1);

    public abstract void finishIteratingHistoryLocked();

    public abstract boolean startIteratingOldHistoryLocked();

    public abstract boolean getNextOldHistoryLocked(HistoryItem var1);

    public abstract void finishIteratingOldHistoryLocked();

    public abstract long getHistoryBaseTime();

    public abstract int getStartCount();

    public abstract long getScreenOnTime(long var1, int var3);

    public abstract int getScreenOnCount(int var1);

    public abstract long getInteractiveTime(long var1, int var3);

    public abstract long getScreenBrightnessTime(int var1, long var2, int var4);

    public abstract long getLowPowerModeEnabledTime(long var1, int var3);

    public abstract int getLowPowerModeEnabledCount(int var1);

    public abstract int getNumConnectivityChange(int var1);

    public abstract long getPhoneOnTime(long var1, int var3);

    public abstract int getPhoneOnCount(int var1);

    public abstract long getPhoneSignalStrengthTime(int var1, long var2, int var4);

    public abstract long getPhoneSignalScanningTime(long var1, int var3);

    public abstract int getPhoneSignalStrengthCount(int var1, int var2);

    public abstract long getMobileRadioActiveTime(long var1, int var3);

    public abstract int getMobileRadioActiveCount(int var1);

    public abstract long getMobileRadioActiveAdjustedTime(int var1);

    public abstract long getMobileRadioActiveUnknownTime(int var1);

    public abstract int getMobileRadioActiveUnknownCount(int var1);

    public abstract long getPhoneDataConnectionTime(int var1, long var2, int var4);

    public abstract int getPhoneDataConnectionCount(int var1, int var2);

    public abstract long getWifiOnTime(long var1, int var3);

    public abstract long getGlobalWifiRunningTime(long var1, int var3);

    public abstract long getWifiStateTime(int var1, long var2, int var4);

    public abstract int getWifiStateCount(int var1, int var2);

    public abstract long getWifiSupplStateTime(int var1, long var2, int var4);

    public abstract int getWifiSupplStateCount(int var1, int var2);

    public abstract long getWifiSignalStrengthTime(int var1, long var2, int var4);

    public abstract int getWifiSignalStrengthCount(int var1, int var2);

    public abstract long getBluetoothOnTime(long var1, int var3);

    public abstract int getBluetoothPingCount();

    public abstract long getBluetoothStateTime(int var1, long var2, int var4);

    public abstract int getBluetoothStateCount(int var1, int var2);

    public abstract long getFlashlightOnTime(long var1, int var3);

    public abstract long getFlashlightOnCount(int var1);

    public abstract long getNetworkActivityBytes(int var1, int var2);

    public abstract long getNetworkActivityPackets(int var1, int var2);

    public abstract long getStartClockTime();

    public abstract String getStartPlatformVersion();

    public abstract String getEndPlatformVersion();

    public abstract int getParcelVersion();

    public abstract boolean getIsOnBattery();

    public abstract SparseArray<? extends Uid> getUidStats();

    public abstract long getBatteryUptime(long var1);

    public abstract long getBatteryRealtime(long var1);

    public abstract int getDischargeStartLevel();

    public abstract int getDischargeCurrentLevel();

    public abstract int getLowDischargeAmountSinceCharge();

    public abstract int getHighDischargeAmountSinceCharge();

    public abstract int getDischargeAmount(int var1);

    public abstract int getDischargeAmountScreenOn();

    public abstract int getDischargeAmountScreenOnSinceCharge();

    public abstract int getDischargeAmountScreenOff();

    public abstract int getDischargeAmountScreenOffSinceCharge();

    public abstract long computeBatteryUptime(long var1, int var3);

    public abstract long computeBatteryRealtime(long var1, int var3);

    public abstract long computeBatteryScreenOffUptime(long var1, int var3);

    public abstract long computeBatteryScreenOffRealtime(long var1, int var3);

    public abstract long computeUptime(long var1, int var3);

    public abstract long computeRealtime(long var1, int var3);

    public abstract long computeBatteryTimeRemaining(long var1);

    public abstract int getNumDischargeStepDurations();

    public abstract long[] getDischargeStepDurationsArray();

    public abstract long computeChargeTimeRemaining(long var1);

    public abstract int getNumChargeStepDurations();

    public abstract long[] getChargeStepDurationsArray();

    public abstract Map<String, ? extends Timer> getWakeupReasonStats();

    public abstract Map<String, ? extends Timer> getKernelWakelockStats();

    public abstract int getCpuSpeedSteps();

    public abstract void writeToParcelWithoutUids(Parcel var1, int var2);

    private static void formatTimeRaw(StringBuilder out, long seconds) {
        long mins;
        long used;
        long hours;
        long days = seconds / 86400L;
        if (days != 0L) {
            out.append(days);
            out.append("d ");
        }
        if ((hours = (seconds - (used = days * 60L * 60L * 24L)) / 3600L) != 0L || used != 0L) {
            out.append(hours);
            out.append("h ");
        }
        if ((mins = (seconds - (used += hours * 60L * 60L)) / 60L) != 0L || used != 0L) {
            out.append(mins);
            out.append("m ");
        }
        if (seconds != 0L || (used += mins * 60L) != 0L) {
            out.append(seconds - used);
            out.append("s ");
        }
    }

    public static void formatTime(StringBuilder sb, long time) {
        long sec = time / 100L;
        BatteryStats.formatTimeRaw(sb, sec);
        sb.append((time - sec * 100L) * 10L);
        sb.append("ms ");
    }

    public static void formatTimeMs(StringBuilder sb, long time) {
        long sec = time / 1000L;
        BatteryStats.formatTimeRaw(sb, sec);
        sb.append(time - sec * 1000L);
        sb.append("ms ");
    }

    public static void formatTimeMsNoSpace(StringBuilder sb, long time) {
        long sec = time / 1000L;
        BatteryStats.formatTimeRaw(sb, sec);
        sb.append(time - sec * 1000L);
        sb.append("ms");
    }

    public String formatRatioLocked(long num, long den) {
        if (den == 0L) {
            return "--%";
        }
        float perc = (float)num / (float)den * 100.0f;
        this.mFormatBuilder.setLength(0);
        this.mFormatter.format("%.1f%%", Float.valueOf(perc));
        return this.mFormatBuilder.toString();
    }

    String formatBytesLocked(long bytes) {
        this.mFormatBuilder.setLength(0);
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            this.mFormatter.format("%.2fKB", (double)bytes / 1024.0);
            return this.mFormatBuilder.toString();
        }
        if (bytes < 0x40000000L) {
            this.mFormatter.format("%.2fMB", (double)bytes / 1048576.0);
            return this.mFormatBuilder.toString();
        }
        this.mFormatter.format("%.2fGB", (double)bytes / 1.073741824E9);
        return this.mFormatBuilder.toString();
    }

    private static long computeWakeLock(Timer timer, long elapsedRealtimeUs, int which) {
        if (timer != null) {
            long totalTimeMicros = timer.getTotalTimeLocked(elapsedRealtimeUs, which);
            long totalTimeMillis = (totalTimeMicros + 500L) / 1000L;
            return totalTimeMillis;
        }
        return 0L;
    }

    private static String printWakeLock(StringBuilder sb, Timer timer, long elapsedRealtimeUs, String name, int which, String linePrefix) {
        if (timer != null) {
            long totalTimeMillis = BatteryStats.computeWakeLock(timer, elapsedRealtimeUs, which);
            int count = timer.getCountLocked(which);
            if (totalTimeMillis != 0L) {
                sb.append(linePrefix);
                BatteryStats.formatTimeMs(sb, totalTimeMillis);
                if (name != null) {
                    sb.append(name);
                    sb.append(' ');
                }
                sb.append('(');
                sb.append(count);
                sb.append(" times)");
                return ", ";
            }
        }
        return linePrefix;
    }

    private static String printWakeLockCheckin(StringBuilder sb, Timer timer, long elapsedRealtimeUs, String name, int which, String linePrefix) {
        long totalTimeMicros = 0L;
        int count = 0;
        if (timer != null) {
            totalTimeMicros = timer.getTotalTimeLocked(elapsedRealtimeUs, which);
            count = timer.getCountLocked(which);
        }
        sb.append(linePrefix);
        sb.append((totalTimeMicros + 500L) / 1000L);
        sb.append(',');
        sb.append(name != null ? name + "," : "");
        sb.append(count);
        return ",";
    }

    private static void dumpLine(PrintWriter pw, int uid, String category, String type, Object ... args) {
        pw.print(9);
        pw.print(',');
        pw.print(uid);
        pw.print(',');
        pw.print(category);
        pw.print(',');
        pw.print(type);
        for (Object arg : args) {
            pw.print(',');
            pw.print(arg);
        }
        pw.println();
    }

    public void dumpCheckinLocked(Context context, PrintWriter pw, int which, int reqUid) {
        this.dumpCheckinLocked(context, pw, which, reqUid, BatteryStatsHelper.checkWifiOnly(context));
    }

    public void dumpCheckinLocked(Context context, PrintWriter pw, int which, int reqUid, boolean wifiOnly) {
        int i;
        long rawUptime = SystemClock.uptimeMillis() * 1000L;
        long rawRealtime = SystemClock.elapsedRealtime() * 1000L;
        long batteryUptime = this.getBatteryUptime(rawUptime);
        long whichBatteryUptime = this.computeBatteryUptime(rawUptime, which);
        long whichBatteryRealtime = this.computeBatteryRealtime(rawRealtime, which);
        long whichBatteryScreenOffUptime = this.computeBatteryScreenOffUptime(rawUptime, which);
        long whichBatteryScreenOffRealtime = this.computeBatteryScreenOffRealtime(rawRealtime, which);
        long totalRealtime = this.computeRealtime(rawRealtime, which);
        long totalUptime = this.computeUptime(rawUptime, which);
        long screenOnTime = this.getScreenOnTime(rawRealtime, which);
        long interactiveTime = this.getInteractiveTime(rawRealtime, which);
        long lowPowerModeEnabledTime = this.getLowPowerModeEnabledTime(rawRealtime, which);
        int connChanges = this.getNumConnectivityChange(which);
        long phoneOnTime = this.getPhoneOnTime(rawRealtime, which);
        long wifiOnTime = this.getWifiOnTime(rawRealtime, which);
        long wifiRunningTime = this.getGlobalWifiRunningTime(rawRealtime, which);
        long bluetoothOnTime = this.getBluetoothOnTime(rawRealtime, which);
        StringBuilder sb = new StringBuilder(128);
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        String category = STAT_NAMES[which];
        BatteryStats.dumpLine(pw, 0, category, BATTERY_DATA, which == 0 ? Integer.valueOf(this.getStartCount()) : "N/A", whichBatteryRealtime / 1000L, whichBatteryUptime / 1000L, totalRealtime / 1000L, totalUptime / 1000L, this.getStartClockTime(), whichBatteryScreenOffRealtime / 1000L, whichBatteryScreenOffUptime / 1000L);
        long fullWakeLockTimeTotal = 0L;
        long partialWakeLockTimeTotal = 0L;
        for (int iu = 0; iu < NU; ++iu) {
            Uid u = uidStats.valueAt(iu);
            Map<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            if (wakelocks.size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                Timer partialWakeTimer;
                Uid.Wakelock wl = ent.getValue();
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotal += fullWakeTimer.getTotalTimeLocked(rawRealtime, which);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null) continue;
                partialWakeLockTimeTotal += partialWakeTimer.getTotalTimeLocked(rawRealtime, which);
            }
        }
        long mobileRxTotalBytes = this.getNetworkActivityBytes(0, which);
        long mobileTxTotalBytes = this.getNetworkActivityBytes(1, which);
        long wifiRxTotalBytes = this.getNetworkActivityBytes(2, which);
        long wifiTxTotalBytes = this.getNetworkActivityBytes(3, which);
        long mobileRxTotalPackets = this.getNetworkActivityPackets(0, which);
        long mobileTxTotalPackets = this.getNetworkActivityPackets(1, which);
        long wifiRxTotalPackets = this.getNetworkActivityPackets(2, which);
        long wifiTxTotalPackets = this.getNetworkActivityPackets(3, which);
        BatteryStats.dumpLine(pw, 0, category, GLOBAL_NETWORK_DATA, mobileRxTotalBytes, mobileTxTotalBytes, wifiRxTotalBytes, wifiTxTotalBytes, mobileRxTotalPackets, mobileTxTotalPackets, wifiRxTotalPackets, wifiTxTotalPackets);
        BatteryStats.dumpLine(pw, 0, category, MISC_DATA, screenOnTime / 1000L, phoneOnTime / 1000L, wifiOnTime / 1000L, wifiRunningTime / 1000L, bluetoothOnTime / 1000L, mobileRxTotalBytes, mobileTxTotalBytes, wifiRxTotalBytes, wifiTxTotalBytes, fullWakeLockTimeTotal / 1000L, partialWakeLockTimeTotal / 1000L, 0, this.getMobileRadioActiveTime(rawRealtime, which) / 1000L, this.getMobileRadioActiveAdjustedTime(which) / 1000L, interactiveTime / 1000L, lowPowerModeEnabledTime / 1000L, connChanges);
        Object[] args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getScreenBrightnessTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, SCREEN_BRIGHTNESS_DATA, args);
        args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getPhoneSignalStrengthTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_STRENGTH_TIME_DATA, args);
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_SCANNING_TIME_DATA, this.getPhoneSignalScanningTime(rawRealtime, which) / 1000L);
        for (i = 0; i < 5; ++i) {
            args[i] = this.getPhoneSignalStrengthCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_STRENGTH_COUNT_DATA, args);
        args = new Object[17];
        for (i = 0; i < 17; ++i) {
            args[i] = this.getPhoneDataConnectionTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, DATA_CONNECTION_TIME_DATA, args);
        for (i = 0; i < 17; ++i) {
            args[i] = this.getPhoneDataConnectionCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, DATA_CONNECTION_COUNT_DATA, args);
        args = new Object[8];
        for (i = 0; i < 8; ++i) {
            args[i] = this.getWifiStateTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_STATE_TIME_DATA, args);
        for (i = 0; i < 8; ++i) {
            args[i] = this.getWifiStateCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_STATE_COUNT_DATA, args);
        args = new Object[13];
        for (i = 0; i < 13; ++i) {
            args[i] = this.getWifiSupplStateTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_SUPPL_STATE_TIME_DATA, args);
        for (i = 0; i < 13; ++i) {
            args[i] = this.getWifiSupplStateCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_SUPPL_STATE_COUNT_DATA, args);
        args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getWifiSignalStrengthTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_SIGNAL_STRENGTH_TIME_DATA, args);
        for (i = 0; i < 5; ++i) {
            args[i] = this.getWifiSignalStrengthCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_SIGNAL_STRENGTH_COUNT_DATA, args);
        args = new Object[4];
        for (i = 0; i < 4; ++i) {
            args[i] = this.getBluetoothStateTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, BLUETOOTH_STATE_TIME_DATA, args);
        for (i = 0; i < 4; ++i) {
            args[i] = this.getBluetoothStateCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, BLUETOOTH_STATE_COUNT_DATA, args);
        if (which == 2) {
            BatteryStats.dumpLine(pw, 0, category, BATTERY_LEVEL_DATA, this.getDischargeStartLevel(), this.getDischargeCurrentLevel());
        }
        if (which == 2) {
            BatteryStats.dumpLine(pw, 0, category, BATTERY_DISCHARGE_DATA, this.getDischargeStartLevel() - this.getDischargeCurrentLevel(), this.getDischargeStartLevel() - this.getDischargeCurrentLevel(), this.getDischargeAmountScreenOn(), this.getDischargeAmountScreenOff());
        } else {
            BatteryStats.dumpLine(pw, 0, category, BATTERY_DISCHARGE_DATA, this.getLowDischargeAmountSinceCharge(), this.getHighDischargeAmountSinceCharge(), this.getDischargeAmountScreenOnSinceCharge(), this.getDischargeAmountScreenOffSinceCharge());
        }
        if (reqUid < 0) {
            Map<String, ? extends Timer> wakeupReasons;
            Map<String, ? extends Timer> kernelWakelocks = this.getKernelWakelockStats();
            if (kernelWakelocks.size() > 0) {
                for (Map.Entry<String, ? extends Timer> ent : kernelWakelocks.entrySet()) {
                    sb.setLength(0);
                    BatteryStats.printWakeLockCheckin(sb, ent.getValue(), rawRealtime, null, which, "");
                    BatteryStats.dumpLine(pw, 0, category, KERNEL_WAKELOCK_DATA, ent.getKey(), sb.toString());
                }
            }
            if ((wakeupReasons = this.getWakeupReasonStats()).size() > 0) {
                for (Map.Entry<String, ? extends Timer> ent : wakeupReasons.entrySet()) {
                    long totalTimeMicros = ent.getValue().getTotalTimeLocked(rawRealtime, which);
                    int count = ent.getValue().getCountLocked(which);
                    BatteryStats.dumpLine(pw, 0, category, WAKEUP_REASON_DATA, "\"" + ent.getKey() + "\"", (totalTimeMicros + 500L) / 1000L, count);
                }
            }
        }
        BatteryStatsHelper helper = new BatteryStatsHelper(context, false, wifiOnly);
        helper.create(this);
        helper.refreshStats(which, -1);
        List<BatterySipper> sippers = helper.getUsageList();
        if (sippers != null && sippers.size() > 0) {
            BatteryStats.dumpLine(pw, 0, category, POWER_USE_SUMMARY_DATA, BatteryStatsHelper.makemAh(helper.getPowerProfile().getBatteryCapacity()), BatteryStatsHelper.makemAh(helper.getComputedPower()), BatteryStatsHelper.makemAh(helper.getMinDrainedPower()), BatteryStatsHelper.makemAh(helper.getMaxDrainedPower()));
            for (int i2 = 0; i2 < sippers.size(); ++i2) {
                String label;
                BatterySipper bs = sippers.get(i2);
                int uid = 0;
                switch (bs.drainType) {
                    case IDLE: {
                        label = "idle";
                        break;
                    }
                    case CELL: {
                        label = "cell";
                        break;
                    }
                    case PHONE: {
                        label = "phone";
                        break;
                    }
                    case WIFI: {
                        label = "wifi";
                        break;
                    }
                    case BLUETOOTH: {
                        label = "blue";
                        break;
                    }
                    case SCREEN: {
                        label = "scrn";
                        break;
                    }
                    case FLASHLIGHT: {
                        label = "flashlight";
                        break;
                    }
                    case APP: {
                        uid = bs.uidObj.getUid();
                        label = UID_DATA;
                        break;
                    }
                    case USER: {
                        uid = UserHandle.getUid(bs.userId, 0);
                        label = "user";
                        break;
                    }
                    case UNACCOUNTED: {
                        label = "unacc";
                        break;
                    }
                    case OVERCOUNTED: {
                        label = "over";
                        break;
                    }
                    default: {
                        label = "???";
                    }
                }
                BatteryStats.dumpLine(pw, uid, category, POWER_USE_ITEM_DATA, label, BatteryStatsHelper.makemAh(bs.value));
            }
        }
        for (int iu = 0; iu < NU; ++iu) {
            Map<String, ? extends Uid.Pkg> packageStats;
            Map<String, ? extends Uid.Proc> processStats;
            Timer fgTimer;
            Map<String, ? extends Timer> jobs;
            Map<String, ? extends Timer> syncs;
            Map<String, ? extends Uid.Wakelock> wakelocks;
            int uid = uidStats.keyAt(iu);
            if (reqUid >= 0 && uid != reqUid) continue;
            Uid u = uidStats.valueAt(iu);
            long mobileBytesRx = u.getNetworkActivityBytes(0, which);
            long mobileBytesTx = u.getNetworkActivityBytes(1, which);
            long wifiBytesRx = u.getNetworkActivityBytes(2, which);
            long wifiBytesTx = u.getNetworkActivityBytes(3, which);
            long mobilePacketsRx = u.getNetworkActivityPackets(0, which);
            long mobilePacketsTx = u.getNetworkActivityPackets(1, which);
            long mobileActiveTime = u.getMobileRadioActiveTime(which);
            int mobileActiveCount = u.getMobileRadioActiveCount(which);
            long wifiPacketsRx = u.getNetworkActivityPackets(2, which);
            long wifiPacketsTx = u.getNetworkActivityPackets(3, which);
            long fullWifiLockOnTime = u.getFullWifiLockTime(rawRealtime, which);
            long wifiScanTime = u.getWifiScanTime(rawRealtime, which);
            long uidWifiRunningTime = u.getWifiRunningTime(rawRealtime, which);
            if (mobileBytesRx > 0L || mobileBytesTx > 0L || wifiBytesRx > 0L || wifiBytesTx > 0L || mobilePacketsRx > 0L || mobilePacketsTx > 0L || wifiPacketsRx > 0L || wifiPacketsTx > 0L || mobileActiveTime > 0L || mobileActiveCount > 0) {
                BatteryStats.dumpLine(pw, uid, category, NETWORK_DATA, mobileBytesRx, mobileBytesTx, wifiBytesRx, wifiBytesTx, mobilePacketsRx, mobilePacketsTx, wifiPacketsRx, wifiPacketsTx, mobileActiveTime, mobileActiveCount);
            }
            if (fullWifiLockOnTime != 0L || wifiScanTime != 0L || uidWifiRunningTime != 0L) {
                BatteryStats.dumpLine(pw, uid, category, WIFI_DATA, fullWifiLockOnTime, wifiScanTime, uidWifiRunningTime);
            }
            if (u.hasUserActivity()) {
                args = new Object[3];
                boolean hasData = false;
                for (int i3 = 0; i3 < 3; ++i3) {
                    int val = u.getUserActivityCount(i3, which);
                    args[i3] = val;
                    if (val == 0) continue;
                    hasData = true;
                }
                if (hasData) {
                    BatteryStats.dumpLine(pw, uid, category, USER_ACTIVITY_DATA, args);
                }
            }
            if ((wakelocks = u.getWakelockStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                    Uid.Wakelock wl = ent.getValue();
                    String linePrefix = "";
                    sb.setLength(0);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(1), rawRealtime, "f", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(0), rawRealtime, "p", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(2), rawRealtime, "w", which, linePrefix);
                    if (sb.length() <= 0) continue;
                    String name = ent.getKey();
                    if (name.indexOf(44) >= 0) {
                        name = name.replace(',', '_');
                    }
                    BatteryStats.dumpLine(pw, uid, category, WAKELOCK_DATA, name, sb.toString());
                }
            }
            if ((syncs = u.getSyncStats()).size() > 0) {
                for (Map.Entry<String, ? extends Timer> ent : syncs.entrySet()) {
                    Timer timer = ent.getValue();
                    long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                    int count = timer.getCountLocked(which);
                    if (totalTime == 0L) continue;
                    BatteryStats.dumpLine(pw, uid, category, SYNC_DATA, ent.getKey(), totalTime, count);
                }
            }
            if ((jobs = u.getJobStats()).size() > 0) {
                for (Map.Entry<String, ? extends Timer> ent : jobs.entrySet()) {
                    Timer timer = ent.getValue();
                    long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                    int count = timer.getCountLocked(which);
                    if (totalTime == 0L) continue;
                    BatteryStats.dumpLine(pw, uid, category, JOB_DATA, ent.getKey(), totalTime, count);
                }
            }
            SparseArray<? extends Uid.Sensor> sensors = u.getSensorStats();
            int NSE = sensors.size();
            for (int ise = 0; ise < NSE; ++ise) {
                Uid.Sensor se = sensors.valueAt(ise);
                int sensorNumber = sensors.keyAt(ise);
                Timer timer = se.getSensorTime();
                if (timer == null) continue;
                long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                int count = timer.getCountLocked(which);
                if (totalTime == 0L) continue;
                BatteryStats.dumpLine(pw, uid, category, SENSOR_DATA, sensorNumber, totalTime, count);
            }
            Timer vibTimer = u.getVibratorOnTimer();
            if (vibTimer != null) {
                long totalTime = (vibTimer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                int count = vibTimer.getCountLocked(which);
                if (totalTime != 0L) {
                    BatteryStats.dumpLine(pw, uid, category, VIBRATOR_DATA, totalTime, count);
                }
            }
            if ((fgTimer = u.getForegroundActivityTimer()) != null) {
                long totalTime = (fgTimer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                int count = fgTimer.getCountLocked(which);
                if (totalTime != 0L) {
                    BatteryStats.dumpLine(pw, uid, category, FOREGROUND_DATA, totalTime, count);
                }
            }
            Object[] stateTimes = new Object[3];
            long totalStateTime = 0L;
            for (int ips = 0; ips < 3; ++ips) {
                stateTimes[ips] = ((totalStateTime += u.getProcessStateTime(ips, rawRealtime, which)) + 500L) / 1000L;
            }
            if (totalStateTime > 0L) {
                BatteryStats.dumpLine(pw, uid, category, STATE_TIME_DATA, stateTimes);
            }
            if ((processStats = u.getProcessStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Proc> ent : processStats.entrySet()) {
                    Uid.Proc ps = ent.getValue();
                    long userMillis = ps.getUserTime(which) * 10L;
                    long systemMillis = ps.getSystemTime(which) * 10L;
                    long foregroundMillis = ps.getForegroundTime(which) * 10L;
                    int starts = ps.getStarts(which);
                    int numCrashes = ps.getNumCrashes(which);
                    int numAnrs = ps.getNumAnrs(which);
                    if (userMillis == 0L && systemMillis == 0L && foregroundMillis == 0L && starts == 0 && numAnrs == 0 && numCrashes == 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, PROCESS_DATA, ent.getKey(), userMillis, systemMillis, foregroundMillis, starts, numAnrs, numCrashes);
                }
            }
            if ((packageStats = u.getPackageStats()).size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Pkg> ent : packageStats.entrySet()) {
                Uid.Pkg ps = ent.getValue();
                int wakeups = ps.getWakeups(which);
                Map<String, ? extends Uid.Pkg.Serv> serviceStats = ps.getServiceStats();
                for (Map.Entry<String, ? extends Uid.Pkg.Serv> sent : serviceStats.entrySet()) {
                    Uid.Pkg.Serv ss = sent.getValue();
                    long startTime = ss.getStartTime(batteryUptime, which);
                    int starts = ss.getStarts(which);
                    int launches = ss.getLaunches(which);
                    if (startTime == 0L && starts == 0 && launches == 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, APK_DATA, wakeups, ent.getKey(), sent.getKey(), startTime / 1000L, starts, launches);
                }
            }
        }
    }

    private void printmAh(PrintWriter printer, double power) {
        printer.print(BatteryStatsHelper.makemAh(power));
    }

    public void dumpLocked(Context context, PrintWriter pw, String prefix, int which, int reqUid) {
        this.dumpLocked(context, pw, prefix, which, reqUid, BatteryStatsHelper.checkWifiOnly(context));
    }

    public void dumpLocked(Context context, PrintWriter pw, String prefix, int which, int reqUid, boolean wifiOnly) {
        int i;
        long time;
        int i2;
        long mobileActiveAdjustedTime;
        long time2;
        int i3;
        int connChanges;
        long rawUptime = SystemClock.uptimeMillis() * 1000L;
        long rawRealtime = SystemClock.elapsedRealtime() * 1000L;
        long batteryUptime = this.getBatteryUptime(rawUptime);
        long whichBatteryUptime = this.computeBatteryUptime(rawUptime, which);
        long whichBatteryRealtime = this.computeBatteryRealtime(rawRealtime, which);
        long totalRealtime = this.computeRealtime(rawRealtime, which);
        long totalUptime = this.computeUptime(rawUptime, which);
        long whichBatteryScreenOffUptime = this.computeBatteryScreenOffUptime(rawUptime, which);
        long whichBatteryScreenOffRealtime = this.computeBatteryScreenOffRealtime(rawRealtime, which);
        long batteryTimeRemaining = this.computeBatteryTimeRemaining(rawRealtime);
        long chargeTimeRemaining = this.computeChargeTimeRemaining(rawRealtime);
        StringBuilder sb = new StringBuilder(128);
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Time on battery: ");
        BatteryStats.formatTimeMs(sb, whichBatteryRealtime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryRealtime, totalRealtime));
        sb.append(") realtime, ");
        BatteryStats.formatTimeMs(sb, whichBatteryUptime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryUptime, totalRealtime));
        sb.append(") uptime");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Time on battery screen off: ");
        BatteryStats.formatTimeMs(sb, whichBatteryScreenOffRealtime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryScreenOffRealtime, totalRealtime));
        sb.append(") realtime, ");
        BatteryStats.formatTimeMs(sb, whichBatteryScreenOffUptime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryScreenOffUptime, totalRealtime));
        sb.append(") uptime");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Total run time: ");
        BatteryStats.formatTimeMs(sb, totalRealtime / 1000L);
        sb.append("realtime, ");
        BatteryStats.formatTimeMs(sb, totalUptime / 1000L);
        sb.append("uptime");
        pw.println(sb.toString());
        if (batteryTimeRemaining >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Battery time remaining: ");
            BatteryStats.formatTimeMs(sb, batteryTimeRemaining / 1000L);
            pw.println(sb.toString());
        }
        if (chargeTimeRemaining >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Charge time remaining: ");
            BatteryStats.formatTimeMs(sb, chargeTimeRemaining / 1000L);
            pw.println(sb.toString());
        }
        pw.print("  Start clock time: ");
        pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.getStartClockTime()).toString());
        long screenOnTime = this.getScreenOnTime(rawRealtime, which);
        long interactiveTime = this.getInteractiveTime(rawRealtime, which);
        long lowPowerModeEnabledTime = this.getLowPowerModeEnabledTime(rawRealtime, which);
        long phoneOnTime = this.getPhoneOnTime(rawRealtime, which);
        long wifiRunningTime = this.getGlobalWifiRunningTime(rawRealtime, which);
        long wifiOnTime = this.getWifiOnTime(rawRealtime, which);
        long bluetoothOnTime = this.getBluetoothOnTime(rawRealtime, which);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Screen on: ");
        BatteryStats.formatTimeMs(sb, screenOnTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(screenOnTime, whichBatteryRealtime));
        sb.append(") ");
        sb.append(this.getScreenOnCount(which));
        sb.append("x, Interactive: ");
        BatteryStats.formatTimeMs(sb, interactiveTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(interactiveTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Screen brightnesses:");
        boolean didOne = false;
        for (int i4 = 0; i4 < 5; ++i4) {
            long time3 = this.getScreenBrightnessTime(i4, rawRealtime, which);
            if (time3 == 0L) continue;
            sb.append("\n    ");
            sb.append(prefix);
            didOne = true;
            sb.append(SCREEN_BRIGHTNESS_NAMES[i4]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time3 / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time3, screenOnTime));
            sb.append(")");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        if (lowPowerModeEnabledTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Low power mode enabled: ");
            BatteryStats.formatTimeMs(sb, lowPowerModeEnabledTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(lowPowerModeEnabledTime, whichBatteryRealtime));
            sb.append(")");
            pw.println(sb.toString());
        }
        if (phoneOnTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Active phone call: ");
            BatteryStats.formatTimeMs(sb, phoneOnTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(phoneOnTime, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneOnCount(which));
        }
        if ((connChanges = this.getNumConnectivityChange(which)) != 0) {
            pw.print(prefix);
            pw.print("  Connectivity changes: ");
            pw.println(connChanges);
        }
        long fullWakeLockTimeTotalMicros = 0L;
        long partialWakeLockTimeTotalMicros = 0L;
        ArrayList<TimerEntry> timers = new ArrayList<TimerEntry>();
        for (int iu = 0; iu < NU; ++iu) {
            Uid u = uidStats.valueAt(iu);
            Map<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            if (wakelocks.size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                long totalTimeMicros;
                Timer partialWakeTimer;
                Uid.Wakelock wl = ent.getValue();
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotalMicros += fullWakeTimer.getTotalTimeLocked(rawRealtime, which);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null || (totalTimeMicros = partialWakeTimer.getTotalTimeLocked(rawRealtime, which)) <= 0L) continue;
                if (reqUid < 0) {
                    timers.add(new TimerEntry(ent.getKey(), u.getUid(), partialWakeTimer, totalTimeMicros));
                }
                partialWakeLockTimeTotalMicros += totalTimeMicros;
            }
        }
        long mobileRxTotalBytes = this.getNetworkActivityBytes(0, which);
        long mobileTxTotalBytes = this.getNetworkActivityBytes(1, which);
        long wifiRxTotalBytes = this.getNetworkActivityBytes(2, which);
        long wifiTxTotalBytes = this.getNetworkActivityBytes(3, which);
        long mobileRxTotalPackets = this.getNetworkActivityPackets(0, which);
        long mobileTxTotalPackets = this.getNetworkActivityPackets(1, which);
        long wifiRxTotalPackets = this.getNetworkActivityPackets(2, which);
        long wifiTxTotalPackets = this.getNetworkActivityPackets(3, which);
        if (fullWakeLockTimeTotalMicros != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Total full wakelock time: ");
            BatteryStats.formatTimeMsNoSpace(sb, (fullWakeLockTimeTotalMicros + 500L) / 1000L);
            pw.println(sb.toString());
        }
        if (partialWakeLockTimeTotalMicros != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Total partial wakelock time: ");
            BatteryStats.formatTimeMsNoSpace(sb, (partialWakeLockTimeTotalMicros + 500L) / 1000L);
            pw.println(sb.toString());
        }
        pw.print(prefix);
        pw.print("  Mobile total received: ");
        pw.print(this.formatBytesLocked(mobileRxTotalBytes));
        pw.print(", sent: ");
        pw.print(this.formatBytesLocked(mobileTxTotalBytes));
        pw.print(" (packets received ");
        pw.print(mobileRxTotalPackets);
        pw.print(", sent ");
        pw.print(mobileTxTotalPackets);
        pw.println(")");
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Phone signal levels:");
        didOne = false;
        for (i3 = 0; i3 < 5; ++i3) {
            time2 = this.getPhoneSignalStrengthTime(i3, rawRealtime, which);
            if (time2 == 0L) continue;
            sb.append("\n    ");
            sb.append(prefix);
            didOne = true;
            sb.append(SignalStrength.SIGNAL_STRENGTH_NAMES[i3]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time2 / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time2, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneSignalStrengthCount(i3, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Signal scanning time: ");
        BatteryStats.formatTimeMsNoSpace(sb, this.getPhoneSignalScanningTime(rawRealtime, which) / 1000L);
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Radio types:");
        didOne = false;
        for (i3 = 0; i3 < 17; ++i3) {
            time2 = this.getPhoneDataConnectionTime(i3, rawRealtime, which);
            if (time2 == 0L) continue;
            sb.append("\n    ");
            sb.append(prefix);
            didOne = true;
            sb.append(DATA_CONNECTION_NAMES[i3]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time2 / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time2, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneDataConnectionCount(i3, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Mobile radio active time: ");
        long mobileActiveTime = this.getMobileRadioActiveTime(rawRealtime, which);
        BatteryStats.formatTimeMs(sb, mobileActiveTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(mobileActiveTime, whichBatteryRealtime));
        sb.append(") ");
        sb.append(this.getMobileRadioActiveCount(which));
        sb.append("x");
        pw.println(sb.toString());
        long mobileActiveUnknownTime = this.getMobileRadioActiveUnknownTime(which);
        if (mobileActiveUnknownTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Mobile radio active unknown time: ");
            BatteryStats.formatTimeMs(sb, mobileActiveUnknownTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(mobileActiveUnknownTime, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getMobileRadioActiveUnknownCount(which));
            sb.append("x");
            pw.println(sb.toString());
        }
        if ((mobileActiveAdjustedTime = this.getMobileRadioActiveAdjustedTime(which)) != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Mobile radio active adjusted time: ");
            BatteryStats.formatTimeMs(sb, mobileActiveAdjustedTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(mobileActiveAdjustedTime, whichBatteryRealtime));
            sb.append(")");
            pw.println(sb.toString());
        }
        pw.print(prefix);
        pw.print("  Wi-Fi total received: ");
        pw.print(this.formatBytesLocked(wifiRxTotalBytes));
        pw.print(", sent: ");
        pw.print(this.formatBytesLocked(wifiTxTotalBytes));
        pw.print(" (packets received ");
        pw.print(wifiRxTotalPackets);
        pw.print(", sent ");
        pw.print(wifiTxTotalPackets);
        pw.println(")");
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Wifi on: ");
        BatteryStats.formatTimeMs(sb, wifiOnTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(wifiOnTime, whichBatteryRealtime));
        sb.append("), Wifi running: ");
        BatteryStats.formatTimeMs(sb, wifiRunningTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(wifiRunningTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Wifi states:");
        didOne = false;
        for (i2 = 0; i2 < 8; ++i2) {
            time = this.getWifiStateTime(i2, rawRealtime, which);
            if (time == 0L) continue;
            sb.append("\n    ");
            didOne = true;
            sb.append(WIFI_STATE_NAMES[i2]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getWifiStateCount(i2, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Wifi supplicant states:");
        didOne = false;
        for (i2 = 0; i2 < 13; ++i2) {
            time = this.getWifiSupplStateTime(i2, rawRealtime, which);
            if (time == 0L) continue;
            sb.append("\n    ");
            didOne = true;
            sb.append(WIFI_SUPPL_STATE_NAMES[i2]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getWifiSupplStateCount(i2, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Wifi signal levels:");
        didOne = false;
        for (i2 = 0; i2 < 5; ++i2) {
            time = this.getWifiSignalStrengthTime(i2, rawRealtime, which);
            if (time == 0L) continue;
            sb.append("\n    ");
            sb.append(prefix);
            didOne = true;
            sb.append("level(");
            sb.append(i2);
            sb.append(") ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getWifiSignalStrengthCount(i2, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Bluetooth on: ");
        BatteryStats.formatTimeMs(sb, bluetoothOnTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(bluetoothOnTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Bluetooth states:");
        didOne = false;
        for (i2 = 0; i2 < 4; ++i2) {
            time = this.getBluetoothStateTime(i2, rawRealtime, which);
            if (time == 0L) continue;
            sb.append("\n    ");
            didOne = true;
            sb.append(BLUETOOTH_STATE_NAMES[i2]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneDataConnectionCount(i2, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        pw.println();
        if (which == 2) {
            if (this.getIsOnBattery()) {
                pw.print(prefix);
                pw.println("  Device is currently unplugged");
                pw.print(prefix);
                pw.print("    Discharge cycle start level: ");
                pw.println(this.getDischargeStartLevel());
                pw.print(prefix);
                pw.print("    Discharge cycle current level: ");
                pw.println(this.getDischargeCurrentLevel());
            } else {
                pw.print(prefix);
                pw.println("  Device is currently plugged into power");
                pw.print(prefix);
                pw.print("    Last discharge cycle start level: ");
                pw.println(this.getDischargeStartLevel());
                pw.print(prefix);
                pw.print("    Last discharge cycle end level: ");
                pw.println(this.getDischargeCurrentLevel());
            }
            pw.print(prefix);
            pw.print("    Amount discharged while screen on: ");
            pw.println(this.getDischargeAmountScreenOn());
            pw.print(prefix);
            pw.print("    Amount discharged while screen off: ");
            pw.println(this.getDischargeAmountScreenOff());
            pw.println(" ");
        } else {
            pw.print(prefix);
            pw.println("  Device battery use since last full charge");
            pw.print(prefix);
            pw.print("    Amount discharged (lower bound): ");
            pw.println(this.getLowDischargeAmountSinceCharge());
            pw.print(prefix);
            pw.print("    Amount discharged (upper bound): ");
            pw.println(this.getHighDischargeAmountSinceCharge());
            pw.print(prefix);
            pw.print("    Amount discharged while screen on: ");
            pw.println(this.getDischargeAmountScreenOnSinceCharge());
            pw.print(prefix);
            pw.print("    Amount discharged while screen off: ");
            pw.println(this.getDischargeAmountScreenOffSinceCharge());
            pw.println();
        }
        BatteryStatsHelper helper = new BatteryStatsHelper(context, false, wifiOnly);
        helper.create(this);
        helper.refreshStats(which, -1);
        List<BatterySipper> sippers = helper.getUsageList();
        if (sippers != null && sippers.size() > 0) {
            pw.print(prefix);
            pw.println("  Estimated power use (mAh):");
            pw.print(prefix);
            pw.print("    Capacity: ");
            this.printmAh(pw, helper.getPowerProfile().getBatteryCapacity());
            pw.print(", Computed drain: ");
            this.printmAh(pw, helper.getComputedPower());
            pw.print(", actual drain: ");
            this.printmAh(pw, helper.getMinDrainedPower());
            if (helper.getMinDrainedPower() != helper.getMaxDrainedPower()) {
                pw.print("-");
                this.printmAh(pw, helper.getMaxDrainedPower());
            }
            pw.println();
            block22: for (int i5 = 0; i5 < sippers.size(); ++i5) {
                BatterySipper bs = sippers.get(i5);
                switch (bs.drainType) {
                    case IDLE: {
                        pw.print(prefix);
                        pw.print("    Idle: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case CELL: {
                        pw.print(prefix);
                        pw.print("    Cell standby: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case PHONE: {
                        pw.print(prefix);
                        pw.print("    Phone calls: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case WIFI: {
                        pw.print(prefix);
                        pw.print("    Wifi: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case BLUETOOTH: {
                        pw.print(prefix);
                        pw.print("    Bluetooth: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case SCREEN: {
                        pw.print(prefix);
                        pw.print("    Screen: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case FLASHLIGHT: {
                        pw.print(prefix);
                        pw.print("    Flashlight: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case APP: {
                        pw.print(prefix);
                        pw.print("    Uid ");
                        UserHandle.formatUid(pw, bs.uidObj.getUid());
                        pw.print(": ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case USER: {
                        pw.print(prefix);
                        pw.print("    User ");
                        pw.print(bs.userId);
                        pw.print(": ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case UNACCOUNTED: {
                        pw.print(prefix);
                        pw.print("    Unaccounted: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                        continue block22;
                    }
                    case OVERCOUNTED: {
                        pw.print(prefix);
                        pw.print("    Over-counted: ");
                        this.printmAh(pw, bs.value);
                        pw.println();
                    }
                }
            }
            pw.println();
        }
        if ((sippers = helper.getMobilemsppList()) != null && sippers.size() > 0) {
            pw.print(prefix);
            pw.println("  Per-app mobile ms per packet:");
            long totalTime = 0L;
            for (i = 0; i < sippers.size(); ++i) {
                BatterySipper bs = sippers.get(i);
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    Uid ");
                UserHandle.formatUid(sb, bs.uidObj.getUid());
                sb.append(": ");
                sb.append(BatteryStatsHelper.makemAh(bs.mobilemspp));
                sb.append(" (");
                sb.append(bs.mobileRxPackets + bs.mobileTxPackets);
                sb.append(" packets over ");
                BatteryStats.formatTimeMsNoSpace(sb, bs.mobileActive);
                sb.append(") ");
                sb.append(bs.mobileActiveCount);
                sb.append("x");
                pw.println(sb.toString());
                totalTime += bs.mobileActive;
            }
            sb.setLength(0);
            sb.append(prefix);
            sb.append("    TOTAL TIME: ");
            BatteryStats.formatTimeMs(sb, totalTime);
            sb.append("(");
            sb.append(this.formatRatioLocked(totalTime, whichBatteryRealtime));
            sb.append(")");
            pw.println(sb.toString());
            pw.println();
        }
        Comparator<TimerEntry> timerComparator = new Comparator<TimerEntry>(){

            @Override
            public int compare(TimerEntry lhs, TimerEntry rhs) {
                long lhsTime = lhs.mTime;
                long rhsTime = rhs.mTime;
                if (lhsTime < rhsTime) {
                    return 1;
                }
                if (lhsTime > rhsTime) {
                    return -1;
                }
                return 0;
            }
        };
        if (reqUid < 0) {
            Map<String, ? extends Timer> wakeupReasons;
            Object timer;
            Map<String, ? extends Timer> kernelWakelocks = this.getKernelWakelockStats();
            if (kernelWakelocks.size() > 0) {
                ArrayList<TimerEntry> ktimers = new ArrayList<TimerEntry>();
                for (Map.Entry<String, ? extends Timer> ent : kernelWakelocks.entrySet()) {
                    timer = ent.getValue();
                    long totalTimeMillis = BatteryStats.computeWakeLock((Timer)timer, rawRealtime, which);
                    if (totalTimeMillis <= 0L) continue;
                    ktimers.add(new TimerEntry(ent.getKey(), 0, (Timer)timer, totalTimeMillis));
                }
                if (ktimers.size() > 0) {
                    Collections.sort(ktimers, timerComparator);
                    pw.print(prefix);
                    pw.println("  All kernel wake locks:");
                    for (int i6 = 0; i6 < ktimers.size(); ++i6) {
                        TimerEntry timer2 = (TimerEntry)ktimers.get(i6);
                        String linePrefix = ": ";
                        sb.setLength(0);
                        sb.append(prefix);
                        sb.append("  Kernel Wake lock ");
                        sb.append(timer2.mName);
                        linePrefix = BatteryStats.printWakeLock(sb, timer2.mTimer, rawRealtime, null, which, linePrefix);
                        if (linePrefix.equals(": ")) continue;
                        sb.append(" realtime");
                        pw.println(sb.toString());
                    }
                    pw.println();
                }
            }
            if (timers.size() > 0) {
                Collections.sort(timers, timerComparator);
                pw.print(prefix);
                pw.println("  All partial wake locks:");
                for (i = 0; i < timers.size(); ++i) {
                    TimerEntry timer3 = (TimerEntry)timers.get(i);
                    sb.setLength(0);
                    sb.append("  Wake lock ");
                    UserHandle.formatUid(sb, timer3.mId);
                    sb.append(" ");
                    sb.append(timer3.mName);
                    BatteryStats.printWakeLock(sb, timer3.mTimer, rawRealtime, null, which, ": ");
                    sb.append(" realtime");
                    pw.println(sb.toString());
                }
                timers.clear();
                pw.println();
            }
            if ((wakeupReasons = this.getWakeupReasonStats()).size() > 0) {
                pw.print(prefix);
                pw.println("  All wakeup reasons:");
                ArrayList<TimerEntry> reasons = new ArrayList<TimerEntry>();
                for (Map.Entry<String, ? extends Timer> ent : wakeupReasons.entrySet()) {
                    Timer timer4 = ent.getValue();
                    reasons.add(new TimerEntry(ent.getKey(), 0, timer4, timer4.getCountLocked(which)));
                }
                Collections.sort(reasons, timerComparator);
                for (int i7 = 0; i7 < reasons.size(); ++i7) {
                    timer = (TimerEntry)reasons.get(i7);
                    String linePrefix = ": ";
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("  Wakeup reason ");
                    sb.append(((TimerEntry)timer).mName);
                    BatteryStats.printWakeLock(sb, ((TimerEntry)timer).mTimer, rawRealtime, null, which, ": ");
                    sb.append(" realtime");
                    pw.println(sb.toString());
                }
                pw.println();
            }
        }
        for (int iu = 0; iu < NU; ++iu) {
            Map<String, ? extends Uid.Pkg> packageStats;
            Timer fgTimer;
            Map<String, ? extends Timer> jobs;
            Map<String, ? extends Timer> syncs;
            int count;
            Map<String, ? extends Uid.Wakelock> wakelocks;
            int uid = uidStats.keyAt(iu);
            if (reqUid >= 0 && uid != reqUid && uid != 1000) continue;
            Uid u = uidStats.valueAt(iu);
            pw.print(prefix);
            pw.print("  ");
            UserHandle.formatUid(pw, uid);
            pw.println(":");
            boolean uidActivity = false;
            long mobileRxBytes = u.getNetworkActivityBytes(0, which);
            long mobileTxBytes = u.getNetworkActivityBytes(1, which);
            long wifiRxBytes = u.getNetworkActivityBytes(2, which);
            long wifiTxBytes = u.getNetworkActivityBytes(3, which);
            long mobileRxPackets = u.getNetworkActivityPackets(0, which);
            long mobileTxPackets = u.getNetworkActivityPackets(1, which);
            long uidMobileActiveTime = u.getMobileRadioActiveTime(which);
            int uidMobileActiveCount = u.getMobileRadioActiveCount(which);
            long wifiRxPackets = u.getNetworkActivityPackets(2, which);
            long wifiTxPackets = u.getNetworkActivityPackets(3, which);
            long fullWifiLockOnTime = u.getFullWifiLockTime(rawRealtime, which);
            long wifiScanTime = u.getWifiScanTime(rawRealtime, which);
            long uidWifiRunningTime = u.getWifiRunningTime(rawRealtime, which);
            if (mobileRxBytes > 0L || mobileTxBytes > 0L || mobileRxPackets > 0L || mobileTxPackets > 0L) {
                pw.print(prefix);
                pw.print("    Mobile network: ");
                pw.print(this.formatBytesLocked(mobileRxBytes));
                pw.print(" received, ");
                pw.print(this.formatBytesLocked(mobileTxBytes));
                pw.print(" sent (packets ");
                pw.print(mobileRxPackets);
                pw.print(" received, ");
                pw.print(mobileTxPackets);
                pw.println(" sent)");
            }
            if (uidMobileActiveTime > 0L || uidMobileActiveCount > 0) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    Mobile radio active: ");
                BatteryStats.formatTimeMs(sb, uidMobileActiveTime / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(uidMobileActiveTime, mobileActiveTime));
                sb.append(") ");
                sb.append(uidMobileActiveCount);
                sb.append("x");
                long packets = mobileRxPackets + mobileTxPackets;
                if (packets == 0L) {
                    packets = 1L;
                }
                sb.append(" @ ");
                sb.append(BatteryStatsHelper.makemAh((double)(uidMobileActiveTime / 1000L) / (double)packets));
                sb.append(" mspp");
                pw.println(sb.toString());
            }
            if (wifiRxBytes > 0L || wifiTxBytes > 0L || wifiRxPackets > 0L || wifiTxPackets > 0L) {
                pw.print(prefix);
                pw.print("    Wi-Fi network: ");
                pw.print(this.formatBytesLocked(wifiRxBytes));
                pw.print(" received, ");
                pw.print(this.formatBytesLocked(wifiTxBytes));
                pw.print(" sent (packets ");
                pw.print(wifiRxPackets);
                pw.print(" received, ");
                pw.print(wifiTxPackets);
                pw.println(" sent)");
            }
            if (fullWifiLockOnTime != 0L || wifiScanTime != 0L || uidWifiRunningTime != 0L) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    Wifi Running: ");
                BatteryStats.formatTimeMs(sb, uidWifiRunningTime / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(uidWifiRunningTime, whichBatteryRealtime));
                sb.append(")\n");
                sb.append(prefix);
                sb.append("    Full Wifi Lock: ");
                BatteryStats.formatTimeMs(sb, fullWifiLockOnTime / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(fullWifiLockOnTime, whichBatteryRealtime));
                sb.append(")\n");
                sb.append(prefix);
                sb.append("    Wifi Scan: ");
                BatteryStats.formatTimeMs(sb, wifiScanTime / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(wifiScanTime, whichBatteryRealtime));
                sb.append(")");
                pw.println(sb.toString());
            }
            if (u.hasUserActivity()) {
                boolean hasData = false;
                for (int i8 = 0; i8 < 3; ++i8) {
                    int val = u.getUserActivityCount(i8, which);
                    if (val == 0) continue;
                    if (!hasData) {
                        sb.setLength(0);
                        sb.append("    User activity: ");
                        hasData = true;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(val);
                    sb.append(" ");
                    sb.append(Uid.USER_ACTIVITY_TYPES[i8]);
                }
                if (hasData) {
                    pw.println(sb.toString());
                }
            }
            if ((wakelocks = u.getWakelockStats()).size() > 0) {
                long totalFull = 0L;
                long totalPartial = 0L;
                long totalWindow = 0L;
                count = 0;
                for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                    Uid.Wakelock wl = ent.getValue();
                    String linePrefix = ": ";
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Wake lock ");
                    sb.append(ent.getKey());
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(1), rawRealtime, "full", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(0), rawRealtime, "partial", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(2), rawRealtime, "window", which, linePrefix);
                    sb.append(" realtime");
                    pw.println(sb.toString());
                    uidActivity = true;
                    ++count;
                    totalFull += BatteryStats.computeWakeLock(wl.getWakeTime(1), rawRealtime, which);
                    totalPartial += BatteryStats.computeWakeLock(wl.getWakeTime(0), rawRealtime, which);
                    totalWindow += BatteryStats.computeWakeLock(wl.getWakeTime(2), rawRealtime, which);
                }
                if (count > 1 && (totalFull != 0L || totalPartial != 0L || totalWindow != 0L)) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    TOTAL wake: ");
                    boolean needComma = false;
                    if (totalFull != 0L) {
                        needComma = true;
                        BatteryStats.formatTimeMs(sb, totalFull);
                        sb.append("full");
                    }
                    if (totalPartial != 0L) {
                        if (needComma) {
                            sb.append(", ");
                        }
                        needComma = true;
                        BatteryStats.formatTimeMs(sb, totalPartial);
                        sb.append("partial");
                    }
                    if (totalWindow != 0L) {
                        if (needComma) {
                            sb.append(", ");
                        }
                        needComma = true;
                        BatteryStats.formatTimeMs(sb, totalWindow);
                        sb.append("window");
                    }
                    sb.append(" realtime");
                    pw.println(sb.toString());
                }
            }
            if ((syncs = u.getSyncStats()).size() > 0) {
                for (Map.Entry<String, ? extends Timer> ent : syncs.entrySet()) {
                    Timer timer = ent.getValue();
                    long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                    count = timer.getCountLocked(which);
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Sync ");
                    sb.append(ent.getKey());
                    sb.append(": ");
                    if (totalTime != 0L) {
                        BatteryStats.formatTimeMs(sb, totalTime);
                        sb.append("realtime (");
                        sb.append(count);
                        sb.append(" times)");
                    } else {
                        sb.append("(not used)");
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
            }
            if ((jobs = u.getJobStats()).size() > 0) {
                for (Map.Entry<String, ? extends Timer> ent : jobs.entrySet()) {
                    Timer timer = ent.getValue();
                    long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                    int count2 = timer.getCountLocked(which);
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Job ");
                    sb.append(ent.getKey());
                    sb.append(": ");
                    if (totalTime != 0L) {
                        BatteryStats.formatTimeMs(sb, totalTime);
                        sb.append("realtime (");
                        sb.append(count2);
                        sb.append(" times)");
                    } else {
                        sb.append("(not used)");
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
            }
            SparseArray<? extends Uid.Sensor> sensors = u.getSensorStats();
            int NSE = sensors.size();
            for (int ise = 0; ise < NSE; ++ise) {
                Uid.Sensor se = sensors.valueAt(ise);
                int sensorNumber = sensors.keyAt(ise);
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    Sensor ");
                int handle = se.getHandle();
                if (handle == -10000) {
                    sb.append("GPS");
                } else {
                    sb.append(handle);
                }
                sb.append(": ");
                Timer timer = se.getSensorTime();
                if (timer != null) {
                    long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                    int count3 = timer.getCountLocked(which);
                    if (totalTime != 0L) {
                        BatteryStats.formatTimeMs(sb, totalTime);
                        sb.append("realtime (");
                        sb.append(count3);
                        sb.append(" times)");
                    } else {
                        sb.append("(not used)");
                    }
                } else {
                    sb.append("(not used)");
                }
                pw.println(sb.toString());
                uidActivity = true;
            }
            Timer vibTimer = u.getVibratorOnTimer();
            if (vibTimer != null) {
                long totalTime = (vibTimer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                int count4 = vibTimer.getCountLocked(which);
                if (totalTime != 0L) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Vibrator: ");
                    BatteryStats.formatTimeMs(sb, totalTime);
                    sb.append("realtime (");
                    sb.append(count4);
                    sb.append(" times)");
                    pw.println(sb.toString());
                    uidActivity = true;
                }
            }
            if ((fgTimer = u.getForegroundActivityTimer()) != null) {
                long totalTime = (fgTimer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                int count5 = fgTimer.getCountLocked(which);
                if (totalTime != 0L) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Foreground activities: ");
                    BatteryStats.formatTimeMs(sb, totalTime);
                    sb.append("realtime (");
                    sb.append(count5);
                    sb.append(" times)");
                    pw.println(sb.toString());
                    uidActivity = true;
                }
            }
            long totalStateTime = 0L;
            for (int ips = 0; ips < 3; ++ips) {
                long time4 = u.getProcessStateTime(ips, rawRealtime, which);
                if (time4 <= 0L) continue;
                totalStateTime += time4;
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    ");
                sb.append(Uid.PROCESS_STATE_NAMES[ips]);
                sb.append(" for: ");
                BatteryStats.formatTimeMs(sb, (totalStateTime + 500L) / 1000L);
                pw.println(sb.toString());
                uidActivity = true;
            }
            Map<String, ? extends Uid.Proc> processStats = u.getProcessStats();
            if (processStats.size() > 0) {
                for (Map.Entry<String, ? extends Uid.Proc> ent : processStats.entrySet()) {
                    int numExcessive;
                    Uid.Proc ps = ent.getValue();
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    long foregroundTime = ps.getForegroundTime(which);
                    int starts = ps.getStarts(which);
                    int numCrashes = ps.getNumCrashes(which);
                    int numAnrs = ps.getNumAnrs(which);
                    int n = numExcessive = which == 0 ? ps.countExcessivePowers() : 0;
                    if (userTime == 0L && systemTime == 0L && foregroundTime == 0L && starts == 0 && numExcessive == 0 && numCrashes == 0 && numAnrs == 0) continue;
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Proc ");
                    sb.append(ent.getKey());
                    sb.append(":\n");
                    sb.append(prefix);
                    sb.append("      CPU: ");
                    BatteryStats.formatTime(sb, userTime);
                    sb.append("usr + ");
                    BatteryStats.formatTime(sb, systemTime);
                    sb.append("krn ; ");
                    BatteryStats.formatTime(sb, foregroundTime);
                    sb.append(FOREGROUND_DATA);
                    if (starts != 0 || numCrashes != 0 || numAnrs != 0) {
                        sb.append("\n");
                        sb.append(prefix);
                        sb.append("      ");
                        boolean hasOne = false;
                        if (starts != 0) {
                            hasOne = true;
                            sb.append(starts);
                            sb.append(" starts");
                        }
                        if (numCrashes != 0) {
                            if (hasOne) {
                                sb.append(", ");
                            }
                            hasOne = true;
                            sb.append(numCrashes);
                            sb.append(" crashes");
                        }
                        if (numAnrs != 0) {
                            if (hasOne) {
                                sb.append(", ");
                            }
                            sb.append(numAnrs);
                            sb.append(" anrs");
                        }
                    }
                    pw.println(sb.toString());
                    for (int e = 0; e < numExcessive; ++e) {
                        Uid.Proc.ExcessivePower ew = ps.getExcessivePower(e);
                        if (ew == null) continue;
                        pw.print(prefix);
                        pw.print("      * Killed for ");
                        if (ew.type == 1) {
                            pw.print("wake lock");
                        } else if (ew.type == 2) {
                            pw.print("cpu");
                        } else {
                            pw.print("unknown");
                        }
                        pw.print(" use: ");
                        TimeUtils.formatDuration(ew.usedTime, pw);
                        pw.print(" over ");
                        TimeUtils.formatDuration(ew.overTime, pw);
                        if (ew.overTime == 0L) continue;
                        pw.print(" (");
                        pw.print(ew.usedTime * 100L / ew.overTime);
                        pw.println("%)");
                    }
                    uidActivity = true;
                }
            }
            if ((packageStats = u.getPackageStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Pkg> ent : packageStats.entrySet()) {
                    Map<String, ? extends Uid.Pkg.Serv> serviceStats;
                    pw.print(prefix);
                    pw.print("    Apk ");
                    pw.print(ent.getKey());
                    pw.println(":");
                    boolean apkActivity = false;
                    Uid.Pkg ps = ent.getValue();
                    int wakeups = ps.getWakeups(which);
                    if (wakeups != 0) {
                        pw.print(prefix);
                        pw.print("      ");
                        pw.print(wakeups);
                        pw.println(" wakeup alarms");
                        apkActivity = true;
                    }
                    if ((serviceStats = ps.getServiceStats()).size() > 0) {
                        for (Map.Entry<String, ? extends Uid.Pkg.Serv> sent : serviceStats.entrySet()) {
                            Uid.Pkg.Serv ss = sent.getValue();
                            long startTime = ss.getStartTime(batteryUptime, which);
                            int starts = ss.getStarts(which);
                            int launches = ss.getLaunches(which);
                            if (startTime == 0L && starts == 0 && launches == 0) continue;
                            sb.setLength(0);
                            sb.append(prefix);
                            sb.append("      Service ");
                            sb.append(sent.getKey());
                            sb.append(":\n");
                            sb.append(prefix);
                            sb.append("        Created for: ");
                            BatteryStats.formatTimeMs(sb, startTime / 1000L);
                            sb.append("uptime\n");
                            sb.append(prefix);
                            sb.append("        Starts: ");
                            sb.append(starts);
                            sb.append(", launches: ");
                            sb.append(launches);
                            pw.println(sb.toString());
                            apkActivity = true;
                        }
                    }
                    if (!apkActivity) {
                        pw.print(prefix);
                        pw.println("      (nothing executed)");
                    }
                    uidActivity = true;
                }
            }
            if (uidActivity) continue;
            pw.print(prefix);
            pw.println("    (nothing executed)");
        }
    }

    static void printBitDescriptions(PrintWriter pw, int oldval, int newval, HistoryTag wakelockTag, BitDescription[] descriptions, boolean longNames) {
        int diff = oldval ^ newval;
        if (diff == 0) {
            return;
        }
        boolean didWake = false;
        for (int i = 0; i < descriptions.length; ++i) {
            BitDescription bd = descriptions[i];
            if ((diff & bd.mask) == 0) continue;
            pw.print(longNames ? " " : ",");
            if (bd.shift < 0) {
                pw.print((newval & bd.mask) != 0 ? "+" : "-");
                pw.print(longNames ? bd.name : bd.shortName);
                if (bd.mask != 0x40000000 || wakelockTag == null) continue;
                didWake = true;
                pw.print("=");
                if (longNames) {
                    UserHandle.formatUid(pw, wakelockTag.uid);
                    pw.print(":\"");
                    pw.print(wakelockTag.string);
                    pw.print("\"");
                    continue;
                }
                pw.print(wakelockTag.poolIdx);
                continue;
            }
            pw.print(longNames ? bd.name : bd.shortName);
            pw.print("=");
            int val = (newval & bd.mask) >> bd.shift;
            if (bd.values != null && val >= 0 && val < bd.values.length) {
                pw.print(longNames ? bd.values[val] : bd.shortValues[val]);
                continue;
            }
            pw.print(val);
        }
        if (!didWake && wakelockTag != null) {
            pw.print(longNames ? " wake_lock=" : ",w=");
            if (longNames) {
                UserHandle.formatUid(pw, wakelockTag.uid);
                pw.print(":\"");
                pw.print(wakelockTag.string);
                pw.print("\"");
            } else {
                pw.print(wakelockTag.poolIdx);
            }
        }
    }

    public void prepareForDumpLocked() {
    }

    private void printSizeValue(PrintWriter pw, long size) {
        float result = size;
        String suffix = "";
        if (result >= 10240.0f) {
            suffix = "KB";
            result /= 1024.0f;
        }
        if (result >= 10240.0f) {
            suffix = "MB";
            result /= 1024.0f;
        }
        if (result >= 10240.0f) {
            suffix = "GB";
            result /= 1024.0f;
        }
        if (result >= 10240.0f) {
            suffix = "TB";
            result /= 1024.0f;
        }
        if (result >= 10240.0f) {
            suffix = "PB";
            result /= 1024.0f;
        }
        pw.print((int)result);
        pw.print(suffix);
    }

    private static boolean dumpTimeEstimate(PrintWriter pw, String label, long[] steps, int count, long modesOfInterest, long modeValues) {
        if (count <= 0) {
            return false;
        }
        long total = 0L;
        int numOfInterest = 0;
        for (int i = 0; i < count; ++i) {
            long initMode = (steps[i] & 0xFF000000000000L) >> 48;
            long modMode = (steps[i] & 0xFF00000000000000L) >> 56;
            if ((modMode & modesOfInterest) != 0L || (initMode & modesOfInterest) != modeValues) continue;
            ++numOfInterest;
            total += steps[i] & 0xFFFFFFFFFFL;
        }
        if (numOfInterest <= 0) {
            return false;
        }
        long estimatedTime = total / (long)numOfInterest * 100L;
        pw.print(label);
        StringBuilder sb = new StringBuilder(64);
        BatteryStats.formatTimeMs(sb, estimatedTime);
        pw.print(sb);
        pw.println();
        return true;
    }

    private static boolean dumpDurationSteps(PrintWriter pw, String header, long[] steps, int count, boolean checkin) {
        if (count <= 0) {
            return false;
        }
        if (!checkin) {
            pw.println(header);
        }
        String[] lineArgs = new String[4];
        for (int i = 0; i < count; ++i) {
            long duration = steps[i] & 0xFFFFFFFFFFL;
            int level = (int)((steps[i] & 0xFF0000000000L) >> 40);
            long initMode = (steps[i] & 0xFF000000000000L) >> 48;
            long modMode = (steps[i] & 0xFF00000000000000L) >> 56;
            if (checkin) {
                lineArgs[0] = Long.toString(duration);
                lineArgs[1] = Integer.toString(level);
                if ((modMode & 3L) == 0L) {
                    switch ((int)(initMode & 3L) + 1) {
                        case 1: {
                            lineArgs[2] = "s-";
                            break;
                        }
                        case 2: {
                            lineArgs[2] = "s+";
                            break;
                        }
                        case 3: {
                            lineArgs[2] = "sd";
                            break;
                        }
                        case 4: {
                            lineArgs[2] = "sds";
                            break;
                        }
                        default: {
                            lineArgs[1] = "?";
                            break;
                        }
                    }
                } else {
                    lineArgs[2] = "";
                }
                lineArgs[3] = (modMode & 4L) == 0L ? ((initMode & 4L) != 0L ? "p+" : "p-") : "";
                BatteryStats.dumpLine(pw, 0, "i", header, lineArgs);
                continue;
            }
            pw.print("  #");
            pw.print(i);
            pw.print(": ");
            TimeUtils.formatDuration(duration, pw);
            pw.print(" to ");
            pw.print(level);
            boolean haveModes = false;
            if ((modMode & 3L) == 0L) {
                pw.print(" (");
                switch ((int)(initMode & 3L) + 1) {
                    case 1: {
                        pw.print("screen-off");
                        break;
                    }
                    case 2: {
                        pw.print("screen-on");
                        break;
                    }
                    case 3: {
                        pw.print("screen-doze");
                        break;
                    }
                    case 4: {
                        pw.print("screen-doze-suspend");
                        break;
                    }
                    default: {
                        lineArgs[1] = "screen-?";
                    }
                }
                haveModes = true;
            }
            if ((modMode & 4L) == 0L) {
                pw.print(haveModes ? ", " : " (");
                pw.print((initMode & 4L) != 0L ? "power-save-on" : "power-save-off");
                haveModes = true;
            }
            if (haveModes) {
                pw.print(")");
            }
            pw.println();
        }
        return true;
    }

    private void dumpHistoryLocked(PrintWriter pw, int flags, long histStart, boolean checkin) {
        HistoryPrinter hprinter = new HistoryPrinter();
        HistoryItem rec = new HistoryItem();
        long lastTime = -1L;
        long baseTime = -1L;
        boolean printed = false;
        HistoryEventTracker tracker = null;
        while (this.getNextHistoryLocked(rec)) {
            lastTime = rec.time;
            if (baseTime < 0L) {
                baseTime = lastTime;
            }
            if (rec.time < histStart) continue;
            if (histStart >= 0L && !printed) {
                if (rec.cmd == 5 || rec.cmd == 7 || rec.cmd == 4 || rec.cmd == 8) {
                    printed = true;
                    hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 0x10) != 0);
                    rec.cmd = 0;
                } else if (rec.currentTime != 0L) {
                    printed = true;
                    byte cmd = rec.cmd;
                    rec.cmd = (byte)5;
                    hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 0x10) != 0);
                    rec.cmd = cmd;
                }
                if (tracker != null) {
                    if (rec.cmd != 0) {
                        hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 0x10) != 0);
                        rec.cmd = 0;
                    }
                    int oldEventCode = rec.eventCode;
                    HistoryTag oldEventTag = rec.eventTag;
                    rec.eventTag = new HistoryTag();
                    for (int i = 0; i < 10; ++i) {
                        HashMap<String, SparseIntArray> active = tracker.getStateForEvent(i);
                        if (active == null) continue;
                        for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                            SparseIntArray uids = ent.getValue();
                            for (int j = 0; j < uids.size(); ++j) {
                                rec.eventCode = i;
                                rec.eventTag.string = ent.getKey();
                                rec.eventTag.uid = uids.keyAt(j);
                                rec.eventTag.poolIdx = uids.valueAt(j);
                                hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 0x10) != 0);
                                rec.wakeReasonTag = null;
                                rec.wakelockTag = null;
                            }
                        }
                    }
                    rec.eventCode = oldEventCode;
                    rec.eventTag = oldEventTag;
                    tracker = null;
                }
            }
            hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 0x10) != 0);
        }
        if (histStart >= 0L) {
            this.commitCurrentHistoryBatchLocked();
            pw.print(checkin ? "NEXT: " : "  NEXT: ");
            pw.println(lastTime + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLocked(Context context, PrintWriter pw, int flags, int reqUid, long histStart) {
        boolean filtering;
        this.prepareForDumpLocked();
        boolean bl = filtering = (flags & 7) != 0;
        if ((flags & 4) != 0 || !filtering) {
            long historyTotalSize = this.getHistoryTotalSize();
            long historyUsedSize = this.getHistoryUsedSize();
            if (this.startIteratingHistoryLocked()) {
                try {
                    pw.print("Battery History (");
                    pw.print(100L * historyUsedSize / historyTotalSize);
                    pw.print("% used, ");
                    this.printSizeValue(pw, historyUsedSize);
                    pw.print(" used of ");
                    this.printSizeValue(pw, historyTotalSize);
                    pw.print(", ");
                    pw.print(this.getHistoryStringPoolSize());
                    pw.print(" strings using ");
                    this.printSizeValue(pw, this.getHistoryStringPoolBytes());
                    pw.println("):");
                    this.dumpHistoryLocked(pw, flags, histStart, false);
                    pw.println();
                }
                finally {
                    this.finishIteratingHistoryLocked();
                }
            }
            if (this.startIteratingOldHistoryLocked()) {
                try {
                    HistoryItem rec = new HistoryItem();
                    pw.println("Old battery History:");
                    HistoryPrinter hprinter = new HistoryPrinter();
                    long baseTime = -1L;
                    while (this.getNextOldHistoryLocked(rec)) {
                        if (baseTime < 0L) {
                            baseTime = rec.time;
                        }
                        hprinter.printNextItem(pw, rec, baseTime, false, (flags & 0x10) != 0);
                    }
                    pw.println();
                }
                finally {
                    this.finishIteratingOldHistoryLocked();
                }
            }
        }
        if (filtering && (flags & 3) == 0) {
            return;
        }
        if (!filtering) {
            SparseArray<? extends Uid> uidStats = this.getUidStats();
            int NU = uidStats.size();
            boolean didPid = false;
            long nowRealtime = SystemClock.elapsedRealtime();
            for (int i = 0; i < NU; ++i) {
                Uid uid = uidStats.valueAt(i);
                SparseArray<? extends Uid.Pid> pids = uid.getPidStats();
                if (pids == null) continue;
                for (int j = 0; j < pids.size(); ++j) {
                    Uid.Pid pid = pids.valueAt(j);
                    if (!didPid) {
                        pw.println("Per-PID Stats:");
                        didPid = true;
                    }
                    long time = pid.mWakeSumMs + (pid.mWakeNesting > 0 ? nowRealtime - pid.mWakeStartMs : 0L);
                    pw.print("  PID ");
                    pw.print(pids.keyAt(j));
                    pw.print(" wake time: ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println("");
                }
            }
            if (didPid) {
                pw.println();
            }
        }
        if (!filtering || (flags & 2) != 0) {
            long timeRemaining;
            if (BatteryStats.dumpDurationSteps(pw, "Discharge step durations:", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), false)) {
                timeRemaining = this.computeBatteryTimeRemaining(SystemClock.elapsedRealtime());
                if (timeRemaining >= 0L) {
                    pw.print("  Estimated discharge time remaining: ");
                    TimeUtils.formatDuration(timeRemaining / 1000L, pw);
                    pw.println();
                }
                BatteryStats.dumpTimeEstimate(pw, "  Estimated screen off time: ", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), 7L, 0L);
                BatteryStats.dumpTimeEstimate(pw, "  Estimated screen off power save time: ", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), 7L, 4L);
                BatteryStats.dumpTimeEstimate(pw, "  Estimated screen on time: ", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), 7L, 1L);
                BatteryStats.dumpTimeEstimate(pw, "  Estimated screen on power save time: ", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), 7L, 5L);
                BatteryStats.dumpTimeEstimate(pw, "  Estimated screen doze time: ", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), 7L, 2L);
                BatteryStats.dumpTimeEstimate(pw, "  Estimated screen doze power save time: ", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), 7L, 6L);
                BatteryStats.dumpTimeEstimate(pw, "  Estimated screen doze suspend time: ", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), 7L, 3L);
                BatteryStats.dumpTimeEstimate(pw, "  Estimated screen doze suspend power save time: ", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), 7L, 7L);
                pw.println();
            }
            if (BatteryStats.dumpDurationSteps(pw, "Charge step durations:", this.getChargeStepDurationsArray(), this.getNumChargeStepDurations(), false)) {
                timeRemaining = this.computeChargeTimeRemaining(SystemClock.elapsedRealtime());
                if (timeRemaining >= 0L) {
                    pw.print("  Estimated charge time remaining: ");
                    TimeUtils.formatDuration(timeRemaining / 1000L, pw);
                    pw.println();
                }
                pw.println();
            }
            pw.println("Statistics since last charge:");
            pw.println("  System starts: " + this.getStartCount() + ", currently on battery: " + this.getIsOnBattery());
            this.dumpLocked(context, pw, "", 0, reqUid, (flags & 0x20) != 0);
            pw.println();
        }
        if (!filtering || (flags & 1) != 0) {
            pw.println("Statistics since last unplugged:");
            this.dumpLocked(context, pw, "", 2, reqUid, (flags & 0x20) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCheckinLocked(Context context, PrintWriter pw, List<ApplicationInfo> apps, int flags, long histStart) {
        boolean filtering;
        this.prepareForDumpLocked();
        BatteryStats.dumpLine(pw, 0, "i", VERSION_DATA, "12", this.getParcelVersion(), this.getStartPlatformVersion(), this.getEndPlatformVersion());
        long now = this.getHistoryBaseTime() + SystemClock.elapsedRealtime();
        boolean bl = filtering = (flags & 7) != 0;
        if (((flags & 8) != 0 || (flags & 4) != 0) && this.startIteratingHistoryLocked()) {
            try {
                for (int i = 0; i < this.getHistoryStringPoolSize(); ++i) {
                    pw.print(9);
                    pw.print(',');
                    pw.print(HISTORY_STRING_POOL);
                    pw.print(',');
                    pw.print(i);
                    pw.print(",");
                    pw.print(this.getHistoryTagPoolUid(i));
                    pw.print(",\"");
                    String str = this.getHistoryTagPoolString(i);
                    str = str.replace("\\", "\\\\");
                    str = str.replace("\"", "\\\"");
                    pw.print(str);
                    pw.print("\"");
                    pw.println();
                }
                this.dumpHistoryLocked(pw, flags, histStart, true);
            }
            finally {
                this.finishIteratingHistoryLocked();
            }
        }
        if (filtering && (flags & 3) == 0) {
            return;
        }
        if (apps != null) {
            SparseArray<ArrayList<String>> uids = new SparseArray<ArrayList<String>>();
            for (int i = 0; i < apps.size(); ++i) {
                ApplicationInfo ai = apps.get(i);
                ArrayList<String> pkgs = (ArrayList<String>)uids.get(ai.uid);
                if (pkgs == null) {
                    pkgs = new ArrayList<String>();
                    uids.put(ai.uid, pkgs);
                }
                pkgs.add(ai.packageName);
            }
            SparseArray<? extends Uid> uidStats = this.getUidStats();
            int NU = uidStats.size();
            String[] lineArgs = new String[2];
            for (int i = 0; i < NU; ++i) {
                int uid = uidStats.keyAt(i);
                ArrayList pkgs = (ArrayList)uids.get(uid);
                if (pkgs == null) continue;
                for (int j = 0; j < pkgs.size(); ++j) {
                    lineArgs[0] = Integer.toString(uid);
                    lineArgs[1] = (String)pkgs.get(j);
                    BatteryStats.dumpLine(pw, 0, "i", UID_DATA, lineArgs);
                }
            }
        }
        if (!filtering || (flags & 2) != 0) {
            BatteryStats.dumpDurationSteps(pw, DISCHARGE_STEP_DATA, this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), true);
            String[] lineArgs = new String[1];
            long timeRemaining = this.computeBatteryTimeRemaining(SystemClock.elapsedRealtime());
            if (timeRemaining >= 0L) {
                lineArgs[0] = Long.toString(timeRemaining);
                BatteryStats.dumpLine(pw, 0, "i", DISCHARGE_TIME_REMAIN_DATA, lineArgs);
            }
            BatteryStats.dumpDurationSteps(pw, CHARGE_STEP_DATA, this.getChargeStepDurationsArray(), this.getNumChargeStepDurations(), true);
            timeRemaining = this.computeChargeTimeRemaining(SystemClock.elapsedRealtime());
            if (timeRemaining >= 0L) {
                lineArgs[0] = Long.toString(timeRemaining);
                BatteryStats.dumpLine(pw, 0, "i", CHARGE_TIME_REMAIN_DATA, lineArgs);
            }
            this.dumpCheckinLocked(context, pw, 0, -1, (flags & 0x20) != 0);
        }
        if (!filtering || (flags & 1) != 0) {
            this.dumpCheckinLocked(context, pw, 2, -1, (flags & 0x20) != 0);
        }
    }

    public static class HistoryPrinter {
        int oldState = 0;
        int oldState2 = 0;
        int oldLevel = -1;
        int oldStatus = -1;
        int oldHealth = -1;
        int oldPlug = -1;
        int oldTemp = -1;
        int oldVolt = -1;
        long lastTime = -1L;

        void reset() {
            this.oldState2 = 0;
            this.oldState = 0;
            this.oldLevel = -1;
            this.oldStatus = -1;
            this.oldHealth = -1;
            this.oldPlug = -1;
            this.oldTemp = -1;
            this.oldVolt = -1;
        }

        public void printNextItem(PrintWriter pw, HistoryItem rec, long baseTime, boolean checkin, boolean verbose) {
            if (!checkin) {
                pw.print("  ");
                TimeUtils.formatDuration(rec.time - baseTime, pw, 19);
                pw.print(" (");
                pw.print(rec.numReadInts);
                pw.print(") ");
            } else {
                pw.print(9);
                pw.print(',');
                pw.print(BatteryStats.HISTORY_DATA);
                pw.print(',');
                if (this.lastTime < 0L) {
                    pw.print(rec.time - baseTime);
                } else {
                    pw.print(rec.time - this.lastTime);
                }
                this.lastTime = rec.time;
            }
            if (rec.cmd == 4) {
                if (checkin) {
                    pw.print(":");
                }
                pw.println("START");
                this.reset();
            } else if (rec.cmd == 5 || rec.cmd == 7) {
                if (checkin) {
                    pw.print(":");
                }
                if (rec.cmd == 7) {
                    pw.print("RESET:");
                    this.reset();
                }
                pw.print("TIME:");
                if (checkin) {
                    pw.println(rec.currentTime);
                } else {
                    pw.print(" ");
                    pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", rec.currentTime).toString());
                }
            } else if (rec.cmd == 8) {
                if (checkin) {
                    pw.print(":");
                }
                pw.println("SHUTDOWN");
            } else if (rec.cmd == 6) {
                if (checkin) {
                    pw.print(":");
                }
                pw.println("*OVERFLOW*");
            } else {
                if (!checkin) {
                    if (rec.batteryLevel < 10) {
                        pw.print("00");
                    } else if (rec.batteryLevel < 100) {
                        pw.print("0");
                    }
                    pw.print(rec.batteryLevel);
                    if (verbose) {
                        pw.print(" ");
                        if (rec.states >= 0) {
                            if (rec.states < 16) {
                                pw.print("0000000");
                            } else if (rec.states < 256) {
                                pw.print("000000");
                            } else if (rec.states < 4096) {
                                pw.print("00000");
                            } else if (rec.states < 65536) {
                                pw.print("0000");
                            } else if (rec.states < 0x100000) {
                                pw.print("000");
                            } else if (rec.states < 0x1000000) {
                                pw.print("00");
                            } else if (rec.states < 0x10000000) {
                                pw.print("0");
                            }
                        }
                        pw.print(Integer.toHexString(rec.states));
                    }
                } else if (this.oldLevel != rec.batteryLevel) {
                    this.oldLevel = rec.batteryLevel;
                    pw.print(",Bl=");
                    pw.print(rec.batteryLevel);
                }
                if (this.oldStatus != rec.batteryStatus) {
                    this.oldStatus = rec.batteryStatus;
                    pw.print(checkin ? ",Bs=" : " status=");
                    switch (this.oldStatus) {
                        case 1: {
                            pw.print(checkin ? "?" : "unknown");
                            break;
                        }
                        case 2: {
                            pw.print(checkin ? "c" : "charging");
                            break;
                        }
                        case 3: {
                            pw.print(checkin ? "d" : "discharging");
                            break;
                        }
                        case 4: {
                            pw.print(checkin ? "n" : "not-charging");
                            break;
                        }
                        case 5: {
                            pw.print(checkin ? "f" : "full");
                            break;
                        }
                        default: {
                            pw.print(this.oldStatus);
                        }
                    }
                }
                if (this.oldHealth != rec.batteryHealth) {
                    this.oldHealth = rec.batteryHealth;
                    pw.print(checkin ? ",Bh=" : " health=");
                    switch (this.oldHealth) {
                        case 1: {
                            pw.print(checkin ? "?" : "unknown");
                            break;
                        }
                        case 2: {
                            pw.print(checkin ? "g" : "good");
                            break;
                        }
                        case 3: {
                            pw.print(checkin ? BatteryStats.HISTORY_DATA : "overheat");
                            break;
                        }
                        case 4: {
                            pw.print(checkin ? "d" : "dead");
                            break;
                        }
                        case 5: {
                            pw.print(checkin ? "v" : "over-voltage");
                            break;
                        }
                        case 6: {
                            pw.print(checkin ? "f" : "failure");
                            break;
                        }
                        case 7: {
                            pw.print(checkin ? "c" : "cold");
                            break;
                        }
                        default: {
                            pw.print(this.oldHealth);
                        }
                    }
                }
                if (this.oldPlug != rec.batteryPlugType) {
                    this.oldPlug = rec.batteryPlugType;
                    pw.print(checkin ? ",Bp=" : " plug=");
                    switch (this.oldPlug) {
                        case 0: {
                            pw.print(checkin ? "n" : "none");
                            break;
                        }
                        case 1: {
                            pw.print(checkin ? "a" : "ac");
                            break;
                        }
                        case 2: {
                            pw.print(checkin ? "u" : "usb");
                            break;
                        }
                        case 4: {
                            pw.print(checkin ? "w" : "wireless");
                            break;
                        }
                        default: {
                            pw.print(this.oldPlug);
                        }
                    }
                }
                if (this.oldTemp != rec.batteryTemperature) {
                    this.oldTemp = rec.batteryTemperature;
                    pw.print(checkin ? ",Bt=" : " temp=");
                    pw.print(this.oldTemp);
                }
                if (this.oldVolt != rec.batteryVoltage) {
                    this.oldVolt = rec.batteryVoltage;
                    pw.print(checkin ? ",Bv=" : " volt=");
                    pw.print(this.oldVolt);
                }
                BatteryStats.printBitDescriptions(pw, this.oldState, rec.states, rec.wakelockTag, HISTORY_STATE_DESCRIPTIONS, !checkin);
                BatteryStats.printBitDescriptions(pw, this.oldState2, rec.states2, null, HISTORY_STATE2_DESCRIPTIONS, !checkin);
                if (rec.wakeReasonTag != null) {
                    if (checkin) {
                        pw.print(",wr=");
                        pw.print(rec.wakeReasonTag.poolIdx);
                    } else {
                        pw.print(" wake_reason=");
                        pw.print(rec.wakeReasonTag.uid);
                        pw.print(":\"");
                        pw.print(rec.wakeReasonTag.string);
                        pw.print("\"");
                    }
                }
                if (rec.eventCode != 0) {
                    pw.print(checkin ? "," : " ");
                    if ((rec.eventCode & 0x8000) != 0) {
                        pw.print("+");
                    } else if ((rec.eventCode & 0x4000) != 0) {
                        pw.print("-");
                    }
                    String[] eventNames = checkin ? HISTORY_EVENT_CHECKIN_NAMES : HISTORY_EVENT_NAMES;
                    int idx = rec.eventCode & 0xFFFF3FFF;
                    if (idx >= 0 && idx < eventNames.length) {
                        pw.print(eventNames[idx]);
                    } else {
                        pw.print(checkin ? "Ev" : "event");
                        pw.print(idx);
                    }
                    pw.print("=");
                    if (checkin) {
                        pw.print(rec.eventTag.poolIdx);
                    } else {
                        UserHandle.formatUid(pw, rec.eventTag.uid);
                        pw.print(":\"");
                        pw.print(rec.eventTag.string);
                        pw.print("\"");
                    }
                }
                pw.println();
                this.oldState = rec.states;
                this.oldState2 = rec.states2;
            }
        }
    }

    static class TimerEntry {
        final String mName;
        final int mId;
        final Timer mTimer;
        final long mTime;

        TimerEntry(String name, int id2, Timer timer, long time) {
            this.mName = name;
            this.mId = id2;
            this.mTimer = timer;
            this.mTime = time;
        }
    }

    public static class BitDescription {
        public final int mask;
        public final int shift;
        public final String name;
        public final String shortName;
        public final String[] values;
        public final String[] shortValues;

        public BitDescription(int mask, String name, String shortName) {
            this.mask = mask;
            this.shift = -1;
            this.name = name;
            this.shortName = shortName;
            this.values = null;
            this.shortValues = null;
        }

        public BitDescription(int mask, int shift, String name, String shortName, String[] values, String[] shortValues) {
            this.mask = mask;
            this.shift = shift;
            this.name = name;
            this.shortName = shortName;
            this.values = values;
            this.shortValues = shortValues;
        }
    }

    public static class HistoryEventTracker {
        private final HashMap<String, SparseIntArray>[] mActiveEvents = new HashMap[10];

        public boolean updateState(int code, String name, int uid, int poolIdx) {
            if ((code & 0x8000) != 0) {
                SparseIntArray uids;
                int idx = code & 0xFFFF3FFF;
                HashMap<String, SparseIntArray> active = this.mActiveEvents[idx];
                if (active == null) {
                    active = new HashMap();
                    this.mActiveEvents[idx] = active;
                }
                if ((uids = active.get(name)) == null) {
                    uids = new SparseIntArray();
                    active.put(name, uids);
                }
                if (uids.indexOfKey(uid) >= 0) {
                    return false;
                }
                uids.put(uid, poolIdx);
            } else if ((code & 0x4000) != 0) {
                int idx = code & 0xFFFF3FFF;
                HashMap<String, SparseIntArray> active = this.mActiveEvents[idx];
                if (active == null) {
                    return false;
                }
                SparseIntArray uids = active.get(name);
                if (uids == null) {
                    return false;
                }
                idx = uids.indexOfKey(uid);
                if (idx < 0) {
                    return false;
                }
                uids.removeAt(idx);
                if (uids.size() <= 0) {
                    active.remove(name);
                }
            }
            return true;
        }

        public void removeEvents(int code) {
            int idx = code & 0xFFFF3FFF;
            this.mActiveEvents[idx] = null;
        }

        public HashMap<String, SparseIntArray> getStateForEvent(int code) {
            return this.mActiveEvents[code];
        }
    }

    public static class HistoryItem
    implements Parcelable {
        public HistoryItem next;
        public long time;
        public static final byte CMD_UPDATE = 0;
        public static final byte CMD_NULL = -1;
        public static final byte CMD_START = 4;
        public static final byte CMD_CURRENT_TIME = 5;
        public static final byte CMD_OVERFLOW = 6;
        public static final byte CMD_RESET = 7;
        public static final byte CMD_SHUTDOWN = 8;
        public byte cmd = (byte)-1;
        public byte batteryLevel;
        public byte batteryStatus;
        public byte batteryHealth;
        public byte batteryPlugType;
        public short batteryTemperature;
        public char batteryVoltage;
        public static final int STATE_BRIGHTNESS_SHIFT = 0;
        public static final int STATE_BRIGHTNESS_MASK = 7;
        public static final int STATE_PHONE_SIGNAL_STRENGTH_SHIFT = 3;
        public static final int STATE_PHONE_SIGNAL_STRENGTH_MASK = 56;
        public static final int STATE_PHONE_STATE_SHIFT = 6;
        public static final int STATE_PHONE_STATE_MASK = 448;
        public static final int STATE_DATA_CONNECTION_SHIFT = 9;
        public static final int STATE_DATA_CONNECTION_MASK = 15872;
        public static final int STATE_CPU_RUNNING_FLAG = Integer.MIN_VALUE;
        public static final int STATE_WAKE_LOCK_FLAG = 0x40000000;
        public static final int STATE_GPS_ON_FLAG = 0x20000000;
        public static final int STATE_WIFI_FULL_LOCK_FLAG = 0x10000000;
        public static final int STATE_WIFI_SCAN_FLAG = 0x8000000;
        public static final int STATE_WIFI_MULTICAST_ON_FLAG = 0x4000000;
        public static final int STATE_MOBILE_RADIO_ACTIVE_FLAG = 0x2000000;
        public static final int STATE_SENSOR_ON_FLAG = 0x800000;
        public static final int STATE_AUDIO_ON_FLAG = 0x400000;
        public static final int STATE_PHONE_SCANNING_FLAG = 0x200000;
        public static final int STATE_SCREEN_ON_FLAG = 0x100000;
        public static final int STATE_BATTERY_PLUGGED_FLAG = 524288;
        public static final int STATE_PHONE_IN_CALL_FLAG = 262144;
        public static final int STATE_BLUETOOTH_ON_FLAG = 65536;
        public static final int MOST_INTERESTING_STATES = 0x1D0000;
        public int states;
        public static final int STATE2_WIFI_SUPPL_STATE_SHIFT = 0;
        public static final int STATE2_WIFI_SUPPL_STATE_MASK = 15;
        public static final int STATE2_WIFI_SIGNAL_STRENGTH_SHIFT = 4;
        public static final int STATE2_WIFI_SIGNAL_STRENGTH_MASK = 112;
        public static final int STATE2_LOW_POWER_FLAG = Integer.MIN_VALUE;
        public static final int STATE2_VIDEO_ON_FLAG = 0x40000000;
        public static final int STATE2_WIFI_RUNNING_FLAG = 0x20000000;
        public static final int STATE2_WIFI_ON_FLAG = 0x10000000;
        public static final int STATE2_FLASHLIGHT_FLAG = 0x8000000;
        public static final int MOST_INTERESTING_STATES2 = -1879048192;
        public int states2;
        public HistoryTag wakelockTag;
        public HistoryTag wakeReasonTag;
        public static final int EVENT_FLAG_START = 32768;
        public static final int EVENT_FLAG_FINISH = 16384;
        public static final int EVENT_NONE = 0;
        public static final int EVENT_PROC = 1;
        public static final int EVENT_FOREGROUND = 2;
        public static final int EVENT_TOP = 3;
        public static final int EVENT_SYNC = 4;
        public static final int EVENT_WAKE_LOCK = 5;
        public static final int EVENT_JOB = 6;
        public static final int EVENT_USER_RUNNING = 7;
        public static final int EVENT_USER_FOREGROUND = 8;
        public static final int EVENT_CONNECTIVITY_CHANGED = 9;
        public static final int EVENT_COUNT = 10;
        public static final int EVENT_TYPE_MASK = -49153;
        public static final int EVENT_PROC_START = 32769;
        public static final int EVENT_PROC_FINISH = 16385;
        public static final int EVENT_FOREGROUND_START = 32770;
        public static final int EVENT_FOREGROUND_FINISH = 16386;
        public static final int EVENT_TOP_START = 32771;
        public static final int EVENT_TOP_FINISH = 16387;
        public static final int EVENT_SYNC_START = 32772;
        public static final int EVENT_SYNC_FINISH = 16388;
        public static final int EVENT_WAKE_LOCK_START = 32773;
        public static final int EVENT_WAKE_LOCK_FINISH = 16389;
        public static final int EVENT_JOB_START = 32774;
        public static final int EVENT_JOB_FINISH = 16390;
        public static final int EVENT_USER_RUNNING_START = 32775;
        public static final int EVENT_USER_RUNNING_FINISH = 16391;
        public static final int EVENT_USER_FOREGROUND_START = 32776;
        public static final int EVENT_USER_FOREGROUND_FINISH = 16392;
        public int eventCode;
        public HistoryTag eventTag;
        public long currentTime;
        public int numReadInts;
        public final HistoryTag localWakelockTag = new HistoryTag();
        public final HistoryTag localWakeReasonTag = new HistoryTag();
        public final HistoryTag localEventTag = new HistoryTag();

        public boolean isDeltaData() {
            return this.cmd == 0;
        }

        public HistoryItem() {
        }

        public HistoryItem(long time, Parcel src) {
            this.time = time;
            this.numReadInts = 2;
            this.readFromParcel(src);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.time);
            int bat = this.cmd & 0xFF | this.batteryLevel << 8 & 0xFF00 | this.batteryStatus << 16 & 0xF0000 | this.batteryHealth << 20 & 0xF00000 | this.batteryPlugType << 24 & 0xF000000 | (this.wakelockTag != null ? 0x10000000 : 0) | (this.wakeReasonTag != null ? 0x20000000 : 0) | (this.eventCode != 0 ? 0x40000000 : 0);
            dest.writeInt(bat);
            bat = this.batteryTemperature & 0xFFFF | this.batteryVoltage << 16 & 0xFFFF0000;
            dest.writeInt(bat);
            dest.writeInt(this.states);
            dest.writeInt(this.states2);
            if (this.wakelockTag != null) {
                this.wakelockTag.writeToParcel(dest, flags);
            }
            if (this.wakeReasonTag != null) {
                this.wakeReasonTag.writeToParcel(dest, flags);
            }
            if (this.eventCode != 0) {
                dest.writeInt(this.eventCode);
                this.eventTag.writeToParcel(dest, flags);
            }
            if (this.cmd == 5 || this.cmd == 7) {
                dest.writeLong(this.currentTime);
            }
        }

        public void readFromParcel(Parcel src) {
            int start = src.dataPosition();
            int bat = src.readInt();
            this.cmd = (byte)(bat & 0xFF);
            this.batteryLevel = (byte)(bat >> 8 & 0xFF);
            this.batteryStatus = (byte)(bat >> 16 & 0xF);
            this.batteryHealth = (byte)(bat >> 20 & 0xF);
            this.batteryPlugType = (byte)(bat >> 24 & 0xF);
            int bat2 = src.readInt();
            this.batteryTemperature = (short)(bat2 & 0xFFFF);
            this.batteryVoltage = (char)(bat2 >> 16 & 0xFFFF);
            this.states = src.readInt();
            this.states2 = src.readInt();
            if ((bat & 0x10000000) != 0) {
                this.wakelockTag = this.localWakelockTag;
                this.wakelockTag.readFromParcel(src);
            } else {
                this.wakelockTag = null;
            }
            if ((bat & 0x20000000) != 0) {
                this.wakeReasonTag = this.localWakeReasonTag;
                this.wakeReasonTag.readFromParcel(src);
            } else {
                this.wakeReasonTag = null;
            }
            if ((bat & 0x40000000) != 0) {
                this.eventCode = src.readInt();
                this.eventTag = this.localEventTag;
                this.eventTag.readFromParcel(src);
            } else {
                this.eventCode = 0;
                this.eventTag = null;
            }
            this.currentTime = this.cmd == 5 || this.cmd == 7 ? src.readLong() : 0L;
            this.numReadInts += (src.dataPosition() - start) / 4;
        }

        public void clear() {
            this.time = 0L;
            this.cmd = (byte)-1;
            this.batteryLevel = 0;
            this.batteryStatus = 0;
            this.batteryHealth = 0;
            this.batteryPlugType = 0;
            this.batteryTemperature = 0;
            this.batteryVoltage = '\u0000';
            this.states = 0;
            this.states2 = 0;
            this.wakelockTag = null;
            this.wakeReasonTag = null;
            this.eventCode = 0;
            this.eventTag = null;
        }

        public void setTo(HistoryItem o) {
            this.time = o.time;
            this.cmd = o.cmd;
            this.setToCommon(o);
        }

        public void setTo(long time, byte cmd, HistoryItem o) {
            this.time = time;
            this.cmd = cmd;
            this.setToCommon(o);
        }

        private void setToCommon(HistoryItem o) {
            this.batteryLevel = o.batteryLevel;
            this.batteryStatus = o.batteryStatus;
            this.batteryHealth = o.batteryHealth;
            this.batteryPlugType = o.batteryPlugType;
            this.batteryTemperature = o.batteryTemperature;
            this.batteryVoltage = o.batteryVoltage;
            this.states = o.states;
            this.states2 = o.states2;
            if (o.wakelockTag != null) {
                this.wakelockTag = this.localWakelockTag;
                this.wakelockTag.setTo(o.wakelockTag);
            } else {
                this.wakelockTag = null;
            }
            if (o.wakeReasonTag != null) {
                this.wakeReasonTag = this.localWakeReasonTag;
                this.wakeReasonTag.setTo(o.wakeReasonTag);
            } else {
                this.wakeReasonTag = null;
            }
            this.eventCode = o.eventCode;
            if (o.eventTag != null) {
                this.eventTag = this.localEventTag;
                this.eventTag.setTo(o.eventTag);
            } else {
                this.eventTag = null;
            }
            this.currentTime = o.currentTime;
        }

        public boolean sameNonEvent(HistoryItem o) {
            return this.batteryLevel == o.batteryLevel && this.batteryStatus == o.batteryStatus && this.batteryHealth == o.batteryHealth && this.batteryPlugType == o.batteryPlugType && this.batteryTemperature == o.batteryTemperature && this.batteryVoltage == o.batteryVoltage && this.states == o.states && this.states2 == o.states2 && this.currentTime == o.currentTime;
        }

        public boolean same(HistoryItem o) {
            if (!this.sameNonEvent(o) || this.eventCode != o.eventCode) {
                return false;
            }
            if (this.wakelockTag != o.wakelockTag) {
                if (this.wakelockTag == null || o.wakelockTag == null) {
                    return false;
                }
                if (!this.wakelockTag.equals(o.wakelockTag)) {
                    return false;
                }
            }
            if (this.wakeReasonTag != o.wakeReasonTag) {
                if (this.wakeReasonTag == null || o.wakeReasonTag == null) {
                    return false;
                }
                if (!this.wakeReasonTag.equals(o.wakeReasonTag)) {
                    return false;
                }
            }
            if (this.eventTag != o.eventTag) {
                if (this.eventTag == null || o.eventTag == null) {
                    return false;
                }
                if (!this.eventTag.equals(o.eventTag)) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class HistoryTag {
        public String string;
        public int uid;
        public int poolIdx;

        public void setTo(HistoryTag o) {
            this.string = o.string;
            this.uid = o.uid;
            this.poolIdx = o.poolIdx;
        }

        public void setTo(String _string, int _uid) {
            this.string = _string;
            this.uid = _uid;
            this.poolIdx = -1;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.string);
            dest.writeInt(this.uid);
        }

        public void readFromParcel(Parcel src) {
            this.string = src.readString();
            this.uid = src.readInt();
            this.poolIdx = -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoryTag that = (HistoryTag)o;
            if (this.uid != that.uid) {
                return false;
            }
            return this.string.equals(that.string);
        }

        public int hashCode() {
            int result = this.string.hashCode();
            result = 31 * result + this.uid;
            return result;
        }
    }

    public static abstract class Uid {
        public static final int PROCESS_STATE_FOREGROUND = 0;
        public static final int PROCESS_STATE_ACTIVE = 1;
        public static final int PROCESS_STATE_RUNNING = 2;
        public static final int NUM_PROCESS_STATE = 3;
        static final String[] PROCESS_STATE_NAMES = new String[]{"Foreground", "Active", "Running"};
        public static final int NUM_WIFI_BATCHED_SCAN_BINS = 5;
        static final String[] USER_ACTIVITY_TYPES = new String[]{"other", "button", "touch"};
        public static final int NUM_USER_ACTIVITY_TYPES = 3;

        public abstract Map<String, ? extends Wakelock> getWakelockStats();

        public abstract Map<String, ? extends Timer> getSyncStats();

        public abstract Map<String, ? extends Timer> getJobStats();

        public abstract SparseArray<? extends Sensor> getSensorStats();

        public abstract SparseArray<? extends Pid> getPidStats();

        public abstract Map<String, ? extends Proc> getProcessStats();

        public abstract Map<String, ? extends Pkg> getPackageStats();

        public abstract int getUid();

        public abstract void noteWifiRunningLocked(long var1);

        public abstract void noteWifiStoppedLocked(long var1);

        public abstract void noteFullWifiLockAcquiredLocked(long var1);

        public abstract void noteFullWifiLockReleasedLocked(long var1);

        public abstract void noteWifiScanStartedLocked(long var1);

        public abstract void noteWifiScanStoppedLocked(long var1);

        public abstract void noteWifiBatchedScanStartedLocked(int var1, long var2);

        public abstract void noteWifiBatchedScanStoppedLocked(long var1);

        public abstract void noteWifiMulticastEnabledLocked(long var1);

        public abstract void noteWifiMulticastDisabledLocked(long var1);

        public abstract void noteActivityResumedLocked(long var1);

        public abstract void noteActivityPausedLocked(long var1);

        public abstract long getWifiRunningTime(long var1, int var3);

        public abstract long getFullWifiLockTime(long var1, int var3);

        public abstract long getWifiScanTime(long var1, int var3);

        public abstract long getWifiBatchedScanTime(int var1, long var2, int var4);

        public abstract long getWifiMulticastTime(long var1, int var3);

        public abstract long getAudioTurnedOnTime(long var1, int var3);

        public abstract long getVideoTurnedOnTime(long var1, int var3);

        public abstract Timer getForegroundActivityTimer();

        public abstract long getProcessStateTime(int var1, long var2, int var4);

        public abstract Timer getVibratorOnTimer();

        public abstract void noteUserActivityLocked(int var1);

        public abstract boolean hasUserActivity();

        public abstract int getUserActivityCount(int var1, int var2);

        public abstract boolean hasNetworkActivity();

        public abstract long getNetworkActivityBytes(int var1, int var2);

        public abstract long getNetworkActivityPackets(int var1, int var2);

        public abstract long getMobileRadioActiveTime(int var1);

        public abstract int getMobileRadioActiveCount(int var1);

        public static abstract class Pkg {
            public abstract int getWakeups(int var1);

            public abstract Map<String, ? extends Serv> getServiceStats();

            public abstract class Serv {
                public abstract long getStartTime(long var1, int var3);

                public abstract int getStarts(int var1);

                public abstract int getLaunches(int var1);
            }
        }

        public static abstract class Proc {
            public abstract boolean isActive();

            public abstract long getUserTime(int var1);

            public abstract long getSystemTime(int var1);

            public abstract int getStarts(int var1);

            public abstract int getNumCrashes(int var1);

            public abstract int getNumAnrs(int var1);

            public abstract long getForegroundTime(int var1);

            public abstract long getTimeAtCpuSpeedStep(int var1, int var2);

            public abstract int countExcessivePowers();

            public abstract ExcessivePower getExcessivePower(int var1);

            public static class ExcessivePower {
                public static final int TYPE_WAKE = 1;
                public static final int TYPE_CPU = 2;
                public int type;
                public long overTime;
                public long usedTime;
            }
        }

        public class Pid {
            public int mWakeNesting;
            public long mWakeSumMs;
            public long mWakeStartMs;
        }

        public static abstract class Sensor {
            public static final int GPS = -10000;

            public abstract int getHandle();

            public abstract Timer getSensorTime();
        }

        public static abstract class Wakelock {
            public abstract Timer getWakeTime(int var1);
        }
    }

    public static abstract class Timer {
        public abstract int getCountLocked(int var1);

        public abstract long getTotalTimeLocked(long var1, int var3);

        public abstract void logState(Printer var1, String var2);
    }

    public static abstract class LongCounter {
        public abstract long getCountLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }

    public static abstract class Counter {
        public abstract int getCountLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }
}

