/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.graphics.Rect;
import android.media.tv.ITvInputClient;
import android.media.tv.ITvInputHardware;
import android.media.tv.ITvInputHardwareCallback;
import android.media.tv.ITvInputManager;
import android.media.tv.ITvInputManagerCallback;
import android.media.tv.TvContentRating;
import android.media.tv.TvContentRatingSystemInfo;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvStreamConfig;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pools;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.View;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TvInputManager {
    private static final String TAG = "TvInputManager";
    static final int VIDEO_UNAVAILABLE_REASON_START = 0;
    static final int VIDEO_UNAVAILABLE_REASON_END = 3;
    public static final int VIDEO_UNAVAILABLE_REASON_UNKNOWN = 0;
    public static final int VIDEO_UNAVAILABLE_REASON_TUNING = 1;
    public static final int VIDEO_UNAVAILABLE_REASON_WEAK_SIGNAL = 2;
    public static final int VIDEO_UNAVAILABLE_REASON_BUFFERING = 3;
    public static final int INPUT_STATE_UNKNOWN = -1;
    public static final int INPUT_STATE_CONNECTED = 0;
    public static final int INPUT_STATE_CONNECTED_STANDBY = 1;
    public static final int INPUT_STATE_DISCONNECTED = 2;
    public static final String ACTION_BLOCKED_RATINGS_CHANGED = "android.media.tv.action.BLOCKED_RATINGS_CHANGED";
    public static final String ACTION_PARENTAL_CONTROLS_ENABLED_CHANGED = "android.media.tv.action.PARENTAL_CONTROLS_ENABLED_CHANGED";
    public static final String ACTION_QUERY_CONTENT_RATING_SYSTEMS = "android.media.tv.action.QUERY_CONTENT_RATING_SYSTEMS";
    public static final String META_DATA_CONTENT_RATING_SYSTEMS = "android.media.tv.metadata.CONTENT_RATING_SYSTEMS";
    private final ITvInputManager mService;
    private final Object mLock;
    private final List<TvInputCallbackRecord> mCallbackRecords;
    private final Map<String, Integer> mStateMap;
    private final SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
    private int mNextSeq;
    private final ITvInputClient mClient;
    private final ITvInputManagerCallback mManagerCallback;
    private final int mUserId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvInputManager(ITvInputManager service, int userId) {
        block6: {
            this.mLock = new Object();
            this.mCallbackRecords = new LinkedList<TvInputCallbackRecord>();
            this.mStateMap = new ArrayMap<String, Integer>();
            this.mSessionCallbackRecordMap = new SparseArray();
            this.mService = service;
            this.mUserId = userId;
            this.mClient = new ITvInputClient.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSessionCreated(String inputId, IBinder token, InputChannel channel, int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for " + token);
                            return;
                        }
                        Session session = null;
                        if (token != null) {
                            session = new Session(token, channel, TvInputManager.this.mService, TvInputManager.this.mUserId, seq, TvInputManager.this.mSessionCallbackRecordMap);
                        }
                        record.postSessionCreated(session);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSessionReleased(int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        TvInputManager.this.mSessionCallbackRecordMap.delete(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq:" + seq);
                            return;
                        }
                        record.mSession.releaseInternal();
                        record.postSessionReleased();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onChannelRetuned(Uri channelUri, int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postChannelRetuned(channelUri);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTracksChanged(List<TvTrackInfo> tracks, int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        if (record.mSession.updateTracks(tracks)) {
                            record.postTracksChanged(tracks);
                            this.postVideoSizeChangedIfNeededLocked(record);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTrackSelected(int type, String trackId, int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        if (record.mSession.updateTrackSelection(type, trackId)) {
                            record.postTrackSelected(type, trackId);
                            this.postVideoSizeChangedIfNeededLocked(record);
                        }
                    }
                }

                private void postVideoSizeChangedIfNeededLocked(SessionCallbackRecord record) {
                    TvTrackInfo track = record.mSession.getVideoTrackToNotify();
                    if (track != null) {
                        record.postVideoSizeChanged(track.getVideoWidth(), track.getVideoHeight());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onVideoAvailable(int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postVideoAvailable();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onVideoUnavailable(int reason, int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postVideoUnavailable(reason);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onContentAllowed(int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postContentAllowed();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onContentBlocked(String rating, int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postContentBlocked(TvContentRating.unflattenFromString(rating));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onLayoutSurface(int left, int top, int right, int bottom, int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postLayoutSurface(left, top, right, bottom);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSessionEvent(String eventType, Bundle eventArgs, int seq) {
                    SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postSessionEvent(eventType, eventArgs);
                    }
                }
            };
            this.mManagerCallback = new ITvInputManagerCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputStateChanged(String inputId, int state) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        TvInputManager.this.mStateMap.put(inputId, state);
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postInputStateChanged(inputId, state);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputAdded(String inputId) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        TvInputManager.this.mStateMap.put(inputId, 0);
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postInputAdded(inputId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputRemoved(String inputId) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        TvInputManager.this.mStateMap.remove(inputId);
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postInputRemoved(inputId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputUpdated(String inputId) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postInputUpdated(inputId);
                        }
                    }
                }
            };
            try {
                if (this.mService == null) break block6;
                this.mService.registerCallback(this.mManagerCallback, this.mUserId);
                List<TvInputInfo> infos = this.mService.getTvInputList(this.mUserId);
                Object object = this.mLock;
                synchronized (object) {
                    for (TvInputInfo info : infos) {
                        String inputId = info.getId();
                        int state = this.mService.getTvInputState(inputId, this.mUserId);
                        if (state == -1) continue;
                        this.mStateMap.put(inputId, state);
                    }
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "TvInputManager initialization failed: " + e);
            }
        }
    }

    public List<TvInputInfo> getTvInputList() {
        try {
            return this.mService.getTvInputList(this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public TvInputInfo getTvInputInfo(String inputId) {
        if (inputId == null) {
            throw new IllegalArgumentException("inputId cannot be null");
        }
        try {
            return this.mService.getTvInputInfo(inputId, this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInputState(String inputId) {
        if (inputId == null) {
            throw new IllegalArgumentException("inputId cannot be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            Integer state = this.mStateMap.get(inputId);
            if (state == null) {
                throw new IllegalArgumentException("Unrecognized input ID: " + inputId);
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(TvInputCallback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackRecords.add(new TvInputCallbackRecord(callback, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(TvInputCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            Iterator<TvInputCallbackRecord> it = this.mCallbackRecords.iterator();
            while (it.hasNext()) {
                TvInputCallbackRecord record = it.next();
                if (record.getCallback() != callback) continue;
                it.remove();
                break;
            }
        }
    }

    public boolean isParentalControlsEnabled() {
        try {
            return this.mService.isParentalControlsEnabled(this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void setParentalControlsEnabled(boolean enabled) {
        try {
            this.mService.setParentalControlsEnabled(enabled, this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRatingBlocked(TvContentRating rating) {
        if (rating == null) {
            throw new IllegalArgumentException("rating cannot be null");
        }
        try {
            return this.mService.isRatingBlocked(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TvContentRating> getBlockedRatings() {
        try {
            ArrayList<TvContentRating> ratings = new ArrayList<TvContentRating>();
            for (String rating : this.mService.getBlockedRatings(this.mUserId)) {
                ratings.add(TvContentRating.unflattenFromString(rating));
            }
            return ratings;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void addBlockedRating(TvContentRating rating) {
        if (rating == null) {
            throw new IllegalArgumentException("rating cannot be null");
        }
        try {
            this.mService.addBlockedRating(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeBlockedRating(TvContentRating rating) {
        if (rating == null) {
            throw new IllegalArgumentException("rating cannot be null");
        }
        try {
            this.mService.removeBlockedRating(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TvContentRatingSystemInfo> getTvContentRatingSystemList() {
        try {
            return this.mService.getTvContentRatingSystemList(this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSession(String inputId, SessionCallback callback, Handler handler) {
        if (inputId == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        SessionCallbackRecord record = new SessionCallbackRecord(callback, handler);
        SparseArray<SessionCallbackRecord> sparseArray = this.mSessionCallbackRecordMap;
        synchronized (sparseArray) {
            int seq = this.mNextSeq++;
            this.mSessionCallbackRecordMap.put(seq, record);
            try {
                this.mService.createSession(this.mClient, inputId, seq, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public List<TvStreamConfig> getAvailableTvStreamConfigList(String inputId) {
        try {
            return this.mService.getAvailableTvStreamConfigList(inputId, this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean captureFrame(String inputId, Surface surface, TvStreamConfig config) {
        try {
            return this.mService.captureFrame(inputId, surface, config, this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSingleSessionActive() {
        try {
            return this.mService.isSingleSessionActive(this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TvInputHardwareInfo> getHardwareList() {
        try {
            return this.mService.getHardwareList();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public Hardware acquireTvInputHardware(int deviceId, final HardwareCallback callback, TvInputInfo info) {
        try {
            return new Hardware(this.mService.acquireTvInputHardware(deviceId, new ITvInputHardwareCallback.Stub(){

                @Override
                public void onReleased() {
                    callback.onReleased();
                }

                @Override
                public void onStreamConfigChanged(TvStreamConfig[] configs) {
                    callback.onStreamConfigChanged(configs);
                }
            }, info, this.mUserId));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void releaseTvInputHardware(int deviceId, Hardware hardware) {
        try {
            this.mService.releaseTvInputHardware(deviceId, hardware.getInterface(), this.mUserId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Hardware {
        private final ITvInputHardware mInterface;

        private Hardware(ITvInputHardware hardwareInterface) {
            this.mInterface = hardwareInterface;
        }

        private ITvInputHardware getInterface() {
            return this.mInterface;
        }

        public boolean setSurface(Surface surface, TvStreamConfig config) {
            try {
                return this.mInterface.setSurface(surface, config);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setStreamVolume(float volume) {
            try {
                this.mInterface.setStreamVolume(volume);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean dispatchKeyEventToHdmi(KeyEvent event) {
            try {
                return this.mInterface.dispatchKeyEventToHdmi(event);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void overrideAudioSink(int audioType, String audioAddress, int samplingRate, int channelMask, int format) {
            try {
                this.mInterface.overrideAudioSink(audioType, audioAddress, samplingRate, channelMask, format);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Session {
        static final int DISPATCH_IN_PROGRESS = -1;
        static final int DISPATCH_NOT_HANDLED = 0;
        static final int DISPATCH_HANDLED = 1;
        private static final long INPUT_SESSION_NOT_RESPONDING_TIMEOUT = 2500L;
        private final ITvInputManager mService;
        private final int mUserId;
        private final int mSeq;
        private final InputEventHandler mHandler = new InputEventHandler(Looper.getMainLooper());
        private final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
        private final SparseArray<PendingEvent> mPendingEvents = new SparseArray(20);
        private final SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
        private IBinder mToken;
        private TvInputEventSender mSender;
        private InputChannel mChannel;
        private final Object mTrackLock = new Object();
        private final List<TvTrackInfo> mAudioTracks = new ArrayList<TvTrackInfo>();
        private final List<TvTrackInfo> mVideoTracks = new ArrayList<TvTrackInfo>();
        private final List<TvTrackInfo> mSubtitleTracks = new ArrayList<TvTrackInfo>();
        private String mSelectedAudioTrackId;
        private String mSelectedVideoTrackId;
        private String mSelectedSubtitleTrackId;
        private int mVideoWidth;
        private int mVideoHeight;

        private Session(IBinder token, InputChannel channel, ITvInputManager service, int userId, int seq, SparseArray<SessionCallbackRecord> sessionCallbackRecordMap) {
            this.mToken = token;
            this.mChannel = channel;
            this.mService = service;
            this.mUserId = userId;
            this.mSeq = seq;
            this.mSessionCallbackRecordMap = sessionCallbackRecordMap;
        }

        public void release() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.releaseSession(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            this.releaseInternal();
        }

        void setMain() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setMainSession(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setSurface(Surface surface) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setSurface(this.mToken, surface, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void dispatchSurfaceChanged(int format, int width, int height) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.dispatchSurfaceChanged(this.mToken, format, width, height, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setStreamVolume(float volume) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                if (volume < 0.0f || volume > 1.0f) {
                    throw new IllegalArgumentException("volume should be between 0.0f and 1.0f");
                }
                this.mService.setVolume(this.mToken, volume, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void tune(Uri channelUri) {
            this.tune(channelUri, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tune(Uri channelUri, Bundle params) {
            if (channelUri == null) {
                throw new IllegalArgumentException("channelUri cannot be null");
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            Object object = this.mTrackLock;
            synchronized (object) {
                this.mAudioTracks.clear();
                this.mVideoTracks.clear();
                this.mSubtitleTracks.clear();
                this.mSelectedAudioTrackId = null;
                this.mSelectedVideoTrackId = null;
                this.mSelectedSubtitleTrackId = null;
                this.mVideoWidth = 0;
                this.mVideoHeight = 0;
            }
            try {
                this.mService.tune(this.mToken, channelUri, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setCaptionEnabled(boolean enabled) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setCaptionEnabled(this.mToken, enabled, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectTrack(int type, String trackId) {
            Object object = this.mTrackLock;
            synchronized (object) {
                if (type == 0) {
                    if (trackId != null && !this.containsTrack(this.mAudioTracks, trackId)) {
                        Log.w(TvInputManager.TAG, "Invalid audio trackId: " + trackId);
                        return;
                    }
                } else if (type == 1) {
                    if (trackId != null && !this.containsTrack(this.mVideoTracks, trackId)) {
                        Log.w(TvInputManager.TAG, "Invalid video trackId: " + trackId);
                        return;
                    }
                } else if (type == 2) {
                    if (trackId != null && !this.containsTrack(this.mSubtitleTracks, trackId)) {
                        Log.w(TvInputManager.TAG, "Invalid subtitle trackId: " + trackId);
                        return;
                    }
                } else {
                    throw new IllegalArgumentException("invalid type: " + type);
                }
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.selectTrack(this.mToken, type, trackId, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean containsTrack(List<TvTrackInfo> tracks, String trackId) {
            for (TvTrackInfo track : tracks) {
                if (!track.getId().equals(trackId)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TvTrackInfo> getTracks(int type) {
            Object object = this.mTrackLock;
            synchronized (object) {
                if (type == 0) {
                    if (this.mAudioTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mAudioTracks);
                }
                if (type == 1) {
                    if (this.mVideoTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mVideoTracks);
                }
                if (type == 2) {
                    if (this.mSubtitleTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mSubtitleTracks);
                }
            }
            throw new IllegalArgumentException("invalid type: " + type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSelectedTrack(int type) {
            Object object = this.mTrackLock;
            synchronized (object) {
                if (type == 0) {
                    return this.mSelectedAudioTrackId;
                }
                if (type == 1) {
                    return this.mSelectedVideoTrackId;
                }
                if (type == 2) {
                    return this.mSelectedSubtitleTrackId;
                }
            }
            throw new IllegalArgumentException("invalid type: " + type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean updateTracks(List<TvTrackInfo> tracks) {
            Object object = this.mTrackLock;
            synchronized (object) {
                this.mAudioTracks.clear();
                this.mVideoTracks.clear();
                this.mSubtitleTracks.clear();
                for (TvTrackInfo track : tracks) {
                    if (track.getType() == 0) {
                        this.mAudioTracks.add(track);
                        continue;
                    }
                    if (track.getType() == 1) {
                        this.mVideoTracks.add(track);
                        continue;
                    }
                    if (track.getType() != 2) continue;
                    this.mSubtitleTracks.add(track);
                }
                return !this.mAudioTracks.isEmpty() || !this.mVideoTracks.isEmpty() || !this.mSubtitleTracks.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean updateTrackSelection(int type, String trackId) {
            Object object = this.mTrackLock;
            synchronized (object) {
                if (type == 0 && trackId != this.mSelectedAudioTrackId) {
                    this.mSelectedAudioTrackId = trackId;
                    return true;
                }
                if (type == 1 && trackId != this.mSelectedVideoTrackId) {
                    this.mSelectedVideoTrackId = trackId;
                    return true;
                }
                if (type == 2 && trackId != this.mSelectedSubtitleTrackId) {
                    this.mSelectedSubtitleTrackId = trackId;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TvTrackInfo getVideoTrackToNotify() {
            Object object = this.mTrackLock;
            synchronized (object) {
                if (!this.mVideoTracks.isEmpty() && this.mSelectedVideoTrackId != null) {
                    for (TvTrackInfo track : this.mVideoTracks) {
                        if (!track.getId().equals(this.mSelectedVideoTrackId)) continue;
                        int videoWidth = track.getVideoWidth();
                        int videoHeight = track.getVideoHeight();
                        if (this.mVideoWidth == videoWidth && this.mVideoHeight == videoHeight) continue;
                        this.mVideoWidth = videoWidth;
                        this.mVideoHeight = videoHeight;
                        return track;
                    }
                }
            }
            return null;
        }

        public void sendAppPrivateCommand(String action, Bundle data) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.sendAppPrivateCommand(this.mToken, action, data, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        void createOverlayView(View view, Rect frame) {
            if (view == null) {
                throw new IllegalArgumentException("view cannot be null");
            }
            if (frame == null) {
                throw new IllegalArgumentException("frame cannot be null");
            }
            if (view.getWindowToken() == null) {
                throw new IllegalStateException("view must be attached to a window");
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.createOverlayView(this.mToken, view.getWindowToken(), frame, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        void relayoutOverlayView(Rect frame) {
            if (frame == null) {
                throw new IllegalArgumentException("frame cannot be null");
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.relayoutOverlayView(this.mToken, frame, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        void removeOverlayView() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.removeOverlayView(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        void requestUnblockContent(TvContentRating unblockedRating) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            if (unblockedRating == null) {
                throw new IllegalArgumentException("unblockedRating cannot be null");
            }
            try {
                this.mService.requestUnblockContent(this.mToken, unblockedRating.flattenToString(), this.mUserId);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int dispatchInputEvent(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
            if (event == null) {
                throw new IllegalArgumentException("event cannot be null");
            }
            if (callback != null && handler == null) {
                throw new IllegalArgumentException("handler cannot be null");
            }
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                if (this.mChannel == null) {
                    return 0;
                }
                PendingEvent p = this.obtainPendingEventLocked(event, token, callback, handler);
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    return this.sendInputEventOnMainLooperLocked(p);
                }
                Message msg = this.mHandler.obtainMessage(1, p);
                msg.setAsynchronous(true);
                this.mHandler.sendMessage(msg);
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendInputEventAndReportResultOnMainLooper(PendingEvent p) {
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int result = this.sendInputEventOnMainLooperLocked(p);
                if (result == -1) {
                    return;
                }
            }
            this.invokeFinishedInputEventCallback(p, false);
        }

        private int sendInputEventOnMainLooperLocked(PendingEvent p) {
            if (this.mChannel != null) {
                InputEvent event;
                int seq;
                if (this.mSender == null) {
                    this.mSender = new TvInputEventSender(this.mChannel, this.mHandler.getLooper());
                }
                if (this.mSender.sendInputEvent(seq = (event = p.mEvent).getSequenceNumber(), event)) {
                    this.mPendingEvents.put(seq, p);
                    Message msg = this.mHandler.obtainMessage(2, p);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageDelayed(msg, 2500L);
                    return -1;
                }
                Log.w(TvInputManager.TAG, "Unable to send input event to session: " + this.mToken + " dropping:" + event);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishedInputEvent(int seq, boolean handled, boolean timeout) {
            PendingEvent p;
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int index = this.mPendingEvents.indexOfKey(seq);
                if (index < 0) {
                    return;
                }
                p = this.mPendingEvents.valueAt(index);
                this.mPendingEvents.removeAt(index);
                if (timeout) {
                    Log.w(TvInputManager.TAG, "Timeout waiting for seesion to handle input event after 2500 ms: " + this.mToken);
                } else {
                    this.mHandler.removeMessages(2, p);
                }
            }
            this.invokeFinishedInputEventCallback(p, handled);
        }

        void invokeFinishedInputEventCallback(PendingEvent p, boolean handled) {
            p.mHandled = handled;
            if (p.mEventHandler.getLooper().isCurrentThread()) {
                p.run();
            } else {
                Message msg = Message.obtain(p.mEventHandler, p);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }

        private void flushPendingEventsLocked() {
            this.mHandler.removeMessages(3);
            int count = this.mPendingEvents.size();
            for (int i = 0; i < count; ++i) {
                int seq = this.mPendingEvents.keyAt(i);
                Message msg = this.mHandler.obtainMessage(3, seq, 0);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }

        private PendingEvent obtainPendingEventLocked(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
            PendingEvent p = this.mPendingEventPool.acquire();
            if (p == null) {
                p = new PendingEvent();
            }
            p.mEvent = event;
            p.mEventToken = token;
            p.mCallback = callback;
            p.mEventHandler = handler;
            return p;
        }

        private void recyclePendingEventLocked(PendingEvent p) {
            p.recycle();
            this.mPendingEventPool.release(p);
        }

        IBinder getToken() {
            return this.mToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseInternal() {
            this.mToken = null;
            Object object = this.mHandler;
            synchronized (object) {
                if (this.mChannel != null) {
                    if (this.mSender != null) {
                        this.flushPendingEventsLocked();
                        this.mSender.dispose();
                        this.mSender = null;
                    }
                    this.mChannel.dispose();
                    this.mChannel = null;
                }
            }
            object = this.mSessionCallbackRecordMap;
            synchronized (object) {
                this.mSessionCallbackRecordMap.remove(this.mSeq);
            }
        }

        private class PendingEvent
        implements Runnable {
            public InputEvent mEvent;
            public Object mEventToken;
            public FinishedInputEventCallback mCallback;
            public Handler mEventHandler;
            public boolean mHandled;

            private PendingEvent() {
            }

            public void recycle() {
                this.mEvent = null;
                this.mEventToken = null;
                this.mCallback = null;
                this.mEventHandler = null;
                this.mHandled = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.mCallback.onFinishedInputEvent(this.mEventToken, this.mHandled);
                Handler handler = this.mEventHandler;
                synchronized (handler) {
                    Session.this.recyclePendingEventLocked(this);
                }
            }
        }

        private class TvInputEventSender
        extends InputEventSender {
            public TvInputEventSender(InputChannel inputChannel, Looper looper) {
                super(inputChannel, looper);
            }

            @Override
            public void onInputEventFinished(int seq, boolean handled) {
                Session.this.finishedInputEvent(seq, handled, false);
            }
        }

        private class InputEventHandler
        extends Handler {
            public static final int MSG_SEND_INPUT_EVENT = 1;
            public static final int MSG_TIMEOUT_INPUT_EVENT = 2;
            public static final int MSG_FLUSH_INPUT_EVENT = 3;

            InputEventHandler(Looper looper) {
                super(looper, null, true);
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        Session.this.sendInputEventAndReportResultOnMainLooper((PendingEvent)msg.obj);
                        return;
                    }
                    case 2: {
                        Session.this.finishedInputEvent(msg.arg1, false, true);
                        return;
                    }
                    case 3: {
                        Session.this.finishedInputEvent(msg.arg1, false, false);
                        return;
                    }
                }
            }
        }

        public static interface FinishedInputEventCallback {
            public void onFinishedInputEvent(Object var1, boolean var2);
        }
    }

    public static abstract class HardwareCallback {
        public abstract void onReleased();

        public abstract void onStreamConfigChanged(TvStreamConfig[] var1);
    }

    private static class TvInputCallbackRecord {
        private final TvInputCallback mCallback;
        private final Handler mHandler;

        public TvInputCallbackRecord(TvInputCallback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        public TvInputCallback getCallback() {
            return this.mCallback;
        }

        public void postInputStateChanged(final String inputId, final int state) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvInputCallbackRecord.this.mCallback.onInputStateChanged(inputId, state);
                }
            });
        }

        public void postInputAdded(final String inputId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvInputCallbackRecord.this.mCallback.onInputAdded(inputId);
                }
            });
        }

        public void postInputRemoved(final String inputId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvInputCallbackRecord.this.mCallback.onInputRemoved(inputId);
                }
            });
        }

        public void postInputUpdated(final String inputId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvInputCallbackRecord.this.mCallback.onInputUpdated(inputId);
                }
            });
        }
    }

    public static abstract class TvInputCallback {
        public void onInputStateChanged(String inputId, int state) {
        }

        public void onInputAdded(String inputId) {
        }

        public void onInputRemoved(String inputId) {
        }

        public void onInputUpdated(String inputId) {
        }
    }

    private static class SessionCallbackRecord {
        private final SessionCallback mSessionCallback;
        private final Handler mHandler;
        private Session mSession;

        SessionCallbackRecord(SessionCallback sessionCallback, Handler handler) {
            this.mSessionCallback = sessionCallback;
            this.mHandler = handler;
        }

        void postSessionCreated(final Session session) {
            this.mSession = session;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onSessionCreated(session);
                }
            });
        }

        void postSessionReleased() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onSessionReleased(SessionCallbackRecord.this.mSession);
                }
            });
        }

        void postChannelRetuned(final Uri channelUri) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onChannelRetuned(SessionCallbackRecord.this.mSession, channelUri);
                }
            });
        }

        void postTracksChanged(final List<TvTrackInfo> tracks) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onTracksChanged(SessionCallbackRecord.this.mSession, tracks);
                }
            });
        }

        void postTrackSelected(final int type, final String trackId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onTrackSelected(SessionCallbackRecord.this.mSession, type, trackId);
                }
            });
        }

        void postVideoSizeChanged(final int width, final int height) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onVideoSizeChanged(SessionCallbackRecord.this.mSession, width, height);
                }
            });
        }

        void postVideoAvailable() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onVideoAvailable(SessionCallbackRecord.this.mSession);
                }
            });
        }

        void postVideoUnavailable(final int reason) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onVideoUnavailable(SessionCallbackRecord.this.mSession, reason);
                }
            });
        }

        void postContentAllowed() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onContentAllowed(SessionCallbackRecord.this.mSession);
                }
            });
        }

        void postContentBlocked(final TvContentRating rating) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onContentBlocked(SessionCallbackRecord.this.mSession, rating);
                }
            });
        }

        void postLayoutSurface(final int left, final int top, final int right, final int bottom) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onLayoutSurface(SessionCallbackRecord.this.mSession, left, top, right, bottom);
                }
            });
        }

        void postSessionEvent(final String eventType, final Bundle eventArgs) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onSessionEvent(SessionCallbackRecord.this.mSession, eventType, eventArgs);
                }
            });
        }
    }

    public static abstract class SessionCallback {
        public void onSessionCreated(Session session) {
        }

        public void onSessionReleased(Session session) {
        }

        public void onChannelRetuned(Session session, Uri channelUri) {
        }

        public void onTracksChanged(Session session, List<TvTrackInfo> tracks) {
        }

        public void onTrackSelected(Session session, int type, String trackId) {
        }

        public void onVideoSizeChanged(Session session, int width, int height) {
        }

        public void onVideoAvailable(Session session) {
        }

        public void onVideoUnavailable(Session session, int reason) {
        }

        public void onContentAllowed(Session session) {
        }

        public void onContentBlocked(Session session, TvContentRating rating) {
        }

        public void onLayoutSurface(Session session, int left, int top, int right, int bottom) {
        }

        public void onSessionEvent(Session session, String eventType, Bundle eventArgs) {
        }
    }
}

