/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCryptoException;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.UUID;

public class MediaCrypto {
    private long mNativeContext;

    public static boolean isCryptoSchemeSupported(UUID uuid) {
        return MediaCrypto.isCryptoSchemeSupportedNative(MediaCrypto.getByteArrayFromUUID(uuid));
    }

    private static byte[] getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private static boolean isCryptoSchemeSupportedNative(byte[] byArray) {
        return OverrideMethod.invokeI("android.media.MediaCrypto#isCryptoSchemeSupportedNative([B)Z", true, null) != 0;
    }

    public MediaCrypto(UUID uuid, byte[] initData) throws MediaCryptoException {
        this.native_setup(MediaCrypto.getByteArrayFromUUID(uuid), initData);
    }

    public boolean requiresSecureDecoderComponent(String string2) {
        return OverrideMethod.invokeI("android.media.MediaCrypto#requiresSecureDecoderComponent(Ljava/lang/String;)Z", true, this) != 0;
    }

    protected void finalize() {
        this.native_finalize();
    }

    public void release() {
        OverrideMethod.invokeV("android.media.MediaCrypto#release()V", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaCrypto#native_init()V", true, null);
    }

    private void native_setup(byte[] byArray, byte[] byArray2) throws MediaCryptoException {
        OverrideMethod.invokeV("android.media.MediaCrypto#native_setup([B[B)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaCrypto#native_finalize()V", true, this);
    }

    static {
        System.loadLibrary("media_jni");
        MediaCrypto.native_init();
    }
}

