/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Rect;
import android.media.AudioSystem;
import android.media.Image;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.media.Utils;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MediaCodec {
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    public static final int BUFFER_FLAG_KEY_FRAME = 1;
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    private EventHandler mEventHandler;
    private Callback mCallback;
    private static final int EVENT_CALLBACK = 1;
    private static final int EVENT_SET_CALLBACK = 2;
    private static final int CB_INPUT_AVAILABLE = 1;
    private static final int CB_OUTPUT_AVAILABLE = 2;
    private static final int CB_ERROR = 3;
    private static final int CB_OUTPUT_FORMAT_CHANGE = 4;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    private ByteBuffer[] mCachedInputBuffers;
    private ByteBuffer[] mCachedOutputBuffers;
    private final BufferMap mDequeuedInputBuffers = new BufferMap();
    private final BufferMap mDequeuedOutputBuffers = new BufferMap();
    private final Object mBufferLock;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    private long mNativeContext;

    public static MediaCodec createDecoderByType(String type) throws IOException {
        return new MediaCodec(type, true, false);
    }

    public static MediaCodec createEncoderByType(String type) throws IOException {
        return new MediaCodec(type, true, true);
    }

    public static MediaCodec createByCodecName(String name) throws IOException {
        return new MediaCodec(name, false, false);
    }

    private MediaCodec(String name, boolean nameIsType, boolean encoder) {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mBufferLock = new Object();
        this.native_setup(name, nameIsType, encoder);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public void reset() {
        this.freeAllTrackedBuffers();
        this.native_reset();
    }

    private void native_reset() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_reset()V", true, this);
    }

    public void release() {
        this.freeAllTrackedBuffers();
        this.native_release();
    }

    private void native_release() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_release()V", true, this);
    }

    public void configure(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        Map<String, Object> formatMap = format.getMap();
        String[] keys = null;
        Object[] values = null;
        if (format != null) {
            keys = new String[formatMap.size()];
            values = new Object[formatMap.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : formatMap.entrySet()) {
                if (entry.getKey().equals("audio-session-id")) {
                    int sessionId = 0;
                    try {
                        sessionId = (Integer)entry.getValue();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Wrong Session ID Parameter!");
                    }
                    keys[i] = "audio-hw-sync";
                    values[i] = AudioSystem.getAudioHwSyncForSession(sessionId);
                } else {
                    keys[i] = entry.getKey();
                    values[i] = entry.getValue();
                }
                ++i;
            }
        }
        this.native_configure(keys, values, surface, crypto, flags);
    }

    private void native_setCallback(Callback callback) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setCallback(Landroid/media/MediaCodec$Callback;)V", true, this);
    }

    private void native_configure(String[] stringArray, Object[] objectArray, Surface surface, MediaCrypto mediaCrypto, int n) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_configure([Ljava/lang/String;[Ljava/lang/Object;Landroid/view/Surface;Landroid/media/MediaCrypto;I)V", true, this);
    }

    public Surface createInputSurface() {
        return (Surface)OverrideMethod.invokeA("android.media.MediaCodec#createInputSurface()Landroid/view/Surface;", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.native_start();
        Object object = this.mBufferLock;
        synchronized (object) {
            this.cacheBuffers(true);
            this.cacheBuffers(false);
        }
    }

    private void native_start() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_start()V", true, this);
    }

    public void stop() {
        this.native_stop();
        this.freeAllTrackedBuffers();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeMessages(1);
            this.mEventHandler.removeMessages(2);
        }
    }

    private void native_stop() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_stop()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffers(this.mCachedInputBuffers);
            this.invalidateByteBuffers(this.mCachedOutputBuffers);
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
        this.native_flush();
    }

    private void native_flush() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_flush()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) throws CryptoException {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index);
            throw e;
        }
    }

    private void native_queueInputBuffer(int n, int n2, int n3, long l, int n4) throws CryptoException {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueInputBuffer(IIIJI)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) throws CryptoException {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index);
            throw e;
        }
    }

    private void native_queueSecureInputBuffer(int n, int n2, CryptoInfo cryptoInfo, long l, int n3) throws CryptoException {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueSecureInputBuffer(IILandroid/media/MediaCodec$CryptoInfo;JI)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeueInputBuffer(long timeoutUs) {
        int res = this.native_dequeueInputBuffer(timeoutUs);
        if (res >= 0) {
            Object object = this.mBufferLock;
            synchronized (object) {
                this.validateInputByteBuffer(this.mCachedInputBuffers, res);
            }
        }
        return res;
    }

    private int native_dequeueInputBuffer(long l) {
        return OverrideMethod.invokeI("android.media.MediaCodec#native_dequeueInputBuffer(J)I", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeueOutputBuffer(BufferInfo info, long timeoutUs) {
        int res = this.native_dequeueOutputBuffer(info, timeoutUs);
        Object object = this.mBufferLock;
        synchronized (object) {
            if (res == -3) {
                this.cacheBuffers(false);
            } else if (res >= 0) {
                this.validateOutputByteBuffer(this.mCachedOutputBuffers, res, info);
            }
        }
        return res;
    }

    private int native_dequeueOutputBuffer(BufferInfo bufferInfo, long l) {
        return OverrideMethod.invokeI("android.media.MediaCodec#native_dequeueOutputBuffer(Landroid/media/MediaCodec$BufferInfo;J)I", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutputBuffer(int index, boolean render) {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.remove(index);
        }
        this.releaseOutputBuffer(index, render, false, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutputBuffer(int index, long renderTimestampNs) {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.remove(index);
        }
        this.releaseOutputBuffer(index, true, true, renderTimestampNs);
    }

    private void releaseOutputBuffer(int n, boolean bl, boolean bl2, long l) {
        OverrideMethod.invokeV("android.media.MediaCodec#releaseOutputBuffer(IZZJ)V", true, this);
    }

    public void signalEndOfInputStream() {
        OverrideMethod.invokeV("android.media.MediaCodec#signalEndOfInputStream()V", true, this);
    }

    public MediaFormat getOutputFormat() {
        return new MediaFormat(this.getFormatNative(false));
    }

    public MediaFormat getInputFormat() {
        return new MediaFormat(this.getFormatNative(true));
    }

    public MediaFormat getOutputFormat(int index) {
        return new MediaFormat(this.getOutputFormatNative(index));
    }

    private Map<String, Object> getFormatNative(boolean bl) {
        return (Map)OverrideMethod.invokeA("android.media.MediaCodec#getFormatNative(Z)Ljava/util/Map;", true, this);
    }

    private Map<String, Object> getOutputFormatNative(int n) {
        return (Map)OverrideMethod.invokeA("android.media.MediaCodec#getOutputFormatNative(I)Ljava/util/Map;", true, this);
    }

    private void invalidateByteBuffer(ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(false);
        }
    }

    private void validateInputByteBuffer(ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidateByteBuffer(ByteBuffer[] buffers, int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            ByteBuffer buffer;
            if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
                buffer.setAccessible(true);
            }
        }
    }

    private void validateOutputByteBuffer(ByteBuffer[] buffers, int index, BufferInfo info) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.limit(info.offset + info.size).position(info.offset);
        }
    }

    private void invalidateByteBuffers(ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                if (buffer == null) continue;
                buffer.setAccessible(false);
            }
        }
    }

    private void freeByteBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            NioUtils.freeDirectBuffer(buffer);
        }
    }

    private void freeByteBuffers(ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                this.freeByteBuffer(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeAllTrackedBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.freeByteBuffers(this.mCachedInputBuffers);
            this.freeByteBuffers(this.mCachedOutputBuffers);
            this.mCachedInputBuffers = null;
            this.mCachedOutputBuffers = null;
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
    }

    private void cacheBuffers(boolean input) {
        ByteBuffer[] buffers = null;
        try {
            buffers = this.getBuffers(input);
            this.invalidateByteBuffers(buffers);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (input) {
            this.mCachedInputBuffers = buffers;
        } else {
            this.mCachedOutputBuffers = buffers;
        }
    }

    public ByteBuffer[] getInputBuffers() {
        if (this.mCachedInputBuffers == null) {
            throw new IllegalStateException();
        }
        return this.mCachedInputBuffers;
    }

    public ByteBuffer[] getOutputBuffers() {
        if (this.mCachedOutputBuffers == null) {
            throw new IllegalStateException();
        }
        return this.mCachedOutputBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getInputBuffer(int index) {
        ByteBuffer newBuffer = this.getBuffer(true, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getInputImage(int index) {
        Image newImage = this.getImage(true, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.put(index, newImage);
        }
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getOutputBuffer(int index) {
        ByteBuffer newBuffer = this.getBuffer(false, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getOutputImage(int index) {
        Image newImage = this.getImage(false, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.put(index, newImage);
        }
        return newImage;
    }

    public void setVideoScalingMode(int n) {
        OverrideMethod.invokeV("android.media.MediaCodec#setVideoScalingMode(I)V", true, this);
    }

    public String getName() {
        return (String)OverrideMethod.invokeA("android.media.MediaCodec#getName()Ljava/lang/String;", true, this);
    }

    public void setParameters(Bundle params) {
        if (params == null) {
            return;
        }
        String[] keys = new String[params.size()];
        Object[] values = new Object[params.size()];
        int i = 0;
        Iterator<String> i$ = params.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            keys[i] = key = i$.next();
            values[i] = params.get(key);
            ++i;
        }
        this.setParameters(keys, values);
    }

    public void setCallback(Callback cb) {
        if (this.mEventHandler != null) {
            Message msg = this.mEventHandler.obtainMessage(2, 0, 0, cb);
            this.mEventHandler.sendMessage(msg);
            this.native_setCallback(cb);
        }
    }

    private void postEventFromNative(int what, int arg1, int arg2, Object obj) {
        if (this.mEventHandler != null) {
            Message msg = this.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            this.mEventHandler.sendMessage(msg);
        }
    }

    private void setParameters(String[] stringArray, Object[] objectArray) {
        OverrideMethod.invokeV("android.media.MediaCodec#setParameters([Ljava/lang/String;[Ljava/lang/Object;)V", true, this);
    }

    public MediaCodecInfo getCodecInfo() {
        return MediaCodecList.getInfoFor(this.getName());
    }

    private ByteBuffer[] getBuffers(boolean bl) {
        return (ByteBuffer[])OverrideMethod.invokeA("android.media.MediaCodec#getBuffers(Z)[Ljava/nio/ByteBuffer;", true, this);
    }

    private ByteBuffer getBuffer(boolean bl, int n) {
        return (ByteBuffer)OverrideMethod.invokeA("android.media.MediaCodec#getBuffer(ZI)Ljava/nio/ByteBuffer;", true, this);
    }

    private Image getImage(boolean bl, int n) {
        return (Image)OverrideMethod.invokeA("android.media.MediaCodec#getImage(ZI)Landroid/media/Image;", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_init()V", true, null);
    }

    private void native_setup(String string2, boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setup(Ljava/lang/String;ZZ)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_finalize()V", true, this);
    }

    static {
        System.loadLibrary("media_jni");
        MediaCodec.native_init();
    }

    public static class MediaImage
    extends Image {
        private final boolean mIsReadOnly;
        private boolean mIsValid;
        private final int mWidth;
        private final int mHeight;
        private final int mFormat;
        private long mTimestamp;
        private final Image.Plane[] mPlanes;
        private final ByteBuffer mBuffer;
        private final ByteBuffer mInfo;
        private final int mXOffset;
        private final int mYOffset;
        private static final int TYPE_YUV = 1;

        @Override
        public int getFormat() {
            this.checkValid();
            return this.mFormat;
        }

        @Override
        public int getHeight() {
            this.checkValid();
            return this.mHeight;
        }

        @Override
        public int getWidth() {
            this.checkValid();
            return this.mWidth;
        }

        @Override
        public long getTimestamp() {
            this.checkValid();
            return this.mTimestamp;
        }

        @Override
        public Image.Plane[] getPlanes() {
            this.checkValid();
            return Arrays.copyOf(this.mPlanes, this.mPlanes.length);
        }

        @Override
        public void close() {
            if (this.mIsValid) {
                NioUtils.freeDirectBuffer(this.mBuffer);
                this.mIsValid = false;
            }
        }

        @Override
        public void setCropRect(Rect cropRect) {
            if (this.mIsReadOnly) {
                throw new ReadOnlyBufferException();
            }
            super.setCropRect(cropRect);
        }

        private void checkValid() {
            if (!this.mIsValid) {
                throw new IllegalStateException("Image is already released");
            }
        }

        private int readInt(ByteBuffer buffer, boolean asLong) {
            if (asLong) {
                return (int)buffer.getLong();
            }
            return buffer.getInt();
        }

        public MediaImage(ByteBuffer buffer, ByteBuffer info, boolean readOnly, long timestamp, int xOffset, int yOffset, Rect cropRect) {
            this.mFormat = 35;
            this.mTimestamp = timestamp;
            this.mIsValid = true;
            this.mIsReadOnly = buffer.isReadOnly();
            this.mBuffer = buffer.duplicate();
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            this.mInfo = info;
            if (info.remaining() == 80 || info.remaining() == 156 || info.remaining() == 160) {
                boolean sizeIsLong = info.remaining() != 80;
                int type = this.readInt(info, info.remaining() == 160);
                if (type != 1) {
                    throw new UnsupportedOperationException("unsupported type: " + type);
                }
                int numPlanes = this.readInt(info, sizeIsLong);
                if (numPlanes != 3) {
                    throw new RuntimeException("unexpected number of planes: " + numPlanes);
                }
                this.mWidth = this.readInt(info, sizeIsLong);
                this.mHeight = this.readInt(info, sizeIsLong);
                if (this.mWidth < 1 || this.mHeight < 1) {
                    throw new UnsupportedOperationException("unsupported size: " + this.mWidth + "x" + this.mHeight);
                }
                int bitDepth = this.readInt(info, sizeIsLong);
                if (bitDepth != 8) {
                    throw new UnsupportedOperationException("unsupported bit depth: " + bitDepth);
                }
                this.mPlanes = new MediaPlane[numPlanes];
                for (int ix = 0; ix < numPlanes; ++ix) {
                    int vert;
                    int planeOffset = this.readInt(info, sizeIsLong);
                    int colInc = this.readInt(info, sizeIsLong);
                    int rowInc = this.readInt(info, sizeIsLong);
                    int horiz = this.readInt(info, sizeIsLong);
                    if (horiz != (vert = this.readInt(info, sizeIsLong)) || horiz != (ix == 0 ? 1 : 2)) {
                        throw new UnsupportedOperationException("unexpected subsampling: " + horiz + "x" + vert + " on plane " + ix);
                    }
                    buffer.clear();
                    buffer.position(this.mBuffer.position() + planeOffset + xOffset / horiz * colInc + yOffset / vert * rowInc);
                    buffer.limit(buffer.position() + Utils.divUp(bitDepth, 8) + (this.mHeight / vert - 1) * rowInc + (this.mWidth / horiz - 1) * colInc);
                    this.mPlanes[ix] = new MediaPlane(buffer.slice(), rowInc, colInc);
                }
            } else {
                throw new UnsupportedOperationException("unsupported info length: " + info.remaining());
            }
            if (cropRect == null) {
                cropRect = new Rect(0, 0, this.mWidth, this.mHeight);
            }
            cropRect.offset(-xOffset, -yOffset);
            super.setCropRect(cropRect);
        }

        private class MediaPlane
        extends Image.Plane {
            private final int mRowInc;
            private final int mColInc;
            private final ByteBuffer mData;

            public MediaPlane(ByteBuffer buffer, int rowInc, int colInc) {
                this.mData = buffer;
                this.mRowInc = rowInc;
                this.mColInc = colInc;
            }

            @Override
            public int getRowStride() {
                MediaImage.this.checkValid();
                return this.mRowInc;
            }

            @Override
            public int getPixelStride() {
                MediaImage.this.checkValid();
                return this.mColInc;
            }

            @Override
            public ByteBuffer getBuffer() {
                MediaImage.this.checkValid();
                return this.mData;
            }
        }
    }

    public static abstract class Callback {
        public abstract void onInputBufferAvailable(MediaCodec var1, int var2);

        public abstract void onOutputBufferAvailable(MediaCodec var1, int var2, BufferInfo var3);

        public abstract void onError(MediaCodec var1, CodecException var2);

        public abstract void onOutputFormatChanged(MediaCodec var1, MediaFormat var2);
    }

    private static class BufferMap {
        private final Map<Integer, CodecBuffer> mMap = new HashMap<Integer, CodecBuffer>();

        private BufferMap() {
        }

        public void remove(int index) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer != null) {
                buffer.free();
                this.mMap.remove(index);
            }
        }

        public void put(int index, ByteBuffer newBuffer) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer();
                this.mMap.put(index, buffer);
            }
            buffer.setByteBuffer(newBuffer);
        }

        public void put(int index, Image newImage) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer();
                this.mMap.put(index, buffer);
            }
            buffer.setImage(newImage);
        }

        public void clear() {
            for (CodecBuffer buffer : this.mMap.values()) {
                buffer.free();
            }
            this.mMap.clear();
        }

        private static class CodecBuffer {
            private Image mImage;
            private ByteBuffer mByteBuffer;

            private CodecBuffer() {
            }

            public void free() {
                if (this.mByteBuffer != null) {
                    NioUtils.freeDirectBuffer(this.mByteBuffer);
                    this.mByteBuffer = null;
                }
                if (this.mImage != null) {
                    this.mImage.close();
                    this.mImage = null;
                }
            }

            public void setImage(Image image) {
                this.free();
                this.mImage = image;
            }

            public void setByteBuffer(ByteBuffer buffer) {
                this.free();
                this.mByteBuffer = buffer;
            }
        }
    }

    public static class CryptoInfo {
        public int numSubSamples;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public byte[] key;
        public byte[] iv;
        public int mode;

        public void set(int newNumSubSamples, int[] newNumBytesOfClearData, int[] newNumBytesOfEncryptedData, byte[] newKey, byte[] newIV, int newMode) {
            this.numSubSamples = newNumSubSamples;
            this.numBytesOfClearData = newNumBytesOfClearData;
            this.numBytesOfEncryptedData = newNumBytesOfEncryptedData;
            this.key = newKey;
            this.iv = newIV;
            this.mode = newMode;
        }

        public String toString() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append(this.numSubSamples + " subsamples, key [");
            String hexdigits = "0123456789abcdef";
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.key[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.key[i] & 0xF));
            }
            builder.append("], iv [");
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.iv[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.iv[i] & 0xF));
            }
            builder.append("], clear ");
            builder.append(Arrays.toString(this.numBytesOfClearData));
            builder.append(", encrypted ");
            builder.append(Arrays.toString(this.numBytesOfEncryptedData));
            return builder.toString();
        }
    }

    public static class CryptoException
    extends RuntimeException {
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_RESOURCE_BUSY = 3;
        public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        private int mErrorCode;

        public CryptoException(int errorCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }
    }

    public static class CodecException
    extends IllegalStateException {
        private static final int ACTION_TRANSIENT = 1;
        private static final int ACTION_RECOVERABLE = 2;
        private final String mDiagnosticInfo;
        private final int mErrorCode;
        private final int mActionCode;

        CodecException(int errorCode, int actionCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
            this.mActionCode = actionCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaCodec.error_" + sign + Math.abs(errorCode);
        }

        public boolean isTransient() {
            return this.mActionCode == 1;
        }

        public boolean isRecoverable() {
            return this.mActionCode == 2;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }
    }

    private class EventHandler
    extends Handler {
        private MediaCodec mCodec;

        public EventHandler(MediaCodec codec, Looper looper) {
            super(looper);
            this.mCodec = codec;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.handleCallback(msg);
                    break;
                }
                case 2: {
                    MediaCodec.this.mCallback = (Callback)msg.obj;
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCallback(Message msg) {
            if (MediaCodec.this.mCallback == null) {
                return;
            }
            switch (msg.arg1) {
                case 1: {
                    int index = msg.arg2;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        MediaCodec.this.validateInputByteBuffer(MediaCodec.this.mCachedInputBuffers, index);
                    }
                    MediaCodec.this.mCallback.onInputBufferAvailable(this.mCodec, index);
                    break;
                }
                case 2: {
                    int index = msg.arg2;
                    BufferInfo info = (BufferInfo)msg.obj;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        MediaCodec.this.validateOutputByteBuffer(MediaCodec.this.mCachedOutputBuffers, index, info);
                    }
                    MediaCodec.this.mCallback.onOutputBufferAvailable(this.mCodec, index, info);
                    break;
                }
                case 3: {
                    MediaCodec.this.mCallback.onError(this.mCodec, (CodecException)msg.obj);
                    break;
                }
                case 4: {
                    MediaCodec.this.mCallback.onOutputFormatChanged(this.mCodec, new MediaFormat((Map)msg.obj));
                    break;
                }
            }
        }
    }

    public static class BufferInfo {
        public int offset;
        public int size;
        public long presentationTimeUs;
        public int flags;

        public void set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            this.offset = newOffset;
            this.size = newSize;
            this.presentationTimeUs = newTimeUs;
            this.flags = newFlags;
        }
    }
}

