/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Rect;
import com.android.tools.layoutlib.java.AutoCloseable;
import java.nio.ByteBuffer;

public abstract class Image
implements AutoCloseable {
    private Rect mCropRect;

    protected Image() {
    }

    public abstract int getFormat();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract long getTimestamp();

    public Rect getCropRect() {
        if (this.mCropRect == null) {
            return new Rect(0, 0, this.getWidth(), this.getHeight());
        }
        return new Rect(this.mCropRect);
    }

    public void setCropRect(Rect cropRect) {
        if (cropRect != null) {
            cropRect = new Rect(cropRect);
            cropRect.intersect(0, 0, this.getWidth(), this.getHeight());
        }
        this.mCropRect = cropRect;
    }

    public abstract Plane[] getPlanes();

    @Override
    public abstract void close();

    public static abstract class Plane {
        protected Plane() {
        }

        public abstract int getRowStride();

        public abstract int getPixelStride();

        public abstract ByteBuffer getBuffer();
    }
}

