/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MutableBackgroundColorSpan;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.view.accessibility.CaptioningManager;
import java.util.ArrayList;
import java.util.Arrays;

class CCParser {
    public static final int MAX_ROWS = 15;
    public static final int MAX_COLS = 32;
    private static final String TAG = "CCParser";
    private static final boolean DEBUG = Log.isLoggable("CCParser", 3);
    private static final int INVALID = -1;
    private static final int RCL = 32;
    private static final int BS = 33;
    private static final int AOF = 34;
    private static final int AON = 35;
    private static final int DER = 36;
    private static final int RU2 = 37;
    private static final int RU3 = 38;
    private static final int RU4 = 39;
    private static final int FON = 40;
    private static final int RDC = 41;
    private static final int TR = 42;
    private static final int RTD = 43;
    private static final int EDM = 44;
    private static final int CR = 45;
    private static final int ENM = 46;
    private static final int EOC = 47;
    private static final char TS = '\u00a0';
    private static final int MODE_UNKNOWN = 0;
    private static final int MODE_PAINT_ON = 1;
    private static final int MODE_ROLL_UP = 2;
    private static final int MODE_POP_ON = 3;
    private static final int MODE_TEXT = 4;
    private final DisplayListener mListener;
    private int mMode = 1;
    private int mRollUpSize = 4;
    private CCMemory mDisplay = new CCMemory();
    private CCMemory mNonDisplay = new CCMemory();
    private CCMemory mTextMem = new CCMemory();

    CCParser(DisplayListener listener) {
        this.mListener = listener;
    }

    void parse(byte[] data) {
        CCData[] ccData = CCData.fromByteArray(data);
        for (int i = 0; i < ccData.length; ++i) {
            if (DEBUG) {
                Log.d(TAG, ccData[i].toString());
            }
            if (this.handleCtrlCode(ccData[i]) || this.handleTabOffsets(ccData[i]) || this.handlePACCode(ccData[i]) || this.handleMidRowCode(ccData[i])) continue;
            this.handleDisplayableChars(ccData[i]);
        }
    }

    private CCMemory getMemory() {
        switch (this.mMode) {
            case 3: {
                return this.mNonDisplay;
            }
            case 4: {
                return this.mTextMem;
            }
            case 1: 
            case 2: {
                return this.mDisplay;
            }
        }
        Log.w(TAG, "unrecoginized mode: " + this.mMode);
        return this.mDisplay;
    }

    private boolean handleDisplayableChars(CCData ccData) {
        if (!ccData.isDisplayableChar()) {
            return false;
        }
        if (ccData.isExtendedChar()) {
            this.getMemory().bs();
        }
        this.getMemory().writeText(ccData.getDisplayText());
        if (this.mMode == 1 || this.mMode == 2) {
            this.updateDisplay();
        }
        return true;
    }

    private boolean handleMidRowCode(CCData ccData) {
        StyleCode m = ccData.getMidRow();
        if (m != null) {
            this.getMemory().writeMidRowCode(m);
            return true;
        }
        return false;
    }

    private boolean handlePACCode(CCData ccData) {
        PAC pac = ccData.getPAC();
        if (pac != null) {
            if (this.mMode == 2) {
                this.getMemory().moveBaselineTo(pac.getRow(), this.mRollUpSize);
            }
            this.getMemory().writePAC(pac);
            return true;
        }
        return false;
    }

    private boolean handleTabOffsets(CCData ccData) {
        int tabs = ccData.getTabOffset();
        if (tabs > 0) {
            this.getMemory().tab(tabs);
            return true;
        }
        return false;
    }

    private boolean handleCtrlCode(CCData ccData) {
        int ctrlCode = ccData.getCtrlCode();
        switch (ctrlCode) {
            case 32: {
                this.mMode = 3;
                break;
            }
            case 33: {
                this.getMemory().bs();
                break;
            }
            case 36: {
                this.getMemory().der();
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                this.mRollUpSize = ctrlCode - 35;
                if (this.mMode != 2) {
                    this.mDisplay.erase();
                    this.mNonDisplay.erase();
                }
                this.mMode = 2;
                break;
            }
            case 40: {
                Log.i(TAG, "Flash On");
                break;
            }
            case 41: {
                this.mMode = 1;
                break;
            }
            case 42: {
                this.mMode = 4;
                this.mTextMem.erase();
                break;
            }
            case 43: {
                this.mMode = 4;
                break;
            }
            case 44: {
                this.mDisplay.erase();
                this.updateDisplay();
                break;
            }
            case 45: {
                if (this.mMode == 2) {
                    this.getMemory().rollUp(this.mRollUpSize);
                } else {
                    this.getMemory().cr();
                }
                if (this.mMode != 2) break;
                this.updateDisplay();
                break;
            }
            case 46: {
                this.mNonDisplay.erase();
                break;
            }
            case 47: {
                this.swapMemory();
                this.mMode = 3;
                this.updateDisplay();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void updateDisplay() {
        if (this.mListener != null) {
            CaptioningManager.CaptionStyle captionStyle = this.mListener.getCaptionStyle();
            this.mListener.onDisplayChanged(this.mDisplay.getStyledText(captionStyle));
        }
    }

    private void swapMemory() {
        CCMemory temp = this.mDisplay;
        this.mDisplay = this.mNonDisplay;
        this.mNonDisplay = temp;
    }

    private static class CCData {
        private final byte mType;
        private final byte mData1;
        private final byte mData2;
        private static final String[] mCtrlCodeMap = new String[]{"RCL", "BS", "AOF", "AON", "DER", "RU2", "RU3", "RU4", "FON", "RDC", "TR", "RTD", "EDM", "CR", "ENM", "EOC"};
        private static final String[] mSpecialCharMap = new String[]{"\u00ae", "\u00b0", "\u00bd", "\u00bf", "\u2122", "\u00a2", "\u00a3", "\u266a", "\u00e0", "\u00a0", "\u00e8", "\u00e2", "\u00ea", "\u00ee", "\u00f4", "\u00fb"};
        private static final String[] mSpanishCharMap = new String[]{"\u00c1", "\u00c9", "\u00d3", "\u00da", "\u00dc", "\u00fc", "\u2018", "\u00a1", "*", "'", "\u2014", "\u00a9", "\u2120", "\u2022", "\u201c", "\u201d", "\u00c0", "\u00c2", "\u00c7", "\u00c8", "\u00ca", "\u00cb", "\u00eb", "\u00ce", "\u00cf", "\u00ef", "\u00d4", "\u00d9", "\u00f9", "\u00db", "\u00ab", "\u00bb"};
        private static final String[] mProtugueseCharMap = new String[]{"\u00c3", "\u00e3", "\u00cd", "\u00cc", "\u00ec", "\u00d2", "\u00f2", "\u00d5", "\u00f5", "{", "}", "\\", "^", "_", "|", "~", "\u00c4", "\u00e4", "\u00d6", "\u00f6", "\u00df", "\u00a5", "\u00a4", "\u2502", "\u00c5", "\u00e5", "\u00d8", "\u00f8", "\u250c", "\u2510", "\u2514", "\u2518"};

        static CCData[] fromByteArray(byte[] data) {
            CCData[] ccData = new CCData[data.length / 3];
            for (int i = 0; i < ccData.length; ++i) {
                ccData[i] = new CCData(data[i * 3], data[i * 3 + 1], data[i * 3 + 2]);
            }
            return ccData;
        }

        CCData(byte type, byte data1, byte data2) {
            this.mType = type;
            this.mData1 = data1;
            this.mData2 = data2;
        }

        int getCtrlCode() {
            if ((this.mData1 == 20 || this.mData1 == 28) && this.mData2 >= 32 && this.mData2 <= 47) {
                return this.mData2;
            }
            return -1;
        }

        StyleCode getMidRow() {
            if ((this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 32 && this.mData2 <= 47) {
                return StyleCode.fromByte(this.mData2);
            }
            return null;
        }

        PAC getPAC() {
            if ((this.mData1 & 0x70) == 16 && (this.mData2 & 0x40) == 64 && ((this.mData1 & 7) != 0 || (this.mData2 & 0x20) == 0)) {
                return PAC.fromBytes(this.mData1, this.mData2);
            }
            return null;
        }

        int getTabOffset() {
            if ((this.mData1 == 23 || this.mData1 == 31) && this.mData2 >= 33 && this.mData2 <= 35) {
                return this.mData2 & 3;
            }
            return 0;
        }

        boolean isDisplayableChar() {
            return this.isBasicChar() || this.isSpecialChar() || this.isExtendedChar();
        }

        String getDisplayText() {
            String str = this.getBasicChars();
            if (str == null && (str = this.getSpecialChar()) == null) {
                str = this.getExtendedChar();
            }
            return str;
        }

        private String ctrlCodeToString(int ctrlCode) {
            return mCtrlCodeMap[ctrlCode - 32];
        }

        private boolean isBasicChar() {
            return this.mData1 >= 32 && this.mData1 <= 127;
        }

        private boolean isSpecialChar() {
            return (this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 48 && this.mData2 <= 63;
        }

        private boolean isExtendedChar() {
            return (this.mData1 == 18 || this.mData1 == 26 || this.mData1 == 19 || this.mData1 == 27) && this.mData2 >= 32 && this.mData2 <= 63;
        }

        private char getBasicChar(byte data) {
            char c;
            switch (data) {
                case 42: {
                    c = '\u00e1';
                    break;
                }
                case 92: {
                    c = '\u00e9';
                    break;
                }
                case 94: {
                    c = '\u00ed';
                    break;
                }
                case 95: {
                    c = '\u00f3';
                    break;
                }
                case 96: {
                    c = '\u00fa';
                    break;
                }
                case 123: {
                    c = '\u00e7';
                    break;
                }
                case 124: {
                    c = '\u00f7';
                    break;
                }
                case 125: {
                    c = '\u00d1';
                    break;
                }
                case 126: {
                    c = '\u00f1';
                    break;
                }
                case 127: {
                    c = '\u2588';
                    break;
                }
                default: {
                    c = (char)data;
                }
            }
            return c;
        }

        private String getBasicChars() {
            if (this.mData1 >= 32 && this.mData1 <= 127) {
                StringBuilder builder = new StringBuilder(2);
                builder.append(this.getBasicChar(this.mData1));
                if (this.mData2 >= 32 && this.mData2 <= 127) {
                    builder.append(this.getBasicChar(this.mData2));
                }
                return builder.toString();
            }
            return null;
        }

        private String getSpecialChar() {
            if ((this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 48 && this.mData2 <= 63) {
                return mSpecialCharMap[this.mData2 - 48];
            }
            return null;
        }

        private String getExtendedChar() {
            if ((this.mData1 == 18 || this.mData1 == 26) && this.mData2 >= 32 && this.mData2 <= 63) {
                return mSpanishCharMap[this.mData2 - 32];
            }
            if ((this.mData1 == 19 || this.mData1 == 27) && this.mData2 >= 32 && this.mData2 <= 63) {
                return mProtugueseCharMap[this.mData2 - 32];
            }
            return null;
        }

        public String toString() {
            if (this.mData1 < 16 && this.mData2 < 16) {
                return String.format("[%d]Null: %02x %02x", this.mType, this.mData1, this.mData2);
            }
            int ctrlCode = this.getCtrlCode();
            if (ctrlCode != -1) {
                return String.format("[%d]%s", this.mType, this.ctrlCodeToString(ctrlCode));
            }
            int tabOffset = this.getTabOffset();
            if (tabOffset > 0) {
                return String.format("[%d]Tab%d", this.mType, tabOffset);
            }
            PAC pac = this.getPAC();
            if (pac != null) {
                return String.format("[%d]PAC: %s", this.mType, pac.toString());
            }
            StyleCode m = this.getMidRow();
            if (m != null) {
                return String.format("[%d]Mid-row: %s", this.mType, m.toString());
            }
            if (this.isDisplayableChar()) {
                return String.format("[%d]Displayable: %s (%02x %02x)", this.mType, this.getDisplayText(), this.mData1, this.mData2);
            }
            return String.format("[%d]Invalid: %02x %02x", this.mType, this.mData1, this.mData2);
        }
    }

    private static class CCMemory {
        private final String mBlankLine;
        private final CCLineBuilder[] mLines = new CCLineBuilder[17];
        private int mRow;
        private int mCol;

        CCMemory() {
            char[] blank = new char[34];
            Arrays.fill(blank, '\u00a0');
            this.mBlankLine = new String(blank);
        }

        void erase() {
            for (int i = 0; i < this.mLines.length; ++i) {
                this.mLines[i] = null;
            }
            this.mRow = 15;
            this.mCol = 1;
        }

        void der() {
            if (this.mLines[this.mRow] != null) {
                for (int i = 0; i < this.mCol; ++i) {
                    if (this.mLines[this.mRow].charAt(i) == '\u00a0') continue;
                    for (int j = this.mCol; j < this.mLines[this.mRow].length(); ++j) {
                        this.mLines[j].setCharAt(j, '\u00a0');
                    }
                    return;
                }
                this.mLines[this.mRow] = null;
            }
        }

        void tab(int tabs) {
            this.moveCursorByCol(tabs);
        }

        void bs() {
            this.moveCursorByCol(-1);
            if (this.mLines[this.mRow] != null) {
                this.mLines[this.mRow].setCharAt(this.mCol, '\u00a0');
                if (this.mCol == 31) {
                    this.mLines[this.mRow].setCharAt(32, '\u00a0');
                }
            }
        }

        void cr() {
            this.moveCursorTo(this.mRow + 1, 1);
        }

        void rollUp(int windowSize) {
            int i;
            for (i = 0; i <= this.mRow - windowSize; ++i) {
                this.mLines[i] = null;
            }
            int startRow = this.mRow - windowSize + 1;
            if (startRow < 1) {
                startRow = 1;
            }
            for (i = startRow; i < this.mRow; ++i) {
                this.mLines[i] = this.mLines[i + 1];
            }
            for (i = this.mRow; i < this.mLines.length; ++i) {
                this.mLines[i] = null;
            }
            this.mCol = 1;
        }

        void writeText(String text) {
            for (int i = 0; i < text.length(); ++i) {
                this.getLineBuffer(this.mRow).setCharAt(this.mCol, text.charAt(i));
                this.moveCursorByCol(1);
            }
        }

        void writeMidRowCode(StyleCode m) {
            this.getLineBuffer(this.mRow).setMidRowAt(this.mCol, m);
            this.moveCursorByCol(1);
        }

        void writePAC(PAC pac) {
            if (pac.isIndentPAC()) {
                this.moveCursorTo(pac.getRow(), pac.getCol());
            } else {
                this.moveCursorTo(pac.getRow(), 1);
            }
            this.getLineBuffer(this.mRow).setPACAt(this.mCol, pac);
        }

        SpannableStringBuilder[] getStyledText(CaptioningManager.CaptionStyle captionStyle) {
            ArrayList<SpannableStringBuilder> rows = new ArrayList<SpannableStringBuilder>(15);
            for (int i = 1; i <= 15; ++i) {
                rows.add(this.mLines[i] != null ? this.mLines[i].getStyledText(captionStyle) : null);
            }
            return rows.toArray(new SpannableStringBuilder[15]);
        }

        private static int clamp(int x, int min, int max) {
            return x < min ? min : (x > max ? max : x);
        }

        private void moveCursorTo(int row, int col) {
            this.mRow = CCMemory.clamp(row, 1, 15);
            this.mCol = CCMemory.clamp(col, 1, 32);
        }

        private void moveCursorToRow(int row) {
            this.mRow = CCMemory.clamp(row, 1, 15);
        }

        private void moveCursorByCol(int col) {
            this.mCol = CCMemory.clamp(this.mCol + col, 1, 32);
        }

        private void moveBaselineTo(int baseRow, int windowSize) {
            int i;
            if (this.mRow == baseRow) {
                return;
            }
            int actualWindowSize = windowSize;
            if (baseRow < actualWindowSize) {
                actualWindowSize = baseRow;
            }
            if (this.mRow < actualWindowSize) {
                actualWindowSize = this.mRow;
            }
            if (baseRow < this.mRow) {
                for (i = actualWindowSize - 1; i >= 0; --i) {
                    this.mLines[baseRow - i] = this.mLines[this.mRow - i];
                }
            } else {
                for (i = 0; i < actualWindowSize; ++i) {
                    this.mLines[baseRow - i] = this.mLines[this.mRow - i];
                }
            }
            for (i = 0; i <= baseRow - windowSize; ++i) {
                this.mLines[i] = null;
            }
            for (i = baseRow + 1; i < this.mLines.length; ++i) {
                this.mLines[i] = null;
            }
        }

        private CCLineBuilder getLineBuffer(int row) {
            if (this.mLines[row] == null) {
                this.mLines[row] = new CCLineBuilder(this.mBlankLine);
            }
            return this.mLines[row];
        }
    }

    private static class CCLineBuilder {
        private final StringBuilder mDisplayChars;
        private final StyleCode[] mMidRowStyles;
        private final StyleCode[] mPACStyles;

        CCLineBuilder(String str) {
            this.mDisplayChars = new StringBuilder(str);
            this.mMidRowStyles = new StyleCode[this.mDisplayChars.length()];
            this.mPACStyles = new StyleCode[this.mDisplayChars.length()];
        }

        void setCharAt(int index, char ch) {
            this.mDisplayChars.setCharAt(index, ch);
            this.mMidRowStyles[index] = null;
        }

        void setMidRowAt(int index, StyleCode m) {
            this.mDisplayChars.setCharAt(index, ' ');
            this.mMidRowStyles[index] = m;
        }

        void setPACAt(int index, PAC pac) {
            this.mPACStyles[index] = pac;
        }

        char charAt(int index) {
            return this.mDisplayChars.charAt(index);
        }

        int length() {
            return this.mDisplayChars.length();
        }

        void applyStyleSpan(SpannableStringBuilder styledText, StyleCode s, int start, int end) {
            if (s.isItalics()) {
                styledText.setSpan(new StyleSpan(2), start, end, 33);
            }
            if (s.isUnderline()) {
                styledText.setSpan(new UnderlineSpan(), start, end, 33);
            }
        }

        SpannableStringBuilder getStyledText(CaptioningManager.CaptionStyle captionStyle) {
            SpannableStringBuilder styledText = new SpannableStringBuilder(this.mDisplayChars);
            int start = -1;
            int styleStart = -1;
            StyleCode curStyle = null;
            for (int next = 0; next < this.mDisplayChars.length(); ++next) {
                StyleCode newStyle = null;
                if (this.mMidRowStyles[next] != null) {
                    newStyle = this.mMidRowStyles[next];
                } else if (this.mPACStyles[next] != null && (styleStart < 0 || start < 0)) {
                    newStyle = this.mPACStyles[next];
                }
                if (newStyle != null) {
                    curStyle = newStyle;
                    if (styleStart >= 0 && start >= 0) {
                        this.applyStyleSpan(styledText, newStyle, styleStart, next);
                    }
                    styleStart = next;
                }
                if (this.mDisplayChars.charAt(next) != '\u00a0') {
                    if (start >= 0) continue;
                    start = next;
                    continue;
                }
                if (start < 0) continue;
                int expandedStart = this.mDisplayChars.charAt(start) == ' ' ? start : start - 1;
                int expandedEnd = this.mDisplayChars.charAt(next - 1) == ' ' ? next : next + 1;
                styledText.setSpan(new MutableBackgroundColorSpan(captionStyle.backgroundColor), expandedStart, expandedEnd, 33);
                if (styleStart >= 0) {
                    this.applyStyleSpan(styledText, curStyle, styleStart, expandedEnd);
                }
                start = -1;
            }
            return styledText;
        }
    }

    private static class PAC
    extends StyleCode {
        final int mRow;
        final int mCol;

        static PAC fromBytes(byte data1, byte data2) {
            int[] rowTable = new int[]{11, 1, 3, 12, 14, 5, 7, 9};
            int row = rowTable[data1 & 7] + ((data2 & 0x20) >> 5);
            int style2 = 0;
            if ((data2 & 1) != 0) {
                style2 |= 2;
            }
            if ((data2 & 0x10) != 0) {
                int indent = data2 >> 1 & 7;
                return new PAC(row, indent * 4, style2, 0);
            }
            int color2 = data2 >> 1 & 7;
            if (color2 == 7) {
                color2 = 0;
                style2 |= 1;
            }
            return new PAC(row, -1, style2, color2);
        }

        PAC(int row, int col, int style2, int color2) {
            super(style2, color2);
            this.mRow = row;
            this.mCol = col;
        }

        boolean isIndentPAC() {
            return this.mCol >= 0;
        }

        int getRow() {
            return this.mRow;
        }

        int getCol() {
            return this.mCol;
        }

        @Override
        public String toString() {
            return String.format("{%d, %d}, %s", this.mRow, this.mCol, super.toString());
        }
    }

    private static class StyleCode {
        static final int COLOR_WHITE = 0;
        static final int COLOR_GREEN = 1;
        static final int COLOR_BLUE = 2;
        static final int COLOR_CYAN = 3;
        static final int COLOR_RED = 4;
        static final int COLOR_YELLOW = 5;
        static final int COLOR_MAGENTA = 6;
        static final int COLOR_INVALID = 7;
        static final int STYLE_ITALICS = 1;
        static final int STYLE_UNDERLINE = 2;
        static final String[] mColorMap = new String[]{"WHITE", "GREEN", "BLUE", "CYAN", "RED", "YELLOW", "MAGENTA", "INVALID"};
        final int mStyle;
        final int mColor;

        static StyleCode fromByte(byte data2) {
            int style2 = 0;
            int color2 = data2 >> 1 & 7;
            if ((data2 & 1) != 0) {
                style2 |= 2;
            }
            if (color2 == 7) {
                color2 = 0;
                style2 |= 1;
            }
            return new StyleCode(style2, color2);
        }

        StyleCode(int style2, int color2) {
            this.mStyle = style2;
            this.mColor = color2;
        }

        boolean isItalics() {
            return (this.mStyle & 1) != 0;
        }

        boolean isUnderline() {
            return (this.mStyle & 2) != 0;
        }

        int getColor() {
            return this.mColor;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("{");
            str.append(mColorMap[this.mColor]);
            if ((this.mStyle & 1) != 0) {
                str.append(", ITALICS");
            }
            if ((this.mStyle & 2) != 0) {
                str.append(", UNDERLINE");
            }
            str.append("}");
            return str.toString();
        }
    }

    static interface DisplayListener {
        public void onDisplayChanged(SpannableStringBuilder[] var1);

        public CaptioningManager.CaptionStyle getCaptionStyle();
    }
}

