/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.MediaRecorder;
import android.media.MediaSyncEvent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public class AudioRecord {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int RECORDSTATE_STOPPED = 1;
    public static final int RECORDSTATE_RECORDING = 3;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_INVALID_OPERATION = -3;
    private static final int AUDIORECORD_ERROR_SETUP_ZEROFRAMECOUNT = -16;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDCHANNELMASK = -17;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDFORMAT = -18;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDSOURCE = -19;
    private static final int AUDIORECORD_ERROR_SETUP_NATIVEINITFAILED = -20;
    private static final int NATIVE_EVENT_MARKER = 2;
    private static final int NATIVE_EVENT_NEW_POS = 3;
    private static final String TAG = "android.media.AudioRecord";
    public static final String SUBMIX_FIXED_VOLUME = "fixedVolume";
    private long mNativeRecorderInJavaObj;
    private long mNativeCallbackCookie;
    private int mSampleRate;
    private int mChannelCount;
    private int mChannelMask;
    private int mAudioFormat;
    private int mRecordSource;
    private int mState = 0;
    private int mRecordingState = 1;
    private final Object mRecordingStateLock = new Object();
    private OnRecordPositionUpdateListener mPositionListener = null;
    private final Object mPositionListenerLock = new Object();
    private NativeEventHandler mEventHandler = null;
    private Looper mInitializationLooper = null;
    private int mNativeBufferSizeInBytes = 0;
    private int mSessionId = 0;
    private AudioAttributes mAudioAttributes;
    private boolean mIsSubmixFullVolume = false;
    private final IBinder mICallBack = new Binder();

    public AudioRecord(int audioSource, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setInternalCapturePreset(audioSource).build(), new AudioFormat.Builder().setChannelMask(AudioRecord.getChannelMaskFromLegacyConfig(channelConfig, true)).setEncoding(audioFormat).setSampleRate(sampleRateInHz).build(), bufferSizeInBytes, 0);
    }

    public AudioRecord(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int sessionId) throws IllegalArgumentException {
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        this.mInitializationLooper = Looper.myLooper();
        if (this.mInitializationLooper == null) {
            this.mInitializationLooper = Looper.getMainLooper();
        }
        if (attributes.getCapturePreset() == 8) {
            AudioAttributes.Builder filteredAttr = new AudioAttributes.Builder();
            for (String tag : attributes.getTags()) {
                if (tag.equalsIgnoreCase(SUBMIX_FIXED_VOLUME)) {
                    this.mIsSubmixFullVolume = true;
                    Log.v(TAG, "Will record from REMOTE_SUBMIX at full fixed volume");
                    continue;
                }
                filteredAttr.addTag(tag);
            }
            filteredAttr.setInternalCapturePreset(attributes.getCapturePreset());
            this.mAudioAttributes = filteredAttr.build();
        } else {
            this.mAudioAttributes = attributes;
        }
        int rate = 0;
        if ((format.getPropertySetMask() & 2) != 0) {
            rate = format.getSampleRate();
        } else {
            rate = AudioSystem.getPrimaryOutputSamplingRate();
            if (rate <= 0) {
                rate = 44100;
            }
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(attributes.getCapturePreset(), rate, encoding);
        this.mChannelCount = AudioFormat.channelCountFromInChannelMask(format.getChannelMask());
        this.mChannelMask = AudioRecord.getChannelMaskFromLegacyConfig(format.getChannelMask(), false);
        this.audioBuffSizeCheck(bufferSizeInBytes);
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioRecord>(this), this.mAudioAttributes, this.mSampleRate, this.mChannelMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, session);
        if (initResult != 0) {
            AudioRecord.loge("Error code " + initResult + " when initializing native AudioRecord object.");
            return;
        }
        this.mSessionId = session[0];
        this.mState = 1;
    }

    private static int getChannelMaskFromLegacyConfig(int inChannelConfig, boolean allowLegacyConfig) {
        int mask;
        switch (inChannelConfig) {
            case 1: 
            case 2: 
            case 16: {
                mask = 16;
                break;
            }
            case 3: 
            case 12: {
                mask = 12;
                break;
            }
            case 48: {
                mask = inChannelConfig;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel configuration.");
            }
        }
        if (!(allowLegacyConfig || inChannelConfig != 2 && inChannelConfig != 3)) {
            throw new IllegalArgumentException("Unsupported deprecated configuration.");
        }
        return mask;
    }

    private void audioParamCheck(int audioSource, int sampleRateInHz, int audioFormat) throws IllegalArgumentException {
        if (audioSource < 0 || audioSource > MediaRecorder.getAudioSourceMax() && audioSource != 1998 && audioSource != 1999) {
            throw new IllegalArgumentException("Invalid audio source.");
        }
        this.mRecordSource = audioSource;
        if (sampleRateInHz < 4000 || sampleRateInHz > 48000) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        switch (audioFormat) {
            case 1: {
                this.mAudioFormat = 2;
                break;
            }
            case 2: 
            case 3: {
                this.mAudioFormat = audioFormat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sample encoding. Should be ENCODING_PCM_8BIT or ENCODING_PCM_16BIT.");
            }
        }
    }

    private void audioBuffSizeCheck(int audioBufferSize) throws IllegalArgumentException {
        int frameSizeInBytes = this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat);
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
    }

    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.native_release();
        this.mState = 0;
    }

    protected void finalize() {
        this.release();
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getAudioSource() {
        return this.mRecordSource;
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getChannelConfiguration() {
        return this.mChannelMask;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordingState() {
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            return this.mRecordingState;
        }
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 16: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: 
            case 48: {
                channelCount = 2;
                break;
            }
            default: {
                AudioRecord.loge("getMinBufferSize(): Invalid channel configuration.");
                return -2;
            }
        }
        if (audioFormat != 2) {
            AudioRecord.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        int size = AudioRecord.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size == 0) {
            return -2;
        }
        if (size == -1) {
            return -1;
        }
        return size;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(0, 0) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording(MediaSyncEvent syncEvent) throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(syncEvent.getType(), syncEvent.getAudioSessionId()) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            this.handleFullVolumeRec(false);
            this.native_stop();
            this.mRecordingState = 1;
        }
    }

    private void handleFullVolumeRec(boolean starting) {
        if (!this.mIsSubmixFullVolume) {
            return;
        }
        IBinder b = ServiceManager.getService("audio");
        IAudioService ias = IAudioService.Stub.asInterface(b);
        try {
            ias.forceRemoteSubmixFullVolume(starting, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to AudioService when handling full submix volume", e);
        }
    }

    public int read(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        if (this.mState != 1) {
            return -3;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        return this.native_read_in_byte_array(audioData, offsetInBytes, sizeInBytes);
    }

    public int read(short[] audioData, int offsetInShorts, int sizeInShorts) {
        if (this.mState != 1) {
            return -3;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        return this.native_read_in_short_array(audioData, offsetInShorts, sizeInShorts);
    }

    public int read(ByteBuffer audioBuffer, int sizeInBytes) {
        if (this.mState != 1) {
            return -3;
        }
        if (audioBuffer == null || sizeInBytes < 0) {
            return -2;
        }
        return this.native_read_in_direct_buffer(audioBuffer, sizeInBytes);
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener) {
        this.setRecordPositionUpdateListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener, Handler handler) {
        Object object = this.mPositionListenerLock;
        synchronized (object) {
            this.mPositionListener = listener;
            this.mEventHandler = listener != null ? (handler != null ? new NativeEventHandler(this, handler.getLooper()) : new NativeEventHandler(this, this.mInitializationLooper)) : null;
        }
    }

    public int setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    public int setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    private static void postEventFromNative(Object audiorecord_ref, int what, int arg1, int arg2, Object obj) {
        AudioRecord recorder = (AudioRecord)((WeakReference)audiorecord_ref).get();
        if (recorder == null) {
            return;
        }
        if (recorder.mEventHandler != null) {
            Message m = recorder.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            recorder.mEventHandler.sendMessage(m);
        }
    }

    private int native_setup(Object object, Object object2, int n, int n2, int n3, int n4, int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_setup(Ljava/lang/Object;Ljava/lang/Object;IIII[I)I", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.AudioRecord#native_finalize()V", true, this);
    }

    private void native_release() {
        OverrideMethod.invokeV("android.media.AudioRecord#native_release()V", true, this);
    }

    private int native_start(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_start(II)I", true, this);
    }

    private void native_stop() {
        OverrideMethod.invokeV("android.media.AudioRecord#native_stop()V", true, this);
    }

    private int native_read_in_byte_array(byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_read_in_byte_array([BII)I", true, this);
    }

    private int native_read_in_short_array(short[] sArray, int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_read_in_short_array([SII)I", true, this);
    }

    private int native_read_in_direct_buffer(Object object, int n) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_read_in_direct_buffer(Ljava/lang/Object;I)I", true, this);
    }

    private int native_set_marker_pos(int n) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_set_marker_pos(I)I", true, this);
    }

    private int native_get_marker_pos() {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_marker_pos()I", true, this);
    }

    private int native_set_pos_update_period(int n) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_set_pos_update_period(I)I", true, this);
    }

    private int native_get_pos_update_period() {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_pos_update_period()I", true, this);
    }

    private static int native_get_min_buff_size(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_min_buff_size(III)I", true, null);
    }

    private static void logd(String msg) {
        Log.d(TAG, msg);
    }

    private static void loge(String msg) {
        Log.e(TAG, msg);
    }

    private class NativeEventHandler
    extends Handler {
        private final AudioRecord mAudioRecord;

        NativeEventHandler(AudioRecord recorder, Looper looper) {
            super(looper);
            this.mAudioRecord = recorder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            OnRecordPositionUpdateListener listener = null;
            Object object = AudioRecord.this.mPositionListenerLock;
            synchronized (object) {
                listener = this.mAudioRecord.mPositionListener;
            }
            switch (msg.what) {
                case 2: {
                    if (listener == null) break;
                    listener.onMarkerReached(this.mAudioRecord);
                    break;
                }
                case 3: {
                    if (listener == null) break;
                    listener.onPeriodicNotification(this.mAudioRecord);
                    break;
                }
                default: {
                    AudioRecord.loge("Unknown native event type: " + msg.what);
                }
            }
        }
    }

    public static interface OnRecordPositionUpdateListener {
        public void onMarkerReached(AudioRecord var1);

        public void onPeriodicNotification(AudioRecord var1);
    }
}

