/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class GpsClock
implements Parcelable {
    private static final String TAG = "GpsClock";
    public static final byte TYPE_UNKNOWN = 0;
    public static final byte TYPE_LOCAL_HW_TIME = 1;
    public static final byte TYPE_GPS_TIME = 2;
    private static final short HAS_NO_FLAGS = 0;
    private static final short HAS_LEAP_SECOND = 1;
    private static final short HAS_TIME_UNCERTAINTY = 2;
    private static final short HAS_FULL_BIAS = 4;
    private static final short HAS_BIAS = 8;
    private static final short HAS_BIAS_UNCERTAINTY = 16;
    private static final short HAS_DRIFT = 32;
    private static final short HAS_DRIFT_UNCERTAINTY = 64;
    private short mFlags;
    private short mLeapSecond;
    private byte mType;
    private long mTimeInNs;
    private double mTimeUncertaintyInNs;
    private long mFullBiasInNs;
    private double mBiasInNs;
    private double mBiasUncertaintyInNs;
    private double mDriftInNsPerSec;
    private double mDriftUncertaintyInNsPerSec;
    public static final Parcelable.Creator<GpsClock> CREATOR = new Parcelable.Creator<GpsClock>(){

        @Override
        public GpsClock createFromParcel(Parcel parcel) {
            GpsClock gpsClock = new GpsClock();
            gpsClock.mFlags = (short)parcel.readInt();
            gpsClock.mLeapSecond = (short)parcel.readInt();
            gpsClock.mType = parcel.readByte();
            gpsClock.mTimeInNs = parcel.readLong();
            gpsClock.mTimeUncertaintyInNs = parcel.readDouble();
            gpsClock.mFullBiasInNs = parcel.readLong();
            gpsClock.mBiasInNs = parcel.readDouble();
            gpsClock.mBiasUncertaintyInNs = parcel.readDouble();
            gpsClock.mDriftInNsPerSec = parcel.readDouble();
            gpsClock.mDriftUncertaintyInNsPerSec = parcel.readDouble();
            return gpsClock;
        }

        public GpsClock[] newArray(int size) {
            return new GpsClock[size];
        }
    };

    GpsClock() {
        this.initialize();
    }

    public void set(GpsClock clock) {
        this.mFlags = clock.mFlags;
        this.mLeapSecond = clock.mLeapSecond;
        this.mType = clock.mType;
        this.mTimeInNs = clock.mTimeInNs;
        this.mTimeUncertaintyInNs = clock.mTimeUncertaintyInNs;
        this.mFullBiasInNs = clock.mFullBiasInNs;
        this.mBiasInNs = clock.mBiasInNs;
        this.mBiasUncertaintyInNs = clock.mBiasUncertaintyInNs;
        this.mDriftInNsPerSec = clock.mDriftInNsPerSec;
        this.mDriftUncertaintyInNsPerSec = clock.mDriftUncertaintyInNsPerSec;
    }

    public void reset() {
        this.initialize();
    }

    public byte getType() {
        return this.mType;
    }

    public void setType(byte value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                this.mType = value;
                break;
            }
            default: {
                Log.d(TAG, "Sanitizing invalid 'type': " + value);
                this.mType = 0;
            }
        }
    }

    private String getTypeString() {
        switch (this.mType) {
            case 0: {
                return "Unknown";
            }
            case 2: {
                return "GpsTime";
            }
            case 1: {
                return "LocalHwClock";
            }
        }
        return "<Invalid>";
    }

    public boolean hasLeapSecond() {
        return this.isFlagSet((short)1);
    }

    public short getLeapSecond() {
        return this.mLeapSecond;
    }

    public void setLeapSecond(short leapSecond) {
        this.setFlag((short)1);
        this.mLeapSecond = leapSecond;
    }

    public void resetLeapSecond() {
        this.resetFlag((short)1);
        this.mLeapSecond = Short.MIN_VALUE;
    }

    public long getTimeInNs() {
        return this.mTimeInNs;
    }

    public void setTimeInNs(long timeInNs) {
        this.mTimeInNs = timeInNs;
    }

    public boolean hasTimeUncertaintyInNs() {
        return this.isFlagSet((short)2);
    }

    public double getTimeUncertaintyInNs() {
        return this.mTimeUncertaintyInNs;
    }

    public void setTimeUncertaintyInNs(double timeUncertaintyInNs) {
        this.setFlag((short)2);
        this.mTimeUncertaintyInNs = timeUncertaintyInNs;
    }

    public void resetTimeUncertaintyInNs() {
        this.resetFlag((short)2);
        this.mTimeUncertaintyInNs = Double.NaN;
    }

    public boolean hasFullBiasInNs() {
        return this.isFlagSet((short)4);
    }

    public long getFullBiasInNs() {
        return this.mFullBiasInNs;
    }

    public void setFullBiasInNs(long value) {
        this.setFlag((short)4);
        this.mFullBiasInNs = value;
    }

    public void resetFullBiasInNs() {
        this.resetFlag((short)4);
        this.mFullBiasInNs = Long.MIN_VALUE;
    }

    public boolean hasBiasInNs() {
        return this.isFlagSet((short)8);
    }

    public double getBiasInNs() {
        return this.mBiasInNs;
    }

    public void setBiasInNs(double biasInNs) {
        this.setFlag((short)8);
        this.mBiasInNs = biasInNs;
    }

    public void resetBiasInNs() {
        this.resetFlag((short)8);
        this.mBiasInNs = Double.NaN;
    }

    public boolean hasBiasUncertaintyInNs() {
        return this.isFlagSet((short)16);
    }

    public double getBiasUncertaintyInNs() {
        return this.mBiasUncertaintyInNs;
    }

    public void setBiasUncertaintyInNs(double biasUncertaintyInNs) {
        this.setFlag((short)16);
        this.mBiasUncertaintyInNs = biasUncertaintyInNs;
    }

    public void resetBiasUncertaintyInNs() {
        this.resetFlag((short)16);
        this.mBiasUncertaintyInNs = Double.NaN;
    }

    public boolean hasDriftInNsPerSec() {
        return this.isFlagSet((short)32);
    }

    public double getDriftInNsPerSec() {
        return this.mDriftInNsPerSec;
    }

    public void setDriftInNsPerSec(double driftInNsPerSec) {
        this.setFlag((short)32);
        this.mDriftInNsPerSec = driftInNsPerSec;
    }

    public void resetDriftInNsPerSec() {
        this.resetFlag((short)32);
        this.mDriftInNsPerSec = Double.NaN;
    }

    public boolean hasDriftUncertaintyInNsPerSec() {
        return this.isFlagSet((short)64);
    }

    public double getDriftUncertaintyInNsPerSec() {
        return this.mDriftUncertaintyInNsPerSec;
    }

    public void setDriftUncertaintyInNsPerSec(double driftUncertaintyInNsPerSec) {
        this.setFlag((short)64);
        this.mDriftUncertaintyInNsPerSec = driftUncertaintyInNsPerSec;
    }

    public void resetDriftUncertaintyInNsPerSec() {
        this.resetFlag((short)64);
        this.mDriftUncertaintyInNsPerSec = Double.NaN;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mFlags);
        parcel.writeInt(this.mLeapSecond);
        parcel.writeByte(this.mType);
        parcel.writeLong(this.mTimeInNs);
        parcel.writeDouble(this.mTimeUncertaintyInNs);
        parcel.writeLong(this.mFullBiasInNs);
        parcel.writeDouble(this.mBiasInNs);
        parcel.writeDouble(this.mBiasUncertaintyInNs);
        parcel.writeDouble(this.mDriftInNsPerSec);
        parcel.writeDouble(this.mDriftUncertaintyInNsPerSec);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String format = "   %-15s = %s\n";
        String formatWithUncertainty = "   %-15s = %-25s   %-26s = %s\n";
        StringBuilder builder = new StringBuilder("GpsClock:\n");
        builder.append(String.format("   %-15s = %s\n", "Type", this.getTypeString()));
        builder.append(String.format("   %-15s = %s\n", "LeapSecond", this.hasLeapSecond() ? Short.valueOf(this.mLeapSecond) : null));
        builder.append(String.format("   %-15s = %-25s   %-26s = %s\n", "TimeInNs", this.mTimeInNs, "TimeUncertaintyInNs", this.hasTimeUncertaintyInNs() ? Double.valueOf(this.mTimeUncertaintyInNs) : null));
        builder.append(String.format("   %-15s = %s\n", "FullBiasInNs", this.hasFullBiasInNs() ? Long.valueOf(this.mFullBiasInNs) : null));
        builder.append(String.format("   %-15s = %-25s   %-26s = %s\n", "BiasInNs", this.hasBiasInNs() ? Double.valueOf(this.mBiasInNs) : null, "BiasUncertaintyInNs", this.hasBiasUncertaintyInNs() ? Double.valueOf(this.mBiasUncertaintyInNs) : null));
        builder.append(String.format("   %-15s = %-25s   %-26s = %s\n", "DriftInNsPerSec", this.hasDriftInNsPerSec() ? Double.valueOf(this.mDriftInNsPerSec) : null, "DriftUncertaintyInNsPerSec", this.hasDriftUncertaintyInNsPerSec() ? Double.valueOf(this.mDriftUncertaintyInNsPerSec) : null));
        return builder.toString();
    }

    private void initialize() {
        this.mFlags = 0;
        this.resetLeapSecond();
        this.setType((byte)0);
        this.setTimeInNs(Long.MIN_VALUE);
        this.resetTimeUncertaintyInNs();
        this.resetFullBiasInNs();
        this.resetBiasInNs();
        this.resetBiasUncertaintyInNs();
        this.resetDriftInNsPerSec();
        this.resetDriftUncertaintyInNsPerSec();
    }

    private void setFlag(short flag) {
        this.mFlags = (short)(this.mFlags | flag);
    }

    private void resetFlag(short flag) {
        this.mFlags = (short)(this.mFlags & ~flag);
    }

    private boolean isFlagSet(short flag) {
        return (this.mFlags & flag) == flag;
    }
}

