/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.inputmethodservice.InputMethodService;
import android.util.AttributeSet;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

public class ExtractEditText
extends EditText {
    private InputMethodService mIME;
    private int mSettingExtractedText;

    public ExtractEditText(Context context) {
        super(context, null);
    }

    public ExtractEditText(Context context, AttributeSet attrs) {
        super(context, attrs, 16842862);
    }

    public ExtractEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ExtractEditText(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    void setIME(InputMethodService ime) {
        this.mIME = ime;
    }

    public void startInternalChanges() {
        ++this.mSettingExtractedText;
    }

    public void finishInternalChanges() {
        --this.mSettingExtractedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExtractedText(ExtractedText text) {
        try {
            ++this.mSettingExtractedText;
            super.setExtractedText(text);
        }
        finally {
            --this.mSettingExtractedText;
        }
    }

    @Override
    protected void onSelectionChanged(int selStart, int selEnd) {
        if (this.mSettingExtractedText == 0 && this.mIME != null && selStart >= 0 && selEnd >= 0) {
            this.mIME.onExtractedSelectionChanged(selStart, selEnd);
        }
    }

    @Override
    public boolean performClick() {
        if (!super.performClick() && this.mIME != null) {
            this.mIME.onExtractedTextClicked();
            return true;
        }
        return false;
    }

    @Override
    public boolean onTextContextMenuItem(int id2) {
        if (this.mIME != null && this.mIME.onExtractTextContextMenuItem(id2)) {
            if (id2 == 0x1020021) {
                this.stopSelectionActionMode();
            }
            return true;
        }
        return super.onTextContextMenuItem(id2);
    }

    @Override
    public boolean isInputMethodTarget() {
        return true;
    }

    public boolean hasVerticalScrollBar() {
        return this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
    }

    @Override
    public boolean hasWindowFocus() {
        return this.isEnabled();
    }

    @Override
    public boolean isFocused() {
        return this.isEnabled();
    }

    @Override
    public boolean hasFocus() {
        return this.isEnabled();
    }

    @Override
    protected void viewClicked(InputMethodManager imm) {
        if (this.mIME != null) {
            this.mIME.onViewClicked(false);
        }
    }

    @Override
    protected void deleteText_internal(int start, int end) {
        this.mIME.onExtractedDeleteText(start, end);
    }

    @Override
    protected void replaceText_internal(int start, int end, CharSequence text) {
        this.mIME.onExtractedReplaceText(start, end, text);
    }

    @Override
    protected void setSpan_internal(Object span, int start, int end, int flags) {
        this.mIME.onExtractedSetSpan(span, start, end, flags);
    }

    @Override
    protected void setCursorPosition_internal(int start, int end) {
        this.mIME.onExtractedSelectionChanged(start, end);
    }
}

