/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.utils.ParamsUtils;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.Objects;

public class LegacyFocusStateMapper {
    private static String TAG = "LegacyFocusStateMapper";
    private static final boolean VERBOSE = Log.isLoggable(TAG, 2);
    private final Camera mCamera;
    private int mAfStatePrevious = 0;
    private String mAfModePrevious = null;
    private final Object mLock = new Object();
    private int mAfRun = 0;
    private int mAfState = 0;

    public LegacyFocusStateMapper(Camera camera) {
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestTriggers(CaptureRequest captureRequest, Camera.Parameters parameters) {
        int currentAfRun;
        Preconditions.checkNotNull(captureRequest, "captureRequest must not be null");
        int afTrigger = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_AF_TRIGGER, 0);
        final String afMode = parameters.getFocusMode();
        if (!Objects.equals(this.mAfModePrevious, afMode)) {
            if (VERBOSE) {
                Log.v(TAG, "processRequestTriggers - AF mode switched from " + this.mAfModePrevious + " to " + afMode);
            }
            Object object = this.mLock;
            synchronized (object) {
                ++this.mAfRun;
                this.mAfState = 0;
            }
            this.mCamera.cancelAutoFocus();
        }
        this.mAfModePrevious = afMode;
        Object object = this.mLock;
        synchronized (object) {
            currentAfRun = this.mAfRun;
        }
        Object afMoveCallback = new Camera.AutoFocusMoveCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAutoFocusMoving(boolean start, Camera camera) {
                Object object = LegacyFocusStateMapper.this.mLock;
                synchronized (object) {
                    int latestAfRun = LegacyFocusStateMapper.this.mAfRun;
                    if (VERBOSE) {
                        Log.v(TAG, "onAutoFocusMoving - start " + start + " latest AF run " + latestAfRun + ", last AF run " + currentAfRun);
                    }
                    if (currentAfRun != latestAfRun) {
                        Log.d(TAG, "onAutoFocusMoving - ignoring move callbacks from old af run" + currentAfRun);
                        return;
                    }
                    int newAfState = start ? 1 : 2;
                    String string2 = afMode;
                    int n = -1;
                    switch (string2.hashCode()) {
                        case 910005312: {
                            if (!string2.equals("continuous-picture")) break;
                            n = 0;
                            break;
                        }
                        case -194628547: {
                            if (!string2.equals("continuous-video")) break;
                            n = 1;
                        }
                    }
                    switch (n) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            Log.w(TAG, "onAutoFocus - got unexpected onAutoFocus in mode " + afMode);
                        }
                    }
                    LegacyFocusStateMapper.this.mAfState = newAfState;
                }
            }
        };
        Object object2 = afMode;
        int n = -1;
        switch (((String)object2).hashCode()) {
            case 3005871: {
                if (!((String)object2).equals("auto")) break;
                n = 0;
                break;
            }
            case 103652300: {
                if (!((String)object2).equals("macro")) break;
                n = 1;
                break;
            }
            case 910005312: {
                if (!((String)object2).equals("continuous-picture")) break;
                n = 2;
                break;
            }
            case -194628547: {
                if (!((String)object2).equals("continuous-video")) break;
                n = 3;
            }
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.mCamera.setAutoFocusMoveCallback((Camera.AutoFocusMoveCallback)afMoveCallback);
            }
        }
        switch (afTrigger) {
            case 1: {
                int currentAfRun2;
                int afStateAfterStart;
                afMoveCallback = afMode;
                int n2 = -1;
                switch (((String)afMoveCallback).hashCode()) {
                    case 3005871: {
                        if (!((String)afMoveCallback).equals("auto")) break;
                        n2 = 0;
                        break;
                    }
                    case 103652300: {
                        if (!((String)afMoveCallback).equals("macro")) break;
                        n2 = 1;
                        break;
                    }
                    case 910005312: {
                        if (!((String)afMoveCallback).equals("continuous-picture")) break;
                        n2 = 2;
                        break;
                    }
                    case -194628547: {
                        if (!((String)afMoveCallback).equals("continuous-video")) break;
                        n2 = 3;
                    }
                }
                switch (n2) {
                    case 0: 
                    case 1: {
                        afStateAfterStart = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        afStateAfterStart = 1;
                        break;
                    }
                    default: {
                        afStateAfterStart = 0;
                    }
                }
                Object object3 = this.mLock;
                synchronized (object3) {
                    currentAfRun2 = ++this.mAfRun;
                    this.mAfState = afStateAfterStart;
                }
                if (VERBOSE) {
                    Log.v(TAG, "processRequestTriggers - got AF_TRIGGER_START, new AF run is " + currentAfRun2);
                }
                if (afStateAfterStart == 0) break;
                this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onAutoFocus(boolean success, Camera camera) {
                        Object object = LegacyFocusStateMapper.this.mLock;
                        synchronized (object) {
                            int latestAfRun = LegacyFocusStateMapper.this.mAfRun;
                            if (VERBOSE) {
                                Log.v(TAG, "onAutoFocus - success " + success + " latest AF run " + latestAfRun + ", last AF run " + currentAfRun2);
                            }
                            if (latestAfRun != currentAfRun2) {
                                Log.d(TAG, String.format("onAutoFocus - ignoring AF callback (old run %d, new run %d)", currentAfRun2, latestAfRun));
                                return;
                            }
                            int newAfState = success ? 4 : 5;
                            String string2 = afMode;
                            int n = -1;
                            switch (string2.hashCode()) {
                                case 3005871: {
                                    if (!string2.equals("auto")) break;
                                    n = 0;
                                    break;
                                }
                                case 910005312: {
                                    if (!string2.equals("continuous-picture")) break;
                                    n = 1;
                                    break;
                                }
                                case -194628547: {
                                    if (!string2.equals("continuous-video")) break;
                                    n = 2;
                                    break;
                                }
                                case 103652300: {
                                    if (!string2.equals("macro")) break;
                                    n = 3;
                                }
                            }
                            switch (n) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    break;
                                }
                                default: {
                                    Log.w(TAG, "onAutoFocus - got unexpected onAutoFocus in mode " + afMode);
                                }
                            }
                            LegacyFocusStateMapper.this.mAfState = newAfState;
                        }
                    }
                });
                break;
            }
            case 2: {
                object2 = this.mLock;
                synchronized (object2) {
                    int updatedAfRun;
                    Object object4 = this.mLock;
                    synchronized (object4) {
                        updatedAfRun = ++this.mAfRun;
                        this.mAfState = 0;
                    }
                    this.mCamera.cancelAutoFocus();
                    if (VERBOSE) {
                        Log.v(TAG, "processRequestTriggers - got AF_TRIGGER_CANCEL, new AF run is " + updatedAfRun);
                    }
                    break;
                }
            }
            case 0: {
                break;
            }
            default: {
                Log.w(TAG, "processRequestTriggers - ignoring unknown control.afTrigger = " + afTrigger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapResultTriggers(CameraMetadataNative result) {
        int newAfState;
        Preconditions.checkNotNull(result, "result must not be null");
        Object object = this.mLock;
        synchronized (object) {
            newAfState = this.mAfState;
        }
        if (VERBOSE && newAfState != this.mAfStatePrevious) {
            Log.v(TAG, String.format("mapResultTriggers - afState changed from %s to %s", LegacyFocusStateMapper.afStateToString(this.mAfStatePrevious), LegacyFocusStateMapper.afStateToString(newAfState)));
        }
        result.set(CaptureResult.CONTROL_AF_STATE, Integer.valueOf(newAfState));
        this.mAfStatePrevious = newAfState;
    }

    private static String afStateToString(int afState) {
        switch (afState) {
            case 3: {
                return "ACTIVE_SCAN";
            }
            case 4: {
                return "FOCUSED_LOCKED";
            }
            case 0: {
                return "INACTIVE";
            }
            case 5: {
                return "NOT_FOCUSED_LOCKED";
            }
            case 2: {
                return "PASSIVE_FOCUSED";
            }
            case 1: {
                return "PASSIVE_SCAN";
            }
            case 6: {
                return "PASSIVE_UNFOCUSED";
            }
        }
        return "UNKNOWN(" + afState + ")";
    }
}

