/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.utils.CameraBinderDecorator;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.LongParcelable;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class CameraDeviceImpl
extends CameraDevice {
    private final String TAG;
    private final boolean DEBUG;
    private static final int REQUEST_ID_NONE = -1;
    private ICameraDeviceUser mRemoteDevice;
    final Object mInterfaceLock = new Object();
    private final CameraDeviceCallbacks mCallbacks = new CameraDeviceCallbacks();
    private final CameraDevice.StateCallback mDeviceCallback;
    private volatile StateCallbackKK mSessionStateCallback;
    private final Handler mDeviceHandler;
    private volatile boolean mClosing = false;
    private boolean mInError = false;
    private boolean mIdle = true;
    private final SparseArray<CaptureCallbackHolder> mCaptureCallbackMap = new SparseArray();
    private int mRepeatingRequestId = -1;
    private final ArrayList<Integer> mRepeatingRequestIdDeletedList = new ArrayList();
    private final SparseArray<Surface> mConfiguredOutputs = new SparseArray();
    private final String mCameraId;
    private final CameraCharacteristics mCharacteristics;
    private final int mTotalPartialCount;
    private final List<AbstractMap.SimpleEntry<Long, Integer>> mFrameNumberRequestPairs = new ArrayList<AbstractMap.SimpleEntry<Long, Integer>>();
    private final FrameNumberTracker mFrameNumberTracker = new FrameNumberTracker();
    private CameraCaptureSessionImpl mCurrentSession;
    private int mNextSessionId = 0;
    private final Runnable mCallOnOpened = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onOpened(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onOpened(CameraDeviceImpl.this);
        }
    };
    private final Runnable mCallOnUnconfigured = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onUnconfigured(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnActive = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onActive(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnBusy = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onBusy(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnClosed = new Runnable(){
        private boolean mClosedOnce = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.mClosedOnce) {
                throw new AssertionError((Object)"Don't post #onClosed more than once");
            }
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onClosed(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onClosed(CameraDeviceImpl.this);
            this.mClosedOnce = true;
        }
    };
    private final Runnable mCallOnIdle = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onIdle(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnDisconnected = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onDisconnected(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onDisconnected(CameraDeviceImpl.this);
        }
    };

    public CameraDeviceImpl(String cameraId, CameraDevice.StateCallback callback, Handler handler, CameraCharacteristics characteristics) {
        if (cameraId == null || callback == null || handler == null || characteristics == null) {
            throw new IllegalArgumentException("Null argument given");
        }
        this.mCameraId = cameraId;
        this.mDeviceCallback = callback;
        this.mDeviceHandler = handler;
        this.mCharacteristics = characteristics;
        int MAX_TAG_LEN = 23;
        String tag = String.format("CameraDevice-JV-%s", this.mCameraId);
        if (tag.length() > 23) {
            tag = tag.substring(0, 23);
        }
        this.TAG = tag;
        this.DEBUG = Log.isLoggable(this.TAG, 3);
        Integer partialCount = this.mCharacteristics.get(CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT);
        this.mTotalPartialCount = partialCount == null ? 1 : partialCount;
    }

    public CameraDeviceCallbacks getCallbacks() {
        return this.mCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteDevice(ICameraDeviceUser remoteDevice) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInError) {
                return;
            }
            this.mRemoteDevice = CameraBinderDecorator.newInstance(remoteDevice);
            this.mDeviceHandler.post(this.mCallOnOpened);
            this.mDeviceHandler.post(this.mCallOnUnconfigured);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteFailure(CameraRuntimeException failure) {
        int failureCode = 4;
        boolean failureIsError = true;
        switch (failure.getReason()) {
            case 4: {
                failureCode = 1;
                break;
            }
            case 5: {
                failureCode = 2;
                break;
            }
            case 1: {
                failureCode = 3;
                break;
            }
            case 2: {
                failureIsError = false;
                break;
            }
            case 3: {
                failureCode = 4;
                break;
            }
            default: {
                Log.wtf(this.TAG, "Unknown failure in opening camera device: " + failure.getReason());
            }
        }
        final int code = failureCode;
        final boolean isError = failureIsError;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mInError = true;
            this.mDeviceHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (isError) {
                        CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, code);
                    } else {
                        CameraDeviceImpl.this.mDeviceCallback.onDisconnected(CameraDeviceImpl.this);
                    }
                }
            });
        }
    }

    @Override
    public String getId() {
        return this.mCameraId;
    }

    public void configureOutputs(List<Surface> outputs) throws CameraAccessException {
        this.configureOutputsChecked(outputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configureOutputsChecked(List<Surface> outputs) throws CameraAccessException {
        if (outputs == null) {
            outputs = new ArrayList<Surface>();
        }
        boolean success = false;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            HashSet<Surface> addSet = new HashSet<Surface>(outputs);
            ArrayList<Integer> deleteList = new ArrayList<Integer>();
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                int streamId = this.mConfiguredOutputs.keyAt(i);
                Surface s = this.mConfiguredOutputs.valueAt(i);
                if (!outputs.contains(s)) {
                    deleteList.add(streamId);
                    continue;
                }
                addSet.remove(s);
            }
            this.mDeviceHandler.post(this.mCallOnBusy);
            this.stopRepeating();
            try {
                this.waitUntilIdle();
                this.mRemoteDevice.beginConfigure();
                for (Integer streamId : deleteList) {
                    this.mRemoteDevice.deleteStream(streamId);
                    this.mConfiguredOutputs.delete(streamId);
                }
                for (Surface s : addSet) {
                    int streamId = this.mRemoteDevice.createStream(0, 0, 0, s);
                    this.mConfiguredOutputs.put(streamId, s);
                }
                try {
                    this.mRemoteDevice.endConfigure();
                }
                catch (IllegalArgumentException e) {
                    Log.w(this.TAG, "Stream configuration failed");
                    boolean bl = false;
                    if (success && outputs.size() > 0) {
                        this.mDeviceHandler.post(this.mCallOnIdle);
                    } else {
                        this.mDeviceHandler.post(this.mCallOnUnconfigured);
                    }
                    return bl;
                }
                success = true;
            }
            catch (CameraRuntimeException e) {
                if (e.getReason() != 4) throw e.asChecked();
                throw new IllegalStateException("The camera is currently busy. You must wait until the previous operation completes.");
            }
            catch (RemoteException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (success && outputs.size() > 0) {
                    this.mDeviceHandler.post(this.mCallOnIdle);
                } else {
                    this.mDeviceHandler.post(this.mCallOnUnconfigured);
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            CameraCaptureSessionImpl newSession;
            CameraAccessException pendingException;
            boolean configureSuccess;
            block8: {
                if (this.DEBUG) {
                    Log.d(this.TAG, "createCaptureSession");
                }
                this.checkIfCameraClosedOrInError();
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.replaceSessionClose();
                }
                configureSuccess = true;
                pendingException = null;
                try {
                    configureSuccess = this.configureOutputsChecked(outputs);
                }
                catch (CameraAccessException e) {
                    configureSuccess = false;
                    pendingException = e;
                    if (!this.DEBUG) break block8;
                    Log.v(this.TAG, "createCaptureSession - failed with exception ", e);
                }
            }
            this.mCurrentSession = newSession = new CameraCaptureSessionImpl(this.mNextSessionId++, outputs, callback, handler, this, this.mDeviceHandler, configureSuccess);
            if (pendingException != null) {
                throw pendingException;
            }
            this.mSessionStateCallback = this.mCurrentSession.getDeviceStateCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionListener(StateCallbackKK sessionCallback) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mSessionStateCallback = sessionCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaptureRequest.Builder createCaptureRequest(int templateType) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative templatedRequest = new CameraMetadataNative();
            try {
                this.mRemoteDevice.createDefaultRequest(templateType, templatedRequest);
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return null;
            }
            CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest);
            return builder;
        }
    }

    public int capture(CaptureRequest request, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (this.DEBUG) {
            Log.d(this.TAG, "calling capture");
        }
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, handler, false);
    }

    public int captureBurst(List<CaptureRequest> requests, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, handler, false);
    }

    private void checkEarlyTriggerSequenceComplete(final int requestId, final long lastFrameNumber) {
        if (lastFrameNumber == -1L) {
            CaptureCallbackHolder holder;
            int index = this.mCaptureCallbackMap.indexOfKey(requestId);
            CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
            if (holder != null) {
                this.mCaptureCallbackMap.removeAt(index);
                if (this.DEBUG) {
                    Log.v(this.TAG, String.format("remove holder for requestId %d, because lastFrame is %d.", requestId, lastFrameNumber));
                }
            }
            if (holder != null) {
                if (this.DEBUG) {
                    Log.v(this.TAG, "immediately trigger onCaptureSequenceAborted because request did not reach HAL");
                }
                Runnable resultDispatch = new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            if (CameraDeviceImpl.this.DEBUG) {
                                Log.d(CameraDeviceImpl.this.TAG, String.format("early trigger sequence complete for request %d", requestId));
                            }
                            if (lastFrameNumber < Integer.MIN_VALUE || lastFrameNumber > Integer.MAX_VALUE) {
                                throw new AssertionError((Object)(lastFrameNumber + " cannot be cast to int"));
                            }
                            holder.getCallback().onCaptureSequenceAborted(CameraDeviceImpl.this, requestId);
                        }
                    }
                };
                holder.getHandler().post(resultDispatch);
            } else {
                Log.w(this.TAG, String.format("did not register callback to request %d", requestId));
            }
        } else {
            this.mFrameNumberRequestPairs.add(new AbstractMap.SimpleEntry<Long, Integer>(lastFrameNumber, requestId));
            this.checkAndFireSequenceComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int submitCaptureRequest(List<CaptureRequest> requestList, CaptureCallback callback, Handler handler, boolean repeating) throws CameraAccessException {
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        for (CaptureRequest request : requestList) {
            if (request.getTargets().isEmpty()) {
                throw new IllegalArgumentException("Each request must have at least one Surface target");
            }
            for (Surface surface : request.getTargets()) {
                if (surface != null) continue;
                throw new IllegalArgumentException("Null Surface targets are not allowed");
            }
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int requestId;
            this.checkIfCameraClosedOrInError();
            if (repeating) {
                this.stopRepeating();
            }
            LongParcelable lastFrameNumberRef = new LongParcelable();
            try {
                requestId = this.mRemoteDevice.submitRequestList(requestList, repeating, lastFrameNumberRef);
                if (this.DEBUG) {
                    Log.v(this.TAG, "last frame number " + lastFrameNumberRef.getNumber());
                }
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return -1;
            }
            if (callback != null) {
                this.mCaptureCallbackMap.put(requestId, new CaptureCallbackHolder(callback, requestList, handler, repeating));
            } else if (this.DEBUG) {
                Log.d(this.TAG, "Listen for request " + requestId + " is null");
            }
            long lastFrameNumber = lastFrameNumberRef.getNumber();
            if (repeating) {
                if (this.mRepeatingRequestId != -1) {
                    this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, lastFrameNumber);
                }
                this.mRepeatingRequestId = requestId;
            } else {
                this.mFrameNumberRequestPairs.add(new AbstractMap.SimpleEntry<Long, Integer>(lastFrameNumber, requestId));
            }
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnActive);
            }
            this.mIdle = false;
            return requestId;
        }
    }

    public int setRepeatingRequest(CaptureRequest request, CaptureCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, handler, true);
    }

    public int setRepeatingBurst(List<CaptureRequest> requests, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRepeating() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                int requestId = this.mRepeatingRequestId;
                this.mRepeatingRequestId = -1;
                if (this.mCaptureCallbackMap.get(requestId) != null) {
                    this.mRepeatingRequestIdDeletedList.add(requestId);
                }
                try {
                    LongParcelable lastFrameNumberRef = new LongParcelable();
                    this.mRemoteDevice.cancelRequest(requestId, lastFrameNumberRef);
                    long lastFrameNumber = lastFrameNumberRef.getNumber();
                    this.checkEarlyTriggerSequenceComplete(requestId, lastFrameNumber);
                }
                catch (CameraRuntimeException e) {
                    throw e.asChecked();
                }
                catch (RemoteException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilIdle() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                throw new IllegalStateException("Active repeating request ongoing");
            }
            try {
                this.mRemoteDevice.waitUntilIdle();
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            this.mDeviceHandler.post(this.mCallOnBusy);
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnIdle);
                return;
            }
            try {
                LongParcelable lastFrameNumberRef = new LongParcelable();
                this.mRemoteDevice.flush(lastFrameNumberRef);
                if (this.mRepeatingRequestId != -1) {
                    long lastFrameNumber = lastFrameNumberRef.getNumber();
                    this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, lastFrameNumber);
                    this.mRepeatingRequestId = -1;
                }
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            try {
                if (this.mRemoteDevice != null) {
                    this.mRemoteDevice.disconnect();
                }
            }
            catch (CameraRuntimeException e) {
                Log.e(this.TAG, "Exception while closing: ", e.asChecked());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (this.mRemoteDevice != null || this.mInError) {
                this.mDeviceHandler.post(this.mCallOnClosed);
            }
            this.mRemoteDevice = null;
            this.mInError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndFireSequenceComplete() {
        long completedFrameNumber = this.mFrameNumberTracker.getCompletedFrameNumber();
        Iterator<AbstractMap.SimpleEntry<Long, Integer>> iter = this.mFrameNumberRequestPairs.iterator();
        while (iter.hasNext()) {
            CaptureCallbackHolder holder;
            final AbstractMap.SimpleEntry<Long, Integer> frameNumberRequestPair = iter.next();
            if (frameNumberRequestPair.getKey() > completedFrameNumber) continue;
            final int requestId = frameNumberRequestPair.getValue();
            Object object = this.mInterfaceLock;
            synchronized (object) {
                if (this.mRemoteDevice == null) {
                    Log.w(this.TAG, "Camera closed while checking sequences");
                    return;
                }
                int index = this.mCaptureCallbackMap.indexOfKey(requestId);
                CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
                if (holder != null) {
                    this.mCaptureCallbackMap.removeAt(index);
                    if (this.DEBUG) {
                        Log.v(this.TAG, String.format("remove holder for requestId %d, because lastFrame %d is <= %d", requestId, frameNumberRequestPair.getKey(), completedFrameNumber));
                    }
                }
            }
            iter.remove();
            if (holder == null) continue;
            Runnable resultDispatch = new Runnable(){

                @Override
                public void run() {
                    if (!CameraDeviceImpl.this.isClosed()) {
                        long lastFrameNumber;
                        if (CameraDeviceImpl.this.DEBUG) {
                            Log.d(CameraDeviceImpl.this.TAG, String.format("fire sequence complete for request %d", requestId));
                        }
                        if ((lastFrameNumber = ((Long)frameNumberRequestPair.getKey()).longValue()) < Integer.MIN_VALUE || lastFrameNumber > Integer.MAX_VALUE) {
                            throw new AssertionError((Object)(lastFrameNumber + " cannot be cast to int"));
                        }
                        holder.getCallback().onCaptureSequenceCompleted(CameraDeviceImpl.this, requestId, lastFrameNumber);
                    }
                }
            };
            holder.getHandler().post(resultDispatch);
        }
    }

    static Handler checkHandler(Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        return handler;
    }

    static <T> Handler checkHandler(Handler handler, T callback) {
        if (callback != null) {
            return CameraDeviceImpl.checkHandler(handler);
        }
        return handler;
    }

    private void checkIfCameraClosedOrInError() throws CameraAccessException {
        if (this.mInError) {
            throw new CameraAccessException(3, "The camera device has encountered a serious error");
        }
        if (this.mRemoteDevice == null) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
    }

    private boolean isClosed() {
        return this.mClosing;
    }

    private CameraCharacteristics getCharacteristics() {
        return this.mCharacteristics;
    }

    public class CameraDeviceCallbacks
    extends ICameraDeviceCallbacks.Stub {
        public static final int ERROR_CAMERA_DISCONNECTED = 0;
        public static final int ERROR_CAMERA_DEVICE = 1;
        public static final int ERROR_CAMERA_SERVICE = 2;
        public static final int ERROR_CAMERA_REQUEST = 3;
        public static final int ERROR_CAMERA_RESULT = 4;
        public static final int ERROR_CAMERA_BUFFER = 5;

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceError(final int errorCode, CaptureResultExtras resultExtras) {
            if (CameraDeviceImpl.this.DEBUG) {
                Log.d(CameraDeviceImpl.this.TAG, String.format("Device error received, code %d, frame number %d, request ID %d, subseq ID %d", errorCode, resultExtras.getFrameNumber(), resultExtras.getRequestId(), resultExtras.getSubsequenceId()));
            }
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                switch (errorCode) {
                    case 0: {
                        CameraDeviceImpl.this.mDeviceHandler.post(CameraDeviceImpl.this.mCallOnDisconnected);
                        break;
                    }
                    default: {
                        Log.e(CameraDeviceImpl.this.TAG, "Unknown error from camera device: " + errorCode);
                    }
                    case 1: 
                    case 2: {
                        CameraDeviceImpl.this.mInError = true;
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                if (!CameraDeviceImpl.this.isClosed()) {
                                    CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, errorCode);
                                }
                            }
                        };
                        CameraDeviceImpl.this.mDeviceHandler.post(r);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.onCaptureErrorLocked(errorCode, resultExtras);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceIdle() {
            if (CameraDeviceImpl.this.DEBUG) {
                Log.d(CameraDeviceImpl.this.TAG, "Camera now idle");
            }
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                if (!CameraDeviceImpl.this.mIdle) {
                    CameraDeviceImpl.this.mDeviceHandler.post(CameraDeviceImpl.this.mCallOnIdle);
                }
                CameraDeviceImpl.this.mIdle = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(final CaptureResultExtras resultExtras, final long timestamp) {
            int requestId = resultExtras.getRequestId();
            final long frameNumber = resultExtras.getFrameNumber();
            if (CameraDeviceImpl.this.DEBUG) {
                Log.d(CameraDeviceImpl.this.TAG, "Capture started for id " + requestId + " frame number " + frameNumber);
            }
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                final CaptureCallbackHolder holder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(requestId);
                if (holder == null) {
                    return;
                }
                if (CameraDeviceImpl.this.isClosed()) {
                    return;
                }
                holder.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            holder.getCallback().onCaptureStarted(CameraDeviceImpl.this, holder.getRequest(resultExtras.getSubsequenceId()), timestamp, frameNumber);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras) throws RemoteException {
            int requestId = resultExtras.getRequestId();
            long frameNumber = resultExtras.getFrameNumber();
            if (CameraDeviceImpl.this.DEBUG) {
                Log.v(CameraDeviceImpl.this.TAG, "Received result frame " + frameNumber + " for id " + requestId);
            }
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                CaptureResult finalResult;
                boolean isPartialResult;
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                result.set(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE, CameraDeviceImpl.this.getCharacteristics().get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE));
                final CaptureCallbackHolder holder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(requestId);
                boolean bl = isPartialResult = resultExtras.getPartialResultCount() < CameraDeviceImpl.this.mTotalPartialCount;
                if (holder == null) {
                    if (CameraDeviceImpl.this.DEBUG) {
                        Log.d(CameraDeviceImpl.this.TAG, "holder is null, early return at frame " + frameNumber);
                    }
                    CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult);
                    return;
                }
                if (CameraDeviceImpl.this.isClosed()) {
                    if (CameraDeviceImpl.this.DEBUG) {
                        Log.d(CameraDeviceImpl.this.TAG, "camera is closed, early return at frame " + frameNumber);
                    }
                    CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult);
                    return;
                }
                final CaptureRequest request = holder.getRequest(resultExtras.getSubsequenceId());
                Runnable resultDispatch = null;
                if (isPartialResult) {
                    final CaptureResult resultAsCapture = new CaptureResult(result, request, resultExtras);
                    resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                holder.getCallback().onCaptureProgressed(CameraDeviceImpl.this, request, resultAsCapture);
                            }
                        }
                    };
                    finalResult = resultAsCapture;
                } else {
                    List<CaptureResult> partialResults = CameraDeviceImpl.this.mFrameNumberTracker.popPartialResults(frameNumber);
                    final TotalCaptureResult resultAsCapture = new TotalCaptureResult(result, request, resultExtras, partialResults);
                    resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                holder.getCallback().onCaptureCompleted(CameraDeviceImpl.this, request, resultAsCapture);
                            }
                        }
                    };
                    finalResult = resultAsCapture;
                }
                holder.getHandler().post(resultDispatch);
                CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, finalResult, isPartialResult);
                if (!isPartialResult) {
                    CameraDeviceImpl.this.checkAndFireSequenceComplete();
                }
            }
        }

        private void onCaptureErrorLocked(int errorCode, CaptureResultExtras resultExtras) {
            int requestId = resultExtras.getRequestId();
            int subsequenceId = resultExtras.getSubsequenceId();
            long frameNumber = resultExtras.getFrameNumber();
            final CaptureCallbackHolder holder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(requestId);
            final CaptureRequest request = holder.getRequest(subsequenceId);
            if (errorCode == 5) {
                Log.e(CameraDeviceImpl.this.TAG, String.format("Lost output buffer reported for frame %d", frameNumber));
                return;
            }
            boolean mayHaveBuffers = errorCode == 4;
            int reason = CameraDeviceImpl.this.mCurrentSession != null && CameraDeviceImpl.this.mCurrentSession.isAborting() ? 1 : 0;
            final CaptureFailure failure = new CaptureFailure(request, reason, mayHaveBuffers, requestId, frameNumber);
            Runnable failureDispatch = new Runnable(){

                @Override
                public void run() {
                    if (!CameraDeviceImpl.this.isClosed()) {
                        holder.getCallback().onCaptureFailed(CameraDeviceImpl.this, request, failure);
                    }
                }
            };
            holder.getHandler().post(failureDispatch);
            if (CameraDeviceImpl.this.DEBUG) {
                Log.v(CameraDeviceImpl.this.TAG, String.format("got error frame %d", frameNumber));
            }
            CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, true);
            CameraDeviceImpl.this.checkAndFireSequenceComplete();
        }
    }

    public class FrameNumberTracker {
        private long mCompletedFrameNumber = -1L;
        private final TreeSet<Long> mFutureErrorSet = new TreeSet();
        private final HashMap<Long, List<CaptureResult>> mPartialResults = new HashMap();

        private void update() {
            long errorFrameNumber;
            Iterator<Long> iter = this.mFutureErrorSet.iterator();
            while (iter.hasNext() && (errorFrameNumber = iter.next().longValue()) == this.mCompletedFrameNumber + 1L) {
                ++this.mCompletedFrameNumber;
                iter.remove();
            }
        }

        public void updateTracker(long frameNumber, boolean isError) {
            if (isError) {
                this.mFutureErrorSet.add(frameNumber);
            } else {
                if (frameNumber != this.mCompletedFrameNumber + 1L) {
                    Log.e(CameraDeviceImpl.this.TAG, String.format("result frame number %d comes out of order, should be %d + 1", frameNumber, this.mCompletedFrameNumber));
                }
                this.mCompletedFrameNumber = frameNumber;
            }
            this.update();
        }

        public void updateTracker(long frameNumber, CaptureResult result, boolean partial) {
            if (!partial) {
                this.updateTracker(frameNumber, false);
                return;
            }
            if (result == null) {
                return;
            }
            List<CaptureResult> partials = this.mPartialResults.get(frameNumber);
            if (partials == null) {
                partials = new ArrayList<CaptureResult>();
                this.mPartialResults.put(frameNumber, partials);
            }
            partials.add(result);
        }

        public List<CaptureResult> popPartialResults(long frameNumber) {
            return this.mPartialResults.remove(frameNumber);
        }

        public long getCompletedFrameNumber() {
            return this.mCompletedFrameNumber;
        }
    }

    static class CaptureCallbackHolder {
        private final boolean mRepeating;
        private final CaptureCallback mCallback;
        private final List<CaptureRequest> mRequestList;
        private final Handler mHandler;

        CaptureCallbackHolder(CaptureCallback callback, List<CaptureRequest> requestList, Handler handler, boolean repeating) {
            if (callback == null || handler == null) {
                throw new UnsupportedOperationException("Must have a valid handler and a valid callback");
            }
            this.mRepeating = repeating;
            this.mHandler = handler;
            this.mRequestList = new ArrayList<CaptureRequest>(requestList);
            this.mCallback = callback;
        }

        public boolean isRepeating() {
            return this.mRepeating;
        }

        public CaptureCallback getCallback() {
            return this.mCallback;
        }

        public CaptureRequest getRequest(int subsequenceId) {
            if (subsequenceId >= this.mRequestList.size()) {
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is larger than request list size %d.", subsequenceId, this.mRequestList.size()));
            }
            if (subsequenceId < 0) {
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is negative", subsequenceId));
            }
            return this.mRequestList.get(subsequenceId);
        }

        public CaptureRequest getRequest() {
            return this.getRequest(0);
        }

        public Handler getHandler() {
            return this.mHandler;
        }
    }

    public static abstract class StateCallbackKK
    extends CameraDevice.StateCallback {
        public void onUnconfigured(CameraDevice camera) {
        }

        public void onActive(CameraDevice camera) {
        }

        public void onBusy(CameraDevice camera) {
        }

        public void onIdle(CameraDevice camera) {
        }
    }

    public static abstract class CaptureCallback {
        public static final int NO_FRAMES_CAPTURED = -1;

        public void onCaptureStarted(CameraDevice camera, CaptureRequest request, long timestamp, long frameNumber) {
        }

        public void onCapturePartial(CameraDevice camera, CaptureRequest request, CaptureResult result) {
        }

        public void onCaptureProgressed(CameraDevice camera, CaptureRequest request, CaptureResult partialResult) {
        }

        public void onCaptureCompleted(CameraDevice camera, CaptureRequest request, TotalCaptureResult result) {
        }

        public void onCaptureFailed(CameraDevice camera, CaptureRequest request, CaptureFailure failure) {
        }

        public void onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, long frameNumber) {
        }

        public void onCaptureSequenceAborted(CameraDevice camera, int sequenceId) {
        }
    }
}

