/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import java.util.Collection;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayerDrawable
extends Drawable
implements Drawable.Callback {
    public static final int PADDING_MODE_NEST = 0;
    public static final int PADDING_MODE_STACK = 1;
    LayerState mLayerState;
    private int mOpacityOverride = 0;
    private int[] mPaddingL;
    private int[] mPaddingT;
    private int[] mPaddingR;
    private int[] mPaddingB;
    private final Rect mTmpRect = new Rect();
    private Rect mHotspotBounds;
    private boolean mMutated;

    public LayerDrawable(Drawable[] layers) {
        this(layers, null);
    }

    LayerDrawable(Drawable[] layers, LayerState state) {
        this(state, null);
        int length = layers.length;
        ChildDrawable[] r = new ChildDrawable[length];
        for (int i = 0; i < length; ++i) {
            r[i] = new ChildDrawable();
            r[i].mDrawable = layers[i];
            layers[i].setCallback(this);
            this.mLayerState.mChildrenChangingConfigurations |= layers[i].getChangingConfigurations();
        }
        this.mLayerState.mNum = length;
        this.mLayerState.mChildren = r;
        this.ensurePadding();
    }

    LayerDrawable() {
        this((LayerState)null, null);
    }

    LayerDrawable(LayerState state, Resources res) {
        this.mLayerState = this.createConstantState(state, res);
        if (this.mLayerState.mNum > 0) {
            this.ensurePadding();
        }
    }

    LayerState createConstantState(LayerState state, Resources res) {
        return new LayerState(state, this, res);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = LayerDrawable.obtainAttributes(r, theme, attrs, R.styleable.LayerDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.inflateLayers(r, parser, attrs, theme);
        this.ensurePadding();
        this.onStateChange(this.getState());
    }

    private void updateStateFromTypedArray(TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        this.mOpacityOverride = a.getInt(0, this.mOpacityOverride);
        state.mAutoMirrored = a.getBoolean(1, state.mAutoMirrored);
        state.mPaddingMode = a.getInteger(2, state.mPaddingMode);
    }

    private void inflateLayers(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        LayerState state = this.mLayerState;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            ChildDrawable layer = new ChildDrawable();
            TypedArray a = LayerDrawable.obtainAttributes(r, theme, attrs, R.styleable.LayerDrawableItem);
            this.updateLayerFromTypedArray(layer, a);
            a.recycle();
            if (layer.mDrawable == null) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                layer.mDrawable = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            if (layer.mDrawable != null) {
                state.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
                layer.mDrawable.setCallback(this);
            }
            this.addLayer(layer);
        }
    }

    private void updateLayerFromTypedArray(ChildDrawable layer, TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChildrenChangingConfigurations |= a.getChangingConfigurations();
        layer.mThemeAttrs = a.extractThemeAttrs();
        layer.mInsetL = a.getDimensionPixelOffset(2, layer.mInsetL);
        layer.mInsetT = a.getDimensionPixelOffset(3, layer.mInsetT);
        layer.mInsetR = a.getDimensionPixelOffset(4, layer.mInsetR);
        layer.mInsetB = a.getDimensionPixelOffset(5, layer.mInsetB);
        layer.mId = a.getResourceId(0, layer.mId);
        Drawable dr = a.getDrawable(1);
        if (dr != null) {
            layer.mDrawable = dr;
        }
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.LayerDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
        ChildDrawable[] array2 = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable d;
            ChildDrawable layer = array2[i];
            if (layer.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(layer.mThemeAttrs, R.styleable.LayerDrawableItem);
                this.updateLayerFromTypedArray(layer, a);
                a.recycle();
            }
            if (!(d = layer.mDrawable).canApplyTheme()) continue;
            d.applyTheme(t);
        }
        this.ensurePadding();
        this.onStateChange(this.getState());
    }

    @Override
    public boolean canApplyTheme() {
        return this.mLayerState != null && this.mLayerState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public boolean isProjected() {
        if (super.isProjected()) {
            return true;
        }
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            if (!layers[i].mDrawable.isProjected()) continue;
            return true;
        }
        return false;
    }

    void addLayer(ChildDrawable layer) {
        LayerState st = this.mLayerState;
        int i = st.mNum;
        int N = st.mChildren != null ? st.mChildren.length : 0;
        if (i >= N) {
            ChildDrawable[] nu = new ChildDrawable[N + 10];
            if (i > 0) {
                System.arraycopy(st.mChildren, 0, nu, 0, i);
            }
            st.mChildren = nu;
        }
        st.mChildren[i] = layer;
        ++st.mNum;
        st.invalidateCache();
    }

    ChildDrawable addLayer(Drawable layer, int[] themeAttrs, int id2, int left, int top, int right, int bottom) {
        ChildDrawable childDrawable = new ChildDrawable();
        childDrawable.mId = id2;
        childDrawable.mThemeAttrs = themeAttrs;
        childDrawable.mDrawable = layer;
        childDrawable.mDrawable.setAutoMirrored(this.isAutoMirrored());
        childDrawable.mInsetL = left;
        childDrawable.mInsetT = top;
        childDrawable.mInsetR = right;
        childDrawable.mInsetB = bottom;
        this.addLayer(childDrawable);
        this.mLayerState.mChildrenChangingConfigurations |= layer.getChangingConfigurations();
        layer.setCallback(this);
        return childDrawable;
    }

    public Drawable findDrawableByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        for (int i = this.mLayerState.mNum - 1; i >= 0; --i) {
            if (layers[i].mId != id2) continue;
            return layers[i].mDrawable;
        }
        return null;
    }

    public void setId(int index, int id2) {
        this.mLayerState.mChildren[index].mId = id2;
    }

    public int getNumberOfLayers() {
        return this.mLayerState.mNum;
    }

    public Drawable getDrawable(int index) {
        return this.mLayerState.mChildren[index].mDrawable;
    }

    public int getId(int index) {
        return this.mLayerState.mChildren[index].mId;
    }

    public boolean setDrawableByLayerId(int id2, Drawable drawable2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable childDrawable = layers[i];
            if (childDrawable.mId != id2) continue;
            if (childDrawable.mDrawable != null) {
                if (drawable2 != null) {
                    Rect bounds = childDrawable.mDrawable.getBounds();
                    drawable2.setBounds(bounds);
                }
                childDrawable.mDrawable.setCallback(null);
            }
            if (drawable2 != null) {
                drawable2.setCallback(this);
            }
            childDrawable.mDrawable = drawable2;
            this.mLayerState.invalidateCache();
            return true;
        }
        return false;
    }

    public void setLayerInset(int index, int l, int t, int r, int b) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l;
        childDrawable.mInsetT = t;
        childDrawable.mInsetR = r;
        childDrawable.mInsetB = b;
    }

    public void setPaddingMode(int mode) {
        if (this.mLayerState.mPaddingMode != mode) {
            this.mLayerState.mPaddingMode = mode;
        }
    }

    public int getPaddingMode() {
        return this.mLayerState.mPaddingMode;
    }

    @Override
    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    @Override
    public void draw(Canvas canvas) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.draw(canvas);
        }
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.mChangingConfigurations | this.mLayerState.mChildrenChangingConfigurations;
    }

    @Override
    public boolean getPadding(Rect padding) {
        if (this.mLayerState.mPaddingMode == 0) {
            this.computeNestedPadding(padding);
        } else {
            this.computeStackedPadding(padding);
        }
        return padding.left != 0 || padding.top != 0 || padding.right != 0 || padding.bottom != 0;
    }

    private void computeNestedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array2[i]);
            padding.left += this.mPaddingL[i];
            padding.top += this.mPaddingT[i];
            padding.right += this.mPaddingR[i];
            padding.bottom += this.mPaddingB[i];
        }
    }

    private void computeStackedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array2[i]);
            padding.left = Math.max(padding.left, this.mPaddingL[i]);
            padding.top = Math.max(padding.top, this.mPaddingT[i]);
            padding.right = Math.max(padding.right, this.mPaddingR[i]);
            padding.bottom = Math.max(padding.bottom, this.mPaddingB[i]);
        }
    }

    @Override
    public void getOutline(Outline outline) {
        LayerState state = this.mLayerState;
        ChildDrawable[] children = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            children[i].mDrawable.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    @Override
    public void setHotspot(float x, float y) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setHotspot(x, y);
        }
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setHotspotBounds(left, top, right, bottom);
        }
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setVisible(visible, restart);
        }
        return changed;
    }

    @Override
    public void setDither(boolean dither) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setDither(dither);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setAlpha(alpha);
        }
    }

    @Override
    public int getAlpha() {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        if (this.mLayerState.mNum > 0) {
            return array2[0].mDrawable.getAlpha();
        }
        return super.getAlpha();
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setColorFilter(cf);
        }
    }

    @Override
    public void setTintList(ColorStateList tint) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setTintList(tint);
        }
    }

    @Override
    public void setTintMode(PorterDuff.Mode tintMode) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setTintMode(tintMode);
        }
    }

    public void setOpacity(int opacity) {
        this.mOpacityOverride = opacity;
    }

    @Override
    public int getOpacity() {
        if (this.mOpacityOverride != 0) {
            return this.mOpacityOverride;
        }
        return this.mLayerState.getOpacity();
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        this.mLayerState.mAutoMirrored = mirrored;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setAutoMirrored(mirrored);
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mLayerState.mAutoMirrored;
    }

    @Override
    public boolean isStateful() {
        return this.mLayerState.isStateful();
    }

    @Override
    protected boolean onStateChange(int[] state) {
        boolean paddingChanged = false;
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            if (r.mDrawable.isStateful() && r.mDrawable.setState(state)) {
                changed = true;
            }
            if (!this.refreshChildPadding(i, r)) continue;
            paddingChanged = true;
        }
        if (paddingChanged) {
            this.onBoundsChange(this.getBounds());
        }
        return changed;
    }

    @Override
    protected boolean onLevelChange(int level) {
        boolean paddingChanged = false;
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            if (r.mDrawable.setLevel(level)) {
                changed = true;
            }
            if (!this.refreshChildPadding(i, r)) continue;
            paddingChanged = true;
        }
        if (paddingChanged) {
            this.onBoundsChange(this.getBounds());
        }
        return changed;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        int padL = 0;
        int padT = 0;
        int padR = 0;
        int padB = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            r.mDrawable.setBounds(bounds.left + r.mInsetL + padL, bounds.top + r.mInsetT + padT, bounds.right - r.mInsetR - padR, bounds.bottom - r.mInsetB - padB);
            if (!nest) continue;
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
    }

    @Override
    public int getIntrinsicWidth() {
        int width = -1;
        int padL = 0;
        int padR = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            int w = r.mDrawable.getIntrinsicWidth() + r.mInsetL + r.mInsetR + padL + padR;
            if (w > width) {
                width = w;
            }
            if (!nest) continue;
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
        }
        return width;
    }

    @Override
    public int getIntrinsicHeight() {
        int height = -1;
        int padT = 0;
        int padB = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            int h = r.mDrawable.getIntrinsicHeight() + r.mInsetT + r.mInsetB + padT + padB;
            if (h > height) {
                height = h;
            }
            if (!nest) continue;
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
        return height;
    }

    private boolean refreshChildPadding(int i, ChildDrawable r) {
        Rect rect = this.mTmpRect;
        r.mDrawable.getPadding(rect);
        if (rect.left != this.mPaddingL[i] || rect.top != this.mPaddingT[i] || rect.right != this.mPaddingR[i] || rect.bottom != this.mPaddingB[i]) {
            this.mPaddingL[i] = rect.left;
            this.mPaddingT[i] = rect.top;
            this.mPaddingR[i] = rect.right;
            this.mPaddingB[i] = rect.bottom;
            return true;
        }
        return false;
    }

    void ensurePadding() {
        int N = this.mLayerState.mNum;
        if (this.mPaddingL != null && this.mPaddingL.length >= N) {
            return;
        }
        this.mPaddingL = new int[N];
        this.mPaddingT = new int[N];
        this.mPaddingR = new int[N];
        this.mPaddingB = new int[N];
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLayerState = this.createConstantState(this.mLayerState, null);
            ChildDrawable[] array2 = this.mLayerState.mChildren;
            int N = this.mLayerState.mNum;
            for (int i = 0; i < N; ++i) {
                array2[i].mDrawable.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.clearMutated();
        }
        this.mMutated = false;
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setLayoutDirection(layoutDirection);
        }
        super.setLayoutDirection(layoutDirection);
    }

    static class LayerState
    extends Drawable.ConstantState {
        int mNum;
        ChildDrawable[] mChildren;
        int[] mThemeAttrs;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        private boolean mHaveOpacity;
        private int mOpacity;
        private boolean mHaveIsStateful;
        private boolean mIsStateful;
        private boolean mAutoMirrored = false;
        private int mPaddingMode = 0;

        LayerState(LayerState orig, LayerDrawable owner, Resources res) {
            if (orig != null) {
                int N;
                ChildDrawable[] origChildDrawable = orig.mChildren;
                this.mNum = N = orig.mNum;
                this.mChildren = new ChildDrawable[N];
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                for (int i = 0; i < N; ++i) {
                    ChildDrawable or = origChildDrawable[i];
                    this.mChildren[i] = new ChildDrawable(or, owner, res);
                }
                this.mHaveOpacity = orig.mHaveOpacity;
                this.mOpacity = orig.mOpacity;
                this.mHaveIsStateful = orig.mHaveIsStateful;
                this.mIsStateful = orig.mIsStateful;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mPaddingMode = orig.mPaddingMode;
                this.mThemeAttrs = orig.mThemeAttrs;
            } else {
                this.mNum = 0;
                this.mChildren = null;
            }
        }

        @Override
        public boolean canApplyTheme() {
            if (this.mThemeAttrs != null || super.canApplyTheme()) {
                return true;
            }
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            for (int i = 0; i < N; ++i) {
                ChildDrawable layer = array2[i];
                if (layer.mThemeAttrs == null && !layer.mDrawable.canApplyTheme()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Drawable newDrawable() {
            return new LayerDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new LayerDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public int getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            int op = N > 0 ? array2[0].mDrawable.getOpacity() : -2;
            for (int i = 1; i < N; ++i) {
                op = Drawable.resolveOpacity(op, array2[i].mDrawable.getOpacity());
            }
            this.mOpacity = op;
            this.mHaveOpacity = true;
            return op;
        }

        public boolean isStateful() {
            if (this.mHaveIsStateful) {
                return this.mIsStateful;
            }
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            boolean isStateful = false;
            for (int i = 0; i < N; ++i) {
                if (!array2[i].mDrawable.isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mIsStateful = isStateful;
            this.mHaveIsStateful = true;
            return isStateful;
        }

        public boolean canConstantState() {
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            for (int i = 0; i < N; ++i) {
                if (array2[i].mDrawable.getConstantState() != null) continue;
                return false;
            }
            return true;
        }

        public void invalidateCache() {
            this.mHaveOpacity = false;
            this.mHaveIsStateful = false;
        }

        @Override
        public int addAtlasableBitmaps(Collection<Bitmap> atlasList) {
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            int pixelCount = 0;
            for (int i = 0; i < N; ++i) {
                Drawable.ConstantState state = array2[i].mDrawable.getConstantState();
                if (state == null) continue;
                pixelCount += state.addAtlasableBitmaps(atlasList);
            }
            return pixelCount;
        }
    }

    static class ChildDrawable {
        public Drawable mDrawable;
        public int[] mThemeAttrs;
        public int mInsetL;
        public int mInsetT;
        public int mInsetR;
        public int mInsetB;
        public int mId = -1;

        ChildDrawable() {
        }

        ChildDrawable(ChildDrawable orig, LayerDrawable owner, Resources res) {
            this.mDrawable = res != null ? orig.mDrawable.getConstantState().newDrawable(res) : orig.mDrawable.getConstantState().newDrawable();
            this.mDrawable.setCallback(owner);
            this.mDrawable.setLayoutDirection(orig.mDrawable.getLayoutDirection());
            this.mDrawable.setBounds(orig.mDrawable.getBounds());
            this.mDrawable.setLevel(orig.mDrawable.getLevel());
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mInsetL = orig.mInsetL;
            this.mInsetT = orig.mInsetT;
            this.mInsetR = orig.mInsetR;
            this.mInsetB = orig.mInsetB;
            this.mId = orig.mId;
        }
    }
}

