/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.graphics.Typeface_Delegate;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface {
    private static String TAG = "Typeface";
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACE;
    static Typeface[] sDefaults;
    private static final LongSparseArray<SparseArray<Typeface>> sTypefaceCache;
    static Typeface sDefaultTypeface;
    static Map<String, Typeface> sSystemFontMap;
    static FontFamily[] sFallbackFonts;
    static final String FONTS_CONFIG = "fonts.xml";
    public long native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    private int mStyle = 0;

    private static void setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    public int getStyle() {
        return this.mStyle;
    }

    public boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    public static Typeface create(String familyName, int style2) {
        if (sSystemFontMap != null) {
            return Typeface.create(sSystemFontMap.get(familyName), style2);
        }
        return null;
    }

    public static Typeface create(Typeface family, int style2) {
        Typeface typeface;
        SparseArray<Typeface> styles;
        if (style2 < 0 || style2 > 3) {
            style2 = 0;
        }
        long ni = 0L;
        if (family != null) {
            if (family.mStyle == style2) {
                return family;
            }
            ni = family.native_instance;
        }
        if ((styles = sTypefaceCache.get(ni)) != null && (typeface = styles.get(style2)) != null) {
            return typeface;
        }
        typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
        if (styles == null) {
            styles = new SparseArray(4);
            sTypefaceCache.put(ni, styles);
        }
        styles.put(style2, typeface);
        return typeface;
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    public static Typeface createFromAsset(AssetManager mgr, String path) {
        FontFamily fontFamily;
        if (sFallbackFonts != null && (fontFamily = new FontFamily()).addFontFromAsset(mgr, path)) {
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families);
        }
        throw new RuntimeException("Font asset not found " + path);
    }

    public static Typeface createFromFile(File path) {
        return Typeface.createFromFile(path.getAbsolutePath());
    }

    public static Typeface createFromFile(String path) {
        FontFamily fontFamily;
        if (sFallbackFonts != null && (fontFamily = new FontFamily()).addFont(path)) {
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families);
        }
        throw new RuntimeException("Font not found " + path);
    }

    public static Typeface createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray));
    }

    public static Typeface createFromFamiliesWithDefault(FontFamily[] families) {
        int i;
        long[] ptrArray = new long[families.length + sFallbackFonts.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < sFallbackFonts.length; ++i) {
            ptrArray[i + families.length] = Typeface.sFallbackFonts[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray));
    }

    private Typeface(long ni) {
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
    }

    private static FontFamily makeFamilyFromParsed(FontListParser.Family family) {
        FontFamily fontFamily = new FontFamily(family.lang, family.variant);
        for (FontListParser.Font font : family.fonts) {
            fontFamily.addFontWeightStyle(font.fontName, font.weight, font.isItalic);
        }
        return fontFamily;
    }

    private static void init() {
        File systemFontConfigLocation = Typeface.getSystemFontConfigLocation();
        File configFilename = new File(systemFontConfigLocation, FONTS_CONFIG);
        try {
            FileInputStream fontsIn = new FileInputStream(configFilename);
            FontListParser.Config fontConfig = FontListParser.parse(fontsIn);
            ArrayList<FontFamily> familyList = new ArrayList<FontFamily>();
            for (int i = 0; i < fontConfig.families.size(); ++i) {
                FontListParser.Family f = fontConfig.families.get(i);
                if (i != 0 && f.name != null) continue;
                familyList.add(Typeface.makeFamilyFromParsed(f));
            }
            sFallbackFonts = familyList.toArray(new FontFamily[familyList.size()]);
            Typeface.setDefault(Typeface.createFromFamilies(sFallbackFonts));
            HashMap<String, Typeface> systemFonts = new HashMap<String, Typeface>();
            for (int i = 0; i < fontConfig.families.size(); ++i) {
                Typeface typeface;
                FontListParser.Family f = fontConfig.families.get(i);
                if (f.name == null) continue;
                if (i == 0) {
                    typeface = sDefaultTypeface;
                } else {
                    FontFamily fontFamily = Typeface.makeFamilyFromParsed(f);
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families);
                }
                systemFonts.put(f.name, typeface);
            }
            for (FontListParser.Alias alias : fontConfig.aliases) {
                Typeface base;
                Typeface newFace = base = (Typeface)systemFonts.get(alias.toName);
                int weight = alias.weight;
                if (weight != 400) {
                    newFace = new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
                }
                systemFonts.put(alias.name, newFace);
            }
            sSystemFontMap = systemFonts;
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Didn't create default family (most likely, non-Minikin build)", e);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Error opening " + configFilename);
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading " + configFilename);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "XML parse exception for " + configFilename);
        }
    }

    static File getSystemFontConfigLocation_Original() {
        return new File("/system/etc/");
    }

    @LayoutlibDelegate
    private static File getSystemFontConfigLocation() {
        return Typeface_Delegate.getSystemFontConfigLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    @LayoutlibDelegate
    private static long nativeCreateFromTypeface(long l, int n) {
        return Typeface_Delegate.nativeCreateFromTypeface(l, n);
    }

    @LayoutlibDelegate
    private static long nativeCreateWeightAlias(long l, int n) {
        return Typeface_Delegate.nativeCreateWeightAlias(l, n);
    }

    @LayoutlibDelegate
    private static void nativeUnref(long l) {
        Typeface_Delegate.nativeUnref(l);
    }

    @LayoutlibDelegate
    private static int nativeGetStyle(long l) {
        return Typeface_Delegate.nativeGetStyle(l);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromArray(long[] lArray) {
        return Typeface_Delegate.nativeCreateFromArray(lArray);
    }

    @LayoutlibDelegate
    private static void nativeSetDefault(long l) {
        Typeface_Delegate.nativeSetDefault(l);
    }

    static {
        sTypefaceCache = new LongSparseArray(3);
        Typeface.init();
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }
}

