/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter_Delegate;
import android.graphics.PorterDuff;
import com.android.layoutlib.bridge.impl.PorterDuffUtility;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class PorterDuffColorFilter_Delegate
extends ColorFilter_Delegate {
    private final int mSrcColor;
    private final PorterDuff.Mode mMode;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getSupportMessage() {
        return "PorterDuff Color Filter is not supported for mode: " + this.mMode.name() + ".";
    }

    @Override
    public void applyFilter(Graphics2D g, int width, int height) {
        BufferedImage image = this.createFilterImage(width, height);
        g.setComposite(PorterDuffUtility.getComposite(this.mMode, 255));
        g.drawImage((Image)image, 0, 0, null);
    }

    @LayoutlibDelegate
    static long native_CreatePorterDuffFilter(int srcColor, int porterDuffMode) {
        PorterDuffColorFilter_Delegate newDelegate = new PorterDuffColorFilter_Delegate(srcColor, porterDuffMode);
        return sManager.addNewDelegate(newDelegate);
    }

    private PorterDuffColorFilter_Delegate(int srcColor, int mode) {
        this.mSrcColor = srcColor;
        this.mMode = this.getCompatibleMode(PorterDuffUtility.getPorterDuffMode(mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createFilterImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        try {
            graphics.setColor(new Color(this.mSrcColor, true));
            graphics.fillRect(0, 0, width, height);
        }
        finally {
            graphics.dispose();
        }
        return image;
    }

    private PorterDuff.Mode getCompatibleMode(PorterDuff.Mode mode) {
        PorterDuff.Mode m = mode;
        switch (mode) {
            case SRC: {
                m = PorterDuff.Mode.SRC_IN;
                break;
            }
            case SRC_OVER: {
                m = PorterDuff.Mode.SRC_ATOP;
                break;
            }
            case DST_OVER: {
                m = PorterDuff.Mode.DST;
                break;
            }
            case SRC_OUT: {
                m = PorterDuff.Mode.CLEAR;
                break;
            }
            case DST_ATOP: {
                m = PorterDuff.Mode.DST_IN;
                break;
            }
            case XOR: {
                m = PorterDuff.Mode.DST_OUT;
            }
        }
        return m;
    }
}

