/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix_Delegate;
import android.graphics.RectF;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.PrintWriter;

public class Matrix {
    public static final int MSCALE_X = 0;
    public static final int MSKEW_X = 1;
    public static final int MTRANS_X = 2;
    public static final int MSKEW_Y = 3;
    public static final int MSCALE_Y = 4;
    public static final int MTRANS_Y = 5;
    public static final int MPERSP_0 = 6;
    public static final int MPERSP_1 = 7;
    public static final int MPERSP_2 = 8;
    public static Matrix IDENTITY_MATRIX = new Matrix(){

        void oops() {
            throw new IllegalStateException("Matrix can not be modified");
        }

        @Override
        public void set(Matrix src) {
            this.oops();
        }

        @Override
        public void reset() {
            this.oops();
        }

        @Override
        public void setTranslate(float dx, float dy) {
            this.oops();
        }

        @Override
        public void setScale(float sx, float sy, float px, float py) {
            this.oops();
        }

        @Override
        public void setScale(float sx, float sy) {
            this.oops();
        }

        @Override
        public void setRotate(float degrees, float px, float py) {
            this.oops();
        }

        @Override
        public void setRotate(float degrees) {
            this.oops();
        }

        @Override
        public void setSinCos(float sinValue, float cosValue, float px, float py) {
            this.oops();
        }

        @Override
        public void setSinCos(float sinValue, float cosValue) {
            this.oops();
        }

        @Override
        public void setSkew(float kx, float ky, float px, float py) {
            this.oops();
        }

        @Override
        public void setSkew(float kx, float ky) {
            this.oops();
        }

        @Override
        public boolean setConcat(Matrix a, Matrix b) {
            this.oops();
            return false;
        }

        @Override
        public boolean preTranslate(float dx, float dy) {
            this.oops();
            return false;
        }

        @Override
        public boolean preScale(float sx, float sy, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preScale(float sx, float sy) {
            this.oops();
            return false;
        }

        @Override
        public boolean preRotate(float degrees, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preRotate(float degrees) {
            this.oops();
            return false;
        }

        @Override
        public boolean preSkew(float kx, float ky, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preSkew(float kx, float ky) {
            this.oops();
            return false;
        }

        @Override
        public boolean preConcat(Matrix other) {
            this.oops();
            return false;
        }

        @Override
        public boolean postTranslate(float dx, float dy) {
            this.oops();
            return false;
        }

        @Override
        public boolean postScale(float sx, float sy, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postScale(float sx, float sy) {
            this.oops();
            return false;
        }

        @Override
        public boolean postRotate(float degrees, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postRotate(float degrees) {
            this.oops();
            return false;
        }

        @Override
        public boolean postSkew(float kx, float ky, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postSkew(float kx, float ky) {
            this.oops();
            return false;
        }

        @Override
        public boolean postConcat(Matrix other) {
            this.oops();
            return false;
        }

        @Override
        public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
            this.oops();
            return false;
        }

        @Override
        public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
            this.oops();
            return false;
        }

        @Override
        public void setValues(float[] values) {
            this.oops();
        }
    };
    public long native_instance;

    public Matrix() {
        this.native_instance = Matrix.native_create(0L);
    }

    public Matrix(Matrix src) {
        this.native_instance = Matrix.native_create(src != null ? src.native_instance : 0L);
    }

    public boolean isIdentity() {
        return Matrix.native_isIdentity(this.native_instance);
    }

    public boolean isAffine() {
        return Matrix.native_isAffine(this.native_instance);
    }

    public boolean rectStaysRect() {
        return Matrix.native_rectStaysRect(this.native_instance);
    }

    public void set(Matrix src) {
        if (src == null) {
            this.reset();
        } else {
            Matrix.native_set(this.native_instance, src.native_instance);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        return Matrix.native_equals(this.native_instance, ((Matrix)obj).native_instance);
    }

    public int hashCode() {
        return 44;
    }

    public void reset() {
        Matrix.native_reset(this.native_instance);
    }

    public void setTranslate(float dx, float dy) {
        Matrix.native_setTranslate(this.native_instance, dx, dy);
    }

    public void setScale(float sx, float sy, float px, float py) {
        Matrix.native_setScale(this.native_instance, sx, sy, px, py);
    }

    public void setScale(float sx, float sy) {
        Matrix.native_setScale(this.native_instance, sx, sy);
    }

    public void setRotate(float degrees, float px, float py) {
        Matrix.native_setRotate(this.native_instance, degrees, px, py);
    }

    public void setRotate(float degrees) {
        Matrix.native_setRotate(this.native_instance, degrees);
    }

    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        Matrix.native_setSinCos(this.native_instance, sinValue, cosValue, px, py);
    }

    public void setSinCos(float sinValue, float cosValue) {
        Matrix.native_setSinCos(this.native_instance, sinValue, cosValue);
    }

    public void setSkew(float kx, float ky, float px, float py) {
        Matrix.native_setSkew(this.native_instance, kx, ky, px, py);
    }

    public void setSkew(float kx, float ky) {
        Matrix.native_setSkew(this.native_instance, kx, ky);
    }

    public boolean setConcat(Matrix a, Matrix b) {
        Matrix.native_setConcat(this.native_instance, a.native_instance, b.native_instance);
        return true;
    }

    public boolean preTranslate(float dx, float dy) {
        Matrix.native_preTranslate(this.native_instance, dx, dy);
        return true;
    }

    public boolean preScale(float sx, float sy, float px, float py) {
        Matrix.native_preScale(this.native_instance, sx, sy, px, py);
        return true;
    }

    public boolean preScale(float sx, float sy) {
        Matrix.native_preScale(this.native_instance, sx, sy);
        return true;
    }

    public boolean preRotate(float degrees, float px, float py) {
        Matrix.native_preRotate(this.native_instance, degrees, px, py);
        return true;
    }

    public boolean preRotate(float degrees) {
        Matrix.native_preRotate(this.native_instance, degrees);
        return true;
    }

    public boolean preSkew(float kx, float ky, float px, float py) {
        Matrix.native_preSkew(this.native_instance, kx, ky, px, py);
        return true;
    }

    public boolean preSkew(float kx, float ky) {
        Matrix.native_preSkew(this.native_instance, kx, ky);
        return true;
    }

    public boolean preConcat(Matrix other) {
        Matrix.native_preConcat(this.native_instance, other.native_instance);
        return true;
    }

    public boolean postTranslate(float dx, float dy) {
        Matrix.native_postTranslate(this.native_instance, dx, dy);
        return true;
    }

    public boolean postScale(float sx, float sy, float px, float py) {
        Matrix.native_postScale(this.native_instance, sx, sy, px, py);
        return true;
    }

    public boolean postScale(float sx, float sy) {
        Matrix.native_postScale(this.native_instance, sx, sy);
        return true;
    }

    public boolean postRotate(float degrees, float px, float py) {
        Matrix.native_postRotate(this.native_instance, degrees, px, py);
        return true;
    }

    public boolean postRotate(float degrees) {
        Matrix.native_postRotate(this.native_instance, degrees);
        return true;
    }

    public boolean postSkew(float kx, float ky, float px, float py) {
        Matrix.native_postSkew(this.native_instance, kx, ky, px, py);
        return true;
    }

    public boolean postSkew(float kx, float ky) {
        Matrix.native_postSkew(this.native_instance, kx, ky);
        return true;
    }

    public boolean postConcat(Matrix other) {
        Matrix.native_postConcat(this.native_instance, other.native_instance);
        return true;
    }

    public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.native_setRectToRect(this.native_instance, src, dst, stf.nativeInt);
    }

    private static void checkPointArrays(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        int srcStop = srcIndex + (pointCount << 1);
        int dstStop = dstIndex + (pointCount << 1);
        if ((pointCount | srcIndex | dstIndex | srcStop | dstStop) < 0 || srcStop > src.length || dstStop > dst.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        if (pointCount > 4) {
            throw new IllegalArgumentException();
        }
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        return Matrix.native_setPolyToPoly(this.native_instance, src, srcIndex, dst, dstIndex, pointCount);
    }

    public boolean invert(Matrix inverse) {
        return Matrix.native_invert(this.native_instance, inverse.native_instance);
    }

    public void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        Matrix.native_mapPoints(this.native_instance, dst, dstIndex, src, srcIndex, pointCount, true);
    }

    public void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int vectorCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, vectorCount);
        Matrix.native_mapPoints(this.native_instance, dst, dstIndex, src, srcIndex, vectorCount, false);
    }

    public void mapPoints(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapPoints(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapVectors(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapVectors(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    public void mapVectors(float[] vecs) {
        this.mapVectors(vecs, 0, vecs, 0, vecs.length >> 1);
    }

    public boolean mapRect(RectF dst, RectF src) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.native_mapRect(this.native_instance, dst, src);
    }

    public boolean mapRect(RectF rect) {
        return this.mapRect(rect, rect);
    }

    public float mapRadius(float radius) {
        return Matrix.native_mapRadius(this.native_instance, radius);
    }

    public void getValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.native_getValues(this.native_instance, values);
    }

    public void setValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.native_setValues(this.native_instance, values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Matrix{");
        this.toShortString(sb);
        sb.append('}');
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(64);
        this.toShortString(sb);
        return sb.toString();
    }

    public void toShortString(StringBuilder sb) {
        float[] values = new float[9];
        this.getValues(values);
        sb.append('[');
        sb.append(values[0]);
        sb.append(", ");
        sb.append(values[1]);
        sb.append(", ");
        sb.append(values[2]);
        sb.append("][");
        sb.append(values[3]);
        sb.append(", ");
        sb.append(values[4]);
        sb.append(", ");
        sb.append(values[5]);
        sb.append("][");
        sb.append(values[6]);
        sb.append(", ");
        sb.append(values[7]);
        sb.append(", ");
        sb.append(values[8]);
        sb.append(']');
    }

    public void printShortString(PrintWriter pw) {
        float[] values = new float[9];
        this.getValues(values);
        pw.print('[');
        pw.print(values[0]);
        pw.print(", ");
        pw.print(values[1]);
        pw.print(", ");
        pw.print(values[2]);
        pw.print("][");
        pw.print(values[3]);
        pw.print(", ");
        pw.print(values[4]);
        pw.print(", ");
        pw.print(values[5]);
        pw.print("][");
        pw.print(values[6]);
        pw.print(", ");
        pw.print(values[7]);
        pw.print(", ");
        pw.print(values[8]);
        pw.print(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Matrix.finalizer(this.native_instance);
        }
        finally {
            super.finalize();
        }
    }

    long ni() {
        return this.native_instance;
    }

    @LayoutlibDelegate
    private static long native_create(long l) {
        return Matrix_Delegate.native_create(l);
    }

    @LayoutlibDelegate
    private static boolean native_isIdentity(long l) {
        return Matrix_Delegate.native_isIdentity(l);
    }

    @LayoutlibDelegate
    private static boolean native_isAffine(long l) {
        return Matrix_Delegate.native_isAffine(l);
    }

    @LayoutlibDelegate
    private static boolean native_rectStaysRect(long l) {
        return Matrix_Delegate.native_rectStaysRect(l);
    }

    @LayoutlibDelegate
    private static void native_reset(long l) {
        Matrix_Delegate.native_reset(l);
    }

    @LayoutlibDelegate
    private static void native_set(long l, long l2) {
        Matrix_Delegate.native_set(l, l2);
    }

    @LayoutlibDelegate
    private static void native_setTranslate(long l, float f, float f2) {
        Matrix_Delegate.native_setTranslate(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_setScale(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_setScale(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_setScale(long l, float f, float f2) {
        Matrix_Delegate.native_setScale(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_setRotate(long l, float f, float f2, float f3) {
        Matrix_Delegate.native_setRotate(l, f, f2, f3);
    }

    @LayoutlibDelegate
    private static void native_setRotate(long l, float f) {
        Matrix_Delegate.native_setRotate(l, f);
    }

    @LayoutlibDelegate
    private static void native_setSinCos(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_setSinCos(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_setSinCos(long l, float f, float f2) {
        Matrix_Delegate.native_setSinCos(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_setSkew(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_setSkew(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_setSkew(long l, float f, float f2) {
        Matrix_Delegate.native_setSkew(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_setConcat(long l, long l2, long l3) {
        Matrix_Delegate.native_setConcat(l, l2, l3);
    }

    @LayoutlibDelegate
    private static void native_preTranslate(long l, float f, float f2) {
        Matrix_Delegate.native_preTranslate(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_preScale(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_preScale(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_preScale(long l, float f, float f2) {
        Matrix_Delegate.native_preScale(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_preRotate(long l, float f, float f2, float f3) {
        Matrix_Delegate.native_preRotate(l, f, f2, f3);
    }

    @LayoutlibDelegate
    private static void native_preRotate(long l, float f) {
        Matrix_Delegate.native_preRotate(l, f);
    }

    @LayoutlibDelegate
    private static void native_preSkew(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_preSkew(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_preSkew(long l, float f, float f2) {
        Matrix_Delegate.native_preSkew(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_preConcat(long l, long l2) {
        Matrix_Delegate.native_preConcat(l, l2);
    }

    @LayoutlibDelegate
    private static void native_postTranslate(long l, float f, float f2) {
        Matrix_Delegate.native_postTranslate(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_postScale(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_postScale(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_postScale(long l, float f, float f2) {
        Matrix_Delegate.native_postScale(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_postRotate(long l, float f, float f2, float f3) {
        Matrix_Delegate.native_postRotate(l, f, f2, f3);
    }

    @LayoutlibDelegate
    private static void native_postRotate(long l, float f) {
        Matrix_Delegate.native_postRotate(l, f);
    }

    @LayoutlibDelegate
    private static void native_postSkew(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_postSkew(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_postSkew(long l, float f, float f2) {
        Matrix_Delegate.native_postSkew(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_postConcat(long l, long l2) {
        Matrix_Delegate.native_postConcat(l, l2);
    }

    @LayoutlibDelegate
    private static boolean native_setRectToRect(long l, RectF rectF, RectF rectF2, int n) {
        return Matrix_Delegate.native_setRectToRect(l, rectF, rectF2, n);
    }

    @LayoutlibDelegate
    private static boolean native_setPolyToPoly(long l, float[] fArray, int n, float[] fArray2, int n2, int n3) {
        return Matrix_Delegate.native_setPolyToPoly(l, fArray, n, fArray2, n2, n3);
    }

    @LayoutlibDelegate
    private static boolean native_invert(long l, long l2) {
        return Matrix_Delegate.native_invert(l, l2);
    }

    @LayoutlibDelegate
    private static void native_mapPoints(long l, float[] fArray, int n, float[] fArray2, int n2, int n3, boolean bl) {
        Matrix_Delegate.native_mapPoints(l, fArray, n, fArray2, n2, n3, bl);
    }

    @LayoutlibDelegate
    private static boolean native_mapRect(long l, RectF rectF, RectF rectF2) {
        return Matrix_Delegate.native_mapRect(l, rectF, rectF2);
    }

    @LayoutlibDelegate
    private static float native_mapRadius(long l, float f) {
        return Matrix_Delegate.native_mapRadius(l, f);
    }

    @LayoutlibDelegate
    private static void native_getValues(long l, float[] fArray) {
        Matrix_Delegate.native_getValues(l, fArray);
    }

    @LayoutlibDelegate
    private static void native_setValues(long l, float[] fArray) {
        Matrix_Delegate.native_setValues(l, fArray);
    }

    @LayoutlibDelegate
    private static boolean native_equals(long l, long l2) {
        return Matrix_Delegate.native_equals(l, l2);
    }

    @LayoutlibDelegate
    private static void finalizer(long l) {
        Matrix_Delegate.finalizer(l);
    }

    public static enum ScaleToFit {
        FILL(0),
        START(1),
        CENTER(2),
        END(3);

        final int nativeInt;

        private ScaleToFit(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

