/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas_Delegate;
import android.graphics.Color;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import javax.microedition.khronos.opengles.GL;

public class Canvas {
    private long mNativeCanvasWrapper;
    private Bitmap mBitmap;
    private DrawFilter mDrawFilter;
    protected int mDensity = 0;
    protected int mScreenDensity = 0;
    private int mSurfaceFormat;
    public static final int DIRECTION_LTR = 0;
    public static final int DIRECTION_RTL = 1;
    private static final int MAXMIMUM_BITMAP_SIZE = 32766;
    private final CanvasFinalizer mFinalizer;
    public static final int MATRIX_SAVE_FLAG = 1;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int ALL_SAVE_FLAG = 31;

    public long getNativeCanvasWrapper() {
        return this.mNativeCanvasWrapper;
    }

    public boolean isRecordingFor(Object o) {
        return false;
    }

    public Canvas() {
        if (!this.isHardwareAccelerated()) {
            this.mNativeCanvasWrapper = Canvas.initRaster(0L);
            this.mFinalizer = new CanvasFinalizer(this.mNativeCanvasWrapper);
        } else {
            this.mFinalizer = null;
        }
    }

    public Canvas(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        Canvas.throwIfCannotDraw(bitmap);
        this.mNativeCanvasWrapper = Canvas.initRaster(bitmap.ni());
        this.mFinalizer = new CanvasFinalizer(this.mNativeCanvasWrapper);
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public Canvas(long nativeCanvas) {
        if (nativeCanvas == 0L) {
            throw new IllegalStateException();
        }
        this.mNativeCanvasWrapper = nativeCanvas;
        this.mFinalizer = new CanvasFinalizer(this.mNativeCanvasWrapper);
        this.mDensity = Bitmap.getDefaultDensity();
    }

    @Deprecated
    protected GL getGL() {
        return null;
    }

    public boolean isHardwareAccelerated() {
        return false;
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.isHardwareAccelerated()) {
            throw new RuntimeException("Can't set a bitmap device on a HW accelerated canvas");
        }
        if (bitmap == null) {
            Canvas.native_setBitmap(this.mNativeCanvasWrapper, 0L, false);
            this.mDensity = 0;
        } else {
            if (!bitmap.isMutable()) {
                throw new IllegalStateException();
            }
            Canvas.throwIfCannotDraw(bitmap);
            Canvas.native_setBitmap(this.mNativeCanvasWrapper, bitmap.ni(), true);
            this.mDensity = bitmap.mDensity;
        }
        this.mBitmap = bitmap;
    }

    private void setNativeBitmap(long bitmapHandle) {
        Canvas.native_setBitmap(this.mNativeCanvasWrapper, bitmapHandle, false);
    }

    public void setViewport(int width, int height) {
    }

    public void setHighContrastText(boolean highContrastText) {
    }

    public void insertReorderBarrier() {
    }

    public void insertInorderBarrier() {
    }

    public boolean isOpaque() {
        return Canvas.native_isOpaque(this.mNativeCanvasWrapper);
    }

    public int getWidth() {
        return Canvas.native_getWidth(this.mNativeCanvasWrapper);
    }

    public int getHeight() {
        return Canvas.native_getHeight(this.mNativeCanvasWrapper);
    }

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    public void setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    public int getMaximumBitmapWidth() {
        return 32766;
    }

    public int getMaximumBitmapHeight() {
        return 32766;
    }

    public int save() {
        return Canvas.native_save(this.mNativeCanvasWrapper, 3);
    }

    public int save(int saveFlags) {
        return Canvas.native_save(this.mNativeCanvasWrapper, saveFlags);
    }

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
    }

    public int saveLayer(RectF bounds, Paint paint) {
        return this.saveLayer(bounds, paint, 31);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvasWrapper, left, top, right, bottom, paint != null ? paint.mNativePaint : 0L, saveFlags);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint) {
        return this.saveLayer(left, top, right, bottom, paint, 31);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
    }

    public int saveLayerAlpha(RectF bounds, int alpha) {
        return this.saveLayerAlpha(bounds, alpha, 31);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.native_saveLayerAlpha(this.mNativeCanvasWrapper, left, top, right, bottom, alpha, saveFlags);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha) {
        return this.saveLayerAlpha(left, top, right, bottom, alpha, 31);
    }

    public void restore() {
        Canvas.native_restore(this.mNativeCanvasWrapper);
    }

    public int getSaveCount() {
        return Canvas.native_getSaveCount(this.mNativeCanvasWrapper);
    }

    public void restoreToCount(int saveCount) {
        Canvas.native_restoreToCount(this.mNativeCanvasWrapper, saveCount);
    }

    public void translate(float dx, float dy) {
        Canvas.native_translate(this.mNativeCanvasWrapper, dx, dy);
    }

    public void scale(float sx, float sy) {
        Canvas.native_scale(this.mNativeCanvasWrapper, sx, sy);
    }

    public void scale(float sx, float sy, float px, float py) {
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    public void rotate(float degrees) {
        Canvas.native_rotate(this.mNativeCanvasWrapper, degrees);
    }

    public void rotate(float degrees, float px, float py) {
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    public void skew(float sx, float sy) {
        Canvas.native_skew(this.mNativeCanvasWrapper, sx, sy);
    }

    public void concat(Matrix matrix) {
        if (matrix != null) {
            Canvas.native_concat(this.mNativeCanvasWrapper, matrix.native_instance);
        }
    }

    public void setMatrix(Matrix matrix) {
        Canvas.native_setMatrix(this.mNativeCanvasWrapper, matrix == null ? 0L : matrix.native_instance);
    }

    @Deprecated
    public void getMatrix(Matrix ctm) {
        Canvas.native_getCTM(this.mNativeCanvasWrapper, ctm.native_instance);
    }

    @Deprecated
    public Matrix getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rect) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(Rect rect) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(float left, float top, float right, float bottom) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipPath(Path path, Region.Op op) {
        return Canvas.native_clipPath(this.mNativeCanvasWrapper, path.ni(), op.nativeInt);
    }

    public boolean clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return Canvas.native_clipRegion(this.mNativeCanvasWrapper, region.ni(), op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        return this.clipRegion(region, Region.Op.INTERSECT);
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public void setDrawFilter(DrawFilter filter) {
        long nativeFilter = 0L;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nativeSetDrawFilter(this.mNativeCanvasWrapper, nativeFilter);
    }

    public boolean quickReject(RectF rect, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean quickReject(Path path, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, path.ni());
    }

    public boolean quickReject(float left, float top, float right, float bottom, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, left, top, right, bottom);
    }

    public boolean getClipBounds(Rect bounds) {
        return Canvas.native_getClipBounds(this.mNativeCanvasWrapper, bounds);
    }

    public Rect getClipBounds() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    public void drawRGB(int r, int g, int b) {
        this.drawColor(Color.rgb(r, g, b));
    }

    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor(Color.argb(a, r, g, b));
    }

    public void drawColor(int color2) {
        Canvas.native_drawColor(this.mNativeCanvasWrapper, color2, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        Canvas.native_drawColor(this.mNativeCanvasWrapper, color2, mode.nativeInt);
    }

    public void drawPaint(Paint paint) {
        Canvas.native_drawPaint(this.mNativeCanvasWrapper, paint.mNativePaint);
    }

    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        Canvas.native_drawPoints(this.mNativeCanvasWrapper, pts, offset, count, paint.mNativePaint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    public void drawPoint(float x, float y, Paint paint) {
        Canvas.native_drawPoint(this.mNativeCanvasWrapper, x, y, paint.mNativePaint);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        Canvas.native_drawLine(this.mNativeCanvasWrapper, startX, startY, stopX, stopY, paint.mNativePaint);
    }

    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        Canvas.native_drawLines(this.mNativeCanvasWrapper, pts, offset, count, paint.mNativePaint);
    }

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawRect(RectF rect, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, paint.mNativePaint);
    }

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvasWrapper, left, top, right, bottom, paint.mNativePaint);
    }

    public void drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        this.drawOval(oval.left, oval.top, oval.right, oval.bottom, paint);
    }

    public void drawOval(float left, float top, float right, float bottom, Paint paint) {
        Canvas.native_drawOval(this.mNativeCanvasWrapper, left, top, right, bottom, paint.mNativePaint);
    }

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        Canvas.native_drawCircle(this.mNativeCanvasWrapper, cx, cy, radius, paint.mNativePaint);
    }

    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.drawArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint);
    }

    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        Canvas.native_drawArc(this.mNativeCanvasWrapper, left, top, right, bottom, startAngle, sweepAngle, useCenter, paint.mNativePaint);
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint);
    }

    public void drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        Canvas.native_drawRoundRect(this.mNativeCanvasWrapper, left, top, right, bottom, rx, ry, paint.mNativePaint);
    }

    public void drawPath(Path path, Paint paint) {
        Canvas.native_drawPath(this.mNativeCanvasWrapper, path.ni(), paint.mNativePaint);
    }

    protected static void throwIfCannotDraw(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
        if (!bitmap.isPremultiplied() && bitmap.getConfig() == Bitmap.Config.ARGB_8888 && bitmap.hasAlpha()) {
            throw new RuntimeException("Canvas: trying to use a non-premultiplied bitmap " + bitmap);
        }
    }

    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        patch.drawSoftware(this, dst, paint);
    }

    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        patch.drawSoftware(this, dst, paint);
    }

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        Canvas.throwIfCannotDraw(bitmap);
        this.native_drawBitmap(this.mNativeCanvasWrapper, bitmap.ni(), left, top, paint != null ? paint.mNativePaint : 0L, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.mNativePaint;
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        this.native_drawBitmap(this.mNativeCanvasWrapper, bitmap.ni(), left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.mNativePaint;
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        this.native_drawBitmap(this.mNativeCanvasWrapper, bitmap.ni(), left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    @Deprecated
    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        Canvas.native_drawBitmap(this.mNativeCanvasWrapper, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.mNativePaint : 0L);
    }

    @Deprecated
    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        Canvas.nativeDrawBitmapMatrix(this.mNativeCanvasWrapper, bitmap.ni(), matrix.ni(), paint != null ? paint.mNativePaint : 0L);
    }

    protected static void checkRange(int length, int offset, int count) {
        if ((offset | count) < 0 || offset + count > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, count);
        }
        Canvas.nativeDrawBitmapMesh(this.mNativeCanvasWrapper, bitmap.ni(), meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.mNativePaint : 0L);
    }

    public void drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        Canvas.checkRange(verts.length, vertOffset, vertexCount);
        if (texs != null) {
            Canvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, vertexCount / 2);
        }
        if (indices != null) {
            Canvas.checkRange(indices.length, indexOffset, indexCount);
        }
        Canvas.nativeDrawVertices(this.mNativeCanvasWrapper, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.mNativePaint);
    }

    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvasWrapper, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawText(String text, float x, float y, Paint paint) {
        Canvas.native_drawText(this.mNativeCanvasWrapper, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvasWrapper, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawText(this.mNativeCanvasWrapper, text.toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            Canvas.native_drawText(this.mNativeCanvasWrapper, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
            TemporaryBuffer.recycle(buf);
        }
    }

    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawTextRun(this.mNativeCanvasWrapper, text, index, count, contextIndex, contextCount, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawTextRun(this.mNativeCanvasWrapper, text.toString(), start, end, contextStart, contextEnd, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, isRtl, paint);
        } else {
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            Canvas.native_drawTextRun(this.mNativeCanvasWrapper, buf, start - contextStart, len, 0, contextLen, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
            TemporaryBuffer.recycle(buf);
        }
    }

    @Deprecated
    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < count; ++i) {
            this.drawText(text, index + i, 1, pos[i * 2], pos[i * 2 + 1], paint);
        }
    }

    @Deprecated
    public void drawPosText(String text, float[] pos, Paint paint) {
        this.drawPosText(text.toCharArray(), 0, text.length(), pos, paint);
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawTextOnPath(this.mNativeCanvasWrapper, text, index, count, path.ni(), hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            Canvas.native_drawTextOnPath(this.mNativeCanvasWrapper, text, path.ni(), hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
        }
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        int restoreCount = this.save();
        picture.draw(this);
        this.restoreToCount(restoreCount);
    }

    public void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void release() {
        this.mFinalizer.dispose();
    }

    @LayoutlibDelegate
    public static void freeCaches() {
        Canvas_Delegate.freeCaches();
    }

    @LayoutlibDelegate
    public static void freeTextLayoutCaches() {
        Canvas_Delegate.freeTextLayoutCaches();
    }

    @LayoutlibDelegate
    private static long initRaster(long l) {
        return Canvas_Delegate.initRaster(l);
    }

    @LayoutlibDelegate
    private static void native_setBitmap(long l, long l2, boolean bl) {
        Canvas_Delegate.native_setBitmap(l, l2, bl);
    }

    @LayoutlibDelegate
    private static boolean native_isOpaque(long l) {
        return Canvas_Delegate.native_isOpaque(l);
    }

    @LayoutlibDelegate
    private static int native_getWidth(long l) {
        return Canvas_Delegate.native_getWidth(l);
    }

    @LayoutlibDelegate
    private static int native_getHeight(long l) {
        return Canvas_Delegate.native_getHeight(l);
    }

    @LayoutlibDelegate
    private static int native_save(long l, int n) {
        return Canvas_Delegate.native_save(l, n);
    }

    @LayoutlibDelegate
    private static int native_saveLayer(long l, float f, float f2, float f3, float f4, long l2, int n) {
        return Canvas_Delegate.native_saveLayer(l, f, f2, f3, f4, l2, n);
    }

    @LayoutlibDelegate
    private static int native_saveLayerAlpha(long l, float f, float f2, float f3, float f4, int n, int n2) {
        return Canvas_Delegate.native_saveLayerAlpha(l, f, f2, f3, f4, n, n2);
    }

    @LayoutlibDelegate
    private static void native_restore(long l) {
        Canvas_Delegate.native_restore(l);
    }

    @LayoutlibDelegate
    private static void native_restoreToCount(long l, int n) {
        Canvas_Delegate.native_restoreToCount(l, n);
    }

    @LayoutlibDelegate
    private static int native_getSaveCount(long l) {
        return Canvas_Delegate.native_getSaveCount(l);
    }

    @LayoutlibDelegate
    private static void native_translate(long l, float f, float f2) {
        Canvas_Delegate.native_translate(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_scale(long l, float f, float f2) {
        Canvas_Delegate.native_scale(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_rotate(long l, float f) {
        Canvas_Delegate.native_rotate(l, f);
    }

    @LayoutlibDelegate
    private static void native_skew(long l, float f, float f2) {
        Canvas_Delegate.native_skew(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_concat(long l, long l2) {
        Canvas_Delegate.native_concat(l, l2);
    }

    @LayoutlibDelegate
    private static void native_setMatrix(long l, long l2) {
        Canvas_Delegate.native_setMatrix(l, l2);
    }

    @LayoutlibDelegate
    private static boolean native_clipRect(long l, float f, float f2, float f3, float f4, int n) {
        return Canvas_Delegate.native_clipRect(l, f, f2, f3, f4, n);
    }

    @LayoutlibDelegate
    private static boolean native_clipPath(long l, long l2, int n) {
        return Canvas_Delegate.native_clipPath(l, l2, n);
    }

    @LayoutlibDelegate
    private static boolean native_clipRegion(long l, long l2, int n) {
        return Canvas_Delegate.native_clipRegion(l, l2, n);
    }

    @LayoutlibDelegate
    private static void nativeSetDrawFilter(long l, long l2) {
        Canvas_Delegate.nativeSetDrawFilter(l, l2);
    }

    @LayoutlibDelegate
    private static boolean native_getClipBounds(long l, Rect rect) {
        return Canvas_Delegate.native_getClipBounds(l, rect);
    }

    @LayoutlibDelegate
    private static void native_getCTM(long l, long l2) {
        Canvas_Delegate.native_getCTM(l, l2);
    }

    @LayoutlibDelegate
    private static boolean native_quickReject(long l, long l2) {
        return Canvas_Delegate.native_quickReject(l, l2);
    }

    @LayoutlibDelegate
    private static boolean native_quickReject(long l, float f, float f2, float f3, float f4) {
        return Canvas_Delegate.native_quickReject(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_drawColor(long l, int n, int n2) {
        Canvas_Delegate.native_drawColor(l, n, n2);
    }

    @LayoutlibDelegate
    private static void native_drawPaint(long l, long l2) {
        Canvas_Delegate.native_drawPaint(l, l2);
    }

    @LayoutlibDelegate
    private static void native_drawPoint(long l, float f, float f2, long l2) {
        Canvas_Delegate.native_drawPoint(l, f, f2, l2);
    }

    @LayoutlibDelegate
    private static void native_drawPoints(long l, float[] fArray, int n, int n2, long l2) {
        Canvas_Delegate.native_drawPoints(l, fArray, n, n2, l2);
    }

    @LayoutlibDelegate
    private static void native_drawLine(long l, float f, float f2, float f3, float f4, long l2) {
        Canvas_Delegate.native_drawLine(l, f, f2, f3, f4, l2);
    }

    @LayoutlibDelegate
    private static void native_drawLines(long l, float[] fArray, int n, int n2, long l2) {
        Canvas_Delegate.native_drawLines(l, fArray, n, n2, l2);
    }

    @LayoutlibDelegate
    private static void native_drawRect(long l, float f, float f2, float f3, float f4, long l2) {
        Canvas_Delegate.native_drawRect(l, f, f2, f3, f4, l2);
    }

    @LayoutlibDelegate
    private static void native_drawOval(long l, float f, float f2, float f3, float f4, long l2) {
        Canvas_Delegate.native_drawOval(l, f, f2, f3, f4, l2);
    }

    @LayoutlibDelegate
    private static void native_drawCircle(long l, float f, float f2, float f3, long l2) {
        Canvas_Delegate.native_drawCircle(l, f, f2, f3, l2);
    }

    @LayoutlibDelegate
    private static void native_drawArc(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, long l2) {
        Canvas_Delegate.native_drawArc(l, f, f2, f3, f4, f5, f6, bl, l2);
    }

    @LayoutlibDelegate
    private static void native_drawRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, long l2) {
        Canvas_Delegate.native_drawRoundRect(l, f, f2, f3, f4, f5, f6, l2);
    }

    @LayoutlibDelegate
    private static void native_drawPath(long l, long l2, long l3) {
        Canvas_Delegate.native_drawPath(l, l2, l3);
    }

    @LayoutlibDelegate
    private void native_drawBitmap(long l, long l2, float f, float f2, long l3, int n, int n2, int n3) {
        Canvas_Delegate.native_drawBitmap(this, l, l2, f, f2, l3, n, n2, n3);
    }

    @LayoutlibDelegate
    private void native_drawBitmap(long l, long l2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, long l3, int n, int n2) {
        Canvas_Delegate.native_drawBitmap(this, l, l2, f, f2, f3, f4, f5, f6, f7, f8, l3, n, n2);
    }

    @LayoutlibDelegate
    private static void native_drawBitmap(long l, int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, long l2) {
        Canvas_Delegate.native_drawBitmap(l, nArray, n, n2, f, f2, n3, n4, bl, l2);
    }

    @LayoutlibDelegate
    private static void nativeDrawBitmapMatrix(long l, long l2, long l3, long l4) {
        Canvas_Delegate.nativeDrawBitmapMatrix(l, l2, l3, l4);
    }

    @LayoutlibDelegate
    private static void nativeDrawBitmapMesh(long l, long l2, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, long l3) {
        Canvas_Delegate.nativeDrawBitmapMesh(l, l2, n, n2, fArray, n3, nArray, n4, l3);
    }

    @LayoutlibDelegate
    private static void nativeDrawVertices(long l, int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int[] nArray, int n5, short[] sArray, int n6, int n7, long l2) {
        Canvas_Delegate.nativeDrawVertices(l, n, n2, fArray, n3, fArray2, n4, nArray, n5, sArray, n6, n7, l2);
    }

    @LayoutlibDelegate
    private static void native_drawText(long l, char[] cArray, int n, int n2, float f, float f2, int n3, long l2, long l3) {
        Canvas_Delegate.native_drawText(l, cArray, n, n2, f, f2, n3, l2, l3);
    }

    @LayoutlibDelegate
    private static void native_drawText(long l, String string2, int n, int n2, float f, float f2, int n3, long l2, long l3) {
        Canvas_Delegate.native_drawText(l, string2, n, n2, f, f2, n3, l2, l3);
    }

    @LayoutlibDelegate
    private static void native_drawTextRun(long l, String string2, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
        Canvas_Delegate.native_drawTextRun(l, string2, n, n2, n3, n4, f, f2, bl, l2, l3);
    }

    @LayoutlibDelegate
    private static void native_drawTextRun(long l, char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
        Canvas_Delegate.native_drawTextRun(l, cArray, n, n2, n3, n4, f, f2, bl, l2, l3);
    }

    @LayoutlibDelegate
    private static void native_drawTextOnPath(long l, char[] cArray, int n, int n2, long l2, float f, float f2, int n3, long l3, long l4) {
        Canvas_Delegate.native_drawTextOnPath(l, cArray, n, n2, l2, f, f2, n3, l3, l4);
    }

    @LayoutlibDelegate
    private static void native_drawTextOnPath(long l, String string2, long l2, float f, float f2, int n, long l3, long l4) {
        Canvas_Delegate.native_drawTextOnPath(l, string2, l2, f, f2, n, l3, l4);
    }

    @LayoutlibDelegate
    private static void finalizer(long l) {
        Canvas_Delegate.finalizer(l);
    }

    public static enum VertexMode {
        TRIANGLES(0),
        TRIANGLE_STRIP(1),
        TRIANGLE_FAN(2);

        public final int nativeInt;

        private VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum EdgeType {
        BW(0),
        AA(1);

        public final int nativeInt;

        private EdgeType(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    private static class CanvasFinalizer {
        private long mNativeCanvasWrapper;

        public CanvasFinalizer(long nativeCanvas) {
            this.mNativeCanvasWrapper = nativeCanvas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.dispose();
            }
            finally {
                super.finalize();
            }
        }

        public void dispose() {
            if (this.mNativeCanvasWrapper != 0L) {
                Canvas.finalizer(this.mNativeCanvasWrapper);
                this.mNativeCanvasWrapper = 0L;
            }
        }
    }
}

