/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Configuration;
import android.content.res.ConstantState;
import android.content.res.Resources;
import android.util.ArrayMap;
import android.util.LongSparseArray;
import java.lang.ref.WeakReference;

public class ConfigurationBoundResourceCache<T> {
    private final ArrayMap<String, LongSparseArray<WeakReference<ConstantState<T>>>> mCache = new ArrayMap();
    final Resources mResources;

    public ConfigurationBoundResourceCache(Resources resources) {
        this.mResources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long key, Resources.Theme theme, ConstantState<T> constantState) {
        if (constantState == null) {
            return;
        }
        String themeKey = theme == null ? "" : theme.getKey();
        ConfigurationBoundResourceCache configurationBoundResourceCache = this;
        synchronized (configurationBoundResourceCache) {
            LongSparseArray<WeakReference<ConstantState<Object>>> themedCache = this.mCache.get(themeKey);
            if (themedCache == null) {
                themedCache = new LongSparseArray(1);
                this.mCache.put(themeKey, themedCache);
            }
            themedCache.put(key, new WeakReference<ConstantState<T>>(constantState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long key, Resources.Theme theme) {
        WeakReference<ConstantState<T>> wr;
        LongSparseArray<WeakReference<ConstantState<T>>> themedCache;
        String themeKey = theme != null ? theme.getKey() : "";
        ConfigurationBoundResourceCache configurationBoundResourceCache = this;
        synchronized (configurationBoundResourceCache) {
            themedCache = this.mCache.get(themeKey);
            if (themedCache == null) {
                return null;
            }
            wr = themedCache.get(key);
        }
        if (wr == null) {
            return null;
        }
        ConstantState entry = (ConstantState)wr.get();
        if (entry != null) {
            return entry.newInstance(this.mResources, theme);
        }
        ConfigurationBoundResourceCache configurationBoundResourceCache2 = this;
        synchronized (configurationBoundResourceCache2) {
            themedCache.delete(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationChange(int configChanges) {
        ConfigurationBoundResourceCache configurationBoundResourceCache = this;
        synchronized (configurationBoundResourceCache) {
            int size = this.mCache.size();
            for (int i = size - 1; i >= 0; --i) {
                LongSparseArray<WeakReference<ConstantState<T>>> themeCache = this.mCache.valueAt(i);
                this.onConfigurationChangeInt(themeCache, configChanges);
                if (themeCache.size() != 0) continue;
                this.mCache.removeAt(i);
            }
        }
    }

    private void onConfigurationChangeInt(LongSparseArray<WeakReference<ConstantState<T>>> themeCache, int configChanges) {
        int size = themeCache.size();
        for (int i = size - 1; i >= 0; --i) {
            WeakReference<ConstantState<T>> wr = themeCache.valueAt(i);
            ConstantState constantState = (ConstantState)wr.get();
            if (constantState != null && !Configuration.needNewResources(configChanges, constantState.getChangingConfigurations())) continue;
            themeCache.removeAt(i);
        }
    }
}

