/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.BridgeResources;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater_Delegate;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class BridgeTypedArray
extends TypedArray {
    private final BridgeResources mBridgeResources;
    private final BridgeContext mContext;
    private final boolean mPlatformFile;
    private final ResourceValue[] mResourceData;
    private final String[] mNames;
    private final boolean[] mIsFramework;

    public BridgeTypedArray(BridgeResources resources, BridgeContext context, int len, boolean platformFile) {
        super(resources, null, null, 0);
        this.mBridgeResources = resources;
        this.mContext = context;
        this.mPlatformFile = platformFile;
        this.mResourceData = new ResourceValue[len];
        this.mNames = new String[len];
        this.mIsFramework = new boolean[len];
    }

    public void bridgeSetValue(int index, String name, boolean isFramework, ResourceValue value) {
        this.mResourceData[index] = value;
        this.mNames[index] = name;
        this.mIsFramework[index] = isFramework;
    }

    public void sealArray() {
        int count = 0;
        for (int i = 0; i < this.mResourceData.length; ++i) {
            ResourceValue data = this.mResourceData[i];
            if (data == null) continue;
            if ("@null".equals(data.getValue())) {
                this.mResourceData[i] = null;
                continue;
            }
            ++count;
        }
        this.mIndices = new int[count + 1];
        this.mIndices[0] = count;
        int index = 1;
        for (int i = 0; i < this.mResourceData.length; ++i) {
            if (this.mResourceData[i] == null) continue;
            this.mIndices[index++] = i;
        }
    }

    public void setTheme(Resources.Theme theme) {
        this.mTheme = theme;
    }

    @Override
    public int length() {
        return this.mResourceData.length;
    }

    @Override
    public Resources getResources() {
        return this.mBridgeResources;
    }

    @Override
    public CharSequence getText(int index) {
        return this.getString(index);
    }

    @Override
    public String getString(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        Integer v = this.resolveEnumAttribute(index);
        return v == null ? this.mResourceData[index].getValue() : String.valueOf(v);
    }

    @Override
    public boolean getBoolean(int index, boolean defValue) {
        String s = this.getString(index);
        return s == null ? defValue : XmlUtils.convertValueToBoolean(s, defValue);
    }

    @Override
    public int getInt(int index, int defValue) {
        String s = this.getString(index);
        try {
            if (s != null) {
                return XmlUtils.convertValueToInt(s, defValue);
            }
        }
        catch (NumberFormatException e) {
            Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid integer", s, this.mNames[index]), null);
            return defValue;
        }
        return defValue;
    }

    @Override
    public float getFloat(int index, float defValue) {
        String s = this.getString(index);
        try {
            if (s != null) {
                return Float.parseFloat(s);
            }
        }
        catch (NumberFormatException e) {
            Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" cannot be converted to float.", s, this.mNames[index]), null);
        }
        return defValue;
    }

    @Override
    public int getColor(int index, int defValue) {
        if (index < 0 || index >= this.mResourceData.length) {
            return defValue;
        }
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        ColorStateList colorStateList = ResourceHelper.getColorStateList(this.mResourceData[index], this.mContext);
        if (colorStateList != null) {
            return colorStateList.getDefaultColor();
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColorStateList getColorStateList(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        ResourceValue resValue = this.mResourceData[index];
        String value = resValue.getValue();
        if (value == null) {
            return null;
        }
        File f = new File(value);
        if (f.isFile()) {
            XmlPullParser parser = ParserFactory.create(f);
            BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser(parser, this.mContext, resValue.isFramework());
            try {
                ColorStateList colorStateList = ColorStateList.createFromXml(this.mContext.getResources(), blockParser);
                blockParser.ensurePopped();
                return colorStateList;
            }
            catch (Throwable throwable) {
                try {
                    blockParser.ensurePopped();
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    Bridge.getLog().error("broken", "Failed to configure parser for " + value, (Throwable)e, null);
                    return null;
                }
                catch (Exception e) {
                    Bridge.getLog().error("resources.read", "Failed to parse file " + value, (Throwable)e, null);
                    return null;
                }
            }
        }
        try {
            int color2 = ResourceHelper.getColor(value);
            return ColorStateList.valueOf(color2);
        }
        catch (NumberFormatException e) {
            Bridge.getLog().error("resources.format", e.getMessage(), (Throwable)e, null);
            return null;
        }
    }

    @Override
    public int getInteger(int index, int defValue) {
        return this.getInt(index, defValue);
    }

    @Override
    public float getDimension(int index, float defValue) {
        String s = this.getString(index);
        if (s == null) {
            return defValue;
        }
        try {
            int i = Integer.parseInt(s);
            if (i == -1 || i == -2) {
                return i;
            }
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], s, this.mValue, true)) {
            return this.mValue.getDimension(this.mBridgeResources.getDisplayMetrics());
        }
        return defValue;
    }

    @Override
    public int getDimensionPixelOffset(int index, int defValue) {
        return (int)this.getDimension(index, defValue);
    }

    @Override
    public int getDimensionPixelSize(int index, int defValue) {
        try {
            return this.getDimension(index);
        }
        catch (RuntimeException e) {
            String s = this.getString(index);
            if (s != null) {
                Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid format.", s, this.mNames[index]), null);
            }
            return defValue;
        }
    }

    @Override
    public int getLayoutDimension(int index, String name) {
        try {
            return this.getDimension(index);
        }
        catch (RuntimeException e) {
            if (LayoutInflater_Delegate.sIsInInclude) {
                throw new RuntimeException();
            }
            Bridge.getLog().warning("resources.format", "You must supply a " + name + " attribute.", null);
            return 0;
        }
    }

    @Override
    public int getLayoutDimension(int index, int defValue) {
        return this.getDimensionPixelSize(index, defValue);
    }

    private int getDimension(int index) {
        String s = this.getString(index);
        if (s == null) {
            throw new RuntimeException();
        }
        try {
            int i = Integer.parseInt(s);
            if (i == -1 || i == -2) {
                return i;
            }
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], s, this.mValue, true)) {
            float f = this.mValue.getDimension(this.mBridgeResources.getDisplayMetrics());
            int res = (int)(f + 0.5f);
            if (res != 0) {
                return res;
            }
            if (f == 0.0f) {
                return 0;
            }
            if (f > 0.0f) {
                return 1;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public float getFraction(int index, int base, int pbase, float defValue) {
        String value = this.getString(index);
        if (value == null) {
            return defValue;
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], value, this.mValue, false)) {
            return this.mValue.getFraction(base, pbase);
        }
        Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" cannot be converted to a fraction.", value, this.mNames[index]), null);
        return defValue;
    }

    @Override
    public int getResourceId(int index, int defValue) {
        if (index < 0 || index >= this.mResourceData.length) {
            return defValue;
        }
        ResourceValue resValue = this.mResourceData[index];
        if (resValue == null) {
            return defValue;
        }
        if (resValue instanceof StyleResourceValue) {
            return this.mContext.getDynamicIdByStyle((StyleResourceValue)resValue);
        }
        if (resValue.getResourceType() != null) {
            if (this.mPlatformFile || resValue.isFramework()) {
                return this.mContext.getFrameworkResourceValue(resValue.getResourceType(), resValue.getName(), defValue);
            }
            return this.mContext.getProjectResourceValue(resValue.getResourceType(), resValue.getName(), defValue);
        }
        String value = resValue.getValue();
        if (value == null) {
            return defValue;
        }
        try {
            int i = Integer.parseInt(value);
            if (Integer.toString(i).equals(value)) {
                return i;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (value.startsWith("@id/") || value.startsWith("@+") || value.startsWith("@android:id/")) {
            boolean isFrameworkId;
            int pos = value.indexOf(47);
            String idName = value.substring(pos + 1);
            boolean create = value.startsWith("@+");
            boolean bl = isFrameworkId = this.mPlatformFile || value.startsWith("@android") || value.startsWith("@+android");
            if (create) {
                Integer idValue = isFrameworkId ? Bridge.getResourceId(ResourceType.ID, idName) : this.mContext.getProjectCallback().getResourceId(ResourceType.ID, idName);
                return idValue == null ? defValue : idValue;
            }
            if (isFrameworkId) {
                return this.mContext.getFrameworkResourceValue(ResourceType.ID, idName, defValue);
            }
            return this.mContext.getProjectResourceValue(ResourceType.ID, idName, defValue);
        }
        Integer idValue = resValue.isFramework() ? Bridge.getResourceId(resValue.getResourceType(), resValue.getName()) : this.mContext.getProjectCallback().getResourceId(resValue.getResourceType(), resValue.getName());
        if (idValue != null) {
            return idValue;
        }
        Bridge.getLog().warning("resources.resolve", String.format("Unable to resolve id \"%1$s\" for attribute \"%2$s\"", value, this.mNames[index]), (Object)resValue);
        return defValue;
    }

    @Override
    public int getThemeAttributeId(int index, int defValue) {
        return defValue;
    }

    @Override
    public Drawable getDrawable(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        ResourceValue value = this.mResourceData[index];
        return ResourceHelper.getDrawable(value, this.mContext, this.mTheme);
    }

    @Override
    public CharSequence[] getTextArray(int index) {
        String value = this.getString(index);
        if (value != null) {
            return new CharSequence[]{value};
        }
        return null;
    }

    @Override
    public int[] extractThemeAttrs() {
        return null;
    }

    @Override
    public int getChangingConfigurations() {
        return 0;
    }

    @Override
    public boolean getValue(int index, TypedValue outValue) {
        String s = this.getString(index);
        return s != null && ResourceHelper.parseFloatAttribute(this.mNames[index], s, outValue, false);
    }

    @Override
    public boolean hasValue(int index) {
        return index >= 0 && index < this.mResourceData.length && this.mResourceData[index] != null;
    }

    @Override
    public TypedValue peekValue(int index) {
        if (index < 0 || index >= this.mResourceData.length) {
            return null;
        }
        if (this.getValue(index, this.mValue)) {
            return this.mValue;
        }
        return null;
    }

    @Override
    public String getPositionDescription() {
        return "<internal -- stub if needed>";
    }

    @Override
    public void recycle() {
    }

    @Override
    public String toString() {
        return Arrays.toString(this.mResourceData);
    }

    private Integer resolveEnumAttribute(int index) {
        Map map = null;
        if (this.mIsFramework[index]) {
            map = Bridge.getEnumValues(this.mNames[index]);
        } else {
            RenderResources res = this.mContext.getRenderResources();
            ResourceValue attr2 = res.getProjectResource(ResourceType.ATTR, this.mNames[index]);
            if (attr2 instanceof AttrResourceValue) {
                map = ((AttrResourceValue)attr2).getAttributeValues();
            }
        }
        if (map != null) {
            String[] keywords;
            int result = 0;
            boolean found = false;
            for (String keyword : keywords = this.mResourceData[index].getValue().split("\\|")) {
                Integer i = (Integer)map.get(keyword.trim());
                if (i == null) continue;
                result |= i.intValue();
                found = true;
            }
            if (found) {
                return result;
            }
        }
        return null;
    }

    static TypedArray obtain(Resources res, int len) {
        return res instanceof BridgeResources ? new BridgeTypedArray((BridgeResources)res, null, len, true) : null;
    }
}

