/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager_Delegate;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.SparseArray;
import android.util.TypedValue;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.AutoCloseable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class AssetManager
implements AutoCloseable {
    public static final int ACCESS_UNKNOWN = 0;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_BUFFER = 3;
    private static final String TAG = "AssetManager";
    private static final boolean localLOGV = false;
    private static final boolean DEBUG_REFS = false;
    private static final Object sSync = new Object();
    static AssetManager sSystem = null;
    private final TypedValue mValue = new TypedValue();
    private final long[] mOffsets = new long[2];
    private long mObject;
    private StringBlock[] mStringBlocks = null;
    private int mNumRefs = 1;
    private boolean mOpen = true;
    private HashMap<Long, RuntimeException> mRefStacks;
    static final int STYLE_NUM_ENTRIES = 6;
    static final int STYLE_TYPE = 0;
    static final int STYLE_DATA = 1;
    static final int STYLE_ASSET_COOKIE = 2;
    static final int STYLE_RESOURCE_ID = 3;
    static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    static final int STYLE_DENSITY = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetManager() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.init(false);
            AssetManager.ensureSystemAssets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureSystemAssets() {
        Object object = sSync;
        synchronized (object) {
            if (sSystem == null) {
                AssetManager system = new AssetManager(true);
                system.makeStringBlocks(null);
                sSystem = system;
            }
        }
    }

    private AssetManager(boolean isSystem) {
        this.init(true);
    }

    public static AssetManager getSystem() {
        AssetManager.ensureSystemAssets();
        return sSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decRefsLocked(this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence getResourceText(int ident) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue tmpValue = this.mValue;
            int block = this.loadResourceValue(ident, (short)0, tmpValue, true);
            if (block >= 0) {
                if (tmpValue.type == 3) {
                    return this.mStringBlocks[block].get(tmpValue.data);
                }
                return tmpValue.coerceToString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence getResourceBagText(int ident, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue tmpValue = this.mValue;
            int block = this.loadResourceBagValue(ident, bagEntryId, tmpValue, true);
            if (block >= 0) {
                if (tmpValue.type == 3) {
                    return this.mStringBlocks[block].get(tmpValue.data);
                }
                return tmpValue.coerceToString();
            }
        }
        return null;
    }

    String[] getResourceStringArray(int id2) {
        String[] retArray = this.getArrayStringResource(id2);
        return retArray;
    }

    boolean getResourceValue(int ident, int density, TypedValue outValue, boolean resolveRefs) {
        int block = this.loadResourceValue(ident, (short)density, outValue, resolveRefs);
        if (block >= 0) {
            if (outValue.type != 3) {
                return true;
            }
            outValue.string = this.mStringBlocks[block].get(outValue.data);
            return true;
        }
        return false;
    }

    CharSequence[] getResourceTextArray(int id2) {
        int[] rawInfoArray = this.getArrayStringInfo(id2);
        int rawInfoArrayLen = rawInfoArray.length;
        int infoArrayLen = rawInfoArrayLen / 2;
        CharSequence[] retArray = new CharSequence[infoArrayLen];
        int i = 0;
        int j = 0;
        while (i < rawInfoArrayLen) {
            int block = rawInfoArray[i];
            int index = rawInfoArray[i + 1];
            retArray[j] = index >= 0 ? this.mStringBlocks[block].get(index) : null;
            i += 2;
            ++j;
        }
        return retArray;
    }

    boolean getThemeValue(long theme, int ident, TypedValue outValue, boolean resolveRefs) {
        int block = AssetManager.loadThemeAttributeValue(theme, ident, outValue, resolveRefs);
        if (block >= 0) {
            if (outValue.type != 3) {
                return true;
            }
            StringBlock[] blocks = this.mStringBlocks;
            if (blocks == null) {
                this.ensureStringBlocks();
                blocks = this.mStringBlocks;
            }
            outValue.string = blocks[block].get(outValue.data);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureStringBlocks() {
        if (this.mStringBlocks == null) {
            AssetManager assetManager = this;
            synchronized (assetManager) {
                if (this.mStringBlocks == null) {
                    this.makeStringBlocks(AssetManager.sSystem.mStringBlocks);
                }
            }
        }
    }

    void makeStringBlocks(StringBlock[] seed) {
        int seedNum = seed != null ? seed.length : 0;
        int num = this.getStringBlockCount();
        this.mStringBlocks = new StringBlock[num];
        for (int i = 0; i < num; ++i) {
            this.mStringBlocks[i] = i < seedNum ? seed[i] : new StringBlock(this.getNativeStringBlock(i), true);
        }
    }

    CharSequence getPooledStringForCookie(int cookie, int id2) {
        return this.mStringBlocks[cookie - 1].get(id2);
    }

    public InputStream open(String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open(String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long asset = this.openAsset(fileName, accessMode);
            if (asset != 0L) {
                AssetInputStream res = new AssetInputStream(asset);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openFd(String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openAssetFd(fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    public String[] list(String string2) throws IOException {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#list(Ljava/lang/String;)[Ljava/lang/String;", true, this);
    }

    public InputStream openNonAsset(String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    public InputStream openNonAsset(String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    public InputStream openNonAsset(int cookie, String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long asset = this.openNonAssetNative(cookie, fileName, accessMode);
            if (asset != 0L) {
                AssetInputStream res = new AssetInputStream(asset);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    public AssetFileDescriptor openNonAssetFd(String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openNonAssetFdNative(cookie, fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    public XmlResourceParser openXmlResourceParser(String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    public XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        XmlBlock block = this.openXmlBlockAsset(cookie, fileName);
        XmlResourceParser rp = block.newParser();
        block.close();
        return rp;
    }

    XmlBlock openXmlBlockAsset(String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlBlock openXmlBlockAsset(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long xmlBlock = this.openXmlAssetNative(cookie, fileName);
            if (xmlBlock != 0L) {
                XmlBlock res = new XmlBlock(this, xmlBlock);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset XML file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void xmlBlockGone(int id2) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.decRefsLocked(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long res = this.newTheme();
            this.incRefsLocked(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseTheme(long theme) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.deleteTheme(theme);
            this.decRefsLocked(theme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAssetPath(String path) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            int res = this.addAssetPathNative(path);
            this.makeStringBlocks(this.mStringBlocks);
            return res;
        }
    }

    private int addAssetPathNative(String string2) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#addAssetPathNative(Ljava/lang/String;)I", true, this);
    }

    public int addOverlayPath(String string2) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#addOverlayPath(Ljava/lang/String;)I", true, this);
    }

    public int[] addAssetPaths(String[] paths) {
        if (paths == null) {
            return null;
        }
        int[] cookies = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            cookies[i] = this.addAssetPath(paths[i]);
        }
        return cookies;
    }

    public boolean isUpToDate() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#isUpToDate()Z", true, this) != 0;
    }

    public void setLocale(String string2) {
        OverrideMethod.invokeV("android.content.res.AssetManager#setLocale(Ljava/lang/String;)V", true, this);
    }

    public String[] getLocales() {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#getLocales()[Ljava/lang/String;", true, this);
    }

    public void setConfiguration(int n, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        OverrideMethod.invokeV("android.content.res.AssetManager#setConfiguration(IILjava/lang/String;IIIIIIIIIIIIII)V", true, this);
    }

    int getResourceIdentifier(String string2, String string3, String string4) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getResourceIdentifier(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I", true, this);
    }

    String getResourceName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getResourceName(I)Ljava/lang/String;", true, this);
    }

    String getResourcePackageName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getResourcePackageName(I)Ljava/lang/String;", true, this);
    }

    String getResourceTypeName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getResourceTypeName(I)Ljava/lang/String;", true, this);
    }

    String getResourceEntryName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getResourceEntryName(I)Ljava/lang/String;", true, this);
    }

    private long openAsset(String string2, int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#openAsset(Ljava/lang/String;I)J", true, this);
    }

    private ParcelFileDescriptor openAssetFd(String string2, long[] lArray) throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.content.res.AssetManager#openAssetFd(Ljava/lang/String;[J)Landroid/os/ParcelFileDescriptor;", true, this);
    }

    private long openNonAssetNative(int n, String string2, int n2) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#openNonAssetNative(ILjava/lang/String;I)J", true, this);
    }

    private ParcelFileDescriptor openNonAssetFdNative(int n, String string2, long[] lArray) throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.content.res.AssetManager#openNonAssetFdNative(ILjava/lang/String;[J)Landroid/os/ParcelFileDescriptor;", true, this);
    }

    private void destroyAsset(long l) {
        OverrideMethod.invokeV("android.content.res.AssetManager#destroyAsset(J)V", true, this);
    }

    private int readAssetChar(long l) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#readAssetChar(J)I", true, this);
    }

    private int readAsset(long l, byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#readAsset(J[BII)I", true, this);
    }

    private long seekAsset(long l, long l2, int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#seekAsset(JJI)J", true, this);
    }

    private long getAssetLength(long l) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#getAssetLength(J)J", true, this);
    }

    private long getAssetRemainingLength(long l) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#getAssetRemainingLength(J)J", true, this);
    }

    private int loadResourceValue(int n, short s, TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#loadResourceValue(ISLandroid/util/TypedValue;Z)I", true, this);
    }

    private int loadResourceBagValue(int n, int n2, TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#loadResourceBagValue(IILandroid/util/TypedValue;Z)I", true, this);
    }

    static boolean applyStyle(long l, int n, int n2, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#applyStyle(JIIJ[I[I[I)Z", true, null) != 0;
    }

    static boolean resolveAttrs(long l, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#resolveAttrs(JII[I[I[I[I)Z", true, null) != 0;
    }

    boolean retrieveAttributes(long l, int[] nArray, int[] nArray2, int[] nArray3) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#retrieveAttributes(J[I[I[I)Z", true, this) != 0;
    }

    int getArraySize(int n) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getArraySize(I)I", true, this);
    }

    int retrieveArray(int n, int[] nArray) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#retrieveArray(I[I)I", true, this);
    }

    private int getStringBlockCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getStringBlockCount()I", true, this);
    }

    private long getNativeStringBlock(int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#getNativeStringBlock(I)J", true, this);
    }

    public String getCookieName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getCookieName(I)Ljava/lang/String;", true, this);
    }

    public SparseArray<String> getAssignedPackageIdentifiers() {
        return (SparseArray)OverrideMethod.invokeA("android.content.res.AssetManager#getAssignedPackageIdentifiers()Landroid/util/SparseArray;", true, this);
    }

    public static int getGlobalAssetCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getGlobalAssetCount()I", true, null);
    }

    public static String getAssetAllocations() {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getAssetAllocations()Ljava/lang/String;", true, null);
    }

    public static int getGlobalAssetManagerCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getGlobalAssetManagerCount()I", true, null);
    }

    @LayoutlibDelegate
    private long newTheme() {
        return AssetManager_Delegate.newTheme(this);
    }

    @LayoutlibDelegate
    private void deleteTheme(long l) {
        AssetManager_Delegate.deleteTheme(this, l);
    }

    static void applyThemeStyle(long l, int n, boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#applyThemeStyle(JIZ)V", true, null);
    }

    static void copyTheme(long l, long l2) {
        OverrideMethod.invokeV("android.content.res.AssetManager#copyTheme(JJ)V", true, null);
    }

    static int loadThemeAttributeValue(long l, int n, TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#loadThemeAttributeValue(JILandroid/util/TypedValue;Z)I", true, null);
    }

    static void dumpTheme(long l, int n, String string2, String string3) {
        OverrideMethod.invokeV("android.content.res.AssetManager#dumpTheme(JILjava/lang/String;Ljava/lang/String;)V", true, null);
    }

    private long openXmlAssetNative(int n, String string2) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#openXmlAssetNative(ILjava/lang/String;)J", true, this);
    }

    private String[] getArrayStringResource(int n) {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#getArrayStringResource(I)[Ljava/lang/String;", true, this);
    }

    private int[] getArrayStringInfo(int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#getArrayStringInfo(I)[I", true, this);
    }

    int[] getArrayIntResource(int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#getArrayIntResource(I)[I", true, this);
    }

    int[] getStyleAttributes(int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#getStyleAttributes(I)[I", true, this);
    }

    private void init(boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#init(Z)V", true, this);
    }

    private void destroy() {
        OverrideMethod.invokeV("android.content.res.AssetManager#destroy()V", true, this);
    }

    private void incRefsLocked(long id2) {
        ++this.mNumRefs;
    }

    private void decRefsLocked(long id2) {
        --this.mNumRefs;
        if (this.mNumRefs == 0) {
            this.destroy();
        }
    }

    public class AssetInputStream
    extends InputStream {
        private long mAsset;
        private long mLength;
        private long mMarkPos;

        public int getAssetInt() {
            throw new UnsupportedOperationException();
        }

        public long getNativeAsset() {
            return this.mAsset;
        }

        private AssetInputStream(long asset) {
            this.mAsset = asset;
            this.mLength = AssetManager.this.getAssetLength(asset);
        }

        @Override
        public int read() throws IOException {
            return AssetManager.this.readAssetChar(this.mAsset);
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int available() throws IOException {
            long len = AssetManager.this.getAssetRemainingLength(this.mAsset);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            AssetManager assetManager = AssetManager.this;
            synchronized (assetManager) {
                if (this.mAsset != 0L) {
                    AssetManager.this.destroyAsset(this.mAsset);
                    this.mAsset = 0L;
                    AssetManager.this.decRefsLocked(this.hashCode());
                }
            }
        }

        @Override
        public void mark(int readlimit) {
            this.mMarkPos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
        }

        @Override
        public void reset() throws IOException {
            AssetManager.this.seekAsset(this.mAsset, this.mMarkPos, -1);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            long pos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                AssetManager.this.seekAsset(this.mAsset, n, 0);
            }
            return n;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

