/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

public class SyncActivityTooManyDeletes
extends Activity
implements AdapterView.OnItemClickListener {
    private long mNumDeletes;
    private Account mAccount;
    private String mAuthority;
    private String mProvider;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getIntent().getExtras();
        if (extras == null) {
            this.finish();
            return;
        }
        this.mNumDeletes = extras.getLong("numDeletes");
        this.mAccount = (Account)extras.getParcelable("account");
        this.mAuthority = extras.getString("authority");
        this.mProvider = extras.getString("provider");
        CharSequence[] options = new CharSequence[]{this.getResources().getText(17040763), this.getResources().getText(17040764), this.getResources().getText(17040765)};
        ArrayAdapter<CharSequence> adapter = new ArrayAdapter<CharSequence>((Context)this, 17367043, 16908308, options);
        ListView listView = new ListView(this);
        listView.setAdapter(adapter);
        listView.setItemsCanFocus(true);
        listView.setOnItemClickListener(this);
        TextView textView = new TextView(this);
        CharSequence tooManyDeletesDescFormat = this.getResources().getText(17040762);
        textView.setText(String.format(tooManyDeletesDescFormat.toString(), this.mNumDeletes, this.mProvider, this.mAccount.name));
        LinearLayout ll = new LinearLayout(this);
        ll.setOrientation(1);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2, 0.0f);
        ll.addView((View)textView, lp);
        ll.addView((View)listView, lp);
        this.setContentView(ll);
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (position == 0) {
            this.startSyncReallyDelete();
        } else if (position == 1) {
            this.startSyncUndoDeletes();
        }
        this.finish();
    }

    private void startSyncReallyDelete() {
        Bundle extras = new Bundle();
        extras.putBoolean("deletions_override", true);
        extras.putBoolean("force", true);
        extras.putBoolean("expedited", true);
        extras.putBoolean("upload", true);
        ContentResolver.requestSync(this.mAccount, this.mAuthority, extras);
    }

    private void startSyncUndoDeletes() {
        Bundle extras = new Bundle();
        extras.putBoolean("discard_deletions", true);
        extras.putBoolean("force", true);
        extras.putBoolean("expedited", true);
        extras.putBoolean("upload", true);
        ContentResolver.requestSync(this.mAccount, this.mAuthority, extras);
    }
}

