/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.CloseGuard;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class ContentProviderClient {
    private static final String TAG = "ContentProviderClient";
    @GuardedBy(value="ContentProviderClient.class")
    private static Handler sAnrHandler;
    private final ContentResolver mContentResolver;
    private final IContentProvider mContentProvider;
    private final String mPackageName;
    private final boolean mStable;
    private final CloseGuard mGuard = CloseGuard.get();
    private long mAnrTimeout;
    private NotRespondingRunnable mAnrRunnable;
    private boolean mReleased;

    ContentProviderClient(ContentResolver contentResolver, IContentProvider contentProvider, boolean stable) {
        this.mContentResolver = contentResolver;
        this.mContentProvider = contentProvider;
        this.mPackageName = contentResolver.mPackageName;
        this.mStable = stable;
        this.mGuard.open("release");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetectNotResponding(long timeoutMillis) {
        Class<ContentProviderClient> clazz = ContentProviderClient.class;
        synchronized (ContentProviderClient.class) {
            this.mAnrTimeout = timeoutMillis;
            if (timeoutMillis > 0L) {
                if (this.mAnrRunnable == null) {
                    this.mAnrRunnable = new NotRespondingRunnable();
                }
                if (sAnrHandler == null) {
                    sAnrHandler = new Handler(Looper.getMainLooper(), null, true);
                }
            } else {
                this.mAnrRunnable = null;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private void beforeRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.postDelayed(this.mAnrRunnable, this.mAnrTimeout);
        }
    }

    private void afterRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.removeCallbacks(this.mAnrRunnable);
        }
    }

    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        return this.query(url, projection, selection, selectionArgs, sortOrder, null);
    }

    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) throws RemoteException {
        this.beforeRemote();
        try {
            ICancellationSignal remoteCancellationSignal = null;
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
                remoteCancellationSignal = this.mContentProvider.createCancellationSignal();
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
            Cursor cursor = this.mContentProvider.query(this.mPackageName, url, projection, selection, selectionArgs, sortOrder, remoteCancellationSignal);
            return cursor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public String getType(Uri url) throws RemoteException {
        this.beforeRemote();
        try {
            String string2 = this.mContentProvider.getType(url);
            return string2;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public String[] getStreamTypes(Uri url, String mimeTypeFilter) throws RemoteException {
        this.beforeRemote();
        try {
            String[] stringArray = this.mContentProvider.getStreamTypes(url, mimeTypeFilter);
            return stringArray;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public Uri canonicalize(Uri url) throws RemoteException {
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.canonicalize(this.mPackageName, url);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public Uri uncanonicalize(Uri url) throws RemoteException {
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.uncanonicalize(this.mPackageName, url);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public Uri insert(Uri url, ContentValues initialValues) throws RemoteException {
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.insert(this.mPackageName, url, initialValues);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public int bulkInsert(Uri url, ContentValues[] initialValues) throws RemoteException {
        this.beforeRemote();
        try {
            int n = this.mContentProvider.bulkInsert(this.mPackageName, url, initialValues);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public int delete(Uri url, String selection, String[] selectionArgs) throws RemoteException {
        this.beforeRemote();
        try {
            int n = this.mContentProvider.delete(this.mPackageName, url, selection, selectionArgs);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        this.beforeRemote();
        try {
            int n = this.mContentProvider.update(this.mPackageName, url, values, selection, selectionArgs);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public ParcelFileDescriptor openFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.openFile(url, mode, null);
    }

    public ParcelFileDescriptor openFile(Uri url, String mode, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            ParcelFileDescriptor parcelFileDescriptor = this.mContentProvider.openFile(this.mPackageName, url, mode, remoteSignal, null);
            return parcelFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public AssetFileDescriptor openAssetFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.openAssetFile(url, mode, null);
    }

    public AssetFileDescriptor openAssetFile(Uri url, String mode, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            AssetFileDescriptor assetFileDescriptor = this.mContentProvider.openAssetFile(this.mPackageName, url, mode, remoteSignal);
            return assetFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts) throws RemoteException, FileNotFoundException {
        return this.openTypedAssetFileDescriptor(uri, mimeType, opts, null);
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            AssetFileDescriptor assetFileDescriptor = this.mContentProvider.openTypedAssetFile(this.mPackageName, uri, mimeType, opts, remoteSignal);
            return assetFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        this.beforeRemote();
        try {
            ContentProviderResult[] contentProviderResultArray = this.mContentProvider.applyBatch(this.mPackageName, operations);
            return contentProviderResultArray;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public Bundle call(String method, String arg, Bundle extras) throws RemoteException {
        this.beforeRemote();
        try {
            Bundle bundle = this.mContentProvider.call(this.mPackageName, method, arg, extras);
            return bundle;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release() {
        ContentProviderClient contentProviderClient = this;
        synchronized (contentProviderClient) {
            if (this.mReleased) {
                throw new IllegalStateException("Already released");
            }
            this.mReleased = true;
            this.mGuard.close();
            if (this.mStable) {
                return this.mContentResolver.releaseProvider(this.mContentProvider);
            }
            return this.mContentResolver.releaseUnstableProvider(this.mContentProvider);
        }
    }

    protected void finalize() throws Throwable {
        if (this.mGuard != null) {
            this.mGuard.warnIfOpen();
        }
    }

    public ContentProvider getLocalContentProvider() {
        return ContentProvider.coerceToLocalContentProvider(this.mContentProvider);
    }

    public static void releaseQuietly(ContentProviderClient client) {
        if (client != null) {
            try {
                client.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class NotRespondingRunnable
    implements Runnable {
        private NotRespondingRunnable() {
        }

        @Override
        public void run() {
            Log.w(ContentProviderClient.TAG, "Detected provider not responding: " + ContentProviderClient.this.mContentProvider);
            ContentProviderClient.this.mContentResolver.appNotRespondingViaProvider(ContentProviderClient.this.mContentProvider);
        }
    }
}

