/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import android.widget.TextView;

public class AppWidgetHostView
extends FrameLayout {
    static final String TAG = "AppWidgetHostView";
    static final boolean LOGD = false;
    static final boolean CROSSFADE = false;
    static final int VIEW_MODE_NOINIT = 0;
    static final int VIEW_MODE_CONTENT = 1;
    static final int VIEW_MODE_ERROR = 2;
    static final int VIEW_MODE_DEFAULT = 3;
    static final int FADE_DURATION = 1000;
    static final LayoutInflater.Filter sInflaterFilter = new LayoutInflater.Filter(){

        @Override
        public boolean onLoadClass(Class clazz) {
            return clazz.isAnnotationPresent(RemoteViews.RemoteView.class);
        }
    };
    Context mContext;
    Context mRemoteContext;
    int mAppWidgetId;
    AppWidgetProviderInfo mInfo;
    View mView;
    int mViewMode = 0;
    int mLayoutId = -1;
    long mFadeStartTime = -1L;
    Bitmap mOld;
    Paint mOldPaint = new Paint();
    private RemoteViews.OnClickHandler mOnClickHandler;

    public AppWidgetHostView(Context context) {
        this(context, 0x10A0000, 0x10A0001);
    }

    public AppWidgetHostView(Context context, RemoteViews.OnClickHandler handler) {
        this(context, 0x10A0000, 0x10A0001);
        this.mOnClickHandler = handler;
    }

    public AppWidgetHostView(Context context, int animationIn, int animationOut) {
        super(context);
        this.mContext = context;
        this.setIsRootNamespace(true);
    }

    public void setOnClickHandler(RemoteViews.OnClickHandler handler) {
        this.mOnClickHandler = handler;
    }

    public void setAppWidget(int appWidgetId, AppWidgetProviderInfo info) {
        this.mAppWidgetId = appWidgetId;
        this.mInfo = info;
        if (info != null) {
            Rect padding = AppWidgetHostView.getDefaultPaddingForWidget(this.mContext, info.provider, null);
            this.setPadding(padding.left, padding.top, padding.right, padding.bottom);
            this.setContentDescription(info.label);
        }
    }

    public static Rect getDefaultPaddingForWidget(Context context, ComponentName component, Rect padding) {
        ApplicationInfo appInfo;
        PackageManager packageManager = context.getPackageManager();
        if (padding == null) {
            padding = new Rect(0, 0, 0, 0);
        } else {
            padding.set(0, 0, 0, 0);
        }
        try {
            appInfo = packageManager.getApplicationInfo(component.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return padding;
        }
        if (appInfo.targetSdkVersion >= 14) {
            Resources r = context.getResources();
            padding.left = r.getDimensionPixelSize(17104973);
            padding.right = r.getDimensionPixelSize(17104975);
            padding.top = r.getDimensionPixelSize(17104974);
            padding.bottom = r.getDimensionPixelSize(0x1050050);
        }
        return padding;
    }

    public int getAppWidgetId() {
        return this.mAppWidgetId;
    }

    public AppWidgetProviderInfo getAppWidgetInfo() {
        return this.mInfo;
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        ParcelableSparseArray jail = new ParcelableSparseArray();
        super.dispatchSaveInstanceState(jail);
        container.put(this.generateId(), jail);
    }

    private int generateId() {
        int id2 = this.getId();
        return id2 == -1 ? this.mAppWidgetId : id2;
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable parcelable = container.get(this.generateId());
        ParcelableSparseArray jail = null;
        if (parcelable != null && parcelable instanceof ParcelableSparseArray) {
            jail = (ParcelableSparseArray)parcelable;
        }
        if (jail == null) {
            jail = new ParcelableSparseArray();
        }
        try {
            super.dispatchRestoreInstanceState(jail);
        }
        catch (Exception e) {
            Log.e(TAG, "failed to restoreInstanceState for widget id: " + this.mAppWidgetId + ", " + (this.mInfo == null ? "null" : this.mInfo.provider), e);
        }
    }

    public void updateAppWidgetSize(Bundle newOptions, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        this.updateAppWidgetSize(newOptions, minWidth, minHeight, maxWidth, maxHeight, false);
    }

    public void updateAppWidgetSize(Bundle newOptions, int minWidth, int minHeight, int maxWidth, int maxHeight, boolean ignorePadding) {
        if (newOptions == null) {
            newOptions = new Bundle();
        }
        Rect padding = new Rect();
        if (this.mInfo != null) {
            padding = AppWidgetHostView.getDefaultPaddingForWidget(this.mContext, this.mInfo.provider, padding);
        }
        float density = this.getResources().getDisplayMetrics().density;
        int xPaddingDips = (int)((float)(padding.left + padding.right) / density);
        int yPaddingDips = (int)((float)(padding.top + padding.bottom) / density);
        int newMinWidth = minWidth - (ignorePadding ? 0 : xPaddingDips);
        int newMinHeight = minHeight - (ignorePadding ? 0 : yPaddingDips);
        int newMaxWidth = maxWidth - (ignorePadding ? 0 : xPaddingDips);
        int newMaxHeight = maxHeight - (ignorePadding ? 0 : yPaddingDips);
        AppWidgetManager widgetManager = AppWidgetManager.getInstance(this.mContext);
        Bundle oldOptions = widgetManager.getAppWidgetOptions(this.mAppWidgetId);
        boolean needsUpdate = false;
        if (newMinWidth != oldOptions.getInt("appWidgetMinWidth") || newMinHeight != oldOptions.getInt("appWidgetMinHeight") || newMaxWidth != oldOptions.getInt("appWidgetMaxWidth") || newMaxHeight != oldOptions.getInt("appWidgetMaxHeight")) {
            needsUpdate = true;
        }
        if (needsUpdate) {
            newOptions.putInt("appWidgetMinWidth", newMinWidth);
            newOptions.putInt("appWidgetMinHeight", newMinHeight);
            newOptions.putInt("appWidgetMaxWidth", newMaxWidth);
            newOptions.putInt("appWidgetMaxHeight", newMaxHeight);
            this.updateAppWidgetOptions(newOptions);
        }
    }

    public void updateAppWidgetOptions(Bundle options) {
        AppWidgetManager.getInstance(this.mContext).updateAppWidgetOptions(this.mAppWidgetId, options);
    }

    @Override
    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        Context context = this.mRemoteContext != null ? this.mRemoteContext : this.mContext;
        return new FrameLayout.LayoutParams(context, attrs);
    }

    void resetAppWidget(AppWidgetProviderInfo info) {
        this.mInfo = info;
        this.mViewMode = 0;
        this.updateAppWidget(null);
    }

    public void updateAppWidget(RemoteViews remoteViews) {
        boolean recycled = false;
        View content = null;
        RuntimeException exception = null;
        if (remoteViews == null) {
            if (this.mViewMode == 3) {
                return;
            }
            content = this.getDefaultView();
            this.mLayoutId = -1;
            this.mViewMode = 3;
        } else {
            this.mRemoteContext = this.getRemoteContext();
            int layoutId = remoteViews.getLayoutId();
            if (content == null && layoutId == this.mLayoutId) {
                try {
                    remoteViews.reapply(this.mContext, this.mView, this.mOnClickHandler);
                    content = this.mView;
                    recycled = true;
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            if (content == null) {
                try {
                    content = remoteViews.apply(this.mContext, this, this.mOnClickHandler);
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            this.mLayoutId = layoutId;
            this.mViewMode = 1;
        }
        if (content == null) {
            if (this.mViewMode == 2) {
                return;
            }
            Log.w(TAG, "updateAppWidget couldn't find any view, using error view", exception);
            content = this.getErrorView();
            this.mViewMode = 2;
        }
        if (!recycled) {
            this.prepareView(content);
            this.addView(content);
        }
        if (this.mView != content) {
            this.removeView(this.mView);
            this.mView = content;
        }
    }

    void viewDataChanged(int viewId) {
        View v = this.findViewById(viewId);
        if (v != null && v instanceof AdapterView) {
            AdapterView adapterView = (AdapterView)v;
            Object adapter = adapterView.getAdapter();
            if (adapter instanceof BaseAdapter) {
                BaseAdapter baseAdapter = (BaseAdapter)adapter;
                baseAdapter.notifyDataSetChanged();
            } else if (adapter == null && adapterView instanceof RemoteViewsAdapter.RemoteAdapterConnectionCallback) {
                ((RemoteViewsAdapter.RemoteAdapterConnectionCallback)((Object)adapterView)).deferNotifyDataSetChanged();
            }
        }
    }

    private Context getRemoteContext() {
        try {
            return this.mContext.createApplicationContext(this.mInfo.providerInfo.applicationInfo, 4);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Package name " + this.mInfo.providerInfo.packageName + " not found");
            return this.mContext;
        }
    }

    @Override
    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return super.drawChild(canvas, child, drawingTime);
    }

    protected void prepareView(View view) {
        FrameLayout.LayoutParams requested = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (requested == null) {
            requested = new FrameLayout.LayoutParams(-1, -1);
        }
        requested.gravity = 17;
        view.setLayoutParams(requested);
    }

    protected View getDefaultView() {
        View defaultView = null;
        RuntimeException exception = null;
        try {
            if (this.mInfo != null) {
                int category;
                Context theirContext;
                this.mRemoteContext = theirContext = this.getRemoteContext();
                LayoutInflater inflater = (LayoutInflater)theirContext.getSystemService("layout_inflater");
                inflater = inflater.cloneInContext(theirContext);
                inflater.setFilter(sInflaterFilter);
                AppWidgetManager manager = AppWidgetManager.getInstance(this.mContext);
                Bundle options = manager.getAppWidgetOptions(this.mAppWidgetId);
                int layoutId = this.mInfo.initialLayout;
                if (options.containsKey("appWidgetCategory") && (category = options.getInt("appWidgetCategory")) == 2) {
                    int kgLayoutId = this.mInfo.initialKeyguardLayout;
                    layoutId = kgLayoutId == 0 ? layoutId : kgLayoutId;
                }
                defaultView = inflater.inflate(layoutId, (ViewGroup)this, false);
            } else {
                Log.w(TAG, "can't inflate defaultView because mInfo is missing");
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (exception != null) {
            Log.w(TAG, "Error inflating AppWidget " + this.mInfo + ": " + exception.toString());
        }
        if (defaultView == null) {
            defaultView = this.getErrorView();
        }
        return defaultView;
    }

    protected View getErrorView() {
        TextView tv = new TextView(this.mContext);
        tv.setText(17040694);
        tv.setBackgroundColor(Color.argb(127, 0, 0, 0));
        return tv;
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(AppWidgetHostView.class.getName());
    }

    private static class ParcelableSparseArray
    extends SparseArray<Parcelable>
    implements Parcelable {
        public static final Parcelable.Creator<ParcelableSparseArray> CREATOR = new Parcelable.Creator<ParcelableSparseArray>(){

            @Override
            public ParcelableSparseArray createFromParcel(Parcel source) {
                ParcelableSparseArray array2 = new ParcelableSparseArray();
                ClassLoader loader = array2.getClass().getClassLoader();
                int count = source.readInt();
                for (int i = 0; i < count; ++i) {
                    array2.put(source.readInt(), source.readParcelable(loader));
                }
                return array2;
            }

            public ParcelableSparseArray[] newArray(int size) {
                return new ParcelableSparseArray[size];
            }
        };

        private ParcelableSparseArray() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            int count = this.size();
            dest.writeInt(count);
            for (int i = 0; i < count; ++i) {
                dest.writeInt(this.keyAt(i));
                dest.writeParcelable((Parcelable)this.valueAt(i), 0);
            }
        }
    }
}

