/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.ActivityManagerNative;
import android.app.IUiAutomationConnection;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.view.Display;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.android.tools.layoutlib.java.AutoCloseable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;

public class UiAutomation {
    private static final String LOG_TAG = UiAutomation.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int CONNECTION_ID_UNDEFINED = -1;
    private static final long CONNECT_TIMEOUT_MILLIS = 5000L;
    public static final int ROTATION_UNFREEZE = -2;
    public static final int ROTATION_FREEZE_CURRENT = -1;
    public static final int ROTATION_FREEZE_0 = 0;
    public static final int ROTATION_FREEZE_90 = 1;
    public static final int ROTATION_FREEZE_180 = 2;
    public static final int ROTATION_FREEZE_270 = 3;
    private final Object mLock = new Object();
    private final ArrayList<AccessibilityEvent> mEventQueue = new ArrayList();
    private final IAccessibilityServiceClient mClient;
    private final IUiAutomationConnection mUiAutomationConnection;
    private int mConnectionId = -1;
    private OnAccessibilityEventListener mOnAccessibilityEventListener;
    private boolean mWaitingForEventDelivery;
    private long mLastEventTimeMillis;
    private boolean mIsConnecting;

    public UiAutomation(Looper looper, IUiAutomationConnection connection) {
        if (looper == null) {
            throw new IllegalArgumentException("Looper cannot be null!");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null!");
        }
        this.mUiAutomationConnection = connection;
        this.mClient = new IAccessibilityServiceClientImpl(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfConnectedLocked();
            if (this.mIsConnecting) {
                return;
            }
            this.mIsConnecting = true;
        }
        try {
            this.mUiAutomationConnection.connect(this.mClient);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while connecting UiAutomation", re);
        }
        object = this.mLock;
        synchronized (object) {
            block18: {
                long startTimeMillis = SystemClock.uptimeMillis();
                block13: while (true) {
                    while (true) {
                        if (this.isConnectedLocked()) {
                            break block18;
                        }
                        long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                        long remainingTimeMillis = 5000L - elapsedTimeMillis;
                        if (remainingTimeMillis <= 0L) {
                            throw new RuntimeException("Error while connecting UiAutomation");
                        }
                        try {
                            this.mLock.wait(remainingTimeMillis);
                            continue block13;
                        }
                        catch (InterruptedException ie) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.mIsConnecting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsConnecting) {
                throw new IllegalStateException("Cannot call disconnect() while connecting!");
            }
            this.throwIfNotConnectedLocked();
            this.mConnectionId = -1;
        }
        try {
            this.mUiAutomationConnection.disconnect();
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while disconnecting UiAutomation", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionId() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            return this.mConnectionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnAccessibilityEventListener(OnAccessibilityEventListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnAccessibilityEventListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performGlobalAction(int action) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.performGlobalAction(action);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling performGlobalAction", re);
            }
        }
        return false;
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, focus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityServiceInfo getServiceInfo() {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.getServiceInfo();
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while getting AccessibilityServiceInfo", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceInfo(AccessibilityServiceInfo info) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance().clearCache();
            connection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                connection.setServiceInfo(info);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityWindowInfo> getWindows() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getWindows(connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo getRootInActiveWindow() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean injectInputEvent(InputEvent event, boolean sync) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.injectInputEvent(event, sync);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while injecting input event!", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        switch (rotation) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                try {
                    this.mUiAutomationConnection.setRotation(rotation);
                    return true;
                }
                catch (RemoteException re) {
                    Log.e(LOG_TAG, "Error while setting rotation!", re);
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid rotation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessibilityEvent executeAndWaitForEvent(Runnable command, AccessibilityEventFilter filter, long timeoutMillis) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            this.mEventQueue.clear();
            this.mWaitingForEventDelivery = true;
        }
        long executionStartTimeMillis = SystemClock.uptimeMillis();
        command.run();
        Object object2 = this.mLock;
        synchronized (object2) {
            try {
                long startTimeMillis = SystemClock.uptimeMillis();
                while (true) {
                    if (!this.mEventQueue.isEmpty()) {
                        AccessibilityEvent event = this.mEventQueue.remove(0);
                        if (event.getEventTime() < executionStartTimeMillis) continue;
                        if (filter.accept(event)) {
                            AccessibilityEvent accessibilityEvent = event;
                            return accessibilityEvent;
                        }
                        event.recycle();
                        continue;
                    }
                    long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                    long remainingTimeMillis = timeoutMillis - elapsedTimeMillis;
                    if (remainingTimeMillis <= 0L) {
                        throw new TimeoutException("Expected event not received within: " + timeoutMillis + " ms.");
                    }
                    try {
                        this.mLock.wait(remainingTimeMillis);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            finally {
                this.mWaitingForEventDelivery = false;
                this.mEventQueue.clear();
                this.mLock.notifyAll();
            }
        }
    }

    public void waitForIdle(long idleTimeoutMillis, long globalTimeoutMillis) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            long startTimeMillis = SystemClock.uptimeMillis();
            if (this.mLastEventTimeMillis <= 0L) {
                this.mLastEventTimeMillis = startTimeMillis;
            }
            while (true) {
                long currentTimeMillis;
                long elapsedGlobalTimeMillis;
                long remainingGlobalTimeMillis;
                if ((remainingGlobalTimeMillis = globalTimeoutMillis - (elapsedGlobalTimeMillis = (currentTimeMillis = SystemClock.uptimeMillis()) - startTimeMillis)) <= 0L) {
                    throw new TimeoutException("No idle state with idle timeout: " + idleTimeoutMillis + " within global timeout: " + globalTimeoutMillis);
                }
                long elapsedIdleTimeMillis = currentTimeMillis - this.mLastEventTimeMillis;
                long remainingIdleTimeMillis = idleTimeoutMillis - elapsedIdleTimeMillis;
                if (remainingIdleTimeMillis <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(remainingIdleTimeMillis);
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap takeScreenshot() {
        float screenshotHeight;
        float screenshotWidth;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        Display display = DisplayManagerGlobal.getInstance().getRealDisplay(0);
        Point displaySize = new Point();
        display.getRealSize(displaySize);
        int displayWidth = displaySize.x;
        int displayHeight = displaySize.y;
        int rotation = display.getRotation();
        switch (rotation) {
            case 0: {
                screenshotWidth = displayWidth;
                screenshotHeight = displayHeight;
                break;
            }
            case 1: {
                screenshotWidth = displayHeight;
                screenshotHeight = displayWidth;
                break;
            }
            case 2: {
                screenshotWidth = displayWidth;
                screenshotHeight = displayHeight;
                break;
            }
            case 3: {
                screenshotWidth = displayHeight;
                screenshotHeight = displayWidth;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid rotation: " + rotation);
            }
        }
        Bitmap screenShot = null;
        try {
            screenShot = this.mUiAutomationConnection.takeScreenshot((int)screenshotWidth, (int)screenshotHeight);
            if (screenShot == null) {
                return null;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while taking screnshot!", re);
            return null;
        }
        if (rotation != 0) {
            Bitmap unrotatedScreenShot = Bitmap.createBitmap(displayWidth, displayHeight, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(unrotatedScreenShot);
            canvas.translate(unrotatedScreenShot.getWidth() / 2, unrotatedScreenShot.getHeight() / 2);
            canvas.rotate(UiAutomation.getDegreesForRotation(rotation));
            canvas.translate(-screenshotWidth / 2.0f, -screenshotHeight / 2.0f);
            canvas.drawBitmap(screenShot, 0.0f, 0.0f, null);
            canvas.setBitmap(null);
            screenShot.recycle();
            screenShot = unrotatedScreenShot;
        }
        screenShot.setHasAlpha(false);
        return screenShot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunAsMonkey(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            ActivityManagerNative.getDefault().setUserIsMonkey(enable);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while setting run as monkey!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.clearWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window content frame stats!", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowContentFrameStats getWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window content frame stats!", re);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.clearWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window animation frame stats!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window animation frame stats!", re);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ParcelFileDescriptor executeShellCommand(String command) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        ParcelFileDescriptor source = null;
        ParcelFileDescriptor sink = null;
        try {
            ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
            source = pipe[0];
            sink = pipe[1];
            this.mUiAutomationConnection.executeShellCommand(command, sink);
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error executing shell command!", ioe);
            IoUtils.closeQuietly((AutoCloseable)((Object)sink));
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing shell command!", re);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly((AutoCloseable)((Object)sink));
        }
        IoUtils.closeQuietly((AutoCloseable)((Object)sink));
        return source;
    }

    private static float getDegreesForRotation(int value) {
        switch (value) {
            case 1: {
                return 270.0f;
            }
            case 2: {
                return 180.0f;
            }
            case 3: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    private boolean isConnectedLocked() {
        return this.mConnectionId != -1;
    }

    private void throwIfConnectedLocked() {
        if (this.mConnectionId != -1) {
            throw new IllegalStateException("UiAutomation not connected!");
        }
    }

    private void throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("UiAutomation not connected!");
        }
    }

    private class IAccessibilityServiceClientImpl
    extends AccessibilityService.IAccessibilityServiceClientWrapper {
        public IAccessibilityServiceClientImpl(Looper looper) {
            super(null, looper, new AccessibilityService.Callbacks(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void init(int connectionId, IBinder windowToken) {
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        UiAutomation.this.mConnectionId = connectionId;
                        UiAutomation.this.mLock.notifyAll();
                    }
                }

                @Override
                public void onServiceConnected() {
                }

                @Override
                public void onInterrupt() {
                }

                @Override
                public boolean onGesture(int gestureId) {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAccessibilityEvent(AccessibilityEvent event) {
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        UiAutomation.this.mLastEventTimeMillis = event.getEventTime();
                        if (UiAutomation.this.mWaitingForEventDelivery) {
                            UiAutomation.this.mEventQueue.add(AccessibilityEvent.obtain(event));
                        }
                        UiAutomation.this.mLock.notifyAll();
                    }
                    OnAccessibilityEventListener listener = UiAutomation.this.mOnAccessibilityEventListener;
                    if (listener != null) {
                        listener.onAccessibilityEvent(AccessibilityEvent.obtain(event));
                    }
                }

                @Override
                public boolean onKeyEvent(KeyEvent event) {
                    return false;
                }
            });
        }
    }

    public static interface AccessibilityEventFilter {
        public boolean accept(AccessibilityEvent var1);
    }

    public static interface OnAccessibilityEventListener {
        public void onAccessibilityEvent(AccessibilityEvent var1);
    }
}

