/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityOptions;
import android.app.ApplicationThreadProxy;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IUiAutomationConnection;
import android.app.ProfilerInfo;
import android.app.ResultInfo;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteException;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.content.ReferrerIntent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ApplicationThreadNative
extends Binder
implements IApplicationThread {
    public static IApplicationThread asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IApplicationThread in = (IApplicationThread)obj.queryLocalInterface("android.app.IApplicationThread");
        if (in != null) {
            return in;
        }
        return new ApplicationThreadProxy(obj);
    }

    public ApplicationThreadNative() {
        this.attachInterface(this, "android.app.IApplicationThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        switch (code) {
            case 1: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                boolean finished = data.readInt() != 0;
                boolean userLeaving = data.readInt() != 0;
                int configChanges = data.readInt();
                boolean dontReport = data.readInt() != 0;
                this.schedulePauseActivity(b, finished, userLeaving, configChanges, dontReport);
                return true;
            }
            case 3: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                boolean show = data.readInt() != 0;
                int configChanges = data.readInt();
                this.scheduleStopActivity(b, show, configChanges);
                return true;
            }
            case 4: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                boolean show = data.readInt() != 0;
                this.scheduleWindowVisibility(b, show);
                return true;
            }
            case 27: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                boolean sleeping = data.readInt() != 0;
                this.scheduleSleeping(b, sleeping);
                return true;
            }
            case 5: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                int procState = data.readInt();
                boolean isForward = data.readInt() != 0;
                Bundle resumeArgs = data.readBundle();
                this.scheduleResumeActivity(b, procState, isForward, resumeArgs);
                return true;
            }
            case 6: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                ArrayList<ResultInfo> ri = data.createTypedArrayList(ResultInfo.CREATOR);
                this.scheduleSendResult(b, ri);
                return true;
            }
            case 7: {
                data.enforceInterface("android.app.IApplicationThread");
                Intent intent = Intent.CREATOR.createFromParcel(data);
                IBinder b = data.readStrongBinder();
                int ident = data.readInt();
                ActivityInfo info = ActivityInfo.CREATOR.createFromParcel(data);
                Configuration curConfig = Configuration.CREATOR.createFromParcel(data);
                CompatibilityInfo compatInfo = CompatibilityInfo.CREATOR.createFromParcel(data);
                String referrer = data.readString();
                IVoiceInteractor voiceInteractor = IVoiceInteractor.Stub.asInterface(data.readStrongBinder());
                int procState = data.readInt();
                Bundle state = data.readBundle();
                PersistableBundle persistentState = data.readPersistableBundle();
                ArrayList<ResultInfo> ri = data.createTypedArrayList(ResultInfo.CREATOR);
                ArrayList<ReferrerIntent> pi = data.createTypedArrayList(ReferrerIntent.CREATOR);
                boolean notResumed = data.readInt() != 0;
                boolean isForward = data.readInt() != 0;
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                this.scheduleLaunchActivity(intent, b, ident, info, curConfig, compatInfo, referrer, voiceInteractor, procState, state, persistentState, ri, pi, notResumed, isForward, profilerInfo);
                return true;
            }
            case 26: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                ArrayList<ResultInfo> ri = data.createTypedArrayList(ResultInfo.CREATOR);
                ArrayList<ReferrerIntent> pi = data.createTypedArrayList(ReferrerIntent.CREATOR);
                int configChanges = data.readInt();
                boolean notResumed = data.readInt() != 0;
                Configuration config = null;
                if (data.readInt() != 0) {
                    config = Configuration.CREATOR.createFromParcel(data);
                }
                this.scheduleRelaunchActivity(b, ri, pi, configChanges, notResumed, config);
                return true;
            }
            case 8: {
                data.enforceInterface("android.app.IApplicationThread");
                ArrayList<ReferrerIntent> pi = data.createTypedArrayList(ReferrerIntent.CREATOR);
                IBinder b = data.readStrongBinder();
                this.scheduleNewIntent(pi, b);
                return true;
            }
            case 9: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                boolean finishing = data.readInt() != 0;
                int configChanges = data.readInt();
                this.scheduleDestroyActivity(b, finishing, configChanges);
                return true;
            }
            case 10: {
                data.enforceInterface("android.app.IApplicationThread");
                Intent intent = Intent.CREATOR.createFromParcel(data);
                ActivityInfo info = ActivityInfo.CREATOR.createFromParcel(data);
                CompatibilityInfo compatInfo = CompatibilityInfo.CREATOR.createFromParcel(data);
                int resultCode = data.readInt();
                String resultData = data.readString();
                Bundle resultExtras = data.readBundle();
                boolean sync = data.readInt() != 0;
                int sendingUser = data.readInt();
                int processState = data.readInt();
                this.scheduleReceiver(intent, info, compatInfo, resultCode, resultData, resultExtras, sync, sendingUser, processState);
                return true;
            }
            case 11: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                ServiceInfo info = ServiceInfo.CREATOR.createFromParcel(data);
                CompatibilityInfo compatInfo = CompatibilityInfo.CREATOR.createFromParcel(data);
                int processState = data.readInt();
                this.scheduleCreateService(token, info, compatInfo, processState);
                return true;
            }
            case 20: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                boolean rebind = data.readInt() != 0;
                int processState = data.readInt();
                this.scheduleBindService(token, intent, rebind, processState);
                return true;
            }
            case 21: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                this.scheduleUnbindService(token, intent);
                return true;
            }
            case 17: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                boolean taskRemoved = data.readInt() != 0;
                int startId = data.readInt();
                int fl = data.readInt();
                Intent args = data.readInt() != 0 ? Intent.CREATOR.createFromParcel(data) : null;
                this.scheduleServiceArgs(token, taskRemoved, startId, fl, args);
                return true;
            }
            case 12: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                this.scheduleStopService(token);
                return true;
            }
            case 13: {
                data.enforceInterface("android.app.IApplicationThread");
                String packageName = data.readString();
                ApplicationInfo info = ApplicationInfo.CREATOR.createFromParcel(data);
                ArrayList<ProviderInfo> providers = data.createTypedArrayList(ProviderInfo.CREATOR);
                ComponentName testName = data.readInt() != 0 ? new ComponentName(data) : null;
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                Bundle testArgs = data.readBundle();
                IBinder binder = data.readStrongBinder();
                IInstrumentationWatcher testWatcher = IInstrumentationWatcher.Stub.asInterface(binder);
                binder = data.readStrongBinder();
                IUiAutomationConnection uiAutomationConnection = IUiAutomationConnection.Stub.asInterface(binder);
                int testMode = data.readInt();
                boolean openGlTrace = data.readInt() != 0;
                boolean restrictedBackupMode = data.readInt() != 0;
                boolean persistent = data.readInt() != 0;
                Configuration config = Configuration.CREATOR.createFromParcel(data);
                CompatibilityInfo compatInfo = CompatibilityInfo.CREATOR.createFromParcel(data);
                HashMap services = data.readHashMap(null);
                Bundle coreSettings = data.readBundle();
                this.bindApplication(packageName, info, providers, testName, profilerInfo, testArgs, testWatcher, uiAutomationConnection, testMode, openGlTrace, restrictedBackupMode, persistent, config, compatInfo, services, coreSettings);
                return true;
            }
            case 14: {
                data.enforceInterface("android.app.IApplicationThread");
                this.scheduleExit();
                return true;
            }
            case 33: {
                data.enforceInterface("android.app.IApplicationThread");
                this.scheduleSuicide();
                return true;
            }
            case 16: {
                data.enforceInterface("android.app.IApplicationThread");
                Configuration config = Configuration.CREATOR.createFromParcel(data);
                this.scheduleConfigurationChanged(config);
                return true;
            }
            case 18: {
                data.enforceInterface("android.app.IApplicationThread");
                this.updateTimeZone();
                return true;
            }
            case 38: {
                data.enforceInterface("android.app.IApplicationThread");
                this.clearDnsCache();
                return true;
            }
            case 39: {
                data.enforceInterface("android.app.IApplicationThread");
                String proxy = data.readString();
                String port = data.readString();
                String exclList = data.readString();
                Uri pacFileUrl = Uri.CREATOR.createFromParcel(data);
                this.setHttpProxy(proxy, port, exclList, pacFileUrl);
                return true;
            }
            case 19: {
                data.enforceInterface("android.app.IApplicationThread");
                this.processInBackground();
                return true;
            }
            case 22: {
                data.enforceInterface("android.app.IApplicationThread");
                ParcelFileDescriptor fd = data.readFileDescriptor();
                IBinder service = data.readStrongBinder();
                String[] args = data.readStringArray();
                if (fd != null) {
                    this.dumpService(fd.getFileDescriptor(), service, args);
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return true;
            }
            case 45: {
                data.enforceInterface("android.app.IApplicationThread");
                ParcelFileDescriptor fd = data.readFileDescriptor();
                IBinder service = data.readStrongBinder();
                String[] args = data.readStringArray();
                if (fd != null) {
                    this.dumpProvider(fd.getFileDescriptor(), service, args);
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return true;
            }
            case 23: {
                data.enforceInterface("android.app.IApplicationThread");
                IIntentReceiver receiver = IIntentReceiver.Stub.asInterface(data.readStrongBinder());
                Intent intent = Intent.CREATOR.createFromParcel(data);
                int resultCode = data.readInt();
                String dataStr = data.readString();
                Bundle extras = data.readBundle();
                boolean ordered = data.readInt() != 0;
                boolean sticky = data.readInt() != 0;
                int sendingUser = data.readInt();
                int processState = data.readInt();
                this.scheduleRegisteredReceiver(receiver, intent, resultCode, dataStr, extras, ordered, sticky, sendingUser, processState);
                return true;
            }
            case 24: {
                data.enforceInterface("android.app.IApplicationThread");
                this.scheduleLowMemory();
                return true;
            }
            case 25: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder b = data.readStrongBinder();
                this.scheduleActivityConfigurationChanged(b);
                return true;
            }
            case 28: {
                data.enforceInterface("android.app.IApplicationThread");
                boolean start = data.readInt() != 0;
                int profileType = data.readInt();
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                this.profilerControl(start, profilerInfo, profileType);
                return true;
            }
            case 29: {
                data.enforceInterface("android.app.IApplicationThread");
                int group = data.readInt();
                this.setSchedulingGroup(group);
                return true;
            }
            case 30: {
                data.enforceInterface("android.app.IApplicationThread");
                ApplicationInfo appInfo = ApplicationInfo.CREATOR.createFromParcel(data);
                CompatibilityInfo compatInfo = CompatibilityInfo.CREATOR.createFromParcel(data);
                int backupMode = data.readInt();
                this.scheduleCreateBackupAgent(appInfo, compatInfo, backupMode);
                return true;
            }
            case 31: {
                data.enforceInterface("android.app.IApplicationThread");
                ApplicationInfo appInfo = ApplicationInfo.CREATOR.createFromParcel(data);
                CompatibilityInfo compatInfo = CompatibilityInfo.CREATOR.createFromParcel(data);
                this.scheduleDestroyBackupAgent(appInfo, compatInfo);
                return true;
            }
            case 34: {
                data.enforceInterface("android.app.IApplicationThread");
                int cmd = data.readInt();
                String[] packages = data.readStringArray();
                this.dispatchPackageBroadcast(cmd, packages);
                return true;
            }
            case 35: {
                data.enforceInterface("android.app.IApplicationThread");
                String msg = data.readString();
                this.scheduleCrash(msg);
                return true;
            }
            case 36: {
                data.enforceInterface("android.app.IApplicationThread");
                boolean managed = data.readInt() != 0;
                String path = data.readString();
                ParcelFileDescriptor fd = data.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                this.dumpHeap(managed, path, fd);
                return true;
            }
            case 37: {
                data.enforceInterface("android.app.IApplicationThread");
                ParcelFileDescriptor fd = data.readFileDescriptor();
                IBinder activity = data.readStrongBinder();
                String prefix = data.readString();
                String[] args = data.readStringArray();
                if (fd != null) {
                    this.dumpActivity(fd.getFileDescriptor(), activity, prefix, args);
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return true;
            }
            case 40: {
                data.enforceInterface("android.app.IApplicationThread");
                Bundle settings = data.readBundle();
                this.setCoreSettings(settings);
                return true;
            }
            case 41: {
                data.enforceInterface("android.app.IApplicationThread");
                String pkg = data.readString();
                CompatibilityInfo compat = CompatibilityInfo.CREATOR.createFromParcel(data);
                this.updatePackageCompatibilityInfo(pkg, compat);
                return true;
            }
            case 42: {
                data.enforceInterface("android.app.IApplicationThread");
                int level = data.readInt();
                this.scheduleTrimMemory(level);
                return true;
            }
            case 43: {
                data.enforceInterface("android.app.IApplicationThread");
                ParcelFileDescriptor fd = data.readFileDescriptor();
                Debug.MemoryInfo mi = Debug.MemoryInfo.CREATOR.createFromParcel(data);
                boolean checkin = data.readInt() != 0;
                boolean dumpInfo = data.readInt() != 0;
                boolean dumpDalvik = data.readInt() != 0;
                String[] args = data.readStringArray();
                if (fd != null) {
                    try {
                        this.dumpMemInfo(fd.getFileDescriptor(), mi, checkin, dumpInfo, dumpDalvik, args);
                    }
                    finally {
                        try {
                            fd.close();
                        }
                        catch (IOException e) {}
                    }
                }
                reply.writeNoException();
                return true;
            }
            case 44: {
                data.enforceInterface("android.app.IApplicationThread");
                ParcelFileDescriptor fd = data.readFileDescriptor();
                String[] args = data.readStringArray();
                if (fd != null) {
                    try {
                        this.dumpGfxInfo(fd.getFileDescriptor(), args);
                    }
                    finally {
                        try {
                            fd.close();
                        }
                        catch (IOException e) {}
                    }
                }
                reply.writeNoException();
                return true;
            }
            case 46: {
                data.enforceInterface("android.app.IApplicationThread");
                ParcelFileDescriptor fd = data.readFileDescriptor();
                String[] args = data.readStringArray();
                if (fd != null) {
                    try {
                        this.dumpDbInfo(fd.getFileDescriptor(), args);
                    }
                    finally {
                        try {
                            fd.close();
                        }
                        catch (IOException e) {}
                    }
                }
                reply.writeNoException();
                return true;
            }
            case 47: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder provider = data.readStrongBinder();
                this.unstableProviderDied(provider);
                reply.writeNoException();
                return true;
            }
            case 48: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder activityToken = data.readStrongBinder();
                IBinder requestToken = data.readStrongBinder();
                int requestType = data.readInt();
                this.requestAssistContextExtras(activityToken, requestToken, requestType);
                reply.writeNoException();
                return true;
            }
            case 49: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                boolean timeout = data.readInt() == 1;
                this.scheduleTranslucentConversionComplete(token, timeout);
                reply.writeNoException();
                return true;
            }
            case 32: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                ActivityOptions options = new ActivityOptions(data.readBundle());
                this.scheduleOnNewActivityOptions(token, options);
                reply.writeNoException();
                return true;
            }
            case 50: {
                data.enforceInterface("android.app.IApplicationThread");
                int state = data.readInt();
                this.setProcessState(state);
                reply.writeNoException();
                return true;
            }
            case 51: {
                data.enforceInterface("android.app.IApplicationThread");
                ProviderInfo provider = ProviderInfo.CREATOR.createFromParcel(data);
                this.scheduleInstallProvider(provider);
                reply.writeNoException();
                return true;
            }
            case 52: {
                data.enforceInterface("android.app.IApplicationThread");
                byte is24Hour = data.readByte();
                this.updateTimePrefs(is24Hour == 1);
                reply.writeNoException();
                return true;
            }
            case 53: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                this.scheduleCancelVisibleBehind(token);
                reply.writeNoException();
                return true;
            }
            case 54: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                boolean enabled = data.readInt() > 0;
                this.scheduleBackgroundVisibleBehindChanged(token, enabled);
                reply.writeNoException();
                return true;
            }
            case 55: {
                data.enforceInterface("android.app.IApplicationThread");
                IBinder token = data.readStrongBinder();
                this.scheduleEnterAnimationComplete(token);
                reply.writeNoException();
                return true;
            }
        }
        return super.onTransact(code, data, reply, flags);
    }

    @Override
    public IBinder asBinder() {
        return this;
    }
}

