/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.animation.AnimationThread;
import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.LayoutTransition;
import android.app.Fragment_Delegate;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.AttachInfo_Accessor;
import android.view.BridgeInflater;
import android.view.IWindowManagerImpl;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManagerGlobal_Delegate;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.ActionMenuView;
import android.widget.AdapterView;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.QuickContactBadge;
import android.widget.TabHost;
import android.widget.TabWidget;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.rendering.api.ViewType;
import com.android.internal.util.XmlUtils;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.BridgeMenuItemImpl;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.ListMenuItemView;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeLayoutParamsMapAttributes;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.ActionBarLayout;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.NavigationBar;
import com.android.layoutlib.bridge.bars.StatusBar;
import com.android.layoutlib.bridge.bars.TitleBar;
import com.android.layoutlib.bridge.impl.PlayAnimationThread;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.impl.SystemViewInfo;
import com.android.layoutlib.bridge.impl.binding.FakeAdapter;
import com.android.layoutlib.bridge.impl.binding.FakeExpandableAdapter;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.util.Pair;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RenderSessionImpl
extends RenderAction<SessionParams> {
    private static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    private static final int DEFAULT_STATUS_BAR_HEIGHT = 25;
    private RenderSession mScene;
    private BridgeXmlBlockParser mBlockParser;
    private BridgeInflater mInflater;
    private ResourceValue mWindowBackground;
    private ViewGroup mViewRoot;
    private FrameLayout mContentRoot;
    private Canvas mCanvas;
    private int mMeasuredScreenWidth = -1;
    private int mMeasuredScreenHeight = -1;
    private boolean mIsAlphaChannelImage;
    private boolean mWindowIsFloating;
    private int mStatusBarSize;
    private int mNavigationBarSize;
    private int mNavigationBarOrientation = 0;
    private int mTitleBarSize;
    private int mActionBarSize;
    private BufferedImage mImage;
    private List<ViewInfo> mViewInfoList;
    private List<ViewInfo> mSystemViewInfoList;

    public RenderSessionImpl(SessionParams params) {
        super(new SessionParams(params));
    }

    @Override
    public Result init(long timeout) {
        Result result = super.init(timeout);
        if (!result.isSuccess()) {
            return result;
        }
        SessionParams params = (SessionParams)this.getParams();
        BridgeContext context = this.getContext();
        RenderResources resources = ((SessionParams)this.getParams()).getResources();
        DisplayMetrics metrics = this.getContext().getMetrics();
        this.mIsAlphaChannelImage = this.getBooleanThemeValue(resources, "windowIsFloating", true);
        this.mWindowIsFloating = this.getBooleanThemeValue(resources, "windowIsFloating", true);
        this.findBackground(resources);
        this.findStatusBar(resources, metrics);
        this.findActionBar(resources, metrics);
        this.findNavigationBar(resources, metrics);
        boolean hasNavigationBar = true;
        IWindowManagerImpl iwm = new IWindowManagerImpl(this.getContext().getConfiguration(), metrics, 0, hasNavigationBar);
        WindowManagerGlobal_Delegate.setWindowManagerService(iwm);
        this.mInflater = new BridgeInflater(context, params.getProjectCallback());
        context.setBridgeInflater(this.mInflater);
        this.mBlockParser = new BridgeXmlBlockParser((XmlPullParser)params.getLayoutDescription(), context, false);
        return Result.Status.SUCCESS.createResult();
    }

    public Result inflate() {
        this.checkLock();
        try {
            ViewGroup backgroundView;
            int layoutDirection;
            SessionParams params = (SessionParams)this.getParams();
            HardwareConfig hardwareConfig = params.getHardwareConfig();
            BridgeContext context = this.getContext();
            boolean isRtl = Bridge.isLocaleRtl(params.getLocale());
            int n = layoutDirection = isRtl ? 1 : 0;
            if (this.mWindowIsFloating || params.isForceNoDecor()) {
                this.mContentRoot = new FrameLayout(context);
                this.mViewRoot = this.mContentRoot;
                backgroundView = this.mContentRoot;
                this.mViewRoot.setLayoutDirection(layoutDirection);
            } else {
                LinearLayout.LayoutParams layoutParams;
                LinearLayout topLayout;
                int simulatedPlatformVersion = params.getSimulatedPlatformVersion();
                if (this.hasSoftwareButtons() && this.mNavigationBarOrientation == 1) {
                    topLayout = new LinearLayout(context);
                    topLayout.setLayoutDirection(layoutDirection);
                    this.mViewRoot = topLayout;
                    topLayout.setOrientation(0);
                    if (Config.showOnScreenNavBar(simulatedPlatformVersion)) {
                        try {
                            NavigationBar navigationBar = this.createNavigationBar(context, hardwareConfig.getDensity(), isRtl, params.isRtlSupported(), simulatedPlatformVersion);
                            topLayout.addView(navigationBar);
                        }
                        catch (XmlPullParserException ignored) {
                            // empty catch block
                        }
                    }
                }
                topLayout = new LinearLayout(context);
                topLayout.setOrientation(1);
                topLayout.setLayoutDirection(layoutDirection);
                if (this.mViewRoot == null) {
                    this.mViewRoot = topLayout;
                } else {
                    int topLayoutWidth = params.getHardwareConfig().getScreenWidth() - this.mNavigationBarSize;
                    layoutParams = new LinearLayout.LayoutParams(topLayoutWidth, -1);
                    topLayout.setLayoutParams(layoutParams);
                    if (isRtl && params.isRtlSupported()) {
                        this.mViewRoot.addView(topLayout);
                    } else {
                        this.mViewRoot.addView((View)topLayout, 0);
                    }
                }
                if (this.mStatusBarSize > 0) {
                    try {
                        StatusBar statusBar = this.createStatusBar(context, hardwareConfig.getDensity(), layoutDirection, params.isRtlSupported(), simulatedPlatformVersion);
                        topLayout.addView(statusBar);
                    }
                    catch (XmlPullParserException ignored) {
                        // empty catch block
                    }
                }
                LinearLayout backgroundLayout = new LinearLayout(context);
                backgroundView = backgroundLayout;
                backgroundLayout.setOrientation(1);
                layoutParams = new LinearLayout.LayoutParams(-1, 0);
                layoutParams.weight = 1.0f;
                backgroundLayout.setLayoutParams(layoutParams);
                topLayout.addView(backgroundLayout);
                if (this.mActionBarSize > 0) {
                    ActionBarLayout actionBar = this.createActionBar(context, params, backgroundLayout);
                    actionBar.createMenuPopup();
                    this.mContentRoot = actionBar.getContentRoot();
                } else if (this.mTitleBarSize > 0) {
                    try {
                        TitleBar titleBar = this.createTitleBar(context, params.getAppLabel(), simulatedPlatformVersion);
                        backgroundLayout.addView(titleBar);
                    }
                    catch (XmlPullParserException ignored) {
                        // empty catch block
                    }
                }
                if (this.mContentRoot == null) {
                    this.mContentRoot = new FrameLayout(context);
                    layoutParams = new LinearLayout.LayoutParams(-1, 0);
                    layoutParams.weight = 1.0f;
                    this.mContentRoot.setLayoutParams(layoutParams);
                    backgroundLayout.addView(this.mContentRoot);
                }
                if (Config.showOnScreenNavBar(simulatedPlatformVersion) && this.mNavigationBarOrientation == 0 && this.mNavigationBarSize > 0) {
                    try {
                        NavigationBar navigationBar = this.createNavigationBar(context, hardwareConfig.getDensity(), isRtl, params.isRtlSupported(), simulatedPlatformVersion);
                        topLayout.addView(navigationBar);
                    }
                    catch (XmlPullParserException ignored) {
                        // empty catch block
                    }
                }
            }
            Fragment_Delegate.setProjectCallback(params.getProjectCallback());
            View view = this.mInflater.inflate(this.mBlockParser, (ViewGroup)this.mContentRoot);
            context.popParser();
            Fragment_Delegate.setProjectCallback(null);
            AttachInfo_Accessor.setAttachInfo(this.mViewRoot);
            this.postInflateProcess(view, params.getProjectCallback());
            if (this.mWindowBackground != null) {
                Drawable d = ResourceHelper.getDrawable(this.mWindowBackground, context);
                backgroundView.setBackground(d);
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (PostInflateException e) {
            return Result.Status.ERROR_INFLATION.createResult(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_INFLATION.createResult(t.getMessage(), t);
        }
    }

    public Result render(boolean freshRender) {
        this.checkLock();
        SessionParams params = (SessionParams)this.getParams();
        try {
            if (this.mViewRoot == null) {
                return Result.Status.ERROR_NOT_INFLATED.createResult();
            }
            SessionParams.RenderingMode renderingMode = params.getRenderingMode();
            HardwareConfig hardwareConfig = params.getHardwareConfig();
            boolean newRenderSize = false;
            if (this.mMeasuredScreenWidth == -1) {
                newRenderSize = true;
                this.mMeasuredScreenWidth = hardwareConfig.getScreenWidth();
                this.mMeasuredScreenHeight = hardwareConfig.getScreenHeight();
                if (renderingMode != SessionParams.RenderingMode.NORMAL) {
                    int widthMeasureSpecMode = renderingMode.isHorizExpand() ? 0 : 0x40000000;
                    int heightMeasureSpecMode = renderingMode.isVertExpand() ? 0 : 0x40000000;
                    Pair<Integer, Integer> exactMeasure = this.measureView(this.mViewRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
                    Pair<Integer, Integer> result = this.measureView(this.mContentRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, widthMeasureSpecMode, this.mMeasuredScreenHeight, heightMeasureSpecMode);
                    if (renderingMode.isHorizExpand()) {
                        int measuredWidth = (Integer)exactMeasure.getFirst();
                        int neededWidth = (Integer)result.getFirst();
                        if (neededWidth > measuredWidth) {
                            this.mMeasuredScreenWidth += neededWidth - measuredWidth;
                        }
                    }
                    if (renderingMode.isVertExpand()) {
                        int measuredHeight = (Integer)exactMeasure.getSecond();
                        int neededHeight = (Integer)result.getSecond();
                        if (neededHeight > measuredHeight) {
                            this.mMeasuredScreenHeight += neededHeight - measuredHeight;
                        }
                    }
                }
            }
            this.measureView(this.mViewRoot, null, this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
            this.mViewRoot.layout(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            if (params.isLayoutOnly()) {
                this.mImage = null;
                this.mCanvas = null;
            } else {
                AttachInfo_Accessor.dispatchOnPreDraw(this.mViewRoot);
                boolean newImage = false;
                if (newRenderSize || this.mCanvas == null) {
                    if (params.getImageFactory() != null) {
                        this.mImage = params.getImageFactory().getImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    } else {
                        this.mImage = new BufferedImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight, 2);
                        newImage = true;
                    }
                    if (params.isBgColorOverridden()) {
                        newImage = true;
                        Graphics2D gc = this.mImage.createGraphics();
                        gc.setColor(new Color(params.getOverrideBgColor(), true));
                        gc.setComposite(AlphaComposite.Src);
                        gc.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                        gc.dispose();
                    }
                    Bitmap bitmap = Bitmap_Delegate.createBitmap(this.mImage, true, hardwareConfig.getDensity());
                    this.mCanvas = new Canvas(bitmap);
                    this.mCanvas.setDensity(hardwareConfig.getDensity().getDpiValue());
                }
                if (freshRender && !newImage) {
                    Graphics2D gc = this.mImage.createGraphics();
                    gc.setComposite(AlphaComposite.Src);
                    gc.setColor(new Color(0, true));
                    gc.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    gc.dispose();
                }
                this.mViewRoot.draw(this.mCanvas);
            }
            this.mSystemViewInfoList = this.visitAllChildren(this.mViewRoot, 0, params.getExtendedViewInfoMode(), false);
            return Result.Status.SUCCESS.createResult();
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(t.getMessage(), t);
        }
    }

    private Pair<Integer, Integer> measureView(ViewGroup viewToMeasure, View measuredView, int width, int widthMode, int height, int heightMode) {
        int w_spec = View.MeasureSpec.makeMeasureSpec(width, widthMode);
        int h_spec = View.MeasureSpec.makeMeasureSpec(height, heightMode);
        viewToMeasure.measure(w_spec, h_spec);
        if (measuredView != null) {
            return Pair.of((Object)measuredView.getMeasuredWidth(), (Object)measuredView.getMeasuredHeight());
        }
        return null;
    }

    public Result animate(Object targetObject, String animationName, boolean isFrameworkAnimation, IAnimationListener listener) {
        ResourceValue animationResource;
        this.checkLock();
        BridgeContext context = this.getContext();
        int animationId = 0;
        if (isFrameworkAnimation) {
            animationResource = context.getRenderResources().getFrameworkResource(ResourceType.ANIMATOR, animationName);
            if (animationResource != null) {
                animationId = Bridge.getResourceId(ResourceType.ANIMATOR, animationName);
            }
        } else {
            animationResource = context.getRenderResources().getProjectResource(ResourceType.ANIMATOR, animationName);
            if (animationResource != null) {
                animationId = context.getProjectCallback().getResourceId(ResourceType.ANIMATOR, animationName);
            }
        }
        if (animationResource != null) {
            try {
                Animator anim2 = AnimatorInflater.loadAnimator(context, animationId);
                if (anim2 != null) {
                    anim2.setTarget(targetObject);
                    new PlayAnimationThread(anim2, this, animationName, listener).start();
                    return Result.Status.SUCCESS.createResult();
                }
            }
            catch (Exception e) {
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                return Result.Status.ERROR_UNKNOWN.createResult(t.getMessage(), t);
            }
        }
        return Result.Status.ERROR_ANIM_NOT_FOUND.createResult();
    }

    public Result insertChild(final ViewGroup parentView, ILayoutPullParser childXml, final int index, IAnimationListener listener) {
        this.checkLock();
        BridgeContext context = this.getContext();
        BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser((XmlPullParser)childXml, context, false);
        final View child = this.mInflater.inflate(blockParser, parentView, false);
        blockParser.ensurePopped();
        this.invalidateRenderingSize();
        if (listener != null) {
            new AnimationThread(this, "insertChild", listener){

                @Override
                public Result preAnimation() {
                    parentView.setLayoutTransition(new LayoutTransition());
                    return RenderSessionImpl.this.addView(parentView, child, index);
                }

                @Override
                public void postAnimation() {
                    parentView.setLayoutTransition(null);
                }
            }.start();
            return Result.Status.SUCCESS.createResult((Object)child);
        }
        Result result = this.addView(parentView, child, index);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.render(false);
        if (result.isSuccess()) {
            result = result.getCopyWithData((Object)child);
        }
        return result;
    }

    private Result addView(ViewGroup parent, View view, int index) {
        try {
            parent.addView(view, index);
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException e) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    public Result moveChild(final ViewGroup newParentView, final View childView, final int index, Map<String, String> layoutParamsMap, final IAnimationListener listener) {
        this.checkLock();
        this.invalidateRenderingSize();
        ViewGroup.LayoutParams layoutParams = null;
        if (layoutParamsMap != null) {
            layoutParams = newParentView.generateLayoutParams(new BridgeLayoutParamsMapAttributes(layoutParamsMap));
        }
        final ViewGroup previousParent = (ViewGroup)childView.getParent();
        if (listener != null) {
            final ViewGroup.LayoutParams params = layoutParams;
            if (previousParent != newParentView) {
                new Thread("not animated moveChild"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Result result = RenderSessionImpl.this.moveView(previousParent, newParentView, childView, index, params);
                        if (!result.isSuccess()) {
                            listener.done(result);
                        }
                        if (!(result = RenderSessionImpl.this.acquire(250L)).isSuccess()) {
                            listener.done(result);
                            return;
                        }
                        try {
                            result = RenderSessionImpl.this.render(false);
                            if (result.isSuccess()) {
                                listener.onNewFrame(RenderSessionImpl.this.getSession());
                            }
                        }
                        finally {
                            RenderSessionImpl.this.release();
                        }
                        listener.done(result);
                    }
                }.start();
            } else {
                new AnimationThread(this, "moveChild", listener){

                    @Override
                    public Result preAnimation() {
                        LayoutTransition transition2 = new LayoutTransition();
                        previousParent.setLayoutTransition(transition2);
                        transition2.setDuration(3, 100L);
                        transition2.setStartDelay(1, 100L);
                        transition2.setDuration(1, 100L);
                        transition2.setDuration(0, 100L);
                        transition2.setStartDelay(2, 100L);
                        transition2.setDuration(2, 100L);
                        return RenderSessionImpl.this.moveView(previousParent, newParentView, childView, index, params);
                    }

                    @Override
                    public void postAnimation() {
                        previousParent.setLayoutTransition(null);
                        newParentView.setLayoutTransition(null);
                    }
                }.start();
            }
            return Result.Status.SUCCESS.createResult((Object)layoutParams);
        }
        Result result = this.moveView(previousParent, newParentView, childView, index, layoutParams);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.render(false);
        if (layoutParams != null && result.isSuccess()) {
            result = result.getCopyWithData((Object)layoutParams);
        }
        return result;
    }

    private Result moveView(ViewGroup previousParent, final ViewGroup newParent, final View movedView, final int index, final ViewGroup.LayoutParams params) {
        try {
            LayoutTransition previousTransition = previousParent.getLayoutTransition();
            if (previousTransition != null) {
                previousTransition.addTransitionListener(new LayoutTransition.TransitionListener(){
                    private int mChangeDisappearingCount = 0;

                    @Override
                    public void startTransition(LayoutTransition transition2, ViewGroup container, View view, int transitionType) {
                        if (transitionType == 1) {
                            ++this.mChangeDisappearingCount;
                        }
                    }

                    @Override
                    public void endTransition(LayoutTransition transition2, ViewGroup container, View view, int transitionType) {
                        if (transitionType == 1) {
                            --this.mChangeDisappearingCount;
                        }
                        if (transitionType == 1 && this.mChangeDisappearingCount == 0) {
                            if (params != null) {
                                newParent.addView(movedView, index, params);
                            } else {
                                newParent.addView(movedView, index);
                            }
                        }
                    }
                });
                previousParent.removeView(movedView);
                return Result.Status.SUCCESS.createResult();
            }
            previousParent.removeView(movedView);
            if (params != null) {
                newParent.addView(movedView, index, params);
            } else {
                newParent.addView(movedView, index);
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException e) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    public Result removeChild(final View childView, IAnimationListener listener) {
        this.checkLock();
        this.invalidateRenderingSize();
        final ViewGroup parent = (ViewGroup)childView.getParent();
        if (listener != null) {
            new AnimationThread(this, "moveChild", listener){

                @Override
                public Result preAnimation() {
                    parent.setLayoutTransition(new LayoutTransition());
                    return RenderSessionImpl.this.removeView(parent, childView);
                }

                @Override
                public void postAnimation() {
                    parent.setLayoutTransition(null);
                }
            }.start();
            return Result.Status.SUCCESS.createResult();
        }
        Result result = this.removeView(parent, childView);
        if (!result.isSuccess()) {
            return result;
        }
        return this.render(false);
    }

    private Result removeView(ViewGroup parent, View view) {
        try {
            parent.removeView(view);
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException e) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    private void findBackground(RenderResources resources) {
        if (!((SessionParams)this.getParams()).isBgColorOverridden()) {
            this.mWindowBackground = resources.findItemInTheme("windowBackground", true);
            if (this.mWindowBackground != null) {
                this.mWindowBackground = resources.resolveResValue(this.mWindowBackground);
            }
        }
    }

    private boolean hasSoftwareButtons() {
        return ((SessionParams)this.getParams()).getHardwareConfig().hasSoftwareButtons();
    }

    private void findStatusBar(RenderResources resources, DisplayMetrics metrics) {
        boolean windowFullscreen = this.getBooleanThemeValue(resources, "windowFullscreen", false);
        if (!windowFullscreen && !this.mWindowIsFloating) {
            TypedValue typedValue;
            this.mStatusBarSize = 25;
            ResourceValue value = resources.getFrameworkResource(ResourceType.DIMEN, "status_bar_height");
            if (value != null && (typedValue = ResourceHelper.getValue("status_bar_height", value.getValue(), true)) != null) {
                this.mStatusBarSize = (int)typedValue.getDimension(metrics);
            }
        }
    }

    private void findActionBar(RenderResources resources, DisplayMetrics metrics) {
        if (this.mWindowIsFloating) {
            return;
        }
        boolean windowActionBar = this.getBooleanThemeValue(resources, "windowActionBar", true);
        if (windowActionBar) {
            TypedValue typedValue;
            this.mActionBarSize = 25;
            ResourceValue value = resources.findItemInTheme("actionBarSize", true);
            if ((value = resources.resolveResValue(value)) != null && (typedValue = ResourceHelper.getValue("actionBarSize", value.getValue(), true)) != null) {
                this.mActionBarSize = (int)typedValue.getDimension(metrics);
            }
        } else {
            boolean windowNoTitle = this.getBooleanThemeValue(resources, "windowNoTitle", false);
            if (!windowNoTitle) {
                TypedValue typedValue;
                this.mTitleBarSize = 25;
                ResourceValue value = resources.findItemInTheme("windowTitleSize", true);
                if ((value = resources.resolveResValue(value)) != null && (typedValue = ResourceHelper.getValue("windowTitleSize", value.getValue(), true)) != null) {
                    this.mTitleBarSize = (int)typedValue.getDimension(metrics);
                }
            }
        }
    }

    private void findNavigationBar(RenderResources resources, DisplayMetrics metrics) {
        if (this.hasSoftwareButtons() && !this.mWindowIsFloating) {
            TypedValue typedValue;
            this.mNavigationBarSize = 48;
            HardwareConfig hardwareConfig = ((SessionParams)this.getParams()).getHardwareConfig();
            boolean barOnBottom = true;
            if (hardwareConfig.getOrientation() == ScreenOrientation.LANDSCAPE) {
                int shortSize = hardwareConfig.getScreenHeight();
                int shortSizeDp = shortSize * 160 / hardwareConfig.getDensity().getDpiValue();
                barOnBottom = shortSizeDp >= 600;
            }
            this.mNavigationBarOrientation = barOnBottom ? 0 : 1;
            ResourceValue value = resources.getFrameworkResource(ResourceType.DIMEN, barOnBottom ? "navigation_bar_height" : "navigation_bar_width");
            if (value != null && (typedValue = ResourceHelper.getValue("navigation_bar_height", value.getValue(), true)) != null) {
                this.mNavigationBarSize = (int)typedValue.getDimension(metrics);
            }
        }
    }

    private boolean getBooleanThemeValue(RenderResources resources, String name, boolean defaultValue) {
        ResourceValue value = resources.findItemInTheme(name, true);
        if ((value = resources.resolveResValue(value)) == null || value.getValue() == null) {
            return defaultValue;
        }
        return XmlUtils.convertValueToBoolean(value.getValue(), defaultValue);
    }

    private void postInflateProcess(View view, IProjectCallback projectCallback) throws PostInflateException {
        block11: {
            block13: {
                AdapterBinding binding;
                SessionParams params;
                ResourceReference listRef;
                block14: {
                    block12: {
                        block10: {
                            if (!(view instanceof TabHost)) break block10;
                            this.setupTabHost((TabHost)view, projectCallback);
                            break block11;
                        }
                        if (!(view instanceof QuickContactBadge)) break block12;
                        QuickContactBadge badge = (QuickContactBadge)view;
                        badge.setImageToDefault();
                        break block11;
                    }
                    if (!(view instanceof AdapterView)) break block13;
                    int id2 = view.getId();
                    BridgeContext context = this.getContext();
                    listRef = context.resolveId(id2);
                    if (listRef == null) break block11;
                    params = (SessionParams)this.getParams();
                    binding = (AdapterBinding)params.getAdapterBindings().get(listRef);
                    if (binding == null) {
                        binding = params.getProjectCallback().getAdapterBinding(listRef, context.getViewKey(view), (Object)view);
                    }
                    if (binding == null) break block11;
                    if (!(view instanceof AbsListView)) break block14;
                    if ((binding.getFooterCount() > 0 || binding.getHeaderCount() > 0) && view instanceof ListView) {
                        Pair<View, Boolean> pair;
                        int i;
                        ListView list = (ListView)view;
                        boolean skipCallbackParser = false;
                        int count = binding.getHeaderCount();
                        for (i = 0; i < count; ++i) {
                            pair = context.inflateView(binding.getHeaderAt(i), list, false, skipCallbackParser);
                            if (pair.getFirst() != null) {
                                list.addHeaderView((View)pair.getFirst());
                            }
                            skipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                        count = binding.getFooterCount();
                        for (i = 0; i < count; ++i) {
                            pair = context.inflateView(binding.getFooterAt(i), list, false, skipCallbackParser);
                            if (pair.getFirst() != null) {
                                list.addFooterView((View)pair.getFirst());
                            }
                            skipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                    }
                    if (view instanceof ExpandableListView) {
                        ((ExpandableListView)view).setAdapter(new FakeExpandableAdapter(listRef, binding, params.getProjectCallback()));
                    } else {
                        ((AbsListView)view).setAdapter(new FakeAdapter(listRef, binding, params.getProjectCallback()));
                    }
                    break block11;
                }
                if (!(view instanceof AbsSpinner)) break block11;
                ((AbsSpinner)view).setAdapter(new FakeAdapter(listRef, binding, params.getProjectCallback()));
                break block11;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int count = group.getChildCount();
                for (int c = 0; c < count; ++c) {
                    View child = group.getChildAt(c);
                    this.postInflateProcess(child, projectCallback);
                }
            }
        }
    }

    private void setupTabHost(TabHost tabHost, IProjectCallback projectCallback) throws PostInflateException {
        View v = tabHost.findViewById(16908307);
        if (v == null) {
            throw new PostInflateException("TabHost requires a TabWidget with id \"android:id/tabs\".\n");
        }
        if (!(v instanceof TabWidget)) {
            throw new PostInflateException(String.format("TabHost requires a TabWidget with id \"android:id/tabs\".\nView found with id 'tabs' is '%s'", v.getClass().getCanonicalName()));
        }
        v = tabHost.findViewById(0x1020011);
        if (v == null) {
            throw new PostInflateException("TabHost requires a FrameLayout with id \"android:id/tabcontent\".");
        }
        if (!(v instanceof FrameLayout)) {
            throw new PostInflateException(String.format("TabHost requires a FrameLayout with id \"android:id/tabcontent\".\nView found with id 'tabcontent' is '%s'", v.getClass().getCanonicalName()));
        }
        FrameLayout content = (FrameLayout)v;
        int count = content.getChildCount();
        tabHost.setup();
        if (count == 0) {
            TabHost.TabSpec spec = tabHost.newTabSpec("tag").setIndicator("Tab Label", tabHost.getResources().getDrawable(17301569)).setContent(new TabHost.TabContentFactory(){

                @Override
                public View createTabContent(String tag) {
                    return new LinearLayout(RenderSessionImpl.this.getContext());
                }
            });
            tabHost.addTab(spec);
        } else {
            for (int i = 0; i < count; ++i) {
                View child = content.getChildAt(i);
                String tabSpec = String.format("tab_spec%d", i + 1);
                int id2 = child.getId();
                Pair resource = projectCallback.resolveResourceId(id2);
                String name = resource != null ? (String)resource.getSecond() : String.format("Tab %d", i + 1);
                tabHost.addTab(tabHost.newTabSpec(tabSpec).setIndicator(name).setContent(id2));
            }
        }
    }

    private ViewInfo visit(View view, int offset, boolean setExtendedInfo, boolean isContentFrame) {
        ViewInfo result = this.createViewInfo(view, offset, setExtendedInfo, isContentFrame);
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            result.setChildren(this.visitAllChildren(group, isContentFrame ? 0 : offset, setExtendedInfo, isContentFrame));
        }
        return result;
    }

    private List<ViewInfo> visitAllChildren(ViewGroup viewGroup, int offset, boolean setExtendedInfo, boolean isContentFrame) {
        if (viewGroup == null) {
            return null;
        }
        if (!isContentFrame) {
            offset += viewGroup.getTop();
        }
        int childCount = viewGroup.getChildCount();
        if (viewGroup == this.mContentRoot) {
            ArrayList<ViewInfo> childrenWithoutOffset = new ArrayList<ViewInfo>(childCount);
            ArrayList<ViewInfo> childrenWithOffset = new ArrayList<ViewInfo>(childCount);
            for (int i = 0; i < childCount; ++i) {
                ViewInfo[] childViewInfo = this.visitContentRoot(viewGroup.getChildAt(i), offset, setExtendedInfo);
                childrenWithoutOffset.add(childViewInfo[0]);
                childrenWithOffset.add(childViewInfo[1]);
            }
            this.mViewInfoList = childrenWithOffset;
            return childrenWithoutOffset;
        }
        ArrayList<ViewInfo> children = new ArrayList<ViewInfo>(childCount);
        for (int i = 0; i < childCount; ++i) {
            children.add(this.visit(viewGroup.getChildAt(i), offset, setExtendedInfo, isContentFrame));
        }
        return children;
    }

    private ViewInfo[] visitContentRoot(View view, int offset, boolean setExtendedInfo) {
        ViewInfo[] result = new ViewInfo[2];
        if (view == null) {
            return result;
        }
        result[0] = this.createViewInfo(view, 0, setExtendedInfo, true);
        result[1] = this.createViewInfo(view, offset, setExtendedInfo, true);
        if (view instanceof ViewGroup) {
            List<ViewInfo> children = this.visitAllChildren((ViewGroup)view, 0, setExtendedInfo, true);
            result[0].setChildren(children);
            result[1].setChildren(children);
        }
        return result;
    }

    private ViewInfo createViewInfo(View view, int offset, boolean setExtendedInfo, boolean isContentFrame) {
        SystemViewInfo result;
        if (view == null) {
            return null;
        }
        if (isContentFrame) {
            result = new ViewInfo(view.getClass().getName(), this.getContext().getViewKey(view), view.getLeft(), view.getTop() + offset, view.getRight(), view.getBottom() + offset, (Object)view, (Object)view.getLayoutParams());
        } else {
            SystemViewInfo r;
            result = r = new SystemViewInfo(view.getClass().getName(), this.getViewKey(view), view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), view, view.getLayoutParams());
            if (view instanceof ListMenuItemView) {
                r.setViewType(ViewType.ACTION_BAR_OVERFLOW_MENU);
            } else {
                ViewGroup.LayoutParams lp = view.getLayoutParams();
                if (lp instanceof ActionMenuView.LayoutParams && ((ActionMenuView.LayoutParams)lp).isOverflowButton) {
                    r.setViewType(ViewType.ACTION_BAR_OVERFLOW);
                } else {
                    for (ViewParent parent = view.getParent(); parent != this.mViewRoot && parent instanceof ViewGroup; parent = parent.getParent()) {
                        if (!(parent instanceof ActionMenuView)) continue;
                        r.setViewType(ViewType.ACTION_BAR_MENU);
                        break;
                    }
                }
            }
        }
        if (setExtendedInfo) {
            ViewGroup.MarginLayoutParams marginParams = null;
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                marginParams = (ViewGroup.MarginLayoutParams)params;
            }
            result.setExtendedInfo(view.getBaseline(), marginParams != null ? marginParams.leftMargin : 0, marginParams != null ? marginParams.topMargin : 0, marginParams != null ? marginParams.rightMargin : 0, marginParams != null ? marginParams.bottomMargin : 0);
        }
        return result;
    }

    private Object getViewKey(View view) {
        BridgeContext context = this.getContext();
        if (!(view instanceof MenuView.ItemView)) {
            return context.getViewKey(view);
        }
        MenuItemImpl menuItem = view instanceof ActionMenuItemView ? ((ActionMenuItemView)view).getItemData() : (view instanceof ListMenuItemView ? ((ListMenuItemView)view).getItemData() : (view instanceof IconMenuItemView ? ((IconMenuItemView)view).getItemData() : null));
        if (menuItem instanceof BridgeMenuItemImpl) {
            return ((BridgeMenuItemImpl)menuItem).getViewCookie();
        }
        return null;
    }

    private void invalidateRenderingSize() {
        this.mMeasuredScreenHeight = -1;
        this.mMeasuredScreenWidth = -1;
    }

    private StatusBar createStatusBar(BridgeContext context, Density density, int direction, boolean isRtlSupported, int platformVersion) throws XmlPullParserException {
        StatusBar statusBar = new StatusBar((Context)context, density, direction, isRtlSupported, platformVersion);
        statusBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mStatusBarSize));
        return statusBar;
    }

    private NavigationBar createNavigationBar(BridgeContext context, Density density, boolean isRtl, boolean isRtlSupported, int simulatedPlatformVersion) throws XmlPullParserException {
        NavigationBar navigationBar = new NavigationBar(context, density, this.mNavigationBarOrientation, isRtl, isRtlSupported, simulatedPlatformVersion);
        if (this.mNavigationBarOrientation == 1) {
            navigationBar.setLayoutParams(new LinearLayout.LayoutParams(this.mNavigationBarSize, -1));
        } else {
            navigationBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mNavigationBarSize));
        }
        return navigationBar;
    }

    private TitleBar createTitleBar(BridgeContext context, String title, int simulatedPlatformVersion) throws XmlPullParserException {
        TitleBar titleBar = new TitleBar((Context)context, title, simulatedPlatformVersion);
        titleBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mTitleBarSize));
        return titleBar;
    }

    private ActionBarLayout createActionBar(BridgeContext context, SessionParams params, ViewGroup parentView) {
        return new ActionBarLayout(context, params, parentView);
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public boolean isAlphaChannelImage() {
        return this.mIsAlphaChannelImage;
    }

    public List<ViewInfo> getViewInfos() {
        return this.mViewInfoList;
    }

    public List<ViewInfo> getSystemViewInfos() {
        return this.mSystemViewInfoList;
    }

    public Map<String, String> getDefaultProperties(Object viewObject) {
        return this.getContext().getDefaultPropMap(viewObject);
    }

    public void setScene(RenderSession session) {
        this.mScene = session;
    }

    public RenderSession getSession() {
        return this.mScene;
    }

    private static final class PostInflateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PostInflateException(String message) {
            super(message);
        }
    }
}

