/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.res.Configuration;
import android.os.HandlerThread_Delegate;
import android.util.DisplayMetrics;
import android.view.ViewConfiguration_Accessor;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodManager_Accessor;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderParams;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class RenderAction<T extends RenderParams>
extends RenderResources.FrameworkResourceIdProvider {
    private static BridgeContext sCurrentContext = null;
    private final T mParams;
    private BridgeContext mContext;

    protected RenderAction(T params) {
        this.mParams = params;
    }

    public Result init(long timeout) {
        Result result = this.acquireLock(timeout);
        if (result != null) {
            return result;
        }
        HardwareConfig hardwareConfig = this.mParams.getHardwareConfig();
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.densityDpi = metrics.noncompatDensityDpi = hardwareConfig.getDensity().getDpiValue();
        metrics.scaledDensity = metrics.noncompatScaledDensity = (metrics.density = (metrics.noncompatDensity = (float)metrics.densityDpi / 160.0f));
        metrics.widthPixels = metrics.noncompatWidthPixels = hardwareConfig.getScreenWidth();
        metrics.heightPixels = metrics.noncompatHeightPixels = hardwareConfig.getScreenHeight();
        metrics.xdpi = metrics.noncompatXdpi = hardwareConfig.getXdpi();
        metrics.ydpi = metrics.noncompatYdpi = hardwareConfig.getYdpi();
        RenderResources resources = this.mParams.getResources();
        this.mContext = new BridgeContext(this.mParams.getProjectKey(), metrics, resources, this.mParams.getProjectCallback(), this.getConfiguration(), this.mParams.getTargetSdkVersion(), this.mParams.isRtlSupported());
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    public Result acquire(long timeout) {
        if (this.mContext == null) {
            throw new IllegalStateException("After scene creation, #init() must be called");
        }
        Result result = this.acquireLock(timeout);
        if (result != null) {
            return result;
        }
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    private Result acquireLock(long timeout) {
        block5: {
            ReentrantLock lock = Bridge.getLock();
            if (!lock.isHeldByCurrentThread()) {
                try {
                    boolean acquired = lock.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (!acquired) {
                        return Result.Status.ERROR_TIMEOUT.createResult();
                    }
                    break block5;
                }
                catch (InterruptedException e) {
                    return Result.Status.ERROR_LOCK_INTERRUPTED.createResult();
                }
            }
            if (this.mContext != sCurrentContext) {
                throw new IllegalStateException("Acquiring different scenes from same thread without releases");
            }
            return Result.Status.SUCCESS.createResult();
        }
        return null;
    }

    public void release() {
        ReentrantLock lock = Bridge.getLock();
        if (lock.isHeldByCurrentThread()) {
            this.tearDown();
            lock.unlock();
        }
    }

    private void setUp() {
        this.mContext.initResources();
        sCurrentContext = this.mContext;
        InputMethodManager.getInstance();
        LayoutLog currentLog = this.mParams.getLog();
        Bridge.setLog(currentLog);
        this.mContext.getRenderResources().setFrameworkResourceIdProvider((RenderResources.FrameworkResourceIdProvider)this);
        this.mContext.getRenderResources().setLogger(currentLog);
    }

    private void tearDown() {
        if (this.mContext != null) {
            this.mContext.disposeResources();
        }
        if (sCurrentContext != null) {
            HandlerThread_Delegate.cleanUp(sCurrentContext);
        }
        ViewConfiguration_Accessor.clearConfigurations();
        InputMethodManager_Accessor.resetInstance();
        sCurrentContext = null;
        Bridge.setLog(null);
        if (this.mContext != null) {
            this.mContext.getRenderResources().setFrameworkResourceIdProvider(null);
            this.mContext.getRenderResources().setLogger(null);
        }
    }

    public static BridgeContext getCurrentContext() {
        return sCurrentContext;
    }

    protected T getParams() {
        return this.mParams;
    }

    protected BridgeContext getContext() {
        return this.mContext;
    }

    public LayoutLog getLog() {
        if (this.mParams != null) {
            return this.mParams.getLog();
        }
        return null;
    }

    protected void checkLock() {
        ReentrantLock lock = Bridge.getLock();
        if (!lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("scene must be acquired first. see #acquire(long)");
        }
        if (sCurrentContext != this.mContext) {
            throw new IllegalStateException("Thread acquired a scene but is rendering a different one");
        }
    }

    private Configuration getConfiguration() {
        Density density;
        Configuration config = new Configuration();
        HardwareConfig hardwareConfig = this.mParams.getHardwareConfig();
        ScreenSize screenSize = hardwareConfig.getScreenSize();
        if (screenSize != null) {
            switch (screenSize) {
                case SMALL: {
                    config.screenLayout |= 1;
                    break;
                }
                case NORMAL: {
                    config.screenLayout |= 2;
                    break;
                }
                case LARGE: {
                    config.screenLayout |= 3;
                    break;
                }
                case XLARGE: {
                    config.screenLayout |= 4;
                }
            }
        }
        if ((density = hardwareConfig.getDensity()) == null) {
            density = Density.MEDIUM;
        }
        config.screenWidthDp = hardwareConfig.getScreenWidth() / density.getDpiValue();
        config.screenHeightDp = hardwareConfig.getScreenHeight() / density.getDpiValue();
        config.smallestScreenWidthDp = config.screenHeightDp < config.screenWidthDp ? config.screenHeightDp : config.screenWidthDp;
        config.densityDpi = density.getDpiValue();
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        ScreenOrientation orientation = hardwareConfig.getOrientation();
        if (orientation != null) {
            switch (orientation) {
                case PORTRAIT: {
                    config.orientation = 1;
                    break;
                }
                case LANDSCAPE: {
                    config.orientation = 2;
                    break;
                }
                case SQUARE: {
                    config.orientation = 3;
                }
            }
        } else {
            config.orientation = 0;
        }
        return config;
    }

    public Integer getId(ResourceType resType, String resName) {
        return Bridge.getResourceId(resType, resName);
    }
}

