/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.app.ActionBar;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowCallback;
import android.widget.ActionMenuPresenter;
import android.widget.Toolbar;
import android.widget.Toolbar_Accessor;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.internal.app.ToolbarActionBar;
import com.android.internal.app.WindowDecorActionBar;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.ActionBarAccessor;
import com.android.internal.widget.ActionBarView;
import com.android.internal.widget.DecorToolbar;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.ActionBarLayout;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;

public abstract class CustomActionBarWrapper {
    @NonNull
    protected ActionBar mActionBar;
    @NonNull
    protected SessionParams mParams;
    @NonNull
    protected ActionBarCallback mCallback;
    @NonNull
    protected BridgeContext mContext;

    @NonNull
    public static CustomActionBarWrapper getActionBarWrapper(@NonNull BridgeContext context, @NonNull SessionParams params, @NonNull View decorContent) {
        View view = decorContent.findViewById(16909173);
        if (view instanceof Toolbar) {
            return new ToolbarWrapper(context, params, (Toolbar)view);
        }
        if (view instanceof ActionBarView) {
            return new WindowActionBarWrapper(context, params, decorContent, (ActionBarView)view);
        }
        throw new IllegalStateException("Can't make an action bar out of " + view.getClass().getSimpleName());
    }

    CustomActionBarWrapper(@NonNull BridgeContext context, @NonNull SessionParams params, @NonNull ActionBar actionBar) {
        this.mActionBar = actionBar;
        this.mParams = params;
        this.mCallback = params.getProjectCallback().getActionBarCallback();
        this.mContext = context;
    }

    protected void setupActionBar() {
        String title;
        RenderResources res = this.mContext.getRenderResources();
        ResourceValue titleValue = res.findResValue(title = this.mParams.getAppLabel(), false);
        if (titleValue != null && titleValue.getValue() != null) {
            this.mActionBar.setTitle(titleValue.getValue());
        } else {
            this.mActionBar.setTitle(title);
        }
        String subTitle = this.mCallback.getSubTitle();
        if (subTitle != null) {
            this.mActionBar.setSubtitle(subTitle);
        }
        if (this.mCallback.getHomeButtonStyle() == ActionBarCallback.HomeButtonStyle.SHOW_HOME_AS_UP) {
            this.mActionBar.setDisplayOptions(255, 4);
        }
    }

    protected boolean isSplit() {
        return this.getDecorToolbar().isSplit();
    }

    protected boolean isOverflowPopupNeeded() {
        return this.mCallback.isOverflowPopupNeeded();
    }

    protected void inflateMenus() {
        MenuInflater inflater = new MenuInflater(this.getActionMenuContext());
        MenuBuilder menuBuilder = this.getMenuBuilder();
        for (String name : this.mCallback.getMenuIdNames()) {
            int id2;
            if (name.startsWith("android:")) {
                name = name.substring("android:".length());
                id2 = this.mContext.getFrameworkResourceValue(ResourceType.MENU, name, -1);
            } else {
                id2 = this.mContext.getProjectResourceValue(ResourceType.MENU, name, -1);
            }
            if (id2 <= -1) continue;
            inflater.inflate(id2, menuBuilder);
        }
    }

    @NonNull
    protected Context getActionMenuContext() {
        return this.mActionBar.getThemedContext();
    }

    @NonNull
    abstract Context getPopupContext();

    @NonNull
    abstract MenuBuilder getMenuBuilder();

    @Nullable
    abstract ActionMenuPresenter getActionMenuPresenter();

    @NonNull
    abstract DecorToolbar getDecorToolbar();

    abstract int getMenuPopupElevation();

    abstract int getMenuPopupMargin();

    private static class WindowActionBarWrapper
    extends CustomActionBarWrapper {
        @NonNull
        private final WindowDecorActionBar mActionBar;
        @NonNull
        private final ActionBarView mActionBarView;
        @NonNull
        private final View mDecorContentRoot;
        private MenuBuilder mMenuBuilder;

        public WindowActionBarWrapper(@NonNull BridgeContext context, @NonNull SessionParams params, @NonNull View decorContentRoot, @NonNull ActionBarView actionBarView) {
            super(context, params, new WindowDecorActionBar(decorContentRoot));
            this.mActionBarView = actionBarView;
            this.mActionBar = (WindowDecorActionBar)((CustomActionBarWrapper)this).mActionBar;
            this.mDecorContentRoot = decorContentRoot;
        }

        @Override
        protected void setupActionBar() {
            ViewGroup splitView;
            Drawable iconDrawable;
            super.setupActionBar();
            int navMode = this.mCallback.getNavigationMode();
            this.mActionBar.setNavigationMode(navMode);
            if (navMode == 2) {
                this.setupTabs(3);
            }
            String icon = this.mParams.getAppIcon();
            if (!this.mActionBar.hasIcon() && icon != null && (iconDrawable = this.getDrawable(icon, false)) != null) {
                this.mActionBar.setIcon(iconDrawable);
            }
            if ((splitView = (ViewGroup)this.mDecorContentRoot.findViewById(16909175)) != null) {
                this.mActionBarView.setSplitView(splitView);
                Resources res = this.mContext.getResources();
                boolean split = res.getBoolean(17956870) && this.mCallback.getSplitActionBarWhenNarrow();
                this.mActionBarView.setSplitToolbar(split);
            }
        }

        @Override
        protected void inflateMenus() {
            super.inflateMenus();
            this.mActionBarView.setMenu(this.getMenuBuilder(), null);
        }

        @Override
        @NonNull
        Context getPopupContext() {
            return this.getActionMenuContext();
        }

        @Override
        @NonNull
        MenuBuilder getMenuBuilder() {
            if (this.mMenuBuilder == null) {
                this.mMenuBuilder = new MenuBuilder(this.getActionMenuContext());
            }
            return this.mMenuBuilder;
        }

        @Override
        @Nullable
        ActionMenuPresenter getActionMenuPresenter() {
            return ActionBarAccessor.getActionMenuPresenter(this.mActionBarView);
        }

        @Override
        @NonNull
        ActionBarView getDecorToolbar() {
            return this.mActionBarView;
        }

        @Override
        int getMenuPopupElevation() {
            return 0;
        }

        @Override
        int getMenuPopupMargin() {
            return -ActionBarLayout.getPixelValue("10dp", this.mContext.getMetrics());
        }

        private void setupTabs(int num) {
            for (int i = 1; i <= num; ++i) {
                ActionBar.Tab tab = this.mActionBar.newTab().setText("Tab" + i).setTabListener(new ActionBar.TabListener(){

                    @Override
                    public void onTabUnselected(ActionBar.Tab t, FragmentTransaction ft) {
                    }

                    @Override
                    public void onTabSelected(ActionBar.Tab t, FragmentTransaction ft) {
                    }

                    @Override
                    public void onTabReselected(ActionBar.Tab t, FragmentTransaction ft) {
                    }
                });
                this.mActionBar.addTab(tab);
            }
        }

        @Nullable
        private Drawable getDrawable(@NonNull String name, boolean isFramework) {
            RenderResources res = this.mContext.getRenderResources();
            ResourceValue value = res.findResValue(name, isFramework);
            if ((value = res.resolveResValue(value)) != null) {
                return ResourceHelper.getDrawable(value, this.mContext);
            }
            return null;
        }
    }

    private static class ToolbarWrapper
    extends CustomActionBarWrapper {
        @NonNull
        private final Toolbar mToolbar;

        ToolbarWrapper(@NonNull BridgeContext context, @NonNull SessionParams params, @NonNull Toolbar toolbar) {
            super(context, params, new ToolbarActionBar(toolbar, "", new WindowCallback()));
            this.mToolbar = toolbar;
        }

        @Override
        protected void inflateMenus() {
            super.inflateMenus();
            MenuBuilder menu2 = this.getMenuBuilder();
            DecorToolbar decorToolbar = this.getDecorToolbar();
            decorToolbar.setMenu(new MenuBuilder(this.getActionMenuContext()), null);
            decorToolbar.setMenu(menu2, null);
        }

        @Override
        @NonNull
        Context getPopupContext() {
            return Toolbar_Accessor.getPopupContext(this.mToolbar);
        }

        @Override
        @NonNull
        MenuBuilder getMenuBuilder() {
            return (MenuBuilder)this.mToolbar.getMenu();
        }

        @Override
        @Nullable
        ActionMenuPresenter getActionMenuPresenter() {
            return Toolbar_Accessor.getActionMenuPresenter(this.mToolbar);
        }

        @Override
        @NonNull
        DecorToolbar getDecorToolbar() {
            return this.mToolbar.getWrapper();
        }

        @Override
        int getMenuPopupElevation() {
            return 10;
        }

        @Override
        int getMenuPopupMargin() {
            return 0;
        }
    }
}

