/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.widget.AbsListView;
import android.widget.OverScroller;
import com.android.internal.R;

public class ResolverDrawerLayout
extends ViewGroup {
    private static final String TAG = "ResolverDrawerLayout";
    private int mMaxWidth;
    private int mMaxCollapsedHeight;
    private int mMaxCollapsedHeightSmall;
    private boolean mSmallCollapsed;
    private float mCollapseOffset;
    private int mCollapsibleHeight;
    private int mTopOffset;
    private boolean mIsDragging;
    private boolean mOpenOnClick;
    private boolean mOpenOnLayout;
    private final int mTouchSlop;
    private final float mMinFlingVelocity;
    private final OverScroller mScroller;
    private final VelocityTracker mVelocityTracker;
    private View.OnClickListener mClickOutsideListener;
    private float mInitialTouchX;
    private float mInitialTouchY;
    private float mLastTouchY;
    private int mActivePointerId = -1;
    private final Rect mTempRect = new Rect();
    private final ViewTreeObserver.OnTouchModeChangeListener mTouchModeChangeListener = new ViewTreeObserver.OnTouchModeChangeListener(){

        @Override
        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode && ResolverDrawerLayout.this.hasFocus() && ResolverDrawerLayout.this.isDescendantClipped(ResolverDrawerLayout.this.getFocusedChild())) {
                ResolverDrawerLayout.this.smoothScrollTo(0, 0.0f);
            }
        }
    };

    public ResolverDrawerLayout(Context context) {
        this(context, null);
    }

    public ResolverDrawerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ResolverDrawerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ResolverDrawerLayout, defStyleAttr, 0);
        this.mMaxWidth = a.getDimensionPixelSize(0, -1);
        this.mMaxCollapsedHeight = a.getDimensionPixelSize(1, 0);
        this.mMaxCollapsedHeightSmall = a.getDimensionPixelSize(2, this.mMaxCollapsedHeight);
        a.recycle();
        this.mScroller = new OverScroller(context, AnimationUtils.loadInterpolator(context, 17563653));
        this.mVelocityTracker = VelocityTracker.obtain();
        ViewConfiguration vc = ViewConfiguration.get(context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
    }

    public void setSmallCollapsed(boolean smallCollapsed) {
        this.mSmallCollapsed = smallCollapsed;
        this.requestLayout();
    }

    public boolean isSmallCollapsed() {
        return this.mSmallCollapsed;
    }

    public boolean isCollapsed() {
        return this.mCollapseOffset > 0.0f;
    }

    private boolean isMoving() {
        return this.mIsDragging || !this.mScroller.isFinished();
    }

    private int getMaxCollapsedHeight() {
        return this.isSmallCollapsed() ? this.mMaxCollapsedHeightSmall : this.mMaxCollapsedHeight;
    }

    public void setOnClickOutsideListener(View.OnClickListener listener) {
        this.mClickOutsideListener = listener;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        if (action == 0) {
            this.mVelocityTracker.clear();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialTouchX = x;
                this.mInitialTouchY = this.mLastTouchY = y;
                this.mOpenOnClick = this.isListChildUnderClipped(x, y) && this.mCollapsibleHeight > 0;
                break;
            }
            case 2: {
                float x = ev.getX();
                float y = ev.getY();
                float dy = y - this.mInitialTouchY;
                if (!(Math.abs(dy) > (float)this.mTouchSlop) || this.findChildUnder(x, y) == null || (this.getNestedScrollAxes() & 2) != 0) break;
                this.mActivePointerId = ev.getPointerId(0);
                this.mIsDragging = true;
                this.mLastTouchY = Math.max(this.mLastTouchY - (float)this.mTouchSlop, Math.min(this.mLastTouchY + dy, this.mLastTouchY + (float)this.mTouchSlop));
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.resetTouch();
            }
        }
        if (this.mIsDragging) {
            this.mScroller.abortAnimation();
        }
        return this.mIsDragging || this.mOpenOnClick;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        this.mVelocityTracker.addMovement(ev);
        boolean handled = false;
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialTouchX = x;
                this.mInitialTouchY = this.mLastTouchY = y;
                this.mActivePointerId = ev.getPointerId(0);
                if (this.findChildUnder(this.mInitialTouchX, this.mInitialTouchY) == null && this.mClickOutsideListener != null) {
                    handled = true;
                    this.mIsDragging = true;
                }
                handled |= this.mCollapsibleHeight > 0;
                this.mScroller.abortAnimation();
                break;
            }
            case 2: {
                float dy;
                int index = ev.findPointerIndex(this.mActivePointerId);
                if (index < 0) {
                    Log.e(TAG, "Bad pointer id " + this.mActivePointerId + ", resetting");
                    index = 0;
                    this.mActivePointerId = ev.getPointerId(0);
                    this.mInitialTouchX = ev.getX();
                    this.mInitialTouchY = this.mLastTouchY = ev.getY();
                }
                float x = ev.getX(index);
                float y = ev.getY(index);
                if (!this.mIsDragging && Math.abs(dy = y - this.mInitialTouchY) > (float)this.mTouchSlop && this.findChildUnder(x, y) != null) {
                    this.mIsDragging = true;
                    handled = true;
                    this.mLastTouchY = Math.max(this.mLastTouchY - (float)this.mTouchSlop, Math.min(this.mLastTouchY + dy, this.mLastTouchY + (float)this.mTouchSlop));
                }
                if (this.mIsDragging) {
                    dy = y - this.mLastTouchY;
                    this.performDrag(dy);
                }
                this.mLastTouchY = y;
                break;
            }
            case 5: {
                int pointerId;
                int pointerIndex = ev.getActionIndex();
                this.mActivePointerId = pointerId = ev.getPointerId(pointerIndex);
                this.mInitialTouchX = ev.getX(pointerIndex);
                this.mInitialTouchY = this.mLastTouchY = ev.getY(pointerIndex);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: {
                this.mIsDragging = false;
                if (!this.mIsDragging && this.findChildUnder(this.mInitialTouchX, this.mInitialTouchY) == null && this.findChildUnder(ev.getX(), ev.getY()) == null && this.mClickOutsideListener != null) {
                    this.mClickOutsideListener.onClick(this);
                    this.resetTouch();
                    return true;
                }
                if (this.mOpenOnClick && Math.abs(ev.getX() - this.mInitialTouchX) < (float)this.mTouchSlop && Math.abs(ev.getY() - this.mInitialTouchY) < (float)this.mTouchSlop) {
                    this.smoothScrollTo(0, 0.0f);
                    return true;
                }
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float yvel = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                if (Math.abs(yvel) > this.mMinFlingVelocity) {
                    this.smoothScrollTo(yvel < 0.0f ? 0 : this.mCollapsibleHeight, yvel);
                } else {
                    this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
                }
                this.resetTouch();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
                }
                this.resetTouch();
                return true;
            }
        }
        return handled;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mInitialTouchX = ev.getX(newPointerIndex);
            this.mInitialTouchY = this.mLastTouchY = ev.getY(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    private void resetTouch() {
        this.mActivePointerId = -1;
        this.mIsDragging = false;
        this.mOpenOnClick = false;
        this.mLastTouchY = 0.0f;
        this.mInitialTouchY = 0.0f;
        this.mInitialTouchX = 0.0f;
        this.mVelocityTracker.clear();
    }

    @Override
    public void computeScroll() {
        super.computeScroll();
        if (!this.mScroller.isFinished()) {
            boolean keepGoing = this.mScroller.computeScrollOffset();
            this.performDrag((float)this.mScroller.getCurrY() - this.mCollapseOffset);
            if (keepGoing) {
                this.postInvalidateOnAnimation();
            }
        }
    }

    private float performDrag(float dy) {
        float newPos = Math.max(0.0f, Math.min(this.mCollapseOffset + dy, (float)this.mCollapsibleHeight));
        if (newPos != this.mCollapseOffset) {
            dy = newPos - this.mCollapseOffset;
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.ignoreOffset) continue;
                child.offsetTopAndBottom((int)dy);
            }
            this.mCollapseOffset = newPos;
            this.mTopOffset = (int)((float)this.mTopOffset + dy);
            this.postInvalidateOnAnimation();
            return dy;
        }
        return 0.0f;
    }

    private void smoothScrollTo(int yOffset, float velocity) {
        if (this.getMaxCollapsedHeight() == 0) {
            return;
        }
        this.mScroller.abortAnimation();
        int sy = (int)this.mCollapseOffset;
        int dy = yOffset - sy;
        if (dy == 0) {
            return;
        }
        int height = this.getHeight();
        int halfHeight = height / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dy) / (float)height);
        float distance = (float)halfHeight + (float)halfHeight * this.distanceInfluenceForSnapDuration(distanceRatio);
        int duration = 0;
        if ((velocity = Math.abs(velocity)) > 0.0f) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / velocity));
        } else {
            float pageDelta = (float)Math.abs(dy) / (float)height;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 300);
        this.mScroller.startScroll(0, sy, 0, dy, duration);
        this.postInvalidateOnAnimation();
    }

    private float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    private View findChildUnder(float x, float y) {
        return ResolverDrawerLayout.findChildUnder(this, x, y);
    }

    private static View findChildUnder(ViewGroup parent, float x, float y) {
        int childCount = parent.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = parent.getChildAt(i);
            if (!ResolverDrawerLayout.isChildUnder(child, x, y)) continue;
            return child;
        }
        return null;
    }

    private View findListChildUnder(float x, float y) {
        View v = this.findChildUnder(x, y);
        while (v != null) {
            x -= v.getX();
            y -= v.getY();
            if (v instanceof AbsListView) {
                return ResolverDrawerLayout.findChildUnder((ViewGroup)v, x, y);
            }
            v = v instanceof ViewGroup ? ResolverDrawerLayout.findChildUnder((ViewGroup)v, x, y) : null;
        }
        return v;
    }

    private boolean isListChildUnderClipped(float x, float y) {
        View listChild = this.findListChildUnder(x, y);
        return listChild != null && this.isDescendantClipped(listChild);
    }

    private boolean isDescendantClipped(View child) {
        View directChild;
        this.mTempRect.set(0, 0, child.getWidth(), child.getHeight());
        this.offsetDescendantRectToMyCoords(child, this.mTempRect);
        if (child.getParent() == this) {
            directChild = child;
        } else {
            View v = child;
            ViewParent p = child.getParent();
            while (p != this) {
                v = (View)((Object)p);
                p = v.getParent();
            }
            directChild = v;
        }
        int clipEdge = this.getHeight() - this.getPaddingBottom();
        int childCount = this.getChildCount();
        for (int i = this.indexOfChild(directChild) + 1; i < childCount; ++i) {
            View nextChild = this.getChildAt(i);
            if (nextChild.getVisibility() == 8) continue;
            clipEdge = Math.min(clipEdge, nextChild.getTop());
        }
        return this.mTempRect.bottom > clipEdge;
    }

    private static boolean isChildUnder(View child, float x, float y) {
        float left = child.getX();
        float top = child.getY();
        float right = left + (float)child.getWidth();
        float bottom = top + (float)child.getHeight();
        return x >= left && y >= top && x < right && y < bottom;
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        if (!this.isInTouchMode() && this.isDescendantClipped(focused)) {
            this.smoothScrollTo(0, 0.0f);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnTouchModeChangeListener(this.mTouchModeChangeListener);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnTouchModeChangeListener(this.mTouchModeChangeListener);
    }

    @Override
    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    @Override
    public void onNestedScrollAccepted(View child, View target, int axes) {
        super.onNestedScrollAccepted(child, target, axes);
    }

    @Override
    public void onStopNestedScroll(View child) {
        super.onStopNestedScroll(child);
        if (this.mScroller.isFinished()) {
            this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
        }
    }

    @Override
    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        if (dyUnconsumed < 0) {
            this.performDrag(-dyUnconsumed);
        }
    }

    @Override
    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (dy > 0) {
            consumed[1] = (int)(-this.performDrag(-dy));
        }
    }

    @Override
    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        if (velocityY > this.mMinFlingVelocity && this.mCollapseOffset != 0.0f) {
            this.smoothScrollTo(0, velocityY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed && Math.abs(velocityY) > this.mMinFlingVelocity) {
            this.smoothScrollTo(velocityY > 0.0f ? 0 : this.mCollapsibleHeight, velocityY);
            return true;
        }
        return false;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sourceWidth;
        int widthSize = sourceWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (this.mMaxWidth >= 0) {
            widthSize = Math.min(widthSize, this.mMaxWidth);
        }
        int widthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(heightSize, 0x40000000);
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int heightUsed = this.getPaddingTop() + this.getPaddingBottom();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (!lp.alwaysShow || child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthSpec, widthPadding, heightSpec, heightUsed);
            heightUsed += lp.topMargin + child.getMeasuredHeight() + lp.bottomMargin;
        }
        int alwaysShowHeight = heightUsed;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.alwaysShow || child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthSpec, widthPadding, heightSpec, heightUsed);
            heightUsed += lp.topMargin + child.getMeasuredHeight() + lp.bottomMargin;
        }
        this.mCollapsibleHeight = Math.max(0, heightUsed - alwaysShowHeight - this.getMaxCollapsedHeight());
        this.mCollapseOffset = this.isLaidOut() ? Math.min(this.mCollapseOffset, (float)this.mCollapsibleHeight) : (this.mOpenOnLayout ? 0.0f : (float)this.mCollapsibleHeight);
        this.mTopOffset = Math.max(0, heightSize - heightUsed) + (int)this.mCollapseOffset;
        this.setMeasuredDimension(sourceWidth, heightSize);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.getWidth();
        int ypos = this.mTopOffset;
        int leftEdge = this.getPaddingLeft();
        int rightEdge = width - this.getPaddingRight();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8) continue;
            int top = ypos + lp.topMargin;
            if (lp.ignoreOffset) {
                top = (int)((float)top - this.mCollapseOffset);
            }
            int bottom = top + child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            int widthAvailable = rightEdge - leftEdge;
            int left = leftEdge + (widthAvailable - childWidth) / 2;
            int right = left + childWidth;
            child.layout(left, top, right, bottom);
            ypos = bottom + lp.bottomMargin;
        }
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        ss.open = this.mCollapsibleHeight > 0 && this.mCollapseOffset == 0.0f;
        return ss;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mOpenOnLayout = ss.open;
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean open;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.open = in.readInt() != 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.open ? 1 : 0);
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public boolean alwaysShow;
        public boolean ignoreOffset;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ResolverDrawerLayout_LayoutParams);
            this.alwaysShow = a.getBoolean(1, false);
            this.ignoreOffset = a.getBoolean(2, false);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(LayoutParams source) {
            super(source);
            this.alwaysShow = source.alwaysShow;
            this.ignoreOffset = source.ignoreOffset;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

