/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.LongArray;
import android.util.Pools;
import android.view.View;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessibilityNodeInfo
implements Parcelable {
    private static final boolean DEBUG = false;
    public static final int UNDEFINED_CONNECTION_ID = -1;
    public static final int UNDEFINED_SELECTION_INDEX = -1;
    public static final int UNDEFINED_ITEM_ID = Integer.MAX_VALUE;
    public static final long ROOT_NODE_ID = AccessibilityNodeInfo.makeNodeId(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final int ACTIVE_WINDOW_ID = Integer.MAX_VALUE;
    public static final int ANY_WINDOW_ID = -2;
    public static final int FLAG_PREFETCH_PREDECESSORS = 1;
    public static final int FLAG_PREFETCH_SIBLINGS = 2;
    public static final int FLAG_PREFETCH_DESCENDANTS = 4;
    public static final int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 8;
    public static final int FLAG_REPORT_VIEW_IDS = 16;
    public static final int ACTION_FOCUS = 1;
    public static final int ACTION_CLEAR_FOCUS = 2;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_CLEAR_SELECTION = 8;
    public static final int ACTION_CLICK = 16;
    public static final int ACTION_LONG_CLICK = 32;
    public static final int ACTION_ACCESSIBILITY_FOCUS = 64;
    public static final int ACTION_CLEAR_ACCESSIBILITY_FOCUS = 128;
    public static final int ACTION_NEXT_AT_MOVEMENT_GRANULARITY = 256;
    public static final int ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = 512;
    public static final int ACTION_NEXT_HTML_ELEMENT = 1024;
    public static final int ACTION_PREVIOUS_HTML_ELEMENT = 2048;
    public static final int ACTION_SCROLL_FORWARD = 4096;
    public static final int ACTION_SCROLL_BACKWARD = 8192;
    public static final int ACTION_COPY = 16384;
    public static final int ACTION_PASTE = 32768;
    public static final int ACTION_CUT = 65536;
    public static final int ACTION_SET_SELECTION = 131072;
    public static final int ACTION_EXPAND = 262144;
    public static final int ACTION_COLLAPSE = 524288;
    public static final int ACTION_DISMISS = 0x100000;
    public static final int ACTION_SET_TEXT = 0x200000;
    private static final int LAST_LEGACY_STANDARD_ACTION = 0x200000;
    private static final int ACTION_TYPE_MASK = -16777216;
    public static final String ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT = "ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT";
    public static final String ACTION_ARGUMENT_HTML_ELEMENT_STRING = "ACTION_ARGUMENT_HTML_ELEMENT_STRING";
    public static final String ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN = "ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN";
    public static final String ACTION_ARGUMENT_SELECTION_START_INT = "ACTION_ARGUMENT_SELECTION_START_INT";
    public static final String ACTION_ARGUMENT_SELECTION_END_INT = "ACTION_ARGUMENT_SELECTION_END_INT";
    public static final String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    public static final int FOCUS_INPUT = 1;
    public static final int FOCUS_ACCESSIBILITY = 2;
    public static final int MOVEMENT_GRANULARITY_CHARACTER = 1;
    public static final int MOVEMENT_GRANULARITY_WORD = 2;
    public static final int MOVEMENT_GRANULARITY_LINE = 4;
    public static final int MOVEMENT_GRANULARITY_PARAGRAPH = 8;
    public static final int MOVEMENT_GRANULARITY_PAGE = 16;
    private static final int BOOLEAN_PROPERTY_CHECKABLE = 1;
    private static final int BOOLEAN_PROPERTY_CHECKED = 2;
    private static final int BOOLEAN_PROPERTY_FOCUSABLE = 4;
    private static final int BOOLEAN_PROPERTY_FOCUSED = 8;
    private static final int BOOLEAN_PROPERTY_SELECTED = 16;
    private static final int BOOLEAN_PROPERTY_CLICKABLE = 32;
    private static final int BOOLEAN_PROPERTY_LONG_CLICKABLE = 64;
    private static final int BOOLEAN_PROPERTY_ENABLED = 128;
    private static final int BOOLEAN_PROPERTY_PASSWORD = 256;
    private static final int BOOLEAN_PROPERTY_SCROLLABLE = 512;
    private static final int BOOLEAN_PROPERTY_ACCESSIBILITY_FOCUSED = 1024;
    private static final int BOOLEAN_PROPERTY_VISIBLE_TO_USER = 2048;
    private static final int BOOLEAN_PROPERTY_EDITABLE = 4096;
    private static final int BOOLEAN_PROPERTY_OPENS_POPUP = 8192;
    private static final int BOOLEAN_PROPERTY_DISMISSABLE = 16384;
    private static final int BOOLEAN_PROPERTY_MULTI_LINE = 32768;
    private static final int BOOLEAN_PROPERTY_CONTENT_INVALID = 65536;
    private static final long VIRTUAL_DESCENDANT_ID_MASK = -4294967296L;
    private static final int VIRTUAL_DESCENDANT_ID_SHIFT = 32;
    private static final int MAX_POOL_SIZE = 50;
    private static final Pools.SynchronizedPool<AccessibilityNodeInfo> sPool = new Pools.SynchronizedPool(50);
    private boolean mSealed;
    private int mWindowId = Integer.MAX_VALUE;
    private long mSourceNodeId = ROOT_NODE_ID;
    private long mParentNodeId = ROOT_NODE_ID;
    private long mLabelForId = ROOT_NODE_ID;
    private long mLabeledById = ROOT_NODE_ID;
    private int mBooleanProperties;
    private final Rect mBoundsInParent = new Rect();
    private final Rect mBoundsInScreen = new Rect();
    private CharSequence mPackageName;
    private CharSequence mClassName;
    private CharSequence mText;
    private CharSequence mError;
    private CharSequence mContentDescription;
    private String mViewIdResourceName;
    private LongArray mChildNodeIds;
    private ArrayList<AccessibilityAction> mActions;
    private int mMaxTextLength = -1;
    private int mMovementGranularities;
    private int mTextSelectionStart = -1;
    private int mTextSelectionEnd = -1;
    private int mInputType = 0;
    private int mLiveRegion = 0;
    private Bundle mExtras;
    private int mConnectionId = -1;
    private RangeInfo mRangeInfo;
    private CollectionInfo mCollectionInfo;
    private CollectionItemInfo mCollectionItemInfo;
    public static final Parcelable.Creator<AccessibilityNodeInfo> CREATOR = new Parcelable.Creator<AccessibilityNodeInfo>(){

        @Override
        public AccessibilityNodeInfo createFromParcel(Parcel parcel) {
            AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
            info.initFromParcel(parcel);
            return info;
        }

        public AccessibilityNodeInfo[] newArray(int size) {
            return new AccessibilityNodeInfo[size];
        }
    };

    public static int getAccessibilityViewId(long accessibilityNodeId) {
        return (int)accessibilityNodeId;
    }

    public static int getVirtualDescendantId(long accessibilityNodeId) {
        return (int)((accessibilityNodeId & 0xFFFFFFFF00000000L) >> 32);
    }

    public static long makeNodeId(int accessibilityViewId, int virtualDescendantId) {
        if (virtualDescendantId == -1) {
            virtualDescendantId = Integer.MAX_VALUE;
        }
        return (long)virtualDescendantId << 32 | (long)accessibilityViewId;
    }

    private AccessibilityNodeInfo() {
    }

    public void setSource(View source) {
        this.setSource(source, Integer.MAX_VALUE);
    }

    public void setSource(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        this.mWindowId = root != null ? root.getAccessibilityWindowId() : Integer.MAX_VALUE;
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        this.enforceSealed();
        this.enforceValidFocusType(focus);
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, this.mWindowId, this.mSourceNodeId, focus);
    }

    public AccessibilityNodeInfo focusSearch(int direction) {
        this.enforceSealed();
        this.enforceValidFocusDirection(direction);
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().focusSearch(this.mConnectionId, this.mWindowId, this.mSourceNodeId, direction);
    }

    public int getWindowId() {
        return this.mWindowId;
    }

    public boolean refresh(boolean bypassCache) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        AccessibilityNodeInfo refreshedInfo = client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, bypassCache, 0);
        if (refreshedInfo == null) {
            return false;
        }
        this.init(refreshedInfo);
        refreshedInfo.recycle();
        return true;
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    public LongArray getChildNodeIds() {
        return this.mChildNodeIds;
    }

    public long getChildId(int index) {
        if (this.mChildNodeIds == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.mChildNodeIds.get(index);
    }

    public int getChildCount() {
        return this.mChildNodeIds == null ? 0 : this.mChildNodeIds.size();
    }

    public AccessibilityNodeInfo getChild(int index) {
        this.enforceSealed();
        if (this.mChildNodeIds == null) {
            return null;
        }
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        long childId = this.mChildNodeIds.get(index);
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, childId, false, 4);
    }

    public void addChild(View child) {
        this.addChildInternal(child, Integer.MAX_VALUE, true);
    }

    public void addChildUnchecked(View child) {
        this.addChildInternal(child, Integer.MAX_VALUE, false);
    }

    public boolean removeChild(View child) {
        return this.removeChild(child, Integer.MAX_VALUE);
    }

    public void addChild(View root, int virtualDescendantId) {
        this.addChildInternal(root, virtualDescendantId, true);
    }

    private void addChildInternal(View root, int virtualDescendantId, boolean checked) {
        this.enforceNotSealed();
        if (this.mChildNodeIds == null) {
            this.mChildNodeIds = new LongArray();
        }
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        long childNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
        if (checked && this.mChildNodeIds.indexOf(childNodeId) >= 0) {
            return;
        }
        this.mChildNodeIds.add(childNodeId);
    }

    public boolean removeChild(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        LongArray childIds = this.mChildNodeIds;
        if (childIds == null) {
            return false;
        }
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        long childNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
        int index = childIds.indexOf(childNodeId);
        if (index < 0) {
            return false;
        }
        childIds.remove(index);
        return true;
    }

    public List<AccessibilityAction> getActionList() {
        if (this.mActions == null) {
            return Collections.emptyList();
        }
        return this.mActions;
    }

    @Deprecated
    public int getActions() {
        int returnValue = 0;
        if (this.mActions == null) {
            return returnValue;
        }
        int actionSize = this.mActions.size();
        for (int i = 0; i < actionSize; ++i) {
            int actionId = this.mActions.get(i).getId();
            if (actionId > 0x200000) continue;
            returnValue |= actionId;
        }
        return returnValue;
    }

    public void addAction(AccessibilityAction action) {
        this.enforceNotSealed();
        if (action == null) {
            return;
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.remove(action);
        this.mActions.add(action);
    }

    @Deprecated
    public void addAction(int action) {
        this.enforceNotSealed();
        if ((action & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Action is not a combination of the standard actions: " + action);
        }
        this.addLegacyStandardActions(action);
    }

    @Deprecated
    public void removeAction(int action) {
        this.enforceNotSealed();
        this.removeAction(AccessibilityNodeInfo.getActionSingleton(action));
    }

    public boolean removeAction(AccessibilityAction action) {
        this.enforceNotSealed();
        if (this.mActions == null || action == null) {
            return false;
        }
        return this.mActions.remove(action);
    }

    public void setMaxTextLength(int max) {
        this.enforceNotSealed();
        this.mMaxTextLength = max;
    }

    public int getMaxTextLength() {
        return this.mMaxTextLength;
    }

    public void setMovementGranularities(int granularities) {
        this.enforceNotSealed();
        this.mMovementGranularities = granularities;
    }

    public int getMovementGranularities() {
        return this.mMovementGranularities;
    }

    public boolean performAction(int action) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, action, null);
    }

    public boolean performAction(int action, Bundle arguments) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, action, arguments);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByText(this.mConnectionId, this.mWindowId, this.mSourceNodeId, text);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(String viewId) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByViewId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, viewId);
    }

    public AccessibilityWindowInfo getWindow() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.getWindow(this.mConnectionId, this.mWindowId);
    }

    public AccessibilityNodeInfo getParent() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mParentNodeId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mParentNodeId, false, 7);
    }

    public long getParentNodeId() {
        return this.mParentNodeId;
    }

    public void setParent(View parent) {
        this.setParent(parent, Integer.MAX_VALUE);
    }

    public void setParent(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mParentNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public void getBoundsInParent(Rect outBounds) {
        outBounds.set(this.mBoundsInParent.left, this.mBoundsInParent.top, this.mBoundsInParent.right, this.mBoundsInParent.bottom);
    }

    public void setBoundsInParent(Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInParent.set(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void getBoundsInScreen(Rect outBounds) {
        outBounds.set(this.mBoundsInScreen.left, this.mBoundsInScreen.top, this.mBoundsInScreen.right, this.mBoundsInScreen.bottom);
    }

    public void setBoundsInScreen(Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInScreen.set(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public boolean isCheckable() {
        return this.getBooleanProperty(1);
    }

    public void setCheckable(boolean checkable) {
        this.setBooleanProperty(1, checkable);
    }

    public boolean isChecked() {
        return this.getBooleanProperty(2);
    }

    public void setChecked(boolean checked) {
        this.setBooleanProperty(2, checked);
    }

    public boolean isFocusable() {
        return this.getBooleanProperty(4);
    }

    public void setFocusable(boolean focusable) {
        this.setBooleanProperty(4, focusable);
    }

    public boolean isFocused() {
        return this.getBooleanProperty(8);
    }

    public void setFocused(boolean focused) {
        this.setBooleanProperty(8, focused);
    }

    public boolean isVisibleToUser() {
        return this.getBooleanProperty(2048);
    }

    public void setVisibleToUser(boolean visibleToUser) {
        this.setBooleanProperty(2048, visibleToUser);
    }

    public boolean isAccessibilityFocused() {
        return this.getBooleanProperty(1024);
    }

    public void setAccessibilityFocused(boolean focused) {
        this.setBooleanProperty(1024, focused);
    }

    public boolean isSelected() {
        return this.getBooleanProperty(16);
    }

    public void setSelected(boolean selected) {
        this.setBooleanProperty(16, selected);
    }

    public boolean isClickable() {
        return this.getBooleanProperty(32);
    }

    public void setClickable(boolean clickable) {
        this.setBooleanProperty(32, clickable);
    }

    public boolean isLongClickable() {
        return this.getBooleanProperty(64);
    }

    public void setLongClickable(boolean longClickable) {
        this.setBooleanProperty(64, longClickable);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(128);
    }

    public void setEnabled(boolean enabled) {
        this.setBooleanProperty(128, enabled);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(256);
    }

    public void setPassword(boolean password) {
        this.setBooleanProperty(256, password);
    }

    public boolean isScrollable() {
        return this.getBooleanProperty(512);
    }

    public void setScrollable(boolean scrollable) {
        this.setBooleanProperty(512, scrollable);
    }

    public boolean isEditable() {
        return this.getBooleanProperty(4096);
    }

    public void setEditable(boolean editable) {
        this.setBooleanProperty(4096, editable);
    }

    public CollectionInfo getCollectionInfo() {
        return this.mCollectionInfo;
    }

    public void setCollectionInfo(CollectionInfo collectionInfo) {
        this.enforceNotSealed();
        this.mCollectionInfo = collectionInfo;
    }

    public CollectionItemInfo getCollectionItemInfo() {
        return this.mCollectionItemInfo;
    }

    public void setCollectionItemInfo(CollectionItemInfo collectionItemInfo) {
        this.enforceNotSealed();
        this.mCollectionItemInfo = collectionItemInfo;
    }

    public RangeInfo getRangeInfo() {
        return this.mRangeInfo;
    }

    public void setRangeInfo(RangeInfo rangeInfo) {
        this.enforceNotSealed();
        this.mRangeInfo = rangeInfo;
    }

    public boolean isContentInvalid() {
        return this.getBooleanProperty(65536);
    }

    public void setContentInvalid(boolean contentInvalid) {
        this.setBooleanProperty(65536, contentInvalid);
    }

    public int getLiveRegion() {
        return this.mLiveRegion;
    }

    public void setLiveRegion(int mode) {
        this.enforceNotSealed();
        this.mLiveRegion = mode;
    }

    public boolean isMultiLine() {
        return this.getBooleanProperty(32768);
    }

    public void setMultiLine(boolean multiLine) {
        this.setBooleanProperty(32768, multiLine);
    }

    public boolean canOpenPopup() {
        return this.getBooleanProperty(8192);
    }

    public void setCanOpenPopup(boolean opensPopup) {
        this.enforceNotSealed();
        this.setBooleanProperty(8192, opensPopup);
    }

    public boolean isDismissable() {
        return this.getBooleanProperty(16384);
    }

    public void setDismissable(boolean dismissable) {
        this.setBooleanProperty(16384, dismissable);
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(CharSequence packageName) {
        this.enforceNotSealed();
        this.mPackageName = packageName;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public void setClassName(CharSequence className) {
        this.enforceNotSealed();
        this.mClassName = className;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public void setText(CharSequence text) {
        this.enforceNotSealed();
        this.mText = text;
    }

    public void setError(CharSequence error) {
        this.enforceNotSealed();
        this.mError = error;
    }

    public CharSequence getError() {
        return this.mError;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.enforceNotSealed();
        this.mContentDescription = contentDescription;
    }

    public void setLabelFor(View labeled) {
        this.setLabelFor(labeled, Integer.MAX_VALUE);
    }

    public void setLabelFor(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabelForId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo getLabelFor() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mLabelForId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabelForId, false, 7);
    }

    public void setLabeledBy(View label) {
        this.setLabeledBy(label, Integer.MAX_VALUE);
    }

    public void setLabeledBy(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabeledById = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo getLabeledBy() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mLabeledById)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabeledById, false, 7);
    }

    public void setViewIdResourceName(String viewIdResName) {
        this.enforceNotSealed();
        this.mViewIdResourceName = viewIdResName;
    }

    public String getViewIdResourceName() {
        return this.mViewIdResourceName;
    }

    public int getTextSelectionStart() {
        return this.mTextSelectionStart;
    }

    public int getTextSelectionEnd() {
        return this.mTextSelectionEnd;
    }

    public void setTextSelection(int start, int end) {
        this.enforceNotSealed();
        this.mTextSelectionStart = start;
        this.mTextSelectionEnd = end;
    }

    public int getInputType() {
        return this.mInputType;
    }

    public void setInputType(int inputType) {
        this.enforceNotSealed();
        this.mInputType = inputType;
    }

    public Bundle getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    private boolean getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) != 0;
    }

    private void setBooleanProperty(int property, boolean value) {
        this.enforceNotSealed();
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    public void setConnectionId(int connectionId) {
        this.enforceNotSealed();
        this.mConnectionId = connectionId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public long getSourceNodeId() {
        return this.mSourceNodeId;
    }

    public void setSealed(boolean sealed) {
        this.mSealed = sealed;
    }

    public boolean isSealed() {
        return this.mSealed;
    }

    protected void enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    private void enforceValidFocusDirection(int direction) {
        switch (direction) {
            case 1: 
            case 2: 
            case 17: 
            case 33: 
            case 66: 
            case 130: {
                return;
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    private void enforceValidFocusType(int focusType) {
        switch (focusType) {
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Unknown focus type: " + focusType);
    }

    protected void enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    public static AccessibilityNodeInfo obtain(View source) {
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
        info.setSource(source);
        return info;
    }

    public static AccessibilityNodeInfo obtain(View root, int virtualDescendantId) {
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
        info.setSource(root, virtualDescendantId);
        return info;
    }

    public static AccessibilityNodeInfo obtain() {
        AccessibilityNodeInfo info = sPool.acquire();
        return info != null ? info : new AccessibilityNodeInfo();
    }

    public static AccessibilityNodeInfo obtain(AccessibilityNodeInfo info) {
        AccessibilityNodeInfo infoClone = AccessibilityNodeInfo.obtain();
        infoClone.init(info);
        return infoClone;
    }

    public void recycle() {
        this.clear();
        sPool.release(this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.isSealed() ? 1 : 0);
        parcel.writeLong(this.mSourceNodeId);
        parcel.writeInt(this.mWindowId);
        parcel.writeLong(this.mParentNodeId);
        parcel.writeLong(this.mLabelForId);
        parcel.writeLong(this.mLabeledById);
        parcel.writeInt(this.mConnectionId);
        LongArray childIds = this.mChildNodeIds;
        if (childIds == null) {
            parcel.writeInt(0);
        } else {
            int childIdsSize = childIds.size();
            parcel.writeInt(childIdsSize);
            for (int i = 0; i < childIdsSize; ++i) {
                parcel.writeLong(childIds.get(i));
            }
        }
        parcel.writeInt(this.mBoundsInParent.top);
        parcel.writeInt(this.mBoundsInParent.bottom);
        parcel.writeInt(this.mBoundsInParent.left);
        parcel.writeInt(this.mBoundsInParent.right);
        parcel.writeInt(this.mBoundsInScreen.top);
        parcel.writeInt(this.mBoundsInScreen.bottom);
        parcel.writeInt(this.mBoundsInScreen.left);
        parcel.writeInt(this.mBoundsInScreen.right);
        if (this.mActions != null && !this.mActions.isEmpty()) {
            AccessibilityAction action;
            int i;
            int actionCount = this.mActions.size();
            parcel.writeInt(actionCount);
            int defaultLegacyStandardActions = 0;
            for (i = 0; i < actionCount; ++i) {
                action = this.mActions.get(i);
                if (!AccessibilityNodeInfo.isDefaultLegacyStandardAction(action)) continue;
                defaultLegacyStandardActions |= action.getId();
            }
            parcel.writeInt(defaultLegacyStandardActions);
            for (i = 0; i < actionCount; ++i) {
                action = this.mActions.get(i);
                if (AccessibilityNodeInfo.isDefaultLegacyStandardAction(action)) continue;
                parcel.writeInt(action.getId());
                parcel.writeCharSequence(action.getLabel());
            }
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mMaxTextLength);
        parcel.writeInt(this.mMovementGranularities);
        parcel.writeInt(this.mBooleanProperties);
        parcel.writeCharSequence(this.mPackageName);
        parcel.writeCharSequence(this.mClassName);
        parcel.writeCharSequence(this.mText);
        parcel.writeCharSequence(this.mError);
        parcel.writeCharSequence(this.mContentDescription);
        parcel.writeString(this.mViewIdResourceName);
        parcel.writeInt(this.mTextSelectionStart);
        parcel.writeInt(this.mTextSelectionEnd);
        parcel.writeInt(this.mInputType);
        parcel.writeInt(this.mLiveRegion);
        if (this.mExtras != null) {
            parcel.writeInt(1);
            parcel.writeBundle(this.mExtras);
        } else {
            parcel.writeInt(0);
        }
        if (this.mRangeInfo != null) {
            parcel.writeInt(1);
            parcel.writeInt(this.mRangeInfo.getType());
            parcel.writeFloat(this.mRangeInfo.getMin());
            parcel.writeFloat(this.mRangeInfo.getMax());
            parcel.writeFloat(this.mRangeInfo.getCurrent());
        } else {
            parcel.writeInt(0);
        }
        if (this.mCollectionInfo != null) {
            parcel.writeInt(1);
            parcel.writeInt(this.mCollectionInfo.getRowCount());
            parcel.writeInt(this.mCollectionInfo.getColumnCount());
            parcel.writeInt(this.mCollectionInfo.isHierarchical() ? 1 : 0);
            parcel.writeInt(this.mCollectionInfo.getSelectionMode());
        } else {
            parcel.writeInt(0);
        }
        if (this.mCollectionItemInfo != null) {
            parcel.writeInt(1);
            parcel.writeInt(this.mCollectionItemInfo.getColumnIndex());
            parcel.writeInt(this.mCollectionItemInfo.getColumnSpan());
            parcel.writeInt(this.mCollectionItemInfo.getRowIndex());
            parcel.writeInt(this.mCollectionItemInfo.getRowSpan());
            parcel.writeInt(this.mCollectionItemInfo.isHeading() ? 1 : 0);
            parcel.writeInt(this.mCollectionItemInfo.isSelected() ? 1 : 0);
        } else {
            parcel.writeInt(0);
        }
        this.recycle();
    }

    private void init(AccessibilityNodeInfo other) {
        this.mSealed = other.mSealed;
        this.mSourceNodeId = other.mSourceNodeId;
        this.mParentNodeId = other.mParentNodeId;
        this.mLabelForId = other.mLabelForId;
        this.mLabeledById = other.mLabeledById;
        this.mWindowId = other.mWindowId;
        this.mConnectionId = other.mConnectionId;
        this.mBoundsInParent.set(other.mBoundsInParent);
        this.mBoundsInScreen.set(other.mBoundsInScreen);
        this.mPackageName = other.mPackageName;
        this.mClassName = other.mClassName;
        this.mText = other.mText;
        this.mError = other.mError;
        this.mContentDescription = other.mContentDescription;
        this.mViewIdResourceName = other.mViewIdResourceName;
        ArrayList<AccessibilityAction> otherActions = other.mActions;
        if (otherActions != null && otherActions.size() > 0) {
            if (this.mActions == null) {
                this.mActions = new ArrayList<AccessibilityAction>(otherActions);
            } else {
                this.mActions.clear();
                this.mActions.addAll(other.mActions);
            }
        }
        this.mBooleanProperties = other.mBooleanProperties;
        this.mMaxTextLength = other.mMaxTextLength;
        this.mMovementGranularities = other.mMovementGranularities;
        LongArray otherChildNodeIds = other.mChildNodeIds;
        if (otherChildNodeIds != null && otherChildNodeIds.size() > 0) {
            if (this.mChildNodeIds == null) {
                this.mChildNodeIds = otherChildNodeIds.clone();
            } else {
                this.mChildNodeIds.clear();
                this.mChildNodeIds.addAll(otherChildNodeIds);
            }
        }
        this.mTextSelectionStart = other.mTextSelectionStart;
        this.mTextSelectionEnd = other.mTextSelectionEnd;
        this.mInputType = other.mInputType;
        this.mLiveRegion = other.mLiveRegion;
        if (other.mExtras != null && !other.mExtras.isEmpty()) {
            this.getExtras().putAll(other.mExtras);
        }
        this.mRangeInfo = other.mRangeInfo != null ? RangeInfo.obtain(other.mRangeInfo) : null;
        this.mCollectionInfo = other.mCollectionInfo != null ? CollectionInfo.obtain(other.mCollectionInfo) : null;
        this.mCollectionItemInfo = other.mCollectionItemInfo != null ? CollectionItemInfo.obtain(other.mCollectionItemInfo) : null;
    }

    private void initFromParcel(Parcel parcel) {
        this.mSealed = parcel.readInt() == 1;
        this.mSourceNodeId = parcel.readLong();
        this.mWindowId = parcel.readInt();
        this.mParentNodeId = parcel.readLong();
        this.mLabelForId = parcel.readLong();
        this.mLabeledById = parcel.readLong();
        this.mConnectionId = parcel.readInt();
        int childrenSize = parcel.readInt();
        if (childrenSize <= 0) {
            this.mChildNodeIds = null;
        } else {
            this.mChildNodeIds = new LongArray(childrenSize);
            for (int i = 0; i < childrenSize; ++i) {
                long childId = parcel.readLong();
                this.mChildNodeIds.add(childId);
            }
        }
        this.mBoundsInParent.top = parcel.readInt();
        this.mBoundsInParent.bottom = parcel.readInt();
        this.mBoundsInParent.left = parcel.readInt();
        this.mBoundsInParent.right = parcel.readInt();
        this.mBoundsInScreen.top = parcel.readInt();
        this.mBoundsInScreen.bottom = parcel.readInt();
        this.mBoundsInScreen.left = parcel.readInt();
        this.mBoundsInScreen.right = parcel.readInt();
        int actionCount = parcel.readInt();
        if (actionCount > 0) {
            int legacyStandardActions = parcel.readInt();
            this.addLegacyStandardActions(legacyStandardActions);
            int nonLegacyActionCount = actionCount - Integer.bitCount(legacyStandardActions);
            for (int i = 0; i < nonLegacyActionCount; ++i) {
                AccessibilityAction action = new AccessibilityAction(parcel.readInt(), parcel.readCharSequence());
                this.addAction(action);
            }
        }
        this.mMaxTextLength = parcel.readInt();
        this.mMovementGranularities = parcel.readInt();
        this.mBooleanProperties = parcel.readInt();
        this.mPackageName = parcel.readCharSequence();
        this.mClassName = parcel.readCharSequence();
        this.mText = parcel.readCharSequence();
        this.mError = parcel.readCharSequence();
        this.mContentDescription = parcel.readCharSequence();
        this.mViewIdResourceName = parcel.readString();
        this.mTextSelectionStart = parcel.readInt();
        this.mTextSelectionEnd = parcel.readInt();
        this.mInputType = parcel.readInt();
        this.mLiveRegion = parcel.readInt();
        if (parcel.readInt() == 1) {
            this.getExtras().putAll(parcel.readBundle());
        }
        if (parcel.readInt() == 1) {
            this.mRangeInfo = RangeInfo.obtain(parcel.readInt(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat());
        }
        if (parcel.readInt() == 1) {
            this.mCollectionInfo = CollectionInfo.obtain(parcel.readInt(), parcel.readInt(), parcel.readInt() == 1, parcel.readInt());
        }
        if (parcel.readInt() == 1) {
            this.mCollectionItemInfo = CollectionItemInfo.obtain(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt() == 1, parcel.readInt() == 1);
        }
    }

    private void clear() {
        this.mSealed = false;
        this.mSourceNodeId = ROOT_NODE_ID;
        this.mParentNodeId = ROOT_NODE_ID;
        this.mLabelForId = ROOT_NODE_ID;
        this.mLabeledById = ROOT_NODE_ID;
        this.mWindowId = Integer.MAX_VALUE;
        this.mConnectionId = -1;
        this.mMaxTextLength = -1;
        this.mMovementGranularities = 0;
        if (this.mChildNodeIds != null) {
            this.mChildNodeIds.clear();
        }
        this.mBoundsInParent.set(0, 0, 0, 0);
        this.mBoundsInScreen.set(0, 0, 0, 0);
        this.mBooleanProperties = 0;
        this.mPackageName = null;
        this.mClassName = null;
        this.mText = null;
        this.mError = null;
        this.mContentDescription = null;
        this.mViewIdResourceName = null;
        if (this.mActions != null) {
            this.mActions.clear();
        }
        this.mTextSelectionStart = -1;
        this.mTextSelectionEnd = -1;
        this.mInputType = 0;
        this.mLiveRegion = 0;
        if (this.mExtras != null) {
            this.mExtras.clear();
        }
        if (this.mRangeInfo != null) {
            this.mRangeInfo.recycle();
            this.mRangeInfo = null;
        }
        if (this.mCollectionInfo != null) {
            this.mCollectionInfo.recycle();
            this.mCollectionInfo = null;
        }
        if (this.mCollectionItemInfo != null) {
            this.mCollectionItemInfo.recycle();
            this.mCollectionItemInfo = null;
        }
    }

    private static boolean isDefaultLegacyStandardAction(AccessibilityAction action) {
        return action.getId() <= 0x200000 && TextUtils.isEmpty(action.getLabel());
    }

    private static AccessibilityAction getActionSingleton(int actionId) {
        int actions = AccessibilityAction.sStandardActions.size();
        for (int i = 0; i < actions; ++i) {
            AccessibilityAction currentAction = (AccessibilityAction)AccessibilityAction.sStandardActions.valueAt(i);
            if (actionId != currentAction.getId()) continue;
            return currentAction;
        }
        return null;
    }

    private void addLegacyStandardActions(int actionMask) {
        int id2;
        for (int remainingIds = actionMask; remainingIds > 0; remainingIds &= ~id2) {
            id2 = 1 << Integer.numberOfTrailingZeros(remainingIds);
            AccessibilityAction action = AccessibilityNodeInfo.getActionSingleton(id2);
            this.addAction(action);
        }
    }

    private static String getActionSymbolicName(int action) {
        switch (action) {
            case 1: {
                return "ACTION_FOCUS";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
            case 16: {
                return "ACTION_CLICK";
            }
            case 32: {
                return "ACTION_LONG_CLICK";
            }
            case 64: {
                return "ACTION_ACCESSIBILITY_FOCUS";
            }
            case 128: {
                return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
            }
            case 256: {
                return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
            }
            case 512: {
                return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
            }
            case 1024: {
                return "ACTION_NEXT_HTML_ELEMENT";
            }
            case 2048: {
                return "ACTION_PREVIOUS_HTML_ELEMENT";
            }
            case 4096: {
                return "ACTION_SCROLL_FORWARD";
            }
            case 8192: {
                return "ACTION_SCROLL_BACKWARD";
            }
            case 65536: {
                return "ACTION_CUT";
            }
            case 16384: {
                return "ACTION_COPY";
            }
            case 32768: {
                return "ACTION_PASTE";
            }
            case 131072: {
                return "ACTION_SET_SELECTION";
            }
        }
        return "ACTION_UNKNOWN";
    }

    private static String getMovementGranularitySymbolicName(int granularity) {
        switch (granularity) {
            case 1: {
                return "MOVEMENT_GRANULARITY_CHARACTER";
            }
            case 2: {
                return "MOVEMENT_GRANULARITY_WORD";
            }
            case 4: {
                return "MOVEMENT_GRANULARITY_LINE";
            }
            case 8: {
                return "MOVEMENT_GRANULARITY_PARAGRAPH";
            }
            case 16: {
                return "MOVEMENT_GRANULARITY_PAGE";
            }
        }
        throw new IllegalArgumentException("Unknown movement granularity: " + granularity);
    }

    private boolean canPerformRequestOverConnection(long accessibilityNodeId) {
        return this.mWindowId != Integer.MAX_VALUE && AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId) != Integer.MAX_VALUE && this.mConnectionId != -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccessibilityNodeInfo other = (AccessibilityNodeInfo)object;
        if (this.mSourceNodeId != other.mSourceNodeId) {
            return false;
        }
        return this.mWindowId == other.mWindowId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId);
        result = 31 * result + AccessibilityNodeInfo.getVirtualDescendantId(this.mSourceNodeId);
        result = 31 * result + this.mWindowId;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("; boundsInParent: " + this.mBoundsInParent);
        builder.append("; boundsInScreen: " + this.mBoundsInScreen);
        builder.append("; packageName: ").append(this.mPackageName);
        builder.append("; className: ").append(this.mClassName);
        builder.append("; text: ").append(this.mText);
        builder.append("; error: ").append(this.mError);
        builder.append("; maxTextLength: ").append(this.mMaxTextLength);
        builder.append("; contentDescription: ").append(this.mContentDescription);
        builder.append("; viewIdResName: ").append(this.mViewIdResourceName);
        builder.append("; checkable: ").append(this.isCheckable());
        builder.append("; checked: ").append(this.isChecked());
        builder.append("; focusable: ").append(this.isFocusable());
        builder.append("; focused: ").append(this.isFocused());
        builder.append("; selected: ").append(this.isSelected());
        builder.append("; clickable: ").append(this.isClickable());
        builder.append("; longClickable: ").append(this.isLongClickable());
        builder.append("; enabled: ").append(this.isEnabled());
        builder.append("; password: ").append(this.isPassword());
        builder.append("; scrollable: ").append(this.isScrollable());
        builder.append("; actions: ").append(this.mActions);
        return builder.toString();
    }

    public static class CollectionItemInfo {
        private static final int MAX_POOL_SIZE = 20;
        private static final Pools.SynchronizedPool<CollectionItemInfo> sPool = new Pools.SynchronizedPool(20);
        private boolean mHeading;
        private int mColumnIndex;
        private int mRowIndex;
        private int mColumnSpan;
        private int mRowSpan;
        private boolean mSelected;

        public static CollectionItemInfo obtain(CollectionItemInfo other) {
            return CollectionItemInfo.obtain(other.mRowIndex, other.mRowSpan, other.mColumnIndex, other.mColumnSpan, other.mHeading, other.mSelected);
        }

        public static CollectionItemInfo obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
            return CollectionItemInfo.obtain(rowIndex, rowSpan, columnIndex, columnSpan, heading, false);
        }

        public static CollectionItemInfo obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            CollectionItemInfo info = sPool.acquire();
            if (info == null) {
                return new CollectionItemInfo(rowIndex, rowSpan, columnIndex, columnSpan, heading, selected);
            }
            info.mRowIndex = rowIndex;
            info.mRowSpan = rowSpan;
            info.mColumnIndex = columnIndex;
            info.mColumnSpan = columnSpan;
            info.mHeading = heading;
            info.mSelected = selected;
            return info;
        }

        private CollectionItemInfo(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            this.mRowIndex = rowIndex;
            this.mRowSpan = rowSpan;
            this.mColumnIndex = columnIndex;
            this.mColumnSpan = columnSpan;
            this.mHeading = heading;
            this.mSelected = selected;
        }

        public int getColumnIndex() {
            return this.mColumnIndex;
        }

        public int getRowIndex() {
            return this.mRowIndex;
        }

        public int getColumnSpan() {
            return this.mColumnSpan;
        }

        public int getRowSpan() {
            return this.mRowSpan;
        }

        public boolean isHeading() {
            return this.mHeading;
        }

        public boolean isSelected() {
            return this.mSelected;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }

        private void clear() {
            this.mColumnIndex = 0;
            this.mColumnSpan = 0;
            this.mRowIndex = 0;
            this.mRowSpan = 0;
            this.mHeading = false;
            this.mSelected = false;
        }
    }

    public static class CollectionInfo {
        public static final int SELECTION_MODE_NONE = 0;
        public static final int SELECTION_MODE_SINGLE = 1;
        public static final int SELECTION_MODE_MULTIPLE = 2;
        private static final int MAX_POOL_SIZE = 20;
        private static final Pools.SynchronizedPool<CollectionInfo> sPool = new Pools.SynchronizedPool(20);
        private int mRowCount;
        private int mColumnCount;
        private boolean mHierarchical;
        private int mSelectionMode;

        public static CollectionInfo obtain(CollectionInfo other) {
            return CollectionInfo.obtain(other.mRowCount, other.mColumnCount, other.mHierarchical, other.mSelectionMode);
        }

        public static CollectionInfo obtain(int rowCount, int columnCount, boolean hierarchical) {
            return CollectionInfo.obtain(rowCount, columnCount, hierarchical, 0);
        }

        public static CollectionInfo obtain(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            CollectionInfo info = sPool.acquire();
            if (info == null) {
                return new CollectionInfo(rowCount, columnCount, hierarchical, selectionMode);
            }
            info.mRowCount = rowCount;
            info.mColumnCount = columnCount;
            info.mHierarchical = hierarchical;
            info.mSelectionMode = selectionMode;
            return info;
        }

        private CollectionInfo(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            this.mRowCount = rowCount;
            this.mColumnCount = columnCount;
            this.mHierarchical = hierarchical;
            this.mSelectionMode = selectionMode;
        }

        public int getRowCount() {
            return this.mRowCount;
        }

        public int getColumnCount() {
            return this.mColumnCount;
        }

        public boolean isHierarchical() {
            return this.mHierarchical;
        }

        public int getSelectionMode() {
            return this.mSelectionMode;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }

        private void clear() {
            this.mRowCount = 0;
            this.mColumnCount = 0;
            this.mHierarchical = false;
            this.mSelectionMode = 0;
        }
    }

    public static class RangeInfo {
        private static final int MAX_POOL_SIZE = 10;
        public static final int RANGE_TYPE_INT = 0;
        public static final int RANGE_TYPE_FLOAT = 1;
        public static final int RANGE_TYPE_PERCENT = 2;
        private static final Pools.SynchronizedPool<RangeInfo> sPool = new Pools.SynchronizedPool(10);
        private int mType;
        private float mMin;
        private float mMax;
        private float mCurrent;

        public static RangeInfo obtain(RangeInfo other) {
            return RangeInfo.obtain(other.mType, other.mMin, other.mMax, other.mCurrent);
        }

        public static RangeInfo obtain(int type, float min, float max, float current) {
            RangeInfo info = sPool.acquire();
            return info != null ? info : new RangeInfo(type, min, max, current);
        }

        private RangeInfo(int type, float min, float max, float current) {
            this.mType = type;
            this.mMin = min;
            this.mMax = max;
            this.mCurrent = current;
        }

        public int getType() {
            return this.mType;
        }

        public float getMin() {
            return this.mMin;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getCurrent() {
            return this.mCurrent;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }

        private void clear() {
            this.mType = 0;
            this.mMin = 0.0f;
            this.mMax = 0.0f;
            this.mCurrent = 0.0f;
        }
    }

    public static class AccessibilityAction {
        public static final AccessibilityAction ACTION_FOCUS = new AccessibilityAction(1, null);
        public static final AccessibilityAction ACTION_CLEAR_FOCUS = new AccessibilityAction(2, null);
        public static final AccessibilityAction ACTION_SELECT = new AccessibilityAction(4, null);
        public static final AccessibilityAction ACTION_CLEAR_SELECTION = new AccessibilityAction(8, null);
        public static final AccessibilityAction ACTION_CLICK = new AccessibilityAction(16, null);
        public static final AccessibilityAction ACTION_LONG_CLICK = new AccessibilityAction(32, null);
        public static final AccessibilityAction ACTION_ACCESSIBILITY_FOCUS = new AccessibilityAction(64, null);
        public static final AccessibilityAction ACTION_CLEAR_ACCESSIBILITY_FOCUS = new AccessibilityAction(128, null);
        public static final AccessibilityAction ACTION_NEXT_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(256, null);
        public static final AccessibilityAction ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(512, null);
        public static final AccessibilityAction ACTION_NEXT_HTML_ELEMENT = new AccessibilityAction(1024, null);
        public static final AccessibilityAction ACTION_PREVIOUS_HTML_ELEMENT = new AccessibilityAction(2048, null);
        public static final AccessibilityAction ACTION_SCROLL_FORWARD = new AccessibilityAction(4096, null);
        public static final AccessibilityAction ACTION_SCROLL_BACKWARD = new AccessibilityAction(8192, null);
        public static final AccessibilityAction ACTION_COPY = new AccessibilityAction(16384, null);
        public static final AccessibilityAction ACTION_PASTE = new AccessibilityAction(32768, null);
        public static final AccessibilityAction ACTION_CUT = new AccessibilityAction(65536, null);
        public static final AccessibilityAction ACTION_SET_SELECTION = new AccessibilityAction(131072, null);
        public static final AccessibilityAction ACTION_EXPAND = new AccessibilityAction(262144, null);
        public static final AccessibilityAction ACTION_COLLAPSE = new AccessibilityAction(524288, null);
        public static final AccessibilityAction ACTION_DISMISS = new AccessibilityAction(0x100000, null);
        public static final AccessibilityAction ACTION_SET_TEXT = new AccessibilityAction(0x200000, null);
        private static final ArraySet<AccessibilityAction> sStandardActions = new ArraySet();
        private final int mActionId;
        private final CharSequence mLabel;

        public AccessibilityAction(int actionId, CharSequence label) {
            if ((actionId & 0xFF000000) == 0 && Integer.bitCount(actionId) != 1) {
                throw new IllegalArgumentException("Invalid standard action id");
            }
            this.mActionId = actionId;
            this.mLabel = label;
        }

        public int getId() {
            return this.mActionId;
        }

        public CharSequence getLabel() {
            return this.mLabel;
        }

        public int hashCode() {
            return this.mActionId;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            return this.mActionId == ((AccessibilityAction)other).mActionId;
        }

        public String toString() {
            return "AccessibilityAction: " + AccessibilityNodeInfo.getActionSymbolicName(this.mActionId) + " - " + this.mLabel;
        }

        static {
            sStandardActions.add(ACTION_FOCUS);
            sStandardActions.add(ACTION_CLEAR_FOCUS);
            sStandardActions.add(ACTION_SELECT);
            sStandardActions.add(ACTION_CLEAR_SELECTION);
            sStandardActions.add(ACTION_CLICK);
            sStandardActions.add(ACTION_LONG_CLICK);
            sStandardActions.add(ACTION_ACCESSIBILITY_FOCUS);
            sStandardActions.add(ACTION_CLEAR_ACCESSIBILITY_FOCUS);
            sStandardActions.add(ACTION_NEXT_AT_MOVEMENT_GRANULARITY);
            sStandardActions.add(ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY);
            sStandardActions.add(ACTION_NEXT_HTML_ELEMENT);
            sStandardActions.add(ACTION_PREVIOUS_HTML_ELEMENT);
            sStandardActions.add(ACTION_SCROLL_FORWARD);
            sStandardActions.add(ACTION_SCROLL_BACKWARD);
            sStandardActions.add(ACTION_COPY);
            sStandardActions.add(ACTION_PASTE);
            sStandardActions.add(ACTION_CUT);
            sStandardActions.add(ACTION_SET_SELECTION);
            sStandardActions.add(ACTION_EXPAND);
            sStandardActions.add(ACTION_COLLAPSE);
            sStandardActions.add(ACTION_DISMISS);
            sStandardActions.add(ACTION_SET_TEXT);
        }
    }
}

