/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path_Delegate;
import android.graphics.Rect;
import android.graphics.Region;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.ShadowPainter;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Transformation;
import com.android.annotations.NonNull;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.resources.Density;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ViewGroup_Delegate {
    @LayoutlibDelegate
    static boolean drawChild(ViewGroup thisVG, Canvas canvas, View child, long drawingTime) {
        boolean retVal = thisVG.drawChild_Original(canvas, child, drawingTime);
        if (child.getZ() > thisVG.getZ()) {
            ViewOutlineProvider outlineProvider = child.getOutlineProvider();
            Outline outline = new Outline();
            outlineProvider.getOutline(child, outline);
            if (outline.mPath != null || outline.mRect != null && !outline.mRect.isEmpty()) {
                int restoreTo = ViewGroup_Delegate.transformCanvas(thisVG, canvas, child);
                ViewGroup_Delegate.drawShadow(thisVG, canvas, child, outline);
                canvas.restoreToCount(restoreTo);
            }
        }
        return retVal;
    }

    private static void drawShadow(ViewGroup parent, Canvas canvas, View child, Outline outline) {
        BufferedImage shadow = null;
        int x = 0;
        if (outline.mRect != null) {
            Shadow s = ViewGroup_Delegate.getRectShadow(parent, canvas, child, outline);
            shadow = s.mShadow;
            x = -s.mShadowWidth;
        } else if (outline.mPath != null) {
            shadow = ViewGroup_Delegate.getPathShadow(child, outline, canvas);
        }
        if (shadow == null) {
            return;
        }
        Bitmap bitmap = Bitmap_Delegate.createBitmap(shadow, false, Density.getEnum((int)canvas.getDensity()));
        Rect clipBounds = canvas.getClipBounds();
        Rect newBounds = new Rect(clipBounds);
        newBounds.left += x;
        canvas.clipRect(newBounds, Region.Op.REPLACE);
        canvas.drawBitmap(bitmap, x, 0.0f, null);
        canvas.clipRect(clipBounds, Region.Op.REPLACE);
    }

    private static Shadow getRectShadow(ViewGroup parent, Canvas canvas, View child, Outline outline) {
        float largeShadowThreshold;
        Rect clipBounds = canvas.getClipBounds();
        if (clipBounds.isEmpty()) {
            return null;
        }
        float height = child.getZ() - parent.getZ();
        boolean largeShadow = height > (largeShadowThreshold = TypedValue.applyDimension(1, 10.0f, ViewGroup_Delegate.getMetrics(child)));
        int shadowSize = largeShadow ? 20 : 10;
        BufferedImage shadow = new BufferedImage(clipBounds.width() + shadowSize, clipBounds.height(), 2);
        Graphics2D graphics = shadow.createGraphics();
        Rect rect = outline.mRect;
        if (largeShadow) {
            ShadowPainter.drawRectangleShadow(graphics, rect.left + shadowSize, rect.top, rect.width(), rect.height());
        } else {
            ShadowPainter.drawSmallRectangleShadow(graphics, rect.left + shadowSize, rect.top, rect.width(), rect.height());
        }
        graphics.dispose();
        return new Shadow(shadow, shadowSize);
    }

    @NonNull
    private static DisplayMetrics getMetrics(View view) {
        Context context = view.getContext();
        while (context instanceof ContextThemeWrapper) {
            context = ((ContextThemeWrapper)context).getBaseContext();
        }
        if (context instanceof BridgeContext) {
            return ((BridgeContext)context).getMetrics();
        }
        throw new RuntimeException("View " + view.getClass().getName() + " not created with the " + "right context");
    }

    private static BufferedImage getPathShadow(View child, Outline outline, Canvas canvas) {
        Rect clipBounds = canvas.getClipBounds();
        BufferedImage image = new BufferedImage(clipBounds.width(), clipBounds.height(), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.draw(Path_Delegate.getDelegate(outline.mPath.mNativePath).getJavaShape());
        graphics.dispose();
        return ShadowPainter.createDropShadow(image, (int)child.getZ());
    }

    private static int transformCanvas(ViewGroup thisVG, Canvas canvas, View child) {
        Transformation t;
        boolean hasTransform;
        int restoreTo = canvas.save();
        boolean childHasIdentityMatrix = child.hasIdentityMatrix();
        int flags = thisVG.mGroupFlags;
        Transformation transformToApply = null;
        boolean concatMatrix = false;
        if ((flags & 0x800) != 0 && (hasTransform = thisVG.getChildStaticTransformation(child, t = thisVG.getChildTransformation()))) {
            int transformType = t.getTransformationType();
            transformToApply = transformType != 0 ? t : null;
            concatMatrix = (transformType & 2) != 0;
        }
        concatMatrix |= childHasIdentityMatrix;
        child.computeScroll();
        int sx = child.mScrollX;
        int sy = child.mScrollY;
        canvas.translate(child.mLeft - sx, child.mTop - sy);
        float alpha = child.getAlpha() * child.getTransitionAlpha();
        if (!(transformToApply == null && !(alpha < 1.0f) && childHasIdentityMatrix || transformToApply == null && childHasIdentityMatrix)) {
            int transX = -sx;
            int transY = -sy;
            if (transformToApply != null) {
                if (concatMatrix) {
                    canvas.translate(-transX, -transY);
                    canvas.concat(transformToApply.getMatrix());
                    canvas.translate(transX, transY);
                }
                if (!childHasIdentityMatrix) {
                    canvas.translate(-transX, -transY);
                    canvas.concat(child.getMatrix());
                    canvas.translate(transX, transY);
                }
            }
        }
        return restoreTo;
    }

    private static class Shadow {
        public BufferedImage mShadow;
        public int mShadowWidth;

        public Shadow(BufferedImage shadow, int shadowWidth) {
            this.mShadow = shadow;
            this.mShadowWidth = shadowWidth;
        }
    }
}

