/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.SurfaceTexture;
import android.view.HardwareRenderer;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.tools.layoutlib.create.OverrideMethod;

class HardwareLayer {
    private HardwareRenderer mRenderer;
    private VirtualRefBasePtr mFinalizer;

    private HardwareLayer(HardwareRenderer renderer, long deferredUpdater) {
        if (renderer == null || deferredUpdater == 0L) {
            throw new IllegalArgumentException("Either hardware renderer: " + renderer + " or deferredUpdater: " + deferredUpdater + " is invalid");
        }
        this.mRenderer = renderer;
        this.mFinalizer = new VirtualRefBasePtr(deferredUpdater);
    }

    public void setLayerPaint(Paint paint) {
        HardwareLayer.nSetLayerPaint(this.mFinalizer.get(), paint.mNativePaint);
        this.mRenderer.pushLayerUpdate(this);
    }

    public boolean isValid() {
        return this.mFinalizer != null && this.mFinalizer.get() != 0L;
    }

    public void destroy() {
        if (!this.isValid()) {
            return;
        }
        this.mRenderer.onLayerDestroyed(this);
        this.mRenderer = null;
        this.mFinalizer.release();
        this.mFinalizer = null;
    }

    public long getDeferredLayerUpdater() {
        return this.mFinalizer.get();
    }

    public boolean copyInto(Bitmap bitmap) {
        return this.mRenderer.copyLayerInto(this, bitmap);
    }

    public boolean prepare(int width, int height, boolean isOpaque) {
        return HardwareLayer.nPrepare(this.mFinalizer.get(), width, height, isOpaque);
    }

    public void setTransform(Matrix matrix) {
        HardwareLayer.nSetTransform(this.mFinalizer.get(), matrix.native_instance);
        this.mRenderer.pushLayerUpdate(this);
    }

    public void detachSurfaceTexture() {
        this.mRenderer.detachSurfaceTexture(this.mFinalizer.get());
    }

    public long getLayer() {
        return HardwareLayer.nGetLayer(this.mFinalizer.get());
    }

    public void setSurfaceTexture(SurfaceTexture surface) {
        HardwareLayer.nSetSurfaceTexture(this.mFinalizer.get(), surface, false);
        this.mRenderer.pushLayerUpdate(this);
    }

    public void updateSurfaceTexture() {
        HardwareLayer.nUpdateSurfaceTexture(this.mFinalizer.get());
        this.mRenderer.pushLayerUpdate(this);
    }

    static HardwareLayer adoptTextureLayer(HardwareRenderer renderer, long layer) {
        return new HardwareLayer(renderer, layer);
    }

    private static boolean nPrepare(long l, int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.view.HardwareLayer#nPrepare(JIIZ)Z", true, null) != 0;
    }

    private static void nSetLayerPaint(long l, long l2) {
        OverrideMethod.invokeV("android.view.HardwareLayer#nSetLayerPaint(JJ)V", true, null);
    }

    private static void nSetTransform(long l, long l2) {
        OverrideMethod.invokeV("android.view.HardwareLayer#nSetTransform(JJ)V", true, null);
    }

    private static void nSetSurfaceTexture(long l, SurfaceTexture surfaceTexture, boolean bl) {
        OverrideMethod.invokeV("android.view.HardwareLayer#nSetSurfaceTexture(JLandroid/graphics/SurfaceTexture;Z)V", true, null);
    }

    private static void nUpdateSurfaceTexture(long l) {
        OverrideMethod.invokeV("android.view.HardwareLayer#nUpdateSurfaceTexture(J)V", true, null);
    }

    private static void nUpdateRenderLayer(long l, long l2, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.HardwareLayer#nUpdateRenderLayer(JJIIII)V", true, null);
    }

    private static long nGetLayer(long l) {
        return OverrideMethod.invokeL("android.view.HardwareLayer#nGetLayer(J)J", true, null);
    }

    private static int nGetTexName(long l) {
        return OverrideMethod.invokeI("android.view.HardwareLayer#nGetTexName(J)I", true, null);
    }
}

